/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.ISystemPersistentAdapter;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.ba.ISysBDPersistentAdapter;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDPersistentAdapter;
import net.ibizsys.central.database.ISysDBPersistentAdapter;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.database.SysDBPersistentAdapter;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.util.IEntity;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;

public class SystemPersistentAdapter
implements ISystemPersistentAdapter {
    private static final Log log = LogFactory.getLog(SystemPersistentAdapter.class);
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private Map<String, ISystemPersistentAdapter> dbPersistentAdapterMap = new ConcurrentHashMap<String, ISystemPersistentAdapter>();
    private Map<String, ISystemPersistentAdapter> bdPersistentAdapterMap = new ConcurrentHashMap<String, ISystemPersistentAdapter>();
    private Map<String, ISystemPersistentAdapter> dePersistentAdapterMap = new ConcurrentHashMap<String, ISystemPersistentAdapter>();

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext) throws Exception {
        this.iSystemRuntimeContext = iSystemRuntimeContext;
    }

    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime();
    }

    protected ISystemPersistentAdapter getSystemPersistentAdapter(IDataEntityRuntime iDataEntityRuntime) {
        ISystemPersistentAdapter iSystemPersistentAdapter = this.dePersistentAdapterMap.get(iDataEntityRuntime.getId());
        if (iSystemPersistentAdapter == null) {
            iSystemPersistentAdapter = this.internalGetSystemPersistentAdapter(iDataEntityRuntime);
            this.dePersistentAdapterMap.put(iDataEntityRuntime.getId(), iSystemPersistentAdapter);
        }
        return iSystemPersistentAdapter;
    }

    protected ISystemPersistentAdapter internalGetSystemPersistentAdapter(IDataEntityRuntime iDataEntityRuntime) {
        switch (iDataEntityRuntime.getStorageMode()) {
            case 1: {
                ISysDBSchemeRuntime iSysDBSchemeRuntime = iDataEntityRuntime.getSysDBSchemeRuntime();
                if (iSysDBSchemeRuntime == null) {
                    throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u5b9e\u4f53[%1$s]\u6ca1\u6709\u6307\u5b9a\u7cfb\u7edf\u6570\u636e\u5e93\u4f53\u7cfb", iDataEntityRuntime.getName()));
                }
                ISystemPersistentAdapter iSystemPersistentAdapter = this.dbPersistentAdapterMap.get(iSysDBSchemeRuntime.getId());
                if (iSystemPersistentAdapter == null) {
                    ISysDBPersistentAdapter iSysDBPersistentAdapter = this.createSysDBPersistentAdapter(iSysDBSchemeRuntime);
                    Assert.notNull((Object)iSysDBPersistentAdapter, (String)"\u7cfb\u7edf\u6570\u636e\u5e93\u6301\u4e45\u5316\u9002\u914d\u5668\u65e0\u6548");
                    try {
                        iSysDBPersistentAdapter.init(this.getSystemRuntimeContext(), iSysDBSchemeRuntime);
                    }
                    catch (Exception ex) {
                        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u6570\u636e\u5e93[%1$s]\u6301\u4e45\u5316\u9002\u914d\u5668\u53d1\u751f\u5f02\u5e38, %2$s", iSysDBSchemeRuntime.getName(), ex.getMessage()), ex);
                    }
                    this.dbPersistentAdapterMap.put(iSysDBSchemeRuntime.getId(), iSysDBPersistentAdapter);
                    return iSysDBPersistentAdapter;
                }
                return iSystemPersistentAdapter;
            }
            case 2: {
                ISysBDSchemeRuntime iSysBDSchemeRuntime = iDataEntityRuntime.getSysBDSchemeRuntime();
                if (iSysBDSchemeRuntime == null) {
                    throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u5b9e\u4f53[%1$s]\u6ca1\u6709\u6307\u5b9a\u7cfb\u7edf\u5927\u6570\u636e\u4f53\u7cfb", iDataEntityRuntime.getName()));
                }
                ISystemPersistentAdapter iSystemPersistentAdapter = this.bdPersistentAdapterMap.get(iSysBDSchemeRuntime.getId());
                if (iSystemPersistentAdapter == null) {
                    ISysBDPersistentAdapter iSysBDPersistentAdapter = this.createSysBDPersistentAdapter(iSysBDSchemeRuntime);
                    Assert.notNull((Object)iSysBDPersistentAdapter, (String)"\u7cfb\u7edf\u5927\u6570\u636e\u6301\u4e45\u5316\u9002\u914d\u5668\u65e0\u6548");
                    try {
                        iSysBDPersistentAdapter.init(this.getSystemRuntimeContext(), iSysBDSchemeRuntime);
                    }
                    catch (Exception ex) {
                        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u5927\u6570\u636e[%1$s]\u6301\u4e45\u5316\u9002\u914d\u5668\u53d1\u751f\u5f02\u5e38, %2$s", iSysBDSchemeRuntime.getName(), ex.getMessage()), ex);
                    }
                    this.bdPersistentAdapterMap.put(iSysBDSchemeRuntime.getId(), iSysBDPersistentAdapter);
                    return iSysBDPersistentAdapter;
                }
                return iSystemPersistentAdapter;
            }
            case 0: {
                if (!iDataEntityRuntime.isVirtual()) break;
                if (iDataEntityRuntime.getVirtualMode() == 1) {
                    if (iDataEntityRuntime.getPSDERMultiInherits() == null || iDataEntityRuntime.getPSDERMultiInherits().size() <= 0) break;
                    IDataEntityRuntime majorDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iDataEntityRuntime.getPSDERMultiInherits().get(0).getMajorPSDataEntityMust().getId());
                    return this.getSystemPersistentAdapter(majorDataEntityRuntime);
                }
                if (iDataEntityRuntime.getVirtualMode() != 3) break;
                try {
                    if (iDataEntityRuntime.getPSDataEntity().getMajorPSDERs() != null && iDataEntityRuntime.getPSDataEntity().getMajorPSDERs().size() > 0) {
                        for (IPSDERBase iPSDERBase : iDataEntityRuntime.getPSDataEntity().getMajorPSDERs()) {
                            ISystemPersistentAdapter iSystemPersistentAdapter;
                            ISysDBSchemeRuntime minorSysDBSchemeRuntime;
                            IDataEntityRuntime minorDataEntityRuntime;
                            if (!"DERINDEX".equals(iPSDERBase.getDERType()) || (minorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMinorPSDataEntityMust().getId())).getSystemPersistentAdapter() == null || (minorSysDBSchemeRuntime = minorDataEntityRuntime.getSysDBSchemeRuntime()) == null || (iSystemPersistentAdapter = this.dbPersistentAdapterMap.get(minorSysDBSchemeRuntime.getId())) == null) continue;
                            return iSystemPersistentAdapter;
                        }
                    }
                    break;
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u8ba1\u7b97\u865a\u62df\u7d22\u5f15\u5b9e\u4f53\u6301\u4e45\u5316\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                }
            }
        }
        throw new SystemRuntimeException(this.getSystemRuntimeContext().getSystemRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5b9e\u4f53[%1$s]\u5b58\u50a8\u6a21\u5f0f[%2$s]", iDataEntityRuntime.getName(), iDataEntityRuntime.getStorageMode()));
    }

    protected ISysDBPersistentAdapter createSysDBPersistentAdapter(ISysDBSchemeRuntime iSysDBSchemeRuntime) {
        ISysDBPersistentAdapter iSysDBPersistentAdapter = this.getSystemRuntime().getRuntimeObject("GLOBAL_DBPERSISTENTADAPTER", ISysDBPersistentAdapter.class, true, true);
        if (iSysDBPersistentAdapter != null) {
            return iSysDBPersistentAdapter;
        }
        iSysDBPersistentAdapter = this.getSystemRuntime().getRuntimeObject(ISysDBPersistentAdapter.class, null);
        if (iSysDBPersistentAdapter != null) {
            return iSysDBPersistentAdapter;
        }
        return this.createDefaultSysDBPersistentAdapter();
    }

    protected ISysDBPersistentAdapter createDefaultSysDBPersistentAdapter() {
        return new SysDBPersistentAdapter();
    }

    protected ISysBDPersistentAdapter createSysBDPersistentAdapter(ISysBDSchemeRuntime iSysBDSchemeRuntime) {
        ISysBDPersistentAdapter iSysBDPersistentAdapter = this.getSystemRuntime().getRuntimeObject("GLOBAL_BDPERSISTENTADAPTER", ISysBDPersistentAdapter.class, true, true);
        if (iSysBDPersistentAdapter != null) {
            return iSysBDPersistentAdapter;
        }
        iSysBDPersistentAdapter = this.getSystemRuntime().getRuntimeObject(ISysBDPersistentAdapter.class, null);
        if (iSysBDPersistentAdapter != null) {
            return iSysBDPersistentAdapter;
        }
        return this.createDefaultSysBDPersistentAdapter();
    }

    protected ISysBDPersistentAdapter createDefaultSysBDPersistentAdapter() {
        return new SysBDPersistentAdapter();
    }

    @Override
    public Object create(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, IEntity iEntity, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).create(iDataEntityRuntime, iPSDEAction, iEntity, inputFields, bGet, outputFields, bSysMode);
    }

    @Override
    public Object update(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, IEntity iEntity, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).update(iDataEntityRuntime, iPSDEAction, iEntity, inputFields, bGet, outputFields, bSysMode);
    }

    @Override
    public Object get(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, Object key, String[] outputFields, boolean bTryMode) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).get(iDataEntityRuntime, iPSDEAction, key, outputFields, bTryMode);
    }

    @Override
    public Object get(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, Object key, String[] outputFields, boolean bTryMode) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).get(iDataEntityRuntime, iPSDEDataQuery, key, outputFields, bTryMode);
    }

    @Override
    public void remove(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, Object key, boolean bSysMode) throws Throwable {
        this.getSystemPersistentAdapter(iDataEntityRuntime).remove(iDataEntityRuntime, iPSDEAction, key, bSysMode);
    }

    @Override
    public Object create(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<? extends IEntity> datas, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).create(iDataEntityRuntime, iPSDEAction, datas, inputFields, bGet, outputFields, bSysMode);
    }

    @Override
    public Object update(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<? extends IEntity> datas, String[] inputFields, boolean bGet, String[] outputFields, boolean bSysMode) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).update(iDataEntityRuntime, iPSDEAction, datas, inputFields, bGet, outputFields, bSysMode);
    }

    @Override
    public List get(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<Object> keys, String[] outputFields) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).get(iDataEntityRuntime, iPSDEAction, keys, outputFields);
    }

    @Override
    public void remove(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, List<Object> keys, boolean bSysMode) throws Throwable {
        this.getSystemPersistentAdapter(iDataEntityRuntime).remove(iDataEntityRuntime, iPSDEAction, keys, bSysMode);
    }

    @Override
    public int checkKeyState(IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, Object objKey) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).checkKeyState(iDataEntityRuntime, iPSDEAction, objKey);
    }

    @Override
    public List query(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).query(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields);
    }

    @Override
    public Page query2(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).query2(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields);
    }

    @Override
    public Page fetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields) throws Throwable {
        return this.getSystemPersistentAdapter(iDataEntityRuntime).fetchDataSet(iDataEntityRuntime, iPSDEDataSet, iSearchContext, outputFields);
    }
}

