/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.ibizsys.central.ISystemGateway;
import net.ibizsys.central.ISystemGatewayContext;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.SystemRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelServiceImpl;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.domain.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SystemGateway
implements ISystemGateway {
    private static final Log log = LogFactory.getLog(SystemGateway.class);
    private static ISystemGateway instance = null;
    private Map<String, ISystemRuntime> systemRuntimeMap = new ConcurrentHashMap<String, ISystemRuntime>();
    private Map<Class<?>, Boolean> multiInstanceModeMap = new HashMap();
    private Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private ISystemGatewayContext iSystemGatewayContext = new ISystemGatewayContext(){

        @Override
        public boolean isMultiSystemMode() {
            return SystemGateway.this.getSelf().isMultiSystemMode();
        }

        @Override
        public IDEService getDEService(String strSystemId, String strDataEntityId) {
            return SystemGateway.this.getSelf().getDEService(strSystemId, strDataEntityId);
        }

        @Override
        public IDataEntityRuntime getDataEntityRuntime(String strSystemId, String strDataEntityId) {
            return SystemGateway.this.getSelf().getDataEntityRuntime(strSystemId, strDataEntityId);
        }

        @Override
        public boolean isEnableAppGateway() {
            return SystemGateway.this.getSelf().isEnableAppGateway();
        }

        @Override
        public String getReportFolder() {
            return SystemGateway.this.getSelf().getReportFolder();
        }

        @Override
        public String getFontFolder() {
            return SystemGateway.this.getSelf().getFontFolder();
        }

        @Override
        public String getTempFolder() {
            return SystemGateway.this.getSelf().getTempFolder();
        }

        @Override
        public String getFileFolder() {
            return SystemGateway.this.getSelf().getFileFolder();
        }

        @Override
        public boolean isMultiInstanceMode(Class<?> runtimeClass) {
            return SystemGateway.this.getSelf().isMultiInstanceMode(runtimeClass);
        }

        @Override
        public IDEService getDEService(Class<?> runtimeCls, String strDataEntityId, boolean bTryMode) {
            return SystemGateway.this.getSelf().getDEService(runtimeCls, strDataEntityId, bTryMode);
        }

        @Override
        public DataSource getDataSource(String strDSTag, boolean bTryMode) {
            return SystemGateway.this.getSelf().getDataSource(strDSTag, bTryMode);
        }

        @Override
        public DataSource getDefaultDataSource() {
            return SystemGateway.this.getSelf().getDefaultDataSource();
        }
    };
    private Map<String, String> systemModelFolderPath = new ConcurrentHashMap<String, String>();
    private Map<String, IDEService> systemDEServiceMap = new ConcurrentHashMap<String, IDEService>();
    private Map<String, Object> systemGatewayParamMap = new HashMap<String, Object>();
    private boolean bMultiSystemMode = true;
    private boolean bEnableAppGateway = false;
    private String strTempFolder = null;
    private String strFileFolder = null;
    private String strReportFolder = null;
    private String strFontFolder = null;
    private DataSource defaultDataSource = null;

    public static ISystemGateway getInstance() {
        return SystemGateway.getInstance(false);
    }

    public static ISystemGateway getInstance(boolean bTryMode) {
        if (instance != null || bTryMode) {
            return instance;
        }
        throw new RuntimeException("\u7cfb\u7edf\u7f51\u5173\u5b9e\u4f8b\u4e0d\u5b58\u5728");
    }

    protected static void setInstance(ISystemGateway instance) {
        SystemGateway.instance = instance;
    }

    private SystemGateway getSelf() {
        return this;
    }

    @Override
    public DataSource getDataSource(String strDSTag, boolean bTryMode) {
        DataSource dataSource = null;
        dataSource = StringUtils.hasLength((String)strDSTag) ? this.dataSourceMap.get(strDSTag) : this.getDefaultDataSource();
        if (dataSource != null || bTryMode) {
            return dataSource;
        }
        throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u6e90[%1$s]", strDSTag));
    }

    protected void setDataSource(String strDSTag, DataSource dataSource) {
        this.dataSourceMap.put(strDSTag, dataSource);
    }

    @Override
    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    protected void setDefaultDataSource(DataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    @Override
    public boolean fillDataSourceInfo(ISysDBSchemeRuntime iSysDBSchemeRuntime) {
        return false;
    }

    @Override
    public Object invokeDEMethod(String strSystemId, String strDataEntityName, String strMethodName, Object objArg, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeDEMethod(strDataEntityName, strMethodName, objArg, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIMethod(String strSystemId, String strAPICodeName, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        return this.invokeAPIMethod(strSystemId, strAPICodeName, null, null, strDataEntityName, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIMethod(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIMethod(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIImportData(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIImportData(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIImportData2(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIImportData2(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIGetImportTemplate(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIGetImportTemplate(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strExportTag, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIExportData(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIExportData(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strExportTag, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIExportData(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIExportData(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIPrintData(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIPrintData(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strPrintTag, strPrintType, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIWFStart(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIWFStart(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIWFCancel(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIWFCancel(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeBackendTask(String strSystemId, String strTaskType, String strTaskTag, String strDynaInstId, String strParam, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeBackendTask(strTaskType, strTaskTag, strDynaInstId, strParam, iUserContext, objTag);
    }

    protected ISystemGatewayContext getSystemGatewayContext() {
        return this.iSystemGatewayContext;
    }

    @Override
    public ISystemRuntime getSystemRuntime(String strDeploySystemId) {
        ISystemRuntime iSystemRuntime = this.systemRuntimeMap.get(strDeploySystemId);
        if (iSystemRuntime != null) {
            return iSystemRuntime;
        }
        try {
            IPSSystemService iPSSystemService = this.getPSSystemService(strDeploySystemId);
            iSystemRuntime = this.createSystemRuntime(iPSSystemService, strDeploySystemId);
            iSystemRuntime.init(this.getSystemGatewayContext(), iPSSystemService, strDeploySystemId, null);
            this.systemRuntimeMap.put(strDeploySystemId, iSystemRuntime);
            return iSystemRuntime;
        }
        catch (Exception ex) {
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]\uff0c%2$s", strDeploySystemId, ex.getMessage()), ex);
        }
    }

    public ISystemRuntime getLoadedSystemRuntime(String strDeploySystemId, boolean bTryMode) {
        ISystemRuntime iSystemRuntime = this.systemRuntimeMap.get(strDeploySystemId);
        if (iSystemRuntime != null || bTryMode) {
            return iSystemRuntime;
        }
        throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", strDeploySystemId));
    }

    protected IPSSystemService getPSSystemService(String strDeploySystemId) throws Exception {
        String strModelFolderPath = this.getSystemModelFolderPath(strDeploySystemId);
        if (!StringUtils.hasLength((String)strModelFolderPath)) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u90e8\u7f72\u7cfb\u7edf[%1$s]\u6a21\u578b\u8def\u5f84", strDeploySystemId));
        }
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(strModelFolderPath);
        return psModelServiceImpl;
    }

    protected ISystemRuntime createSystemRuntime(IPSSystemService iPSSystemService) throws Exception {
        return new SystemRuntime();
    }

    protected ISystemRuntime createSystemRuntime(IPSSystemService iPSSystemService, String strDeploySystemId) throws Exception {
        return this.createSystemRuntime(iPSSystemService);
    }

    public void registerSystemModelFolderPath(String strDeploySystemId, String strFolderPath) {
        Assert.hasLength((String)strDeploySystemId, (String)"\u5fc5\u987b\u6307\u5b9a\u90e8\u7f72\u7cfb\u7edf\u6807\u8bc6");
        Assert.hasLength((String)strFolderPath, (String)"\u5fc5\u987b\u6307\u5b9a\u90e8\u7f72\u7cfb\u7edf\u6a21\u578b\u8def\u5f84");
        this.systemModelFolderPath.put(strDeploySystemId, strFolderPath);
    }

    protected String getSystemModelFolderPath(String strDeploySystemId) {
        return this.systemModelFolderPath.get(strDeploySystemId);
    }

    public void registerSystemRuntime(String strDeploySystemId, ISystemRuntime iSystemRuntime) throws Exception {
        Assert.hasLength((String)strDeploySystemId, (String)"\u5fc5\u987b\u6307\u5b9a\u90e8\u7f72\u7cfb\u7edf\u6807\u8bc6");
        Assert.notNull((Object)iSystemRuntime, (String)"\u5fc5\u987b\u6307\u5b9a\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61");
        this.systemRuntimeMap.put(strDeploySystemId, iSystemRuntime);
    }

    public void unregisterSystemRuntime(String strDeploySystemId) throws Exception {
        Assert.hasLength((String)strDeploySystemId, (String)"\u5fc5\u987b\u6307\u5b9a\u90e8\u7f72\u7cfb\u7edf\u6807\u8bc6");
        this.systemRuntimeMap.remove(strDeploySystemId);
    }

    @Override
    public boolean isMultiSystemMode() {
        return this.bMultiSystemMode;
    }

    protected void setMultiSystemMode(boolean bMultiSystemMode) {
        this.bMultiSystemMode = bMultiSystemMode;
    }

    @Override
    public boolean isEnableAppGateway() {
        return this.bEnableAppGateway;
    }

    protected void setEnableAppGateway(boolean bEnableAppGateway) {
        this.bEnableAppGateway = bEnableAppGateway;
    }

    @Override
    public void registerDEService(String strSystemId, String strDataEntityId, IDEService iDEService) {
        if (this.isMultiSystemMode()) {
            return;
        }
        String strDEServiceTag = String.format("%1$s|%2$s", strSystemId, strDataEntityId);
        this.systemDEServiceMap.put(strDEServiceTag, iDEService);
    }

    @Override
    public IDEService getDEService(String strSystemId, String strDataEntityId) {
        return this.getDEService(strSystemId, strDataEntityId, false);
    }

    @Override
    public IDEService getDEService(String strSystemId, String strDataEntityId, boolean bTryMode) {
        if (this.isMultiSystemMode()) {
            ISystemRuntime iSystemRuntime = null;
            try {
                iSystemRuntime = this.getSystemRuntime(strSystemId);
            }
            catch (Throwable e) {
                throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", strSystemId));
            }
            try {
                return iSystemRuntime.getDEService(strDataEntityId);
            }
            catch (Throwable e) {
                if (bTryMode) {
                    return null;
                }
                throw e;
            }
        }
        String strDEServiceTag = String.format("%1$s|%2$s", strSystemId, strDataEntityId);
        IDEService iDEService = this.systemDEServiceMap.get(strDEServiceTag);
        if (iDEService == null) {
            if (bTryMode) {
                return null;
            }
            throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u5b9e\u4f53\u670d\u52a1\u5bf9\u8c61[%1$s][%2$s]", strSystemId, strDataEntityId));
        }
        return iDEService;
    }

    @Override
    public void registerDEService(Class<?> runtimeCls, String strDataEntityId, IDEService iDEService) {
        if (this.isMultiInstanceMode(runtimeCls)) {
            return;
        }
        String strDEServiceTag = String.format("%1$s|%2$s", runtimeCls.getName(), strDataEntityId);
        this.systemDEServiceMap.put(strDEServiceTag, iDEService);
    }

    @Override
    public IDEService getDEService(Class<?> runtimeCls, String strDataEntityId, boolean bTryMode) {
        if (this.isMultiInstanceMode(runtimeCls)) {
            ISystemRuntime iSystemRuntime = null;
            try {
                iSystemRuntime = (ISystemRuntime)this.getSystemRuntime(runtimeCls, false);
            }
            catch (Throwable e) {
                throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", runtimeCls.getName()));
            }
            try {
                return iSystemRuntime.getDEService(strDataEntityId);
            }
            catch (Throwable e) {
                if (bTryMode) {
                    return null;
                }
                throw e;
            }
        }
        String strDEServiceTag = String.format("%1$s|%2$s", runtimeCls.getName(), strDataEntityId);
        IDEService iDEService = this.systemDEServiceMap.get(strDEServiceTag);
        if (iDEService == null) {
            if (bTryMode) {
                return null;
            }
            throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u5b9e\u4f53\u670d\u52a1\u5bf9\u8c61[%1$s][%2$s]", runtimeCls.getName(), strDataEntityId));
        }
        return iDEService;
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime(String strSystemId, String strDataEntityId) {
        ISystemRuntime iSystemRuntime = null;
        try {
            iSystemRuntime = this.getSystemRuntime(strSystemId);
        }
        catch (Exception e) {
            throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", strSystemId));
        }
        return iSystemRuntime.getDataEntityRuntime(strDataEntityId);
    }

    @Override
    public <T> T getSystemRuntime(Class<T> cls, boolean bTryMode) {
        for (ISystemRuntime iSystemRuntime : this.systemRuntimeMap.values()) {
            if (!cls.isAssignableFrom(iSystemRuntime.getClass())) continue;
            return (T)iSystemRuntime;
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", cls.getCanonicalName()));
    }

    @Override
    public <T> T getSysUtilRuntime(Class<?> systemCls, Class<T> cls, boolean bTryMode) {
        ISystemRuntime iSystemRuntime;
        if (systemCls != null && (iSystemRuntime = (ISystemRuntime)this.getSystemRuntime(systemCls, true)) != null) {
            return iSystemRuntime.getSysUtilRuntime(cls, bTryMode);
        }
        for (ISystemRuntime iSystemRuntime2 : this.getSystemRuntimes()) {
            T t = iSystemRuntime2.getSysUtilRuntime(cls, true);
            if (t == null) continue;
            return t;
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemGatewayException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", cls.getCanonicalName()));
    }

    public void setGatewayParam(String strName, Object objValue) {
        this.systemGatewayParamMap.put(strName, objValue);
    }

    public Object removeGatewayParam(String strName) {
        return this.systemGatewayParamMap.remove(strName);
    }

    public boolean containsGatewayParam(String strName) {
        return this.systemGatewayParamMap.containsKey(strName);
    }

    public Object getGatewayParam(String strName) {
        return this.systemGatewayParamMap.get(strName);
    }

    public void resetGatewayParams() {
        this.systemGatewayParamMap.clear();
    }

    @Override
    public Collection<ISystemRuntime> getSystemRuntimes() {
        return this.systemRuntimeMap.values();
    }

    @Override
    public Object invokeAppMethod(String strSystemId, String strAppCodeName, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        return this.invokeAppMethod(strSystemId, strAppCodeName, null, null, strDataEntityName, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAppMethod(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppMethod(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAppImportData(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppImportData(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAppExportData(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppExportData(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strExportTag, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAppExportData(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppExportData(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAppPrintData(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppPrintData(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strPrintTag, strPrintType, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAppWFStart(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppWFStart(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAppWFCancel(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppWFCancel(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIUploadFile(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIUploadFile(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAPIDownloadFile(String strSystemId, String strAPICodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAPIDownloadFile(strAPICodeName, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAppUploadFile(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppUploadFile(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, iUserContext, objTag);
    }

    @Override
    public Object invokeAppDownloadFile(String strSystemId, String strAppCodeName, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, IUserContext iUserContext, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strSystemId);
        return iSystemRuntime.invokeAppDownloadFile(strAppCodeName, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, iUserContext, objTag);
    }

    public String getReportFolder() {
        return this.strReportFolder;
    }

    public void setReportFolder(String strReportFolder) {
        this.strReportFolder = strReportFolder;
    }

    public String getFontFolder() {
        return this.strFontFolder;
    }

    public void setFontFolder(String strFontFolder) {
        this.strFontFolder = strFontFolder;
    }

    public String getFileFolder() {
        return this.strFileFolder;
    }

    public void setFileFolder(String strFileFolder) {
        this.strFileFolder = strFileFolder;
    }

    public String getTempFolder() {
        return this.strTempFolder;
    }

    public void setTempFolder(String strTempFolder) {
        this.strTempFolder = strTempFolder;
    }

    @Override
    public boolean isMultiInstanceMode(Class<?> runtimeClass) {
        Boolean bRet = this.getMultiInstanceMode(runtimeClass);
        if (bRet != null) {
            return bRet;
        }
        return true;
    }

    public void setMultiInstanceMode(Class<?> runtimeClass, Boolean bMode) {
        this.multiInstanceModeMap.put(runtimeClass, bMode);
    }

    public Boolean getMultiInstanceMode(Class<?> runtimeClass) {
        return this.multiInstanceModeMap.get(runtimeClass);
    }
}

