/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class ObjectNodeUtils {
    public static Properties fillProperties(ObjectNode objectNode, Properties properties, String strFieldPrefix) {
        Iterator fields = objectNode.fields();
        if (fields != null) {
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String strKey = (String)entry.getKey();
                if (StringUtils.hasLength((String)strFieldPrefix)) {
                    if (strKey.indexOf(strFieldPrefix) != 0) continue;
                    strKey = strKey.substring(strFieldPrefix.length());
                }
                if (properties == null) {
                    properties = new Properties();
                }
                properties.put(strKey, ((JsonNode)entry.getValue()).textValue());
            }
        }
        return properties;
    }

    public static String getFieldValue(ObjectNode objectNode, String strKey, String strDefault) {
        JsonNode node = objectNode.get(strKey);
        if (node != null) {
            return node.asText(strDefault);
        }
        return strDefault;
    }

    public static int getFieldValue(ObjectNode objectNode, String strKey, int nDefault) {
        JsonNode node = objectNode.get(strKey);
        if (node != null) {
            return node.asInt(nDefault);
        }
        return nDefault;
    }

    public static long getFieldValue(ObjectNode objectNode, String strKey, long nDefault) {
        JsonNode node = objectNode.get(strKey);
        if (node != null) {
            return node.asLong(nDefault);
        }
        return nDefault;
    }

    public static double getFieldValue(ObjectNode objectNode, String strKey, double fDefault) {
        JsonNode node = objectNode.get(strKey);
        if (node != null) {
            return node.asDouble(fDefault);
        }
        return fDefault;
    }
}

