/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.List;
import java.util.TimeZone;
import net.ibizsys.runtime.util.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DataTypeUtils {
    private static final Log log = LogFactory.getLog(DataTypeUtils.class);

    public static Object parse(int dataType, String strValue) throws Exception {
        if (!StringUtils.hasLength((String)strValue)) {
            return null;
        }
        if (dataType == 1) {
            return DataTypeUtils.testBigInt(strValue);
        }
        if (dataType == 9 || dataType == 17) {
            return DataTypeUtils.testInteger(strValue);
        }
        if (dataType == 4 || dataType == 11 || dataType == 12 || dataType == 13 || dataType == 20 || dataType == 21 || dataType == 25) {
            return strValue;
        }
        if (dataType == 5 || dataType == 16 || dataType == 27 || dataType == 28) {
            return DataTypeUtils.testDateTime(strValue);
        }
        if (dataType == 10 || dataType == 14 || dataType == 18 || dataType == 7 || dataType == 15) {
            return DataTypeUtils.testDouble(strValue);
        }
        if (dataType == 6 || dataType == 29) {
            return DataTypeUtils.testDecimal(strValue);
        }
        if (dataType == 24 || dataType == 2) {
            return DataTypeUtils.testByteArray(strValue);
        }
        return strValue;
    }

    public static Object convert(int dataType, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof String && !StringUtils.hasLength((String)((String)value))) {
            return null;
        }
        if (dataType == 1) {
            return DataTypeUtils.getBigIntegerValue(value, null);
        }
        if (dataType == 9 || dataType == 17) {
            return DataTypeUtils.getIntegerValue(value, null);
        }
        if (dataType == 4 || dataType == 11 || dataType == 12 || dataType == 13 || dataType == 20 || dataType == 21 || dataType == 25) {
            return DataTypeUtils.getStringValue(value, null);
        }
        if (dataType == 5 || dataType == 16 || dataType == 27 || dataType == 28) {
            return DataTypeUtils.getDateTimeValue(value, null);
        }
        if (dataType == 10 || dataType == 14 || dataType == 18 || dataType == 7 || dataType == 15) {
            return DataTypeUtils.getDoubleValue(value, null);
        }
        if (dataType == 6 || dataType == 29) {
            return DataTypeUtils.getBigDecimalValue(value, null);
        }
        if (dataType == 24) {
            return DataTypeUtils.getByteArrayValue(value, null);
        }
        return value;
    }

    public static int getObjectDataType(Object objValue) {
        if (objValue == null) {
            return 25;
        }
        if (objValue instanceof String || objValue instanceof Character) {
            return 25;
        }
        if (objValue instanceof Integer) {
            return 9;
        }
        if (objValue instanceof Float || objValue instanceof Double) {
            return 15;
        }
        if (objValue instanceof Date || objValue instanceof java.util.Date || objValue instanceof Timestamp) {
            return 5;
        }
        if (objValue instanceof BigInteger || objValue instanceof Long) {
            return 1;
        }
        if (objValue instanceof BigDecimal) {
            return 29;
        }
        if (objValue instanceof Byte[] || objValue instanceof byte[]) {
            return 24;
        }
        return 25;
    }

    public static Object testBigInt(String strInput) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        strInput = strInput.replace(",", "");
        return new BigInteger(strInput);
    }

    public static Object testInteger(String strInput) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        strInput = strInput.replace(",", "");
        int nValue = Integer.parseInt(strInput);
        return nValue;
    }

    public static Object testDecimal(String strInput) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        strInput = strInput.replace(",", "");
        return new BigDecimal(strInput);
    }

    public static Object testDouble(String strInput) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        strInput = strInput.replace(",", "");
        double fValue = Double.parseDouble(strInput);
        return fValue;
    }

    public static Object testDate(String strInput, TimeZone timeZone) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        java.util.Date dtDate = DateUtils.parse(strInput, timeZone);
        Date retDate = new Date(dtDate.getTime());
        return retDate;
    }

    public static Object testDate(String strInput) throws Exception {
        return DataTypeUtils.testDate(strInput, null);
    }

    public static Object testTime(String strInput) throws Exception {
        return DataTypeUtils.testTime(strInput, null);
    }

    public static Object testTime(String strInput, TimeZone timeZone) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        java.util.Date dtDate = DateUtils.parse(strInput, timeZone);
        Time retTime = new Time(dtDate.getTime());
        return retTime;
    }

    public static Object testDateTime(String strInput) throws Exception {
        return DataTypeUtils.testDateTime(strInput, null);
    }

    public static Object testDateTime(String strInput, TimeZone timeZone) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        java.util.Date dtDate = DateUtils.parse(strInput, timeZone);
        Timestamp retDate = new Timestamp(dtDate.getTime());
        return retDate;
    }

    public static Object testByteArray(String strInput) throws Exception {
        if (!StringUtils.hasLength((String)strInput)) {
            return null;
        }
        return Base64.getDecoder().decode(strInput);
    }

    public static final byte[] getByteArrayValue(Object objValue, byte[] def) {
        if (objValue == null) {
            return def;
        }
        if (objValue instanceof byte[]) {
            return (byte[])objValue;
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return def;
        }
        strValue = strValue.replace(",", "");
        return Base64.getDecoder().decode(strValue);
    }

    public static long compare(int dataType, Object objValue, Object objValueCompare) {
        if (objValue == null || objValueCompare == null) {
            if (objValue == null && objValueCompare == null) {
                return 0L;
            }
            if (objValue == null) {
                return 1L;
            }
            return -1L;
        }
        long nTemp = 0L;
        if (dataType == 1) {
            BigInteger nValue2 = !(objValue instanceof BigInteger) ? new BigInteger(objValue.toString()) : (BigInteger)objValue;
            BigInteger nValueCompare2 = !(objValueCompare instanceof BigInteger) ? new BigInteger(objValueCompare.toString()) : (BigInteger)objValueCompare;
            nTemp = nValue2.longValue() - nValueCompare2.longValue();
        } else if (dataType == 9 || dataType == 17) {
            Integer nValue = !(objValue instanceof Integer) ? Integer.valueOf(Integer.parseInt(objValue.toString())) : (Integer)objValue;
            Integer nValueCompare = !(objValueCompare instanceof Integer) ? Integer.valueOf(Integer.parseInt(objValueCompare.toString())) : (Integer)objValueCompare;
            nTemp = nValue - nValueCompare;
        } else if (dataType == 5 || dataType == 16 || dataType == 27 || dataType == 28) {
            long nTime1 = DataTypeUtils.getDateTimeValue(objValue);
            long nTime2 = DataTypeUtils.getDateTimeValue(objValueCompare);
            nTemp = nTime1 - nTime2;
        } else if (dataType == 10 || dataType == 14 || dataType == 18 || dataType == 7 || dataType == 15) {
            Double fValue = !(objValue instanceof Double) ? Double.valueOf(Double.parseDouble(objValue.toString())) : (Double)objValue;
            Double fValueCompare = !(objValueCompare instanceof Double) ? Double.valueOf(Double.parseDouble(objValueCompare.toString())) : (Double)objValueCompare;
            double fTemp = fValue - fValueCompare;
            nTemp = fTemp == 0.0 ? 0L : (fTemp > 0.0 ? 1L : -1L);
        } else if (dataType == 6 || dataType == 29) {
            BigDecimal fValueCompare2;
            BigDecimal fValue2 = !(objValue instanceof BigDecimal) ? new BigDecimal(objValue.toString()) : (BigDecimal)objValue;
            BigDecimal fTemp = fValue2.subtract(fValueCompare2 = !(objValueCompare instanceof BigDecimal) ? new BigDecimal(objValueCompare.toString()) : (BigDecimal)objValueCompare);
            nTemp = fTemp.doubleValue() == 0.0 ? 0L : (fTemp.doubleValue() > 0.0 ? 1L : -1L);
        } else if (dataType == 4 || dataType == 11 || dataType == 12 || dataType == 13 || dataType == 20 || dataType == 21 || dataType == 25) {
            nTemp = objValue.toString().compareTo(objValueCompare.toString());
        } else if (dataType == 24) {
            byte[] val = DataTypeUtils.getByteArrayValue(objValue, null);
            byte[] valCompare = DataTypeUtils.getByteArrayValue(objValueCompare, null);
            nTemp = Base64.getEncoder().encodeToString(val).compareTo(Base64.getEncoder().encodeToString(valCompare));
        }
        if (nTemp == 0L) {
            return 0L;
        }
        if (nTemp > 0L) {
            return 1L;
        }
        return -1L;
    }

    public static long compare(String strValue, String strValueCompare) {
        return DataTypeUtils.compare(strValue, strValueCompare, false);
    }

    public static long compare(String strValue, String strValueCompare, boolean bIgnoreCase) {
        if (strValue == null || strValueCompare == null) {
            if (strValue == null && strValueCompare == null) {
                return 0L;
            }
            if (strValue == null) {
                return 1L;
            }
            return -1L;
        }
        long nTemp = 0L;
        nTemp = !bIgnoreCase ? (long)strValue.compareTo(strValueCompare) : (long)strValue.compareToIgnoreCase(strValueCompare);
        if (nTemp == 0L) {
            return 0L;
        }
        if (nTemp > 0L) {
            return 1L;
        }
        return -1L;
    }

    public static boolean isStringDataType(int dataType) {
        switch (dataType) {
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLongStringDataType(int dataType) {
        switch (dataType) {
            case 12: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLongBinaryDataType(int dataType) {
        switch (dataType) {
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isBinaryType(int dataType) {
        return dataType == 2 || dataType == 24;
    }

    public static boolean isDateTimeDataType(int dataType) {
        switch (dataType) {
            case 5: 
            case 16: 
            case 22: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isIntDataType(int dataType) {
        return dataType == 9 || dataType == 17 || dataType == 1 || dataType == 23;
    }

    public static final boolean isDoubleDataType(int dataType) {
        return dataType == 7 || dataType == 6 || dataType == 10 || dataType == 18 || dataType == 14 || dataType == 15 || dataType == 29;
    }

    public static final boolean isBigIntDataType(int dataType) {
        return dataType == 1;
    }

    public static final boolean isBigDecimalDataType(int dataType) {
        return dataType == 29 || dataType == 6;
    }

    public static final boolean isNumberDataType(int dataType) {
        return DataTypeUtils.isIntDataType(dataType) || DataTypeUtils.isDoubleDataType(dataType);
    }

    public static long getDateTimeValue(Object obj) {
        if (obj instanceof Time) {
            return ((Time)obj).getTime();
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        if (obj instanceof Timestamp) {
            return ((Timestamp)obj).getTime();
        }
        if (obj instanceof java.util.Date) {
            return ((java.util.Date)obj).getTime();
        }
        return -1L;
    }

    public static boolean testCond(Object objSrcValue, String strOp, Object objDstValue) throws Exception {
        return DataTypeUtils.testCond(objSrcValue, strOp, objDstValue, 0);
    }

    public static boolean testCond(Object objSrcValue, String strOp, Object objDstValue, int nValueDataType) throws Exception {
        if ("ISNULL".equals(strOp)) {
            return objSrcValue == null;
        }
        if ("ISNOTNULL".equals(strOp)) {
            return objSrcValue != null;
        }
        if (objSrcValue == null) {
            if ("EQ".equals(strOp)) {
                return objDstValue == null;
            }
            if ("NOTEQ".equals(strOp)) {
                return objDstValue != null;
            }
            return false;
        }
        if (objSrcValue instanceof String) {
            String strSrcValue = (String)objSrcValue;
            String strDstValue = (String)objDstValue;
            if ("LEFTLIKE".equals(strOp)) {
                return strSrcValue.toUpperCase().indexOf(strDstValue.toUpperCase()) == 0;
            }
            if ("LIKE".equals(strOp)) {
                return strSrcValue.toUpperCase().indexOf(strDstValue.toUpperCase()) != -1;
            }
            if ("RIGHTLIKE".equals(strOp)) {
                int nPos = strSrcValue.toUpperCase().indexOf(strDstValue.toUpperCase());
                if (nPos == -1) {
                    return false;
                }
                return nPos + strDstValue.length() == strSrcValue.length();
            }
        }
        if (nValueDataType == 0) {
            nValueDataType = DataTypeUtils.getObjectDataType(objSrcValue);
        }
        long nRet = DataTypeUtils.compare(nValueDataType, objSrcValue, objDstValue);
        if ("EQ".equals(strOp)) {
            return nRet == 0L;
        }
        if ("NOTEQ".equals(strOp)) {
            return nRet != 0L;
        }
        if ("GT".equals(strOp)) {
            return nRet > 0L;
        }
        if ("GTANDEQ".equals(strOp)) {
            return nRet >= 0L;
        }
        if ("LT".equals(strOp)) {
            return nRet < 0L;
        }
        if ("LTANDEQ".equals(strOp)) {
            return nRet <= 0L;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6\u503c\u6bd4\u8f83\u64cd\u4f5c[%1$s](%2$s)[%3$s]", objSrcValue, strOp, objDstValue));
    }

    public static final Integer asInteger(Object objValue, Integer def) {
        try {
            return DataTypeUtils.getIntegerValue(objValue, def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final Integer getIntegerValue(Object objValue, Integer def) throws Exception {
        if (objValue == null) {
            return def;
        }
        if (objValue instanceof Integer) {
            return (Integer)objValue;
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return def;
        }
        strValue = strValue.replace(",", "");
        return Integer.parseInt(strValue);
    }

    public static final BigDecimal asBigDecimal(Object objValue, BigDecimal fDefault) {
        return DataTypeUtils.getBigDecimalValue(objValue, fDefault);
    }

    public static final BigDecimal getBigDecimalValue(Object objValue, BigDecimal fDefault) {
        if (objValue == null) {
            return fDefault;
        }
        if (objValue instanceof BigDecimal) {
            return (BigDecimal)objValue;
        }
        if (objValue instanceof BigInteger) {
            return new BigDecimal((BigInteger)objValue);
        }
        if (objValue instanceof Double) {
            return BigDecimal.valueOf((Double)objValue);
        }
        if (objValue instanceof Short) {
            return BigDecimal.valueOf(((Short)objValue).shortValue());
        }
        if (objValue instanceof Long) {
            return BigDecimal.valueOf((Long)objValue);
        }
        if (objValue instanceof Integer) {
            return BigDecimal.valueOf(((Integer)objValue).intValue());
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return fDefault;
        }
        strValue = strValue.replace(",", "");
        return new BigDecimal(strValue);
    }

    public static final BigInteger asBigInteger(Object objValue, BigInteger nDefault) {
        return DataTypeUtils.getBigIntegerValue(objValue, nDefault);
    }

    public static final BigInteger getBigIntegerValue(Object objValue, BigInteger nDefault) {
        if (objValue == null) {
            return nDefault;
        }
        if (objValue instanceof BigInteger) {
            return (BigInteger)objValue;
        }
        if (objValue instanceof BigDecimal) {
            return ((BigDecimal)objValue).toBigIntegerExact();
        }
        if (objValue instanceof Long) {
            return BigInteger.valueOf((Long)objValue);
        }
        if (objValue instanceof Integer) {
            return BigInteger.valueOf(((Integer)objValue).intValue());
        }
        if (objValue instanceof Double) {
            return BigInteger.valueOf(((Double)objValue).longValue());
        }
        if (objValue instanceof Short) {
            return BigInteger.valueOf(((Short)objValue).longValue());
        }
        String strValue = null;
        strValue = objValue instanceof String ? (String)objValue : objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return nDefault;
        }
        strValue = strValue.replace(",", "");
        return new BigInteger(strValue);
    }

    public static final Double asDouble(Object objValue, Double def) {
        try {
            return DataTypeUtils.getDoubleValue(objValue, def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final Double getDoubleValue(Object objValue, Double def) throws Exception {
        if (objValue == null) {
            return def;
        }
        if (objValue instanceof Double) {
            return (Double)objValue;
        }
        if (objValue instanceof Float) {
            return ((Float)objValue).doubleValue();
        }
        if (objValue instanceof BigDecimal) {
            return ((BigDecimal)objValue).doubleValue();
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return def;
        }
        strValue = strValue.replace(",", "");
        return Double.parseDouble(strValue);
    }

    public static final Float asFloat(Object objValue, Float def) {
        try {
            return DataTypeUtils.getFloatValue(objValue, def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final Float getFloatValue(Object objValue, Float def) throws Exception {
        if (objValue == null) {
            return def;
        }
        if (objValue instanceof Float) {
            return (Float)objValue;
        }
        if (objValue instanceof Double) {
            return Float.valueOf(((Double)objValue).floatValue());
        }
        if (objValue instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)objValue).floatValue());
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return def;
        }
        strValue = strValue.replace(",", "");
        return Float.valueOf(Float.parseFloat(strValue));
    }

    public static final Long asLong(Object objValue, Long def) {
        try {
            return DataTypeUtils.getLongValue(objValue, def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final Long getLongValue(Object objValue, Long def) throws Exception {
        if (objValue == null) {
            return def;
        }
        if (objValue instanceof Long) {
            return (Long)objValue;
        }
        if (objValue instanceof BigDecimal) {
            return ((BigDecimal)objValue).longValue();
        }
        if (objValue instanceof BigInteger) {
            return ((BigInteger)objValue).longValue();
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return def;
        }
        strValue = strValue.replace(",", "");
        return Long.parseLong(strValue);
    }

    public static Timestamp asDateTime(Object objValue, Timestamp def) {
        try {
            return DataTypeUtils.getDateTimeValue(objValue, def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Deprecated
    public static Timestamp asDateTimeValue(Object objValue, Timestamp def) {
        try {
            return DataTypeUtils.getDateTimeValue(objValue, def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Timestamp getDateTimeValue(Object objValue, Timestamp def) throws Exception {
        if (objValue == null) {
            return def;
        }
        if (objValue instanceof Timestamp) {
            return (Timestamp)objValue;
        }
        if (objValue instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)objValue).getTime());
        }
        if (objValue instanceof Time) {
            return new Timestamp(((Time)objValue).getTime());
        }
        if (objValue instanceof Date) {
            return new Timestamp(((Date)objValue).getTime());
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return def;
        }
        return new Timestamp(DateUtils.parse(strValue).getTime());
    }

    public static final Boolean asBoolean(Object objValue, Boolean def) {
        return DataTypeUtils.getBooleanValue(objValue, def);
    }

    public static final Boolean getBooleanValue(Object objValue, Boolean def) {
        if (objValue == null) {
            return def;
        }
        if (objValue instanceof Boolean) {
            return (Boolean)objValue;
        }
        String strValue = objValue.toString();
        if (!StringUtils.hasLength((String)strValue)) {
            return def;
        }
        return strValue.equalsIgnoreCase("true") || strValue.equalsIgnoreCase("1");
    }

    public static final String asString(Object objValue, String strDefault) {
        return DataTypeUtils.getStringValue(objValue, strDefault);
    }

    public static final String getStringValue(Object objValue, String strDefault) {
        if (objValue == null) {
            return strDefault;
        }
        if (objValue instanceof String) {
            return (String)objValue;
        }
        return objValue.toString();
    }

    public static final String format(String strFormat, Object[] arrList) {
        int nArrCount = arrList == null ? 0 : arrList.length;
        switch (nArrCount) {
            case 0: {
                return strFormat;
            }
            case 1: {
                return String.format(strFormat, arrList[0]);
            }
            case 2: {
                return String.format(strFormat, arrList[0], arrList[1]);
            }
            case 3: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2]);
            }
            case 4: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2], arrList[3]);
            }
            case 5: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2], arrList[3], arrList[4]);
            }
            case 6: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2], arrList[3], arrList[4], arrList[5]);
            }
            case 7: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2], arrList[3], arrList[4], arrList[5], arrList[6]);
            }
            case 8: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2], arrList[3], arrList[4], arrList[5], arrList[6], arrList[7]);
            }
            case 9: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2], arrList[3], arrList[4], arrList[5], arrList[6], arrList[7], arrList[8]);
            }
            case 10: {
                return String.format(strFormat, arrList[0], arrList[1], arrList[2], arrList[3], arrList[4], arrList[5], arrList[6], arrList[7], arrList[8], arrList[9]);
            }
        }
        throw new RuntimeException("\u5b57\u7b26\u4e32\u683c\u5f0f\u5316\u53c2\u6570\u4e0d\u80fd\u8d85\u8fc710");
    }

    public static String getTypeName(int dataType) {
        if (dataType == 1 || dataType == 9 || dataType == 17) {
            return "\u6574\u6570\u578b";
        }
        if (dataType == 4 || dataType == 11 || dataType == 12 || dataType == 13 || dataType == 20 || dataType == 21 || dataType == 25) {
            return "\u5b57\u7b26\u578b";
        }
        if (dataType == 5 || dataType == 16) {
            return "\u65e5\u671f\u65f6\u95f4\u578b";
        }
        if (dataType == 27) {
            return "\u65e5\u671f\u578b";
        }
        if (dataType == 28) {
            return "\u65f6\u95f4\u578b";
        }
        if (dataType == 6 || dataType == 29 || dataType == 10 || dataType == 14 || dataType == 18 || dataType == 7 || dataType == 15) {
            return "\u6570\u503c\u578b";
        }
        if (dataType == 2 || dataType == 24) {
            return "\u6570\u636e\u6d41\u578b";
        }
        return "\u672a\u77e5\u7c7b\u578b";
    }

    public static Object asSimple(Object object) {
        if (object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character) {
            return object;
        }
        if (object instanceof java.util.Date) {
            return ((java.util.Date)object).clone();
        }
        return null;
    }

    public static String[] toArray(List<String> list) {
        if (ObjectUtils.isEmpty(list)) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }
}

