/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.ISystemRuntimeException;
import net.ibizsys.runtime.ISystemRuntimeSetting;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.datasync.IDEDataSyncInRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.domain.DataSyncIn;
import net.ibizsys.runtime.util.domain.DataSyncOut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SysDataSyncAgentRuntimeBase
extends SystemModelRuntimeBase
implements ISysDataSyncAgentRuntime {
    private static final Log log = LogFactory.getLog(SysDataSyncAgentRuntimeBase.class);
    private IPSSysDataSyncAgent iPSSysDataSyncAgent = null;
    private List<IDEDataSyncInRuntime> deDataSyncInRuntimeList = null;
    private boolean bRawDataMode = false;

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSSysDataSyncAgent iPSSysDataSyncAgent) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
        this.iPSSysDataSyncAgent = iPSSysDataSyncAgent;
        if ("IN".equals(iPSSysDataSyncAgent.getSyncDir()) || "INOUT".equals(iPSSysDataSyncAgent.getSyncDir())) {
            this.deDataSyncInRuntimeList = new ArrayList<IDEDataSyncInRuntime>();
        }
        this.setRawDataMode(this.getPSSysDataSyncAgent().isRawDataMode());
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    public IPSSysDataSyncAgent getPSSysDataSyncAgent() {
        return this.iPSSysDataSyncAgent;
    }

    @Override
    public String getId() {
        return this.getPSSysDataSyncAgent().getDynaModelFilePath();
    }

    @Override
    public String getName() {
        return this.getPSSysDataSyncAgent().getName();
    }

    public ISystemRuntimeSetting getSystemRuntimeSetting() {
        if (this.getSystemRuntime() != null) {
            return this.getSystemRuntime().getSystemRuntimeSetting();
        }
        return null;
    }

    @Override
    public String getAgentType() {
        return this.getPSSysDataSyncAgent().getAgentType();
    }

    @Override
    public void send(DataSyncOut[] dataSyncOuts) {
        block8: {
            if (dataSyncOuts == null || dataSyncOuts.length == 0) {
                return;
            }
            try {
                if (!this.isRawDataMode()) {
                    String strSendData = null;
                    try {
                        strSendData = dataSyncOuts.length == 1 ? this.serializeSendData(dataSyncOuts[0]) : this.serializeSendData(dataSyncOuts);
                    }
                    catch (Throwable ex) {
                        throw new Exception(String.format("\u5e8f\u5217\u5316\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                    }
                    this.onSend(this.getSendData(strSendData, dataSyncOuts), dataSyncOuts);
                    break block8;
                }
                for (DataSyncOut dataSyncOut : dataSyncOuts) {
                    this.onSend(dataSyncOut.getData(), new DataSyncOut[]{dataSyncOut});
                }
            }
            catch (Throwable ex) {
                if (ex instanceof ISystemRuntimeException) {
                    throw (RuntimeException)ex;
                }
                log.error((Object)String.format("\u53d1\u9001\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u53d1\u9001\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
    }

    protected String getSendData(String strSendData, DataSyncOut[] dataSyncOuts) throws Throwable {
        ObjectNode packageNode = JsonUtils.createObjectNode();
        packageNode.put("agent", this.getPSSysDataSyncAgent().getCodeName());
        packageNode.put("data", strSendData);
        this.onFillSendData(packageNode, strSendData, dataSyncOuts);
        return packageNode.toString();
    }

    protected void onFillSendData(ObjectNode packageNode, String strSendData, DataSyncOut[] dataSyncOuts) throws Throwable {
    }

    protected String serializeSendData(Object data) throws Throwable {
        return (String)this.getSystemRuntime().serialize(data);
    }

    protected void onSend(String strSendData, DataSyncOut[] dataSyncOuts) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public void recv(DataSyncIn[] dataSyncIns) {
        if (this.deDataSyncInRuntimeList == null) {
            return;
        }
        for (IDEDataSyncInRuntime iDEDataSyncInRuntime : this.deDataSyncInRuntimeList) {
            try {
                iDEDataSyncInRuntime.recv(dataSyncIns);
            }
            catch (RuntimeException ex) {
                log.error((Object)String.format("\u5b9e\u4f53\u6570\u636e\u540c\u6b65[%1$s]\u5904\u7406\u63a5\u6536\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDEDataSyncInRuntime.getName(), ex.getMessage()), (Throwable)ex);
            }
        }
    }

    @Override
    public void registerDEDataSyncInRuntime(IDEDataSyncInRuntime iDEDataSyncInRuntime) {
        if (this.deDataSyncInRuntimeList == null) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406[%1$s]\u4e0d\u662f\u8f93\u5165\u4ee3\u7406", this.getPSSysDataSyncAgent().getName()));
        }
        this.deDataSyncInRuntimeList.add(iDEDataSyncInRuntime);
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysDataSyncAgent();
    }

    protected List<IDEDataSyncInRuntime> getDEDataSyncInRuntimeList() {
        return this.deDataSyncInRuntimeList;
    }

    @Override
    public boolean isInternalAgent() {
        return false;
    }

    @Override
    public boolean isRawDataMode() {
        return this.bRawDataMode;
    }

    protected void setRawDataMode(boolean bRawDataMode) {
        this.bRawDataMode = bRawDataMode;
    }

    protected String getAgentParam(String strName, String strDefault) {
        JsonNode jsonNode;
        if (this.getPSSysDataSyncAgent().getAgentParams() != null && (jsonNode = this.getPSSysDataSyncAgent().getAgentParams().get(strName)) != null) {
            return jsonNode.asText(strDefault);
        }
        return strDefault;
    }
}

