/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.runtime.IModelRuntimeContext;
import net.ibizsys.runtime.plugin.IModelRTAddin;
import net.ibizsys.runtime.plugin.IRuntimeObjectFactory;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ModelRTAddinRepo {
    private static final Log log = LogFactory.getLog(ModelRTAddinRepo.class);
    private Map<String, IModelRTAddin> addinMap = new ConcurrentHashMap<String, IModelRTAddin>();
    private IModelRuntimeContext ctx = null;
    private String strTypePrefix = null;
    private Class<? extends IModelRTAddin> addinCls = null;
    private Map<String, Map> addinListMap = new ConcurrentHashMap<String, Map>();
    private IRuntimeObjectFactory iRuntimeObjectFactory = null;

    public void init(IModelRuntimeContext ctx, Class<? extends IModelRTAddin> addinCls, String strTypePrefix) throws Exception {
        this.init(ctx, addinCls, strTypePrefix, null);
    }

    public void init(IModelRuntimeContext ctx, Class<? extends IModelRTAddin> addinCls, String strTypePrefix, IRuntimeObjectFactory iRuntimeObjectFactory) throws Exception {
        this.ctx = ctx;
        this.strTypePrefix = strTypePrefix;
        this.addinCls = addinCls;
        this.iRuntimeObjectFactory = iRuntimeObjectFactory == null ? RuntimeObjectFactory.getInstance() : iRuntimeObjectFactory;
        this.prepareAddins();
        this.onInit();
    }

    protected void prepareAddins() throws Exception {
        Map<String, ? extends IModelRTAddin> map = this.getRuntimeObjectFactory().getObjects(this.getAddinCls(), this.getTypePrefix());
        if (!ObjectUtils.isEmpty(map)) {
            this.addinMap.putAll(map);
            for (Map.Entry<String, IModelRTAddin> entry : this.addinMap.entrySet()) {
                IModelRTAddin iModelRTAddin = entry.getValue();
                iModelRTAddin.init(this.getContext(), entry.getKey());
            }
        }
    }

    protected void onInit() throws Exception {
    }

    protected IRuntimeObjectFactory getRuntimeObjectFactory() {
        return this.iRuntimeObjectFactory;
    }

    protected IModelRuntimeContext getContext() {
        return this.ctx;
    }

    protected String getTypePrefix() {
        return this.strTypePrefix;
    }

    protected Class<? extends IModelRTAddin> getAddinCls() {
        return this.addinCls;
    }

    public <T> Map<String, T> getAddins(Class<T> cls, String strTypePrefix) {
        String strTag = null;
        strTag = StringUtils.hasLength((String)strTypePrefix) ? String.format("%1$s|%2$s", cls.getCanonicalName(), strTypePrefix) : String.format("%1$s|", cls.getCanonicalName());
        Map objMap = this.addinListMap.get(strTag);
        if (objMap != null) {
            return objMap;
        }
        HashMap<String, IModelRTAddin> map = new HashMap<String, IModelRTAddin>();
        for (Map.Entry<String, IModelRTAddin> entry : this.addinMap.entrySet()) {
            if (!cls.isAssignableFrom(entry.getValue().getClass())) continue;
            if (StringUtils.hasLength((String)strTypePrefix)) {
                if (entry.getKey().indexOf(strTypePrefix) != 0) continue;
                map.put(entry.getKey().substring(strTypePrefix.length()), entry.getValue());
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        this.addinListMap.put(strTag, map);
        return map;
    }

    public <T> T getAddin(Class<T> cls, String strTypePrefix, boolean bTryMode) {
        T t;
        Map<String, T> map = this.getAddins(cls, strTypePrefix);
        if (!ObjectUtils.isEmpty(map) && (t = map.get("")) != null) {
            return t;
        }
        if (bTryMode) {
            return null;
        }
        throw new RuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b[%1$s]\u63d2\u4ef6", strTypePrefix));
    }
}

