/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util.expression;

import java.util.Map;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.lang.Nullable;

public class PropertyMapAccessor
extends MapAccessor {
    private static final Log log = LogFactory.getLog(PropertyMapAccessor.class);
    private String strDefaultValue = null;
    public static final Object NULLOBJECT = new Object();

    public PropertyMapAccessor(String strDefaultValue) {
        this.strDefaultValue = strDefaultValue;
    }

    public PropertyMapAccessor() {
    }

    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{IEntity.class, Map.class};
    }

    public boolean canRead(EvaluationContext context, @Nullable Object target, String name) throws AccessException {
        return true;
    }

    public TypedValue read(EvaluationContext context, @Nullable Object target, String name) throws AccessException {
        if (target == null || target == NULLOBJECT) {
            if (this.strDefaultValue == null) {
                return TypedValue.NULL;
            }
            return new TypedValue((Object)this.strDefaultValue);
        }
        if (target instanceof Map) {
            Map map = (Map)target;
            Object value = map.get(name);
            if (value == null) {
                if (this.strDefaultValue == null) {
                    return TypedValue.NULL;
                }
                return new TypedValue((Object)this.strDefaultValue);
            }
            return new TypedValue(value);
        }
        if (target instanceof IEntity) {
            IEntity iEntity = (IEntity)target;
            Object value = iEntity.get(name);
            if (value == null) {
                if (this.strDefaultValue == null) {
                    return TypedValue.NULL;
                }
                return new TypedValue((Object)this.strDefaultValue);
            }
            return new TypedValue(value);
        }
        try {
            return super.read(context, target, name);
        }
        catch (Exception e) {
            return TypedValue.NULL;
        }
    }
}

