/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.sysutil;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.eai.ISysEAIAgentRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.central.sysutil.ISysUtilRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.IModelRuntimeContext;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.plugin.IModelRTAddin;
import net.ibizsys.runtime.plugin.ModelRTAddinRepo;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.sysutil.ISysFileUtilRuntime;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SysUtilRuntimeBase
extends SystemModelRuntimeBase
implements ISysUtilRuntime {
    private static final Log log = LogFactory.getLog(SysUtilRuntimeBase.class);
    private IPSSysUtil iPSSysUtil = null;
    private ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = null;
    private ISysEAIAgentRuntime inSysEAIAgentRuntime = null;
    private ISysEAIAgentRuntime outSysEAIAgentRuntime = null;
    private String strServiceUrl = null;
    private String strAccessTokenUrl = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private String strAuthMode = null;
    private ISysCacheUtilRuntime iSysCacheUtilRuntime = null;
    private ISysFileUtilRuntime iSysFileUtilRuntime = null;
    private String strLogCat = null;
    private boolean bInstalled = false;
    private ModelRTAddinRepo modelRTAddinRepo = null;

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysUtil iPSSysUtil) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSSysUtil = iPSSysUtil;
        this.strLogCat = this.getPSSysUtil().getUtilType();
        if ("USER".equals(this.strLogCat)) {
            this.strLogCat = this.getPSSysUtil().getUtilTag();
        }
        this.setConfigFolder("sysutil." + PSModelUtils.calcUniqueTag((IPSSystemModule)this.iPSSysUtil.getPSSystemModule(), (String)this.iPSSysUtil.getCodeName()));
        this.prepareDefaultSetting();
        this.onInit();
    }

    public IPSSysUtil getPSSysUtil() {
        return this.iPSSysUtil;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysUtil();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    protected void prepareDefaultSetting() throws Exception {
        this.onPrepareDefaultSetting();
        this.prepareServiceClientSetting();
    }

    protected void onPrepareDefaultSetting() throws Exception {
    }

    protected void prepareServiceClientSetting() throws Exception {
        this.setServiceUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceurl", this.getPSSysUtil().getServicePath()));
        this.setAccessTokenUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".accesstokenurl", this.getPSSysUtil().getAuthAccessTokenUrl()));
        this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSysUtil().getAuthClientId()));
        this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSysUtil().getAuthClientSecret()));
        this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSysUtil().getAuthMode()));
    }

    protected ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime() {
        if (this.iSubSysServiceAPIRuntime == null && this.getPSSysUtil().getPSSubSysServiceAPI() != null) {
            this.iSubSysServiceAPIRuntime = this.getSystemRuntime().getSubSysServiceAPIRuntime(this.getPSSysUtil().getPSSubSysServiceAPI());
        }
        return this.iSubSysServiceAPIRuntime;
    }

    protected ISysEAIAgentRuntime getInSysEAIAgentRuntime() {
        ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime;
        if (this.inSysEAIAgentRuntime == null && this.getPSSysUtil().getInPSSysDataSyncAgent() != null && (iSysDataSyncAgentRuntime = this.getSystemRuntime().getSysDataSyncAgentRuntime(this.getPSSysUtil().getInPSSysDataSyncAgent())) instanceof ISysEAIAgentRuntime) {
            this.inSysEAIAgentRuntime = (ISysEAIAgentRuntime)iSysDataSyncAgentRuntime;
        }
        return this.inSysEAIAgentRuntime;
    }

    protected ISysEAIAgentRuntime getOutSysEAIAgentRuntime() {
        ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime;
        if (this.outSysEAIAgentRuntime == null && this.getPSSysUtil().getOutPSSysDataSyncAgent() != null && (iSysDataSyncAgentRuntime = this.getSystemRuntime().getSysDataSyncAgentRuntime(this.getPSSysUtil().getOutPSSysDataSyncAgent())) instanceof ISysEAIAgentRuntime) {
            this.outSysEAIAgentRuntime = (ISysEAIAgentRuntime)iSysDataSyncAgentRuntime;
        }
        return this.outSysEAIAgentRuntime;
    }

    protected String getUtilParam(String strKey, String strDefault) {
        JsonNode node;
        if (this.getPSSysUtil().getUtilParams() != null && (node = this.getPSSysUtil().getUtilParams().get(strKey)) != null) {
            return node.asText(strDefault);
        }
        return strDefault;
    }

    protected int getUtilParam(String strKey, int nDefault) {
        JsonNode node;
        if (this.getPSSysUtil().getUtilParams() != null && (node = this.getPSSysUtil().getUtilParams().get(strKey)) != null) {
            return node.asInt(nDefault);
        }
        return nDefault;
    }

    protected double getUtilParam(String strKey, double fDefault) {
        JsonNode node;
        if (this.getPSSysUtil().getUtilParams() != null && (node = this.getPSSysUtil().getUtilParams().get(strKey)) != null) {
            return node.asDouble(fDefault);
        }
        return fDefault;
    }

    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    public String getServiceParam() {
        return this.getPSSysUtil().getServiceParam();
    }

    public String getServiceParam2() {
        return this.getPSSysUtil().getServiceParam2();
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    public String getAccessTokenUrl() {
        return this.strAccessTokenUrl;
    }

    protected void setAccessTokenUrl(String strAccessTokenUr) {
        this.strAccessTokenUrl = strAccessTokenUr;
    }

    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    public String getAuthMode() {
        return this.strAuthMode;
    }

    protected void setAuthMode(String strAuthMode) {
        this.strAuthMode = strAuthMode;
    }

    public String getAuthParam() {
        return this.getPSSysUtil().getAuthParam();
    }

    public String getAuthParam2() {
        return this.getPSSysUtil().getAuthParam2();
    }

    @Override
    public synchronized void install() throws Exception {
        if (!this.bInstalled) {
            if (this.getSysCacheUtilRuntime(true) == null) {
                this.prepareSysCacheUtilRuntime();
            }
            if (this.getSysFileUtilRuntime(true) == null) {
                this.prepareSysFileUtilRuntime();
            }
            this.onInstall();
            this.bInstalled = true;
        }
    }

    protected void onInstall() throws Exception {
        if (this.getAddinRepo(true) == null) {
            this.prepareAddinRepo();
        }
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public synchronized void uninstall() {
        try {
            if (this.bInstalled) {
                this.onUninstall();
                this.bInstalled = false;
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5378\u8f7d\u7cfb\u7edf\u529f\u80fd[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.getSystemRuntime().log(40000, this.getLogCat(), String.format("\u5378\u8f7d\u7cfb\u7edf\u529f\u80fd[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), null);
        }
    }

    protected void onUninstall() throws Throwable {
    }

    protected void prepareAddinRepo() throws Exception {
    }

    protected RuntimeException dealException(String strMessage, Throwable ex) {
        this.getSystemRuntime().log(40000, this.getLogCat(), String.format("%1$s%2$s", this.getLogicName(), strMessage), null);
        return new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, strMessage, ex);
    }

    @Override
    public String getLogicName() {
        return this.getName();
    }

    protected ISysCacheUtilRuntime getSysCacheUtilRuntime() {
        return this.getSysCacheUtilRuntime(false);
    }

    protected ISysCacheUtilRuntime getSysCacheUtilRuntime(boolean bTryMode) {
        if (this.iSysCacheUtilRuntime != null || bTryMode) {
            return this.iSysCacheUtilRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, "\u672a\u6307\u5b9a\u7cfb\u7edf\u7f13\u5b58\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setSysCacheUtilRuntime(ISysCacheUtilRuntime iSysCacheUtilRuntime) {
        this.iSysCacheUtilRuntime = iSysCacheUtilRuntime;
    }

    protected void prepareSysCacheUtilRuntime() throws Exception {
        this.setSysCacheUtilRuntime(this.getSystemRuntime().getSysCacheUtilRuntime(true));
    }

    protected ISysFileUtilRuntime getSysFileUtilRuntime() {
        return this.getSysFileUtilRuntime(false);
    }

    protected ISysFileUtilRuntime getSysFileUtilRuntime(boolean bTryMode) {
        if (this.iSysFileUtilRuntime != null || bTryMode) {
            return this.iSysFileUtilRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, "\u672a\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setSysFileUtilRuntime(ISysFileUtilRuntime iSysFileUtilRuntime) {
        this.iSysFileUtilRuntime = iSysFileUtilRuntime;
    }

    protected void prepareSysFileUtilRuntime() throws Exception {
        this.setSysFileUtilRuntime(this.getSystemRuntime().getSysFileUtilRuntime(true));
    }

    protected ModelRTAddinRepo getAddinRepo(boolean bTryMode) {
        if (this.modelRTAddinRepo != null || bTryMode) {
            return this.modelRTAddinRepo;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, "\u63d2\u4ef6\u4ed3\u5e93\u65e0\u6548");
    }

    protected ModelRTAddinRepo getAddinRepo() {
        return this.getAddinRepo(false);
    }

    protected void setAddinRepo(ModelRTAddinRepo modelRTAddinRepo) {
        this.modelRTAddinRepo = modelRTAddinRepo;
    }

    protected void prepareAddinRepo(IModelRuntimeContext ctx, Class<? extends IModelRTAddin> addinCls, String strTypePrefix) throws Exception {
        ModelRTAddinRepo modelRTAddinRepo = new ModelRTAddinRepo();
        modelRTAddinRepo.init(ctx, addinCls, strTypePrefix, this.getSystemRuntime().getRuntimeObjectFactory());
        this.setAddinRepo(modelRTAddinRepo);
    }

    protected <T> Map<String, T> getAddins(Class<T> cls, String strTypePrefix) {
        return this.getAddinRepo().getAddins(cls, strTypePrefix);
    }

    protected void executeAction(String strActionName, IAction iAction) {
        this.executeAction(strActionName, iAction, null, Object.class, this.getLogPOTime());
    }

    protected Object executeAction(String strActionName, IAction iAction, Object[] args) {
        return this.executeAction(strActionName, iAction, args, Object.class, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, Class<T> cls) {
        return this.executeAction(strActionName, iAction, args, cls, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, TypeReference<T> type) {
        return this.executeAction(strActionName, iAction, args, type, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, Class<T> cls, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                log.warn((Object)String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime));
                this.getSystemRuntime().logPO(30000, this.getLogCat(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), this.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getLogicName(), strActionName, ex.getMessage()), ex);
            throw this.dealException(String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, TypeReference<T> type, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                log.warn((Object)String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime));
                this.getSystemRuntime().logPO(30000, this.getLogCat(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), this.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getLogicName(), strActionName, ex.getMessage()), ex);
            throw this.dealException(String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    @Override
    public Object executeAction(final String strActionName, Object[] args) {
        return this.executeAction(strActionName, new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return SysUtilRuntimeBase.this.onExecuteAction(strActionName, args);
            }
        }, args);
    }

    protected Object onExecuteAction(String strActionName, Object[] args) throws Throwable {
        throw new Exception(String.format("\u4e0d\u652f\u6301\u7684\u884c\u4e3a[%1$s]", strActionName));
    }

    protected String getLogCat() {
        return this.strLogCat;
    }

    protected int getLogPOTime() {
        return ActionSessionManager.getLogPOTime();
    }
}

