/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.sysutil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.sysutil.IObjectStorageServiceAdapter;
import net.ibizsys.central.sysutil.SysFileUtilRuntimeBase;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSysFileUtilRuntime
extends SysFileUtilRuntimeBase {
    private static final Log log = LogFactory.getLog(DefaultSysFileUtilRuntime.class);
    public static final String RTFILE_TABLENAME = "_rt_file";
    private Map<String, ProxyOutputStream> proxyOutputStreamMap = new HashMap<String, ProxyOutputStream>();
    private IObjectStorageServiceAdapter iObjectStorageServiceAdapter = null;
    private ISysBDSchemeRuntime iSysBDSchemeRuntime = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (this.getObjectStorageServiceAdapter() == null) {
            this.prepareObjectStorageServiceAdapter();
        }
        if (this.getSysBDSchemeRuntime() == null) {
            this.prepareSysBDSchemeRuntime();
        }
    }

    protected void prepareObjectStorageServiceAdapter() throws Exception {
        if (this.getSubSysServiceAPIRuntime() == null) {
            return;
        }
        this.setObjectStorageServiceAdapter(this.getSubSysServiceAPIRuntime().getObjectStorageServiceAdapter());
    }

    protected IObjectStorageServiceAdapter getObjectStorageServiceAdapter() {
        return this.iObjectStorageServiceAdapter;
    }

    protected void setObjectStorageServiceAdapter(IObjectStorageServiceAdapter iObjectStorageServiceAdapter) {
        this.iObjectStorageServiceAdapter = iObjectStorageServiceAdapter;
    }

    protected void prepareSysBDSchemeRuntime() throws Exception {
        this.setSysBDSchemeRuntime(this.getSystemRuntime().getDefaultSysBDSchemeRuntime());
    }

    protected ISysBDSchemeRuntime getSysBDSchemeRuntime() {
        return this.iSysBDSchemeRuntime;
    }

    protected void setSysBDSchemeRuntime(ISysBDSchemeRuntime iSysBDSchemeRuntime) {
        this.iSysBDSchemeRuntime = iSysBDSchemeRuntime;
    }

    @Override
    protected net.ibizsys.runtime.util.domain.File onCreateUrlFile(String strUrl) throws Throwable {
        net.ibizsys.runtime.util.domain.File file = new net.ibizsys.runtime.util.domain.File();
        file.setFileType("URL");
        file.setUrl(strUrl);
        return file;
    }

    @Override
    protected net.ibizsys.runtime.util.domain.File onGetDraft() throws Throwable {
        net.ibizsys.runtime.util.domain.File file = new net.ibizsys.runtime.util.domain.File();
        file.setFileType("STORAGESERVICE");
        return file;
    }

    @Override
    protected void onCreate(net.ibizsys.runtime.util.domain.File data) throws Throwable {
    }

    @Override
    protected net.ibizsys.runtime.util.domain.File onGet(String strKey, boolean bTryMode) throws Throwable {
        Assert.hasLength((String)strKey, (String)"\u672a\u4f20\u5165\u6587\u4ef6\u6807\u8bc6");
        String strFileFolder = this.getFileFolder(strKey, false);
        String strJsonFile = String.format("%1$s%2$sfile.json", strFileFolder, File.separator);
        File file = new File(strJsonFile);
        if (!file.exists()) {
            if (bTryMode) {
                return null;
            }
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728", new Object[0]), 3);
        }
        net.ibizsys.runtime.util.domain.File data = (net.ibizsys.runtime.util.domain.File)JsonUtils.MAPPER.readValue(file, net.ibizsys.runtime.util.domain.File.class);
        data.setFileId(strKey);
        return data;
    }

    @Override
    protected void onRemove(String strKey) throws Throwable {
        Assert.hasLength((String)strKey, (String)"\u672a\u4f20\u5165\u6587\u4ef6\u6807\u8bc6");
        String strFileFolder = this.getFileFolder(strKey, false);
        String strJsonFile = String.format("%1$s%2$sfile.json", strFileFolder, File.separator);
        File file = new File(strJsonFile);
        if (!file.exists()) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728", new Object[0]), 3);
        }
        net.ibizsys.runtime.util.domain.File data = (net.ibizsys.runtime.util.domain.File)JsonUtils.MAPPER.readValue(file, net.ibizsys.runtime.util.domain.File.class);
        file.delete();
        JsonUtils.MAPPER.writerWithDefaultPrettyPrinter().writeValue(new File(strJsonFile + ".delete"), (Object)data);
    }

    @Override
    protected InputStream onGetInputStream(net.ibizsys.runtime.util.domain.File file) throws Throwable {
        return super.onGetInputStream(file);
    }

    @Override
    protected OutputStream onGetOutputStream(net.ibizsys.runtime.util.domain.File file, boolean bAppendMode) throws Throwable {
        if ("TEMP".equals(file.getFileType())) {
            String strFileFolder = this.getFileFolder(file.getFileId(), false);
            String strDataFile = String.format("%1$s%2$sfile.data", strFileFolder, File.separator);
            return new FileOutputStream(new File(strDataFile), bAppendMode);
        }
        if ("URL".equals(file.getFileType())) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u6587\u4ef6\u7c7b\u578b[%1$s]\u4e0d\u652f\u6301\u5199\u5165", file.getFileType()));
        }
        if ("STORAGESERVICE".equals(file.getFileType())) {
            String strFileFolder = this.getFileFolder(file.getFileId(), true);
            String strDataFile = String.format("%1$s%2$sfile.data", strFileFolder, File.separator);
            FileOutputStream outputStream = new FileOutputStream(new File(strDataFile), bAppendMode);
            return new ProxyOutputStream(file, outputStream);
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u672a\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b[%1$s]", file.getFileType()));
    }

    protected void closeProxyOutputStream(net.ibizsys.runtime.util.domain.File file) throws Throwable {
        if (this.getObjectStorageServiceAdapter() == null) {
            throw new Exception("\u672a\u6307\u5b9a\u5bf9\u8c61\u5b58\u50a8\u670d\u52a1\u63d2\u4ef6");
        }
        String strFileFolder = this.getFileFolder(file.getFileId(), false);
        String strDataFile = String.format("%1$s%2$sfile.data", strFileFolder, File.separator);
        this.getObjectStorageServiceAdapter().saveFile(file, file.getFolder(), new File(strDataFile), null);
    }

    protected String getFileFolder(String strFileId, boolean bCreate) throws Throwable {
        if (!StringUtils.hasLength((String)strFileId) || strFileId.length() < 10) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u4f20\u5165\u6587\u4ef6\u6807\u8bc6\u4e0d\u6b63\u786e", new Object[0]));
        }
        String strFileFolder = this.getSystemRuntime().getFileFolder();
        if (!StringUtils.hasLength((String)strFileFolder)) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u7cfb\u7edf\u672a\u5b9a\u4e49\u6587\u4ef6\u5b58\u50a8\u8def\u5f84", new Object[0]));
        }
        String strFilePath = String.format("%1$s%2$s%3$s%2$s%4$s%2$s%5$s", strFileFolder, File.separator, strFileId.substring(0, 7), strFileId.substring(7, 9), strFileId);
        if (bCreate) {
            File file = new File(strFilePath);
            file.mkdirs();
        }
        return strFilePath;
    }

    @Override
    protected net.ibizsys.runtime.util.domain.File onCreateOSSFile(File file, String strCat) throws Throwable {
        if (this.getObjectStorageServiceAdapter() != null) {
            net.ibizsys.runtime.util.domain.File ossFile = this.getObjectStorageServiceAdapter().saveFile(null, strCat, file, null);
            return ossFile;
        }
        throw new Exception("\u672a\u6307\u5b9a\u5bf9\u8c61\u5b58\u50a8\u670d\u52a1\u63d2\u4ef6");
    }

    private class ProxyOutputStream
    extends OutputStream {
        private net.ibizsys.runtime.util.domain.File file = null;
        private OutputStream realOutputStream = null;

        public ProxyOutputStream(net.ibizsys.runtime.util.domain.File file, OutputStream outputStream) {
            this.file = file;
            this.realOutputStream = outputStream;
            DefaultSysFileUtilRuntime.this.proxyOutputStreamMap.put(file.getFileId(), this);
        }

        public OutputStream getReal() {
            return this.realOutputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.getReal().write(b);
        }

        @Override
        public void close() throws IOException {
            DefaultSysFileUtilRuntime.this.proxyOutputStreamMap.remove(this.file.getFileId());
            this.getReal().close();
            try {
                DefaultSysFileUtilRuntime.this.closeProxyOutputStream(this.file);
            }
            catch (Throwable ex) {
                log.error((Object)ex);
                throw new IOException(ex);
            }
        }

        @Override
        public void flush() throws IOException {
            this.getReal().flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.getReal().write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.getReal().write(b);
        }
    }
}

