/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.service.client;

import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.service.client.ITokenUtil;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class TokenUtilBase
implements ITokenUtil {
    private static final Log log = LogFactory.getLog(TokenUtilBase.class);
    private ISystemRuntime iSystemRuntime = null;
    private IModelRuntime iModelRuntime = null;
    private long nTokenTimeout = 0L;
    private int nDefaultTokenTimeout = 0;
    private String strToken = null;

    public TokenUtilBase(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime) {
        Assert.notNull((Object)iSystemRuntime, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iModelRuntime, (String)"\u4f20\u5165\u6240\u5c5e\u6a21\u578b\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        this.setSystemRuntime(iSystemRuntime);
        this.setModelRuntime(iModelRuntime);
    }

    protected ISystemRuntime getSystemRuntime() {
        return this.iSystemRuntime;
    }

    protected void setSystemRuntime(ISystemRuntime iSystemRuntime) {
        this.iSystemRuntime = iSystemRuntime;
    }

    protected IModelRuntime getModelRuntime() {
        return this.iModelRuntime;
    }

    protected void setModelRuntime(IModelRuntime iModelRuntime) {
        this.iModelRuntime = iModelRuntime;
    }

    protected long getTokenTimeout() {
        return this.nTokenTimeout;
    }

    public void setTokenTimeout(long nTokenTimeout) {
        this.nTokenTimeout = nTokenTimeout;
    }

    protected int getDefaultTokenTimeout() {
        return this.nDefaultTokenTimeout;
    }

    protected void setDefaultTokenTimeout(int nDefaultTokenTimeout) {
        this.nDefaultTokenTimeout = nDefaultTokenTimeout;
    }

    @Override
    public String getToken() {
        if (!StringUtils.hasLength((String)this.strToken)) {
            this.requestTokenIf(true);
        }
        return this.strToken;
    }

    protected void setToken(String strToken) {
        this.strToken = strToken;
    }

    @Override
    public void requestTokenIf(boolean bImmediately) {
        if (this.getTokenTimeout() - System.currentTimeMillis() >= 60000L) {
            return;
        }
        this.requestToken(bImmediately);
    }

    @Override
    public void requestToken() {
        this.requestToken(false);
    }

    protected void requestToken(boolean bImmediately) {
        if (bImmediately) {
            this.onRequestToken();
        } else {
            this.setTokenTimeout(0L);
        }
    }

    protected void onRequestToken() {
        try {
            long nLastTokenTimeout = this.getTokenTimeout();
            this.setToken(this.doRequestToken());
            if (this.getTokenTimeout() == nLastTokenTimeout) {
                this.setTokenTimeout(System.currentTimeMillis() + (long)this.getDefaultTokenTimeout());
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u8ba4\u8bc1\u7ec4\u4ef6[%1$s]\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.getSystemRuntime().log(40000, "TOKENUTIL", String.format("\u8ba4\u8bc1\u7ec4\u4ef6[%1$s]\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.setTokenTimeout(0L);
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getModelRuntime(), String.format("\u8ba4\u8bc1\u7ec4\u4ef6[%1$s]\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
        }
    }

    protected abstract String doRequestToken() throws Throwable;

    protected void runAuthTimer() {
        this.runAuthTimer(false);
    }

    protected void runAuthTimer(boolean bTimerOnly) {
        if (!bTimerOnly) {
            try {
                this.onAuthTimer();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u8ba4\u8bc1\u7ec4\u4ef6[%1$s]\u8ba4\u8bc1\u5b9a\u65f6\u5668\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
                this.getSystemRuntime().log(40000, "TOKENUTIL", String.format("\u8ba4\u8bc1\u7ec4\u4ef6[%1$s]\u8ba4\u8bc1\u5b9a\u65f6\u5668\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            }
        }
        this.getSystemRuntime().threadRun(new Runnable(){

            @Override
            public void run() {
                TokenUtilBase.this.runAuthTimer();
            }
        }, System.currentTimeMillis() + 20000L, "AuthTimer_TokenUtil_" + String.format("%1$s", this.getModelRuntime()));
    }

    protected void onAuthTimer() {
        if (this.getTokenTimeout() - System.currentTimeMillis() >= 120000L) {
            return;
        }
        this.onRequestToken();
    }

    protected String getName() {
        return this.getModelRuntime().getName();
    }
}

