/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.util.DEUtilRuntimeBase;
import net.ibizsys.central.dataentity.util.IDEVersionControlUtilRuntime;
import net.ibizsys.central.dataentity.util.IDEVersionStorageUtilRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEVersionControlUtilRuntimeBase
extends DEUtilRuntimeBase
implements IDEVersionControlUtilRuntime {
    private static final Log log = LogFactory.getLog(DEVersionControlUtilRuntimeBase.class);
    private IDataEntityRuntime versionDataEntityRuntime = null;
    private Map<String, IPSDEField> versionPSDEFieldMap = null;
    private String strInterProcessMutexTag = null;
    private boolean bAutoCommit = false;
    private IPSDEField versionIdPSDEField = null;
    private IPSDEField versionPSDEField = null;

    @Override
    protected void onInit() throws Exception {
        this.setAutoCommit(this.getUtilParam("autocommit", this.isAutoCommit()));
        if (this.getVersionDataEntityRuntime(true) == null) {
            this.prepareVersionDataEntityRuntime();
            this.getVersionDataEntityRuntime(false);
        }
        this.setVersionPSDEField(this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.VERSION, true));
        this.setVersionIdPSDEField(this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.VERSIONID, false));
        this.strInterProcessMutexTag = KeyValueUtils.genUniqueId(PSModelEnums.DEUtilType.VERSIONCONTROL.value, this.getSystemRuntime().getDeploySystemId(), this.getDataEntityRuntime().getPSDataEntity().getId(), this.getPSDEUtil().getId());
        super.onInit();
    }

    protected String getInterProcessMutexTag() {
        return this.strInterProcessMutexTag;
    }

    protected void prepareVersionDataEntityRuntime() throws Exception {
        String[] fields;
        IPSDataEntity utilPSDataEntity = this.getPSDEUtil().getUtilPSDE();
        if (utilPSDataEntity == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u7248\u672c\u5b9e\u4f53", new Object[0]));
        }
        IDataEntityRuntime versionDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(utilPSDataEntity.getId());
        this.setVersionDataEntityRuntime(versionDataEntityRuntime);
        this.setVersionPSDEFieldMap(this.fillVersionPSDEFieldMap(null));
        for (String strField : fields = new String[]{PSModelEnums.PredefinedFieldType.VERSION.value, "DATA", PSModelEnums.PredefinedFieldType.PARENTID.value}) {
            this.getVersionPSDEField(strField, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, IPSDEField> fillVersionPSDEFieldMap(Map<String, IPSDEField> versionPSDEFieldMap) throws Exception {
        String[] fields;
        if (versionPSDEFieldMap == null) {
            versionPSDEFieldMap = new HashMap<String, IPSDEField>();
        }
        for (String strField : fields = new String[]{"NAME", PSModelEnums.PredefinedFieldType.VERSION.value, "DATA", "MANUAL", "CURRENT", "RESTORABLE", "MESSAGE"}) {
            if (versionPSDEFieldMap.containsKey(strField)) continue;
            versionPSDEFieldMap.put(strField, null);
        }
        IDataEntityRuntime versionDataEntityRuntime = this.getVersionDataEntityRuntime();
        IPSDataEntity utilPSDataEntity = versionDataEntityRuntime.getPSDataEntity();
        IPSDERBase iPSDERBase = null;
        List minorPSDERBaseList = utilPSDataEntity.getMinorPSDERs();
        if (!ObjectUtils.isEmpty((Object)minorPSDERBaseList)) {
            for (IPSDERBase item : minorPSDERBaseList) {
                if (!item.getMajorPSDataEntityMust().getId().equalsIgnoreCase(this.getDataEntityRuntime().getPSDataEntity().getId()) || !PSModelEnums.DERType.DER1N.value.equalsIgnoreCase(item.getDERType()) && !PSModelEnums.DERType.DERCUSTOM.value.equalsIgnoreCase(item.getDERType())) continue;
                if (iPSDERBase == null) {
                    iPSDERBase = item;
                    continue;
                }
                log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u4e0e\u5b9e\u4f53[%2$s]\u5b58\u5728\u591a\u4e2a\u5173\u7cfb\uff0c\u5ffd\u7565\u9ed8\u8ba4\u8ba1\u7b97", this.getDataEntityRuntime().getName(), utilPSDataEntity.getName()));
                iPSDERBase = null;
                break;
            }
        }
        if (iPSDERBase != null) {
            if (iPSDERBase instanceof IPSDER1N) {
                IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTID.value, (IPSDEField)iPSDER1N.getPSPickupDEFieldMust());
                if (iPSDER1N.getPSPickupTextDEField() != null) {
                    versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTNAME.value, (IPSDEField)iPSDER1N.getPSPickupTextDEField());
                }
            } else {
                IPSDEField parentType;
                if (!(iPSDERBase instanceof IPSDERCustom)) throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5173\u7cfb\u7c7b\u578b[%1$s]", iPSDERBase.getDERType()));
                IPSDERCustom iPSDERCustom = (IPSDERCustom)iPSDERBase;
                if (iPSDERCustom.getPickupPSDEField() != null) {
                    versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTID.value, iPSDERCustom.getPickupPSDEField());
                }
                if (iPSDERCustom.getPickupTextPSDEField() != null) {
                    versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTNAME.value, iPSDERCustom.getPickupTextPSDEField());
                }
                if ((parentType = versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, true)) != null) {
                    versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, parentType);
                }
            }
        } else {
            versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTID.value, versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false));
            versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false));
            versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTNAME.value, versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTNAME.value, true));
        }
        versionPSDEFieldMap.put(PSModelEnums.PredefinedFieldType.VERSION.value, versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.VERSION.value, true));
        List psDEFieldList = versionDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        if (!ObjectUtils.isEmpty((Object)psDEFieldList)) {
            String strTag;
            for (IPSDEField iPSDEField : psDEFieldList) {
                if (!StringUtils.hasLength((String)iPSDEField.getFieldTag()) || !versionPSDEFieldMap.containsKey(strTag = iPSDEField.getFieldTag().toUpperCase()) || versionPSDEFieldMap.get(strTag) != null) continue;
                versionPSDEFieldMap.put(strTag, iPSDEField);
            }
            for (IPSDEField iPSDEField : psDEFieldList) {
                strTag = iPSDEField.getName().toUpperCase();
                if (!versionPSDEFieldMap.containsKey(strTag) || versionPSDEFieldMap.get(strTag) != null) continue;
                versionPSDEFieldMap.put(strTag, iPSDEField);
            }
        }
        if (versionPSDEFieldMap.get("NAME") != null || versionDataEntityRuntime.getMajorPSDEField() == null) return versionPSDEFieldMap;
        versionPSDEFieldMap.put("NAME", versionDataEntityRuntime.getMajorPSDEField());
        return versionPSDEFieldMap;
    }

    @Override
    public IDataEntityRuntime getVersionDataEntityRuntime() {
        try {
            return this.getVersionDataEntityRuntime(false);
        }
        catch (Exception ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected IDataEntityRuntime getVersionDataEntityRuntime(boolean tryMode) throws Exception {
        if (this.versionDataEntityRuntime != null || tryMode) {
            return this.versionDataEntityRuntime;
        }
        throw new Exception(String.format("\u7248\u672c\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setVersionDataEntityRuntime(IDataEntityRuntime versionDataEntityRuntime) {
        this.versionDataEntityRuntime = versionDataEntityRuntime;
    }

    protected Map<String, IPSDEField> getVersionPSDEFieldMap() {
        return this.versionPSDEFieldMap;
    }

    protected void setVersionPSDEFieldMap(Map<String, IPSDEField> versionPSDEFieldMap) {
        this.versionPSDEFieldMap = versionPSDEFieldMap;
    }

    @Override
    public Object commit(IEntityBase iEntityBase, Object versionData) {
        return this.commit(iEntityBase, versionData, false);
    }

    @Override
    public Object commit(IEntityBase iEntityBase, Object versionData, boolean bManual) {
        Assert.notNull((Object)iEntityBase, (String)"\u672a\u4f20\u5165\u6570\u636e\u5bf9\u8c61");
        Assert.notNull((Object)versionData, (String)"\u672a\u4f20\u5165\u7248\u672c\u6570\u636e\u5bf9\u8c61");
        try {
            return this.onCommit(iEntityBase, versionData, bManual);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u63d0\u4ea4\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onCommit(final IEntityBase iEntityBase, final Object versionData, final boolean bManual) throws Throwable {
        Object lastVersionId;
        IEntityBase last;
        final Object key = this.getDataEntityRuntime().getKeyFieldValue(iEntityBase);
        if (ObjectUtils.isEmpty((Object)key)) {
            throw new Exception("\u6570\u636e\u5bf9\u8c61\u4e2d\u672a\u5305\u542b\u952e\u503c");
        }
        Object versionId = this.getVersionDataEntityRuntime().getKeyFieldValue((IEntityBase)versionData);
        if (ObjectUtils.isEmpty((Object)versionId)) {
            throw new Exception("\u7248\u672c\u6570\u636e\u5bf9\u8c61\u4e2d\u672a\u5305\u542b\u952e\u503c");
        }
        IEntityBase iEntityBase2 = last = bManual ? iEntityBase : this.getDataEntityRuntime().getLastEntity();
        if (last != null && ObjectUtils.isEmpty((Object)(lastVersionId = this.getDataEntityRuntime().getFieldValue(last, this.getVersionIdPSDEField(false))))) {
            this.fixCommit(key, iEntityBase, last);
        }
        lastVersionId = this.getDataEntityRuntime().getFieldValue(iEntityBase, this.getVersionIdPSDEField(false));
        List psDERBaseList = this.getDataEntityRuntime().getPSDataEntity().getMajorPSDERs();
        if (!ObjectUtils.isEmpty((Object)psDERBaseList)) {
            for (IPSDERBase iPSDERBase : psDERBaseList) {
                IDataEntityRuntime refDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMinorPSDataEntityMust().getId(), false);
                if (refDataEntityRuntime.getStorageMode() == 0) continue;
                IPSPickupDEField pickupPSDEField = null;
                if (iPSDERBase instanceof IPSDER1N) {
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    if ((iPSDER1N.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value) {
                        pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                    }
                } else {
                    if (!(iPSDERBase instanceof IPSDERCustom)) continue;
                    IPSDERCustom iPSDERCustom = (IPSDERCustom)iPSDERBase;
                    if ((iPSDERCustom.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value && (refDataEntityRuntime.getDEType() == 4 || PSModelEnums.DERSubType.DER1N.value.equalsIgnoreCase(iPSDERCustom.getDERSubType()))) {
                        pickupPSDEField = iPSDERCustom.getPickupPSDEField();
                    }
                }
                if (pickupPSDEField == null) continue;
                IDEVersionStorageUtilRuntime iDEVersionStorageUtilRuntime = refDataEntityRuntime.getDEVersionStorageUtilRuntime();
                if (iDEVersionStorageUtilRuntime == null) {
                    throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u63d0\u4f9b\u7248\u672c\u6570\u636e\u5b58\u50a8\u529f\u80fd\u7ec4\u4ef6", refDataEntityRuntime.getName()));
                }
                iDEVersionStorageUtilRuntime.commit(iEntityBase, iPSDERBase, lastVersionId);
            }
        }
        IEntityDTO versionDTO = (IEntityDTO)ActionSessionManager.execute(new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return DEVersionControlUtilRuntimeBase.this.doCommitReal(key, iEntityBase, versionData, bManual);
            }
        }, null, this.getInterProcessMutexTag(), key.toString(), 3);
        IPSDEField versionPSDEField = this.getMajorVersionPSDEField(true);
        if (bManual) {
            IEntityDTO temp = this.getDataEntityRuntime().createEntity();
            temp.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), key);
            temp.set(this.getVersionIdPSDEField(false).getLowerCaseName(), versionId);
            if (versionPSDEField != null) {
                Object version = versionDTO.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false).getLowerCaseName());
                if (versionPSDEField != null) {
                    temp.set(versionPSDEField.getLowerCaseName(), version);
                }
            }
            this.getDataEntityRuntime().rawUpdate(Arrays.asList(temp), false);
        } else if (versionPSDEField != null) {
            Object version = versionDTO.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false).getLowerCaseName());
            if (versionPSDEField != null) {
                this.getDataEntityRuntime().setFieldValue(iEntityBase, versionPSDEField, version);
            }
        }
        return versionDTO;
    }

    protected Object doCommitReal(Object key, IEntityBase iEntityBase, Object versionData, boolean bManual) throws Throwable {
        IEntityDTO iEntityDTO;
        int nVer;
        IPSDEField versionIdPSDEField = this.getVersionIdPSDEField(true);
        Object lastVersionId = null;
        IPSDEField parentIdPSDEField = this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
        IPSDEField dataPSDEField = this.getVersionPSDEField("DATA", false);
        IPSDEField versionPSDEField = this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false);
        IPSDEField typePSDEField = this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, true);
        IPSDEField manualPSDEField = this.getVersionPSDEField("MANUAL", true);
        IPSDEField namePSDEField = this.getVersionPSDEField("NAME", true);
        IPSDEField currentPSDEField = this.getVersionPSDEField("CURRENT", true);
        IEntityBase last = bManual ? iEntityBase : this.getDataEntityRuntime().getLastEntity();
        ISearchContextDTO iSearchContextDTO = this.getVersionDataEntityRuntime().createSearchContext();
        iSearchContextDTO.limit(1).count(false);
        iSearchContextDTO.eq(parentIdPSDEField.getLowerCaseName(), key);
        if (typePSDEField != null) {
            iSearchContextDTO.eq(typePSDEField.getLowerCaseName(), this.getDataEntityRuntime().getName());
        }
        this.getVersionDataEntityRuntime().setSearchSort(iSearchContextDTO, versionPSDEField, PSModelEnums.SortDir.DESC.value);
        List<IEntityDTO> list = this.getVersionDataEntityRuntime().selectDataQuery(this.getVersionDataEntityRuntime().getDefaultPSDEDataQuery(), iSearchContextDTO);
        IEntityDTO item = null;
        if (!ObjectUtils.isEmpty(list)) {
            item = list.get(0);
        }
        int n = nVer = item == null ? 0 : item.getInteger(versionPSDEField.getName(), 0);
        if (nVer < 0) {
            nVer = 0;
        }
        if (last != null && versionIdPSDEField != null) {
            lastVersionId = this.getDataEntityRuntime().getFieldValue(last, versionIdPSDEField);
        }
        if (ObjectUtils.isEmpty(lastVersionId) && item != null) {
            lastVersionId = this.getVersionDataEntityRuntime().getKeyFieldValue(item);
        }
        if (!ObjectUtils.isEmpty(lastVersionId) && last != null) {
            iEntityDTO = this.getVersionDataEntityRuntime().createEntity();
            iEntityDTO.set(this.getVersionDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), lastVersionId);
            iEntityDTO.set(dataPSDEField.getName(), this.getDataEntityRuntime().serializeEntity(last));
            if (currentPSDEField != null) {
                iEntityDTO.set(currentPSDEField.getName(), 0);
            }
            this.getVersionDataEntityRuntime().rawUpdate(Arrays.asList(iEntityDTO), false);
        }
        iEntityDTO = (IEntityDTO)versionData;
        iEntityDTO.set(versionPSDEField.getName(), nVer + 1);
        if (namePSDEField != null) {
            iEntityDTO.set(namePSDEField.getName(), String.format("v%1$s", nVer + 1));
        }
        this.getVersionDataEntityRuntime().rawCreate(Arrays.asList(iEntityDTO), false);
        return iEntityDTO;
    }

    @Override
    public Object fixCommit(IEntityBase iEntityBase, Object versionData, boolean bManual) {
        Assert.notNull((Object)iEntityBase, (String)"\u672a\u4f20\u5165\u6570\u636e\u5bf9\u8c61");
        Assert.notNull((Object)versionData, (String)"\u672a\u4f20\u5165\u7248\u672c\u6570\u636e\u5bf9\u8c61");
        try {
            return this.onFixCommit(iEntityBase, versionData, bManual);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u4fee\u590d\u63d0\u4ea4\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onFixCommit(IEntityBase iEntityBase, final Object versionData, boolean bManual) throws Throwable {
        Object version;
        Object lastVersionId;
        IEntityBase last;
        final Object key = this.getDataEntityRuntime().getKeyFieldValue(iEntityBase);
        Object fixedVersionId = this.getVersionDataEntityRuntime().getKeyFieldValue((IEntityBase)versionData);
        IEntityBase iEntityBase2 = last = bManual ? iEntityBase : this.getDataEntityRuntime().getLastEntity();
        if (last != null && !ObjectUtils.isEmpty((Object)(lastVersionId = this.getDataEntityRuntime().getFieldValue(last, this.getVersionIdPSDEField(false))))) {
            throw new Exception("\u6570\u636e\u5df2\u5b58\u5728\u7248\u672c\u6807\u8bc6");
        }
        final IEntityDTO temp = this.getDataEntityRuntime().createEntity();
        temp.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), key);
        temp.set(this.getVersionIdPSDEField(false).getLowerCaseName(), fixedVersionId);
        IEntityDTO versionDTO = (IEntityDTO)ActionSessionManager.execute(new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return DEVersionControlUtilRuntimeBase.this.doCommitReal(key, temp, versionData, false);
            }
        }, null, this.getInterProcessMutexTag(), key.toString(), 3);
        IPSDEField versionPSDEField = this.getMajorVersionPSDEField(true);
        if (versionPSDEField != null) {
            version = versionDTO.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false).getLowerCaseName());
            if (versionPSDEField != null) {
                temp.set(versionPSDEField.getLowerCaseName(), version);
            }
        }
        this.getDataEntityRuntime().rawUpdate(Arrays.asList(temp), true);
        this.getDataEntityRuntime().setFieldValue(last, this.getVersionIdPSDEField(false), fixedVersionId);
        if (last != iEntityBase) {
            this.getDataEntityRuntime().setFieldValue(iEntityBase, this.getVersionIdPSDEField(false), fixedVersionId);
        }
        if (versionPSDEField != null) {
            version = versionDTO.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false).getLowerCaseName());
            this.getDataEntityRuntime().setFieldValue(last, versionPSDEField, version);
            if (last != iEntityBase) {
                this.getDataEntityRuntime().setFieldValue(iEntityBase, versionPSDEField, version);
            }
        }
        return versionData;
    }

    protected Object fixCommit(final Object key, IEntityBase iEntityBase, IEntityBase last) throws Throwable {
        Object version;
        final IEntityDTO fixedVersionDTO = (IEntityDTO)this.prepare(last, "create", this.getDataEntityRuntime().getPSDEAction("create"));
        Object fixedVersionId = this.getVersionDataEntityRuntime().getKeyFieldValue(fixedVersionDTO);
        final IEntityDTO temp = this.getDataEntityRuntime().createEntity();
        temp.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), key);
        temp.set(this.getVersionIdPSDEField(false).getLowerCaseName(), fixedVersionId);
        IEntityDTO versionDTO = (IEntityDTO)ActionSessionManager.execute(new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return DEVersionControlUtilRuntimeBase.this.doCommitReal(key, temp, fixedVersionDTO, false);
            }
        }, null, this.getInterProcessMutexTag(), key.toString(), 3);
        IPSDEField versionPSDEField = this.getMajorVersionPSDEField(true);
        if (versionPSDEField != null) {
            version = versionDTO.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false).getLowerCaseName());
            if (versionPSDEField != null) {
                temp.set(versionPSDEField.getLowerCaseName(), version);
            }
        }
        this.getDataEntityRuntime().rawUpdate(Arrays.asList(temp), true);
        this.getDataEntityRuntime().setFieldValue(last, this.getVersionIdPSDEField(false), fixedVersionId);
        this.getDataEntityRuntime().setFieldValue(iEntityBase, this.getVersionIdPSDEField(false), fixedVersionId);
        if (versionPSDEField != null) {
            version = versionDTO.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false).getLowerCaseName());
            this.getDataEntityRuntime().setFieldValue(last, versionPSDEField, version);
            this.getDataEntityRuntime().setFieldValue(iEntityBase, versionPSDEField, version);
        }
        return fixedVersionDTO;
    }

    protected IPSDEField getVersionPSDEField(String strType, boolean tryMode) throws Exception {
        IPSDEField iPSDEField;
        Map<String, IPSDEField> versionPSDEFieldMap = this.getVersionPSDEFieldMap();
        if (versionPSDEFieldMap != null && (iPSDEField = versionPSDEFieldMap.get(strType)) != null) {
            return iPSDEField;
        }
        if (tryMode) {
            return null;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u5c5e\u6027\u6807\u8bb0[%1$s]\u5bf9\u5e94\u7684\u5c5e\u6027", strType));
    }

    public boolean isAutoCommit() {
        return this.bAutoCommit;
    }

    protected void setAutoCommit(boolean bAutoCommit) {
        this.bAutoCommit = bAutoCommit;
    }

    @Override
    public boolean isCommit(String strActionName, IPSDEAction iPSDEAction) {
        if (iPSDEAction != null) {
            if ("CREATE".equals(iPSDEAction.getActionMode())) {
                return true;
            }
            return this.isAutoCommit() && "UPDATE".equals(iPSDEAction.getActionMode());
        }
        if ("create".equalsIgnoreCase(strActionName)) {
            return true;
        }
        return this.isAutoCommit() && "update".equalsIgnoreCase(strActionName);
    }

    @Override
    public Object prepare(IEntityBase iEntityBase, String strActionName, IPSDEAction iPSDEAction) {
        Assert.notNull((Object)iEntityBase, (String)"\u672a\u4f20\u5165\u6570\u636e\u5bf9\u8c61");
        try {
            return this.onPrepare(iEntityBase, null, strActionName, iPSDEAction, false);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u51c6\u5907\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public Object prepare(IEntityBase iEntityBase, Object versionData) {
        Assert.notNull((Object)iEntityBase, (String)"\u672a\u4f20\u5165\u6570\u636e\u5bf9\u8c61");
        Assert.notNull((Object)iEntityBase, (String)"\u672a\u4f20\u5165\u7248\u672c\u6570\u636e\u5bf9\u8c61");
        try {
            return this.onPrepare(iEntityBase, versionData, null, null, true);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u51c6\u5907\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onPrepare(IEntityBase iEntityBase, Object versionData, String strActionName, IPSDEAction iPSDEAction, boolean bManual) throws Throwable {
        Object key = this.getDataEntityRuntime().getKeyFieldValue(iEntityBase);
        if (ObjectUtils.isEmpty((Object)key)) {
            throw new Exception("\u6570\u636e\u5bf9\u8c61\u4e2d\u672a\u5305\u542b\u952e\u503c");
        }
        IPSDEField versionIdPSDEField = this.getVersionIdPSDEField(false);
        IPSDEField parentIdPSDEField = this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
        IPSDEField typePSDEField = this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, true);
        IPSDEField manualPSDEField = this.getVersionPSDEField("MANUAL", true);
        IPSDEField currentPSDEField = this.getVersionPSDEField("CURRENT", true);
        IEntityDTO iEntityDTO = versionData != null ? (IEntityDTO)versionData : this.getVersionDataEntityRuntime().createEntity();
        iEntityDTO.set(parentIdPSDEField.getName(), key);
        if (typePSDEField != null) {
            iEntityDTO.set(typePSDEField.getName(), this.getDataEntityRuntime().getName());
        }
        if (manualPSDEField != null) {
            iEntityDTO.set(manualPSDEField.getName(), bManual ? 1 : 0);
        }
        if (currentPSDEField != null) {
            iEntityDTO.set(currentPSDEField.getName(), 1);
        }
        this.getVersionDataEntityRuntime().fillEntityKeyValue(iEntityDTO);
        if (!bManual) {
            this.getDataEntityRuntime().setFieldValue(iEntityBase, versionIdPSDEField, this.getVersionDataEntityRuntime().getKeyFieldValue(iEntityDTO));
        }
        return iEntityDTO;
    }

    @Override
    public Object restore(IEntityBase iEntityBase, Object restoreVersionId, Object versionData) {
        Assert.notNull((Object)iEntityBase, (String)"\u672a\u4f20\u5165\u6570\u636e\u5bf9\u8c61");
        Assert.notNull((Object)restoreVersionId, (String)"\u672a\u4f20\u5165\u6062\u590d\u7248\u672c\u6807\u8bc6");
        Assert.notNull((Object)iEntityBase, (String)"\u672a\u4f20\u5165\u7248\u672c\u6570\u636e\u5bf9\u8c61");
        try {
            return this.onRestore(iEntityBase, restoreVersionId, versionData);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6062\u590d\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onRestore(final IEntityBase iEntityBase, Object restoreVersionId, final Object versionData) throws Throwable {
        final Object key = this.getDataEntityRuntime().getKeyFieldValue(iEntityBase);
        if (ObjectUtils.isEmpty((Object)key)) {
            throw new Exception("\u6570\u636e\u5bf9\u8c61\u4e2d\u672a\u5305\u542b\u952e\u503c");
        }
        Object versionId = this.getVersionDataEntityRuntime().getKeyFieldValue((IEntityBase)versionData);
        if (ObjectUtils.isEmpty((Object)versionId)) {
            throw new Exception("\u7248\u672c\u6570\u636e\u5bf9\u8c61\u4e2d\u672a\u5305\u542b\u952e\u503c");
        }
        List psDERBaseList = this.getDataEntityRuntime().getPSDataEntity().getMajorPSDERs();
        if (!ObjectUtils.isEmpty((Object)psDERBaseList)) {
            for (IPSDERBase iPSDERBase : psDERBaseList) {
                IDataEntityRuntime refDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMinorPSDataEntityMust().getId(), false);
                if (refDataEntityRuntime.getStorageMode() == 0) continue;
                IPSPickupDEField pickupPSDEField = null;
                if (iPSDERBase instanceof IPSDER1N) {
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    if ((iPSDER1N.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value) {
                        pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                    }
                } else {
                    if (!(iPSDERBase instanceof IPSDERCustom)) continue;
                    IPSDERCustom iPSDERCustom = (IPSDERCustom)iPSDERBase;
                    if ((iPSDERCustom.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value && (refDataEntityRuntime.getDEType() == 4 || PSModelEnums.DERSubType.DER1N.value.equalsIgnoreCase(iPSDERCustom.getDERSubType()))) {
                        pickupPSDEField = iPSDERCustom.getPickupPSDEField();
                    }
                }
                if (pickupPSDEField == null) continue;
                IDEVersionStorageUtilRuntime iDEVersionStorageUtilRuntime = refDataEntityRuntime.getDEVersionStorageUtilRuntime();
                if (iDEVersionStorageUtilRuntime == null) {
                    throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u63d0\u4f9b\u7248\u672c\u6570\u636e\u5b58\u50a8\u529f\u80fd\u7ec4\u4ef6", refDataEntityRuntime.getName()));
                }
                iDEVersionStorageUtilRuntime.restore(iEntityBase, iPSDERBase, restoreVersionId);
            }
        }
        IEntityDTO versionDTO = (IEntityDTO)ActionSessionManager.execute(new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return DEVersionControlUtilRuntimeBase.this.doCommitReal(key, iEntityBase, versionData, true);
            }
        }, null, this.getInterProcessMutexTag(), key.toString(), 3);
        IEntityDTO restoreEntity = (IEntityDTO)this.get(restoreVersionId);
        IPSDEField versionPSDEField = this.getMajorVersionPSDEField(true);
        IEntityDTO temp = this.getDataEntityRuntime().createEntity();
        restoreEntity.copyTo(temp, true);
        temp.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), key);
        temp.set(this.getVersionIdPSDEField(false).getLowerCaseName(), versionId);
        if (versionPSDEField != null) {
            Object version = versionDTO.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.VERSION.value, false).getLowerCaseName());
            if (versionPSDEField != null) {
                temp.set(versionPSDEField.getLowerCaseName(), version);
            }
        }
        this.getDataEntityRuntime().rawUpdate(Arrays.asList(temp), false);
        return versionDTO;
    }

    @Override
    public boolean isEnableAction(String strActionName, IPSDEAction iPSDEAction, Object[] args) {
        return args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1]);
    }

    @Override
    public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
        Assert.notNull((Object)args, (String)"\u672a\u4f20\u5165\u8c03\u7528\u53c2\u6570");
        try {
            if (args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1])) {
                return this.onExecuteAction(strActionName, iPSDEAction, args, actionData);
            }
            throw new Exception("\u8c03\u7528\u53c2\u6570\u683c\u5f0f\u65e0\u6548");
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6267\u884c\u884c\u4e3a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onExecuteAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
        String strRealActionName;
        String string = strRealActionName = iPSDEAction != null ? iPSDEAction.getName() : strActionName;
        if ("get".equalsIgnoreCase(strRealActionName)) {
            return this.get(args[2]);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u884c\u4e3a[%1$s]", strRealActionName));
    }

    @Override
    public IEntityBase get(Object objVersionId) throws Throwable {
        try {
            return this.onGet(objVersionId);
        }
        catch (Throwable ex) {
            if (ex instanceof DataEntityRuntimeException) {
                DataEntityRuntimeException.rethrow(this, ex);
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u83b7\u53d6\u7248\u672c\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IEntityBase onGet(Object objVersionId) throws Throwable {
        Object versionId = DataTypeUtils.convert(this.getVersionDataEntityRuntime().getKeyPSDEField().getStdDataType(), objVersionId);
        IEntityDTO versionData = this.getVersionDataEntityRuntime().get(versionId);
        String strData = versionData.getString(this.getVersionPSDEField("DATA", false).getLowerCaseName(), null);
        if (!StringUtils.hasLength((String)strData)) {
            Object parentId = versionData.get(this.getVersionPSDEField(PSModelEnums.PredefinedFieldType.PARENTID.value, false).getLowerCaseName());
            return this.getDataEntityRuntime().get(parentId);
        }
        return this.getDataEntityRuntime().deserializeEntity(strData);
    }

    protected IPSDEField getMajorVersionPSDEField(boolean bTryMode) throws Exception {
        if (this.versionPSDEField != null || bTryMode) {
            return this.versionPSDEField;
        }
        throw new Exception(String.format("\u672a\u5b9a\u4e49\u7248\u672c\u53f7\u5b58\u50a8\u5c5e\u6027", new Object[0]));
    }

    protected void setVersionPSDEField(IPSDEField versionPSDEField) {
        this.versionPSDEField = versionPSDEField;
    }

    protected IPSDEField getVersionIdPSDEField(boolean bTryMode) throws Exception {
        if (this.versionIdPSDEField != null || bTryMode) {
            return this.versionIdPSDEField;
        }
        throw new Exception(String.format("\u672a\u5b9a\u4e49\u7248\u672c\u6807\u8bc6\u5b58\u50a8\u5c5e\u6027", new Object[0]));
    }

    protected void setVersionIdPSDEField(IPSDEField versionIdPSDEField) {
        this.versionIdPSDEField = versionIdPSDEField;
    }

    @Override
    public boolean isCurrentVersionId(Object key, Object objVersionId) {
        try {
            return this.onIsCurrentVersionId(key, objVersionId);
        }
        catch (Throwable ex) {
            if (ex instanceof DataEntityRuntimeException) {
                DataEntityRuntimeException.rethrow(this, ex);
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u5224\u65ad\u662f\u5426\u5f53\u524d\u7248\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected boolean onIsCurrentVersionId(Object key, Object objVersionId) throws Throwable {
        Object versionId = DataTypeUtils.convert(this.getVersionDataEntityRuntime().getKeyPSDEField().getStdDataType(), objVersionId);
        IEntityDTO versionData = this.getVersionDataEntityRuntime().get(versionId);
        String strData = versionData.getString(this.getVersionPSDEField("DATA", false).getLowerCaseName(), null);
        return !StringUtils.hasLength((String)strData);
    }
}

