/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import net.ibizsys.central.IDynaInstRuntime;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.central.dataentity.util.IDEUtilRuntime;
import net.ibizsys.model.dataentity.util.IPSDEUtil;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.IModelRuntimeContext;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.runtime.plugin.IModelRTAddin;
import net.ibizsys.runtime.plugin.ModelRTAddinRepo;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DEUtilRuntimeBase
extends net.ibizsys.runtime.dataentity.util.DEUtilRuntimeBase
implements IDEUtilRuntime {
    private static final Log log = LogFactory.getLog(DEUtilRuntimeBase.class);
    private String strLogCat = null;
    private ModelRTAddinRepo modelRTAddinRepo = null;

    @Override
    public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDEUtil iPSDEUtil) throws Exception {
        super.init(iDataEntityRuntimeContext, iPSDEUtil);
        if (this.getAddinRepo(true) == null) {
            this.prepareAddinRepo();
        }
    }

    protected void prepareAddinRepo() throws Exception {
    }

    @Override
    protected void onInit() throws Exception {
        this.strLogCat = this.getPSDEUtil().getUtilType();
        if ("USER".equals(this.strLogCat)) {
            this.strLogCat = this.getPSDEUtil().getUtilTag();
        }
        super.onInit();
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return (ISystemRuntime)super.getSystemRuntime();
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return (IDataEntityRuntime)super.getDataEntityRuntime();
    }

    @Override
    public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime() {
        return null;
    }

    @Override
    public IDynaInstRuntime getDynaInstRuntime() {
        return null;
    }

    protected ModelRTAddinRepo getAddinRepo(boolean bTryMode) throws Exception {
        if (this.modelRTAddinRepo != null || bTryMode) {
            return this.modelRTAddinRepo;
        }
        throw new Exception("\u63d2\u4ef6\u4ed3\u5e93\u65e0\u6548");
    }

    protected ModelRTAddinRepo getAddinRepo() {
        try {
            return this.getAddinRepo(false);
        }
        catch (Exception ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected void setAddinRepo(ModelRTAddinRepo modelRTAddinRepo) {
        this.modelRTAddinRepo = modelRTAddinRepo;
    }

    protected void prepareAddinRepo(IModelRuntimeContext ctx, Class<? extends IModelRTAddin> addinCls, String strTypePrefix) throws Exception {
        ModelRTAddinRepo modelRTAddinRepo = new ModelRTAddinRepo();
        modelRTAddinRepo.init(ctx, addinCls, strTypePrefix, this.getDataEntityRuntime().getSystemRuntime().getRuntimeObjectFactory());
        this.setAddinRepo(modelRTAddinRepo);
    }

    protected <T> Map<String, T> getAddins(Class<T> cls, String strTypePrefix) {
        return this.getAddinRepo().getAddins(cls, strTypePrefix);
    }

    protected void executeAction(String strActionName, IAction iAction) {
        this.executeAction(strActionName, iAction, null, Object.class, this.getLogPOTime());
    }

    protected Object executeAction(String strActionName, IAction iAction, Object[] args) {
        return this.executeAction(strActionName, iAction, args, Object.class, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, Class<T> cls) {
        return this.executeAction(strActionName, iAction, args, cls, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, TypeReference<T> type) {
        return this.executeAction(strActionName, iAction, args, type, this.getLogPOTime());
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, Class<T> cls, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                log.warn((Object)String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime));
                this.getSystemRuntime().logPO(30000, this.getLogCat(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), this.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getLogicName(), strActionName, ex.getMessage()), ex);
            throw this.dealException(String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    protected <T> T executeAction(String strActionName, IAction iAction, Object[] args, TypeReference<T> type, int nPOTime) {
        try {
            long nBeginTime = System.currentTimeMillis();
            Object objRet = iAction.execute(args);
            long bEndTime = System.currentTimeMillis();
            if (bEndTime - nBeginTime > (long)nPOTime) {
                log.warn((Object)String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime));
                this.getSystemRuntime().logPO(30000, this.getLogCat(), String.format("\u6267\u884c[%1$s]\u8017\u65f6[%2$s]ms", strActionName, bEndTime - nBeginTime), this.getLogicName(), strActionName, bEndTime - nBeginTime, null);
            }
            return (T)objRet;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getLogicName(), strActionName, ex.getMessage()), ex);
            throw this.dealException(String.format("%1$s\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strActionName, ex.getMessage()), ex);
        }
    }

    @Override
    public Object executeAction(final String strActionName, Object[] args) {
        return this.executeAction(strActionName, new IAction(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return DEUtilRuntimeBase.this.onExecuteAction(strActionName, args);
            }
        }, args);
    }

    protected Object onExecuteAction(String strActionName, Object[] args) throws Throwable {
        throw new Exception(String.format("\u4e0d\u652f\u6301\u7684\u884c\u4e3a[%1$s]", strActionName));
    }

    protected RuntimeException dealException(String strMessage, Throwable ex) {
        this.getSystemRuntime().log(40000, this.getLogCat(), String.format("%1$s%2$s", this.getLogicName(), strMessage), null);
        return new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, strMessage, ex);
    }

    protected String getLogCat() {
        return this.strLogCat;
    }

    protected int getLogPOTime() {
        return ActionSessionManager.getLogPOTime();
    }
}

