/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.util.DEUtilRuntimeBase;
import net.ibizsys.central.dataentity.util.IDENotifySettingUtilRuntime;
import net.ibizsys.central.res.ISysDEUniStateRuntime;
import net.ibizsys.central.sysutil.ISysUniStateListener;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.IModelRuntimeShutdownable;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DENotifySettingUtilRuntimeBase
extends DEUtilRuntimeBase
implements IDENotifySettingUtilRuntime {
    private static final Log log = LogFactory.getLog(DENotifySettingUtilRuntimeBase.class);
    private Map<String, Map<String, Integer>> notitySettingMapMap = new ConcurrentHashMap<String, Map<String, Integer>>();
    private IDataEntityRuntime settingDataEntityRuntime = null;
    private ISysDEUniStateRuntime settingSysDEUniStateRuntime = null;
    private IPSDEDataSet settingPSDEDataSet = null;
    private IPSDEField settingSystemTagPSDEField = null;
    private IPSDEField settingOwnerTypePSDEField = null;
    private IPSDEField settingOwnerIdPSDEField = null;
    private IPSDEField settingModelPSDEField = null;
    private Map<String, ISysUniStateListener> sysUniStateListenerMap = new ConcurrentHashMap<String, ISysUniStateListener>();
    private Map<String, Map<String, Object>> pathDataMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private IModelRuntimeShutdownable iModelRuntimeShutdownable = new IModelRuntimeShutdownable(){

        @Override
        public void shutdown() throws Exception {
            DENotifySettingUtilRuntimeBase.this.onShutdown();
        }
    };
    private ISysUniStateListener iSysUniStateListener = new ISysUniStateListener(){

        @Override
        public void change(String strPath, String data, String oldData, String strPattern) {
            try {
                log.debug((Object)String.format(String.format("\u7edf\u4e00\u72b6\u6001[%1$s]\u53d8\u66f4\u89e6\u53d1", strPath), new Object[0]));
                DENotifySettingUtilRuntimeBase.this.onUniStateChange(strPath, data, oldData, strPattern);
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u7edf\u4e00\u72b6\u6001[%1$s]\u53d8\u66f4\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strPath, ex.getMessage()), ex);
            }
        }
    };

    @Override
    protected void onInit() throws Exception {
        if (this.getSettingDataEntityRuntime(true) == null) {
            this.prepareSettingDataEntityRuntime();
            this.getSettingDataEntityRuntime(false);
        }
        super.onInit();
        this.getSystemRuntime().registerModelRuntimeShutdownable(this.iModelRuntimeShutdownable);
    }

    protected void prepareSettingDataEntityRuntime() throws Exception {
        IPSDataEntity utilPSDataEntity = this.getPSDEUtil().getUtilPSDE();
        if (utilPSDataEntity == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u901a\u77e5\u8bbe\u7f6e\u5b58\u50a8\u5b9e\u4f53", new Object[0]));
        }
        IDataEntityRuntime settingDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(utilPSDataEntity.getId());
        this.setSettingDataEntityRuntime(settingDataEntityRuntime);
        this.setSettingModelPSDEField(settingDataEntityRuntime.getPSDEFieldByTag("SETTING_MODEL", false));
        this.setSettingSystemTagPSDEField(settingDataEntityRuntime.getPSDEFieldByTag("SYSTEM_TAG", false));
        this.setSettingOwnerTypePSDEField(settingDataEntityRuntime.getPSDEFieldByTag("OWNER_TYPE", false));
        this.setSettingOwnerIdPSDEField(settingDataEntityRuntime.getPSDEFieldByTag("OWNER_ID", false));
        this.setSettingSysDEUniStateRuntime(this.getSettingDataEntityRuntime().getDefaultSysDEUniStateRuntime(true));
    }

    @Override
    public IDataEntityRuntime getSettingDataEntityRuntime() {
        try {
            return this.getSettingDataEntityRuntime(false);
        }
        catch (Exception ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected IPSDEDataSet getSettingPSDEDataSet() {
        return this.settingPSDEDataSet;
    }

    protected void setSettingPSDEDataSet(IPSDEDataSet settingPSDEDataSet) {
        this.settingPSDEDataSet = settingPSDEDataSet;
    }

    protected IPSDEField getSettingSystemTagPSDEField() {
        return this.settingSystemTagPSDEField;
    }

    protected void setSettingSystemTagPSDEField(IPSDEField settingSystemTagPSDEField) {
        this.settingSystemTagPSDEField = settingSystemTagPSDEField;
    }

    protected IPSDEField getSettingOwnerTypePSDEField() {
        return this.settingOwnerTypePSDEField;
    }

    protected void setSettingOwnerTypePSDEField(IPSDEField settingOwnerTypePSDEField) {
        this.settingOwnerTypePSDEField = settingOwnerTypePSDEField;
    }

    protected IPSDEField getSettingOwnerIdPSDEField() {
        return this.settingOwnerIdPSDEField;
    }

    protected void setSettingOwnerIdPSDEField(IPSDEField settingOwnerIdPSDEField) {
        this.settingOwnerIdPSDEField = settingOwnerIdPSDEField;
    }

    protected IPSDEField getSettingModelPSDEField() {
        return this.settingModelPSDEField;
    }

    protected void setSettingModelPSDEField(IPSDEField settingModelPSDEField) {
        this.settingModelPSDEField = settingModelPSDEField;
    }

    protected IDataEntityRuntime getSettingDataEntityRuntime(boolean tryMode) throws Exception {
        if (this.settingDataEntityRuntime != null || tryMode) {
            return this.settingDataEntityRuntime;
        }
        throw new Exception(String.format("\u8bbe\u7f6e\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setSettingDataEntityRuntime(IDataEntityRuntime settingDataEntityRuntime) {
        this.settingDataEntityRuntime = settingDataEntityRuntime;
    }

    protected ISysDEUniStateRuntime getSettingSysDEUniStateRuntime() {
        return this.settingSysDEUniStateRuntime;
    }

    protected void setSettingSysDEUniStateRuntime(ISysDEUniStateRuntime settingSysDEUniStateRuntime) {
        this.settingSysDEUniStateRuntime = settingSysDEUniStateRuntime;
    }

    @Override
    public Map<String, Integer> getSettings(IEntity iEntity, String strNotifyTag, int nMsgType, Set<String> personIdSet) {
        Assert.hasLength((String)strNotifyTag, (String)"\u4f20\u5165\u901a\u77e5\u6807\u8bb0\u65e0\u6548");
        Assert.isTrue((nMsgType > 0 ? 1 : 0) != 0, (String)"\u4f20\u5165\u6d88\u606f\u7c7b\u578b\u65e0\u6548");
        Assert.notEmpty(personIdSet, (String)"\u4f20\u5165\u4eba\u5458\u6807\u8bc6\u96c6\u5408\u65e0\u6548");
        try {
            return this.onGetSettings(iEntity, strNotifyTag, nMsgType, personIdSet);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException.rethrow(this, ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u83b7\u53d6\u901a\u77e5\u8bbe\u7f6e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Map<String, Integer> onGetSettings(IEntity iEntity, String strNotifyTag, int nMsgType, Set<String> personIdSet) throws Throwable {
        Map<String, Integer> map;
        LinkedHashMap<String, Integer> settings = new LinkedHashMap<String, Integer>();
        ArrayList<String> fetchPersonIdList = new ArrayList<String>();
        for (String strPersonId : personIdSet) {
            map = this.notitySettingMapMap.get(String.format("%1$s|%2$s", "PERSONAL", strPersonId));
            if (map != null) continue;
            fetchPersonIdList.add(strPersonId);
        }
        if (!ObjectUtils.isEmpty(fetchPersonIdList)) {
            ISearchContextDTO searchContextDTO = this.getSettingDataEntityRuntime().createSearchContext();
            searchContextDTO.setCount(false);
            searchContextDTO.all();
            searchContextDTO.eq(this.getSettingSystemTagPSDEField().getLowerCaseName(), this.getSystemRuntime().getDeploySystemId());
            searchContextDTO.eq(this.getSettingOwnerTypePSDEField().getLowerCaseName(), "PERSONAL");
            searchContextDTO.in(this.getSettingOwnerIdPSDEField().getLowerCaseName(), fetchPersonIdList);
            List<IEntityDTO> list = this.getSettingDataEntityRuntime().selectDataSet(this.getSettingDataEntityRuntime().getViewPSDEDataSet(), searchContextDTO);
            if (!ObjectUtils.isEmpty(list)) {
                for (IEntityDTO iEntityDTO : list) {
                    this.updateSetting(iEntityDTO, true);
                }
            }
        }
        for (String strPersonId : personIdSet) {
            map = this.notitySettingMapMap.get(String.format("%1$s|%2$s", "PERSONAL", strPersonId));
            if (map != null) continue;
            IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
            iEntityDTO.set(this.getSettingOwnerIdPSDEField().getLowerCaseName(), strPersonId);
            iEntityDTO.set(this.getSettingOwnerTypePSDEField().getLowerCaseName(), "PERSONAL");
            iEntityDTO.set(this.getSettingSystemTagPSDEField().getLowerCaseName(), this.getSystemRuntime().getDeploySystemId());
            this.updateSetting(iEntityDTO, true);
        }
        Map<String, Integer> defaultMap = this.notitySettingMapMap.get(String.format("%1$s|%2$s", "SYSTEM", null));
        if (defaultMap == null) {
            ISearchContextDTO searchContextDTO = this.getSettingDataEntityRuntime().createSearchContext();
            searchContextDTO.setCount(false);
            searchContextDTO.all();
            searchContextDTO.eq(this.getSettingSystemTagPSDEField().getLowerCaseName(), this.getSystemRuntime().getDeploySystemId());
            searchContextDTO.eq(this.getSettingOwnerTypePSDEField().getLowerCaseName(), "SYSTEM");
            searchContextDTO.nvl(this.getSettingOwnerIdPSDEField().getLowerCaseName());
            List<IEntityDTO> list = this.getSettingDataEntityRuntime().selectDataSet(this.getSettingDataEntityRuntime().getViewPSDEDataSet(), searchContextDTO);
            if (!ObjectUtils.isEmpty(list)) {
                for (IEntityDTO iEntityDTO3 : list) {
                    this.updateSetting(iEntityDTO3, true);
                }
            } else {
                IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
                iEntityDTO.set(this.getSettingOwnerTypePSDEField().getLowerCaseName(), "SYSTEM");
                iEntityDTO.set(this.getSettingSystemTagPSDEField().getLowerCaseName(), this.getSystemRuntime().getDeploySystemId());
                this.updateSetting(iEntityDTO, true);
            }
            defaultMap = this.notitySettingMapMap.get(String.format("%1$s|%2$s", "SYSTEM", null));
        }
        for (String strPersonId : personIdSet) {
            Map<String, Integer> map2 = this.notitySettingMapMap.get(String.format("%1$s|%2$s", "PERSONAL", strPersonId));
            if (map2 == null && defaultMap == null) {
                settings.put(strPersonId, nMsgType);
                continue;
            }
            Integer nValue = null;
            if (map2 != null) {
                nValue = map2.get(strNotifyTag);
            }
            if (nValue == null && defaultMap != null) {
                nValue = defaultMap.get(strNotifyTag);
            }
            nValue = nValue == null ? Integer.valueOf(nMsgType) : Integer.valueOf(nValue & nMsgType);
            settings.put(strPersonId, nValue);
        }
        return settings;
    }

    protected void updateSetting(IEntityDTO iEntityDTO, boolean bHook) throws Throwable {
        String strPersonId = iEntityDTO.getString(this.getSettingOwnerIdPSDEField().getLowerCaseName(), null);
        Object model = iEntityDTO.get(this.getSettingModelPSDEField().getLowerCaseName());
        String strOwnerType = iEntityDTO.getString(this.getSettingOwnerTypePSDEField().getLowerCaseName(), null);
        if (!ObjectUtils.isEmpty((Object)model)) {
            HashMap<String, Integer> settings = new HashMap<String, Integer>();
            List list = null;
            list = model instanceof List ? (List)model : JsonUtils.asList(model);
            for (Object item : list) {
                Integer nMsgType;
                String strNotifyTag;
                Object map;
                if (item instanceof Map) {
                    map = (Map)item;
                    strNotifyTag = DataTypeUtils.asString(map.get("id"), null);
                    if (!StringUtils.hasLength((String)strNotifyTag) || (nMsgType = DataTypeUtils.asInteger(map.get("msg_type"), null)) == null) continue;
                    settings.put(strNotifyTag, nMsgType);
                    continue;
                }
                if (!(item instanceof IEntity) || !StringUtils.hasLength((String)(strNotifyTag = DataTypeUtils.asString((map = (IEntity)item).get("id"), null))) || (nMsgType = DataTypeUtils.asInteger(map.get("msg_type"), null)) == null) continue;
                settings.put(strNotifyTag, nMsgType);
            }
            this.notitySettingMapMap.put(String.format("%1$s|%2$s", strOwnerType, strPersonId), settings);
        } else {
            this.notitySettingMapMap.put(String.format("%1$s|%2$s", strOwnerType, strPersonId), new HashMap());
        }
        if (!bHook) {
            return;
        }
        ISysDEUniStateRuntime iSysDEUniStateRuntime = this.getSettingSysDEUniStateRuntime();
        if (iSysDEUniStateRuntime != null) {
            String strPath;
            iSysDEUniStateRuntime.setEntity(iEntityDTO);
            if (iSysDEUniStateRuntime.isEnableListener() && !this.sysUniStateListenerMap.containsKey(strPath = iSysDEUniStateRuntime.getPath(iEntityDTO))) {
                iSysDEUniStateRuntime.registerListener(strPath, false, this.iSysUniStateListener);
                this.sysUniStateListenerMap.put(strPath, this.iSysUniStateListener);
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                iEntityDTO.copyTo(data, false);
                data.remove(this.getSettingModelPSDEField().getLowerCaseName());
                this.pathDataMap.put(strPath, data);
            }
        }
    }

    protected void onUniStateChange(String strPath, String data, String oldData, String strPattern) throws Throwable {
        Map<Object, Object> map = null;
        map = StringUtils.hasLength((String)data) ? JsonUtils.asMap(data) : (StringUtils.hasLength((String)oldData) ? JsonUtils.asMap(oldData) : this.pathDataMap.get(strPath));
        if (map == null) {
            return;
        }
        IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity(map, false);
        if (!StringUtils.hasLength((String)data)) {
            iEntityDTO.reset(this.getSettingModelPSDEField().getLowerCaseName());
        }
        this.updateSetting(iEntityDTO, false);
    }

    protected void onShutdown() throws Exception {
        ISysDEUniStateRuntime iSysDEUniStateRuntime = this.getSettingSysDEUniStateRuntime();
        if (iSysDEUniStateRuntime != null && !ObjectUtils.isEmpty(this.sysUniStateListenerMap)) {
            for (Map.Entry<String, ISysUniStateListener> entry : this.sysUniStateListenerMap.entrySet()) {
                iSysDEUniStateRuntime.unregisterListener(entry.getKey(), false, entry.getValue());
            }
            this.sysUniStateListenerMap.clear();
        }
    }
}

