/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.database.DBDialectUtils;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.util.DEUtilRuntimeBase;
import net.ibizsys.central.dataentity.util.IDEDynaStorageUtilRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.ISearchGroupCond;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.SearchCustomCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEDynaStorageUtilRuntimeBase
extends DEUtilRuntimeBase
implements IDEDynaStorageUtilRuntime {
    private static final Log log = LogFactory.getLog(DEDynaStorageUtilRuntimeBase.class);
    private Map<String, IPSDEField> dynaPSDEFieldMap = null;
    private IDataEntityRuntime storageDataEntityRuntime = null;
    private Map<String, IPSDEField> storagePSDEFieldMap = null;
    private String strDBType = null;
    private boolean bLocalStorageMode = false;
    private IPSDEField localStoragePSDEField = null;

    @Override
    protected void onInit() throws Exception {
        if (this.getDataEntityRuntime().getSysDBSchemeRuntime() != null) {
            this.strDBType = this.getDataEntityRuntime().getSysDBSchemeRuntime().getDBType();
        }
        if (this.getStorageDataEntityRuntime(true) == null) {
            this.prepareStorageDataEntityRuntime();
            this.getStorageDataEntityRuntime(false);
        }
        this.prepareDynaPSDEFields();
        super.onInit();
    }

    protected void prepareDynaPSDEFields() throws Exception {
        List psDEFieldList = this.getDataEntityRuntime().getPSDataEntity().getAllPSDEFields();
        if (!ObjectUtils.isEmpty((Object)psDEFieldList)) {
            LinkedHashMap<String, IPSDEField> dynaPSDEFieldMap = new LinkedHashMap<String, IPSDEField>();
            for (IPSDEField iPSDEField : psDEFieldList) {
                if (!iPSDEField.isDynaStorageDEField()) continue;
                dynaPSDEFieldMap.put(iPSDEField.getName(), iPSDEField);
            }
            if (!ObjectUtils.isEmpty(dynaPSDEFieldMap)) {
                this.setDynaPSDEFieldMap(dynaPSDEFieldMap);
            }
        }
    }

    protected String getDBType() {
        return this.strDBType;
    }

    protected IDBDialect getDBDialect() {
        return DBDialectUtils.getInstance().get(this.getDBType());
    }

    protected boolean isLocalStorageMode() {
        return this.bLocalStorageMode;
    }

    protected void setLocalStorageMode(boolean bLocalStorageMode) {
        this.bLocalStorageMode = bLocalStorageMode;
    }

    protected IPSDEField getLocalStoragePSDEField(boolean bTryMode) throws Exception {
        if (this.localStoragePSDEField != null || bTryMode) {
            return this.localStoragePSDEField;
        }
        throw new Exception(String.format("\u672c\u5730\u5b58\u50a8\u5c5e\u6027\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setLocalStoragePSDEField(IPSDEField localStoragePSDEField) {
        this.localStoragePSDEField = localStoragePSDEField;
    }

    protected Map<String, IPSDEField> getDynaPSDEFieldMap() {
        return this.dynaPSDEFieldMap;
    }

    protected void setDynaPSDEFieldMap(Map<String, IPSDEField> dynaPSDEFieldMap) {
        this.dynaPSDEFieldMap = dynaPSDEFieldMap;
    }

    protected void prepareStorageDataEntityRuntime() throws Exception {
        IPSDataEntity utilPSDataEntity = this.getPSDEUtil().getUtilPSDE();
        if (utilPSDataEntity == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u5b58\u50a8\u5b9e\u4f53", new Object[0]));
        }
        if (this.getDataEntityRuntime().getId().equals(utilPSDataEntity.getId())) {
            this.setStorageDataEntityRuntime(this.getDataEntityRuntime());
            this.setLocalStoragePSDEField(this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.DYNASTORAGE, false));
            this.setLocalStorageMode(true);
        } else {
            IDataEntityRuntime storageDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(utilPSDataEntity.getId());
            this.setStorageDataEntityRuntime(storageDataEntityRuntime);
            HashMap<String, IPSDEField> storagePSDEFieldMap = new HashMap<String, IPSDEField>();
            storagePSDEFieldMap.put("NAME", null);
            storagePSDEFieldMap.put("STRING_VALUE", null);
            storagePSDEFieldMap.put("LONGSTRING_VALUE", null);
            storagePSDEFieldMap.put("DOUBLE_VALUE", null);
            storagePSDEFieldMap.put("DATETIME_VALUE", null);
            storagePSDEFieldMap.put("DECIMAL_VALUE", null);
            storagePSDEFieldMap.put("INT_VALUE", null);
            storagePSDEFieldMap.put("BIGINT_VALUE", null);
            storagePSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTID.value, storageDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false));
            storagePSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, storageDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false));
            storagePSDEFieldMap.put(PSModelEnums.PredefinedFieldType.PARENTNAME.value, storageDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTNAME.value, true));
            List psDEFieldList = storageDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
            if (!ObjectUtils.isEmpty((Object)psDEFieldList)) {
                String strTag;
                for (IPSDEField iPSDEField : psDEFieldList) {
                    if (!StringUtils.hasLength((String)iPSDEField.getFieldTag()) || !storagePSDEFieldMap.containsKey(strTag = iPSDEField.getFieldTag().toUpperCase()) || storagePSDEFieldMap.get(strTag) != null) continue;
                    storagePSDEFieldMap.put(strTag, iPSDEField);
                }
                for (IPSDEField iPSDEField : psDEFieldList) {
                    strTag = iPSDEField.getName().toUpperCase();
                    if (!storagePSDEFieldMap.containsKey(strTag) || storagePSDEFieldMap.get(strTag) != null) continue;
                    storagePSDEFieldMap.put(strTag, iPSDEField);
                }
            }
            if (storagePSDEFieldMap.get("NAME") == null) {
                if (storageDataEntityRuntime.getMajorPSDEField() == null) {
                    throw new Exception("\u5b58\u50a8\u5b9e\u4f53\u672a\u5b9a\u4e49\u4e3b\u5c5e\u6027");
                }
                storagePSDEFieldMap.put("NAME", storageDataEntityRuntime.getMajorPSDEField());
            }
            this.setStoragePSDEFieldMap(storagePSDEFieldMap);
        }
    }

    protected IDataEntityRuntime getStorageDataEntityRuntime() throws Exception {
        return this.getStorageDataEntityRuntime(false);
    }

    protected IDataEntityRuntime getStorageDataEntityRuntime(boolean tryMode) throws Exception {
        if (this.storageDataEntityRuntime != null || tryMode) {
            return this.storageDataEntityRuntime;
        }
        throw new Exception(String.format("\u5b58\u50a8\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setStorageDataEntityRuntime(IDataEntityRuntime storageDataEntityRuntime) {
        this.storageDataEntityRuntime = storageDataEntityRuntime;
    }

    protected Map<String, IPSDEField> getStoragePSDEFieldMap() {
        return this.storagePSDEFieldMap;
    }

    protected void setStoragePSDEFieldMap(Map<String, IPSDEField> storagePSDEFieldMap) {
        this.storagePSDEFieldMap = storagePSDEFieldMap;
    }

    protected Map<String, IPSDEField> getDynaPSDEFields(Object arg0, String strActionName, IPSDEAction iPSDEAction) throws Exception {
        return this.dynaPSDEFieldMap;
    }

    protected Map<String, IPSDEField> getDynaPSDEFields(Object arg0, String strDataSetName, IPSDEDataSet iPSDEDataSet) throws Exception {
        return this.dynaPSDEFieldMap;
    }

    protected Map<String, IPSDEField> getDynaPSDEFields(Object arg0, String strDataQueryName, IPSDEDataQuery iPSDEDataQuery) throws Exception {
        return this.dynaPSDEFieldMap;
    }

    @Override
    public void checkEntityDynaFieldsBeforeProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
        try {
            this.onCheckEntityDynaFieldsBeforeProceed(arg0, strActionName, iPSDEAction);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u884c\u4e3a[%1$s]\u5904\u7406\u524d\u68c0\u67e5\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEAction != null ? iPSDEAction.getName() : strActionName, ex.getMessage()), ex);
        }
    }

    protected void onCheckEntityDynaFieldsBeforeProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
    }

    @Override
    public void translateEntityDynaFieldsBeforeProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
        try {
            this.onTranslateEntityDynaFieldsBeforeProceed(arg0, strActionName, iPSDEAction);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u884c\u4e3a[%1$s]\u5904\u7406\u524d\u8f6c\u6362\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEAction != null ? iPSDEAction.getName() : strActionName, ex.getMessage()), ex);
        }
    }

    protected void onTranslateEntityDynaFieldsBeforeProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        HashMap<String, Object> dynaFieldValueMap = null;
        Map<String, IPSDEField> dynaPSDEFieldMap = this.getDynaPSDEFields((Object)arg0, strActionName, iPSDEAction);
        if (!ObjectUtils.isEmpty(dynaPSDEFieldMap)) {
            for (IPSDEField iPSDEField : dynaPSDEFieldMap.values()) {
                if (!this.getDataEntityRuntime().containsFieldValue(arg0, iPSDEField)) continue;
                if (dynaFieldValueMap == null) {
                    dynaFieldValueMap = new HashMap<String, Object>();
                }
                dynaFieldValueMap.put(iPSDEField.getName(), this.getDataEntityRuntime().getFieldValue(arg0, iPSDEField));
            }
            String strParamKey = String.format("%1$s_%2$s", "__DYNAFIELDS_", actionSession.getSessionId());
            actionSession.setActionParam(strParamKey, dynaFieldValueMap);
        }
        if (!this.isLocalStorageMode()) {
            return;
        }
        if (ObjectUtils.isEmpty(dynaFieldValueMap)) {
            this.getDataEntityRuntime().setFieldValue(arg0, this.getLocalStoragePSDEField(false), null);
        } else {
            this.getDataEntityRuntime().setFieldValue(arg0, this.getLocalStoragePSDEField(false), (Object)JsonUtils.toString(dynaFieldValueMap));
        }
    }

    @Override
    public void translateEntityDynaFieldsAfterProceed(Object arg0, Object objRet, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
        try {
            this.onTranslateEntityDynaFieldsAfterProceed(arg0, objRet, strActionName, iPSDEAction);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u884c\u4e3a[%1$s]\u5904\u7406\u540e\u8f6c\u6362\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEAction != null ? iPSDEAction.getName() : strActionName, ex.getMessage()), ex);
        }
    }

    protected void onTranslateEntityDynaFieldsAfterProceed(Object arg0, Object objRet, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
        Map<String, IPSDEField> dynaPSDEFieldMap = this.getDynaPSDEFields(arg0, strActionName, iPSDEAction);
        if (ObjectUtils.isEmpty(dynaPSDEFieldMap)) {
            return;
        }
        IEntityBase iEntityBase = null;
        if (objRet instanceof IEntityBase) {
            iEntityBase = (IEntityBase)objRet;
        } else if (arg0 instanceof IEntityBase) {
            iEntityBase = (IEntityBase)arg0;
        }
        if (iEntityBase == null) {
            return;
        }
        if (this.isLocalStorageMode()) {
            Object dynaStorage = this.getDataEntityRuntime().getFieldValue(iEntityBase, this.getLocalStoragePSDEField(false));
            Map dynaFieldValueMap = null;
            if (dynaStorage != null) {
                dynaFieldValueMap = JsonUtils.asMap(dynaStorage);
            }
            for (Map.Entry<String, IPSDEField> entry : dynaPSDEFieldMap.entrySet()) {
                Object value = dynaFieldValueMap != null ? dynaFieldValueMap.get(entry.getKey()) : null;
                this.getDataEntityRuntime().setFieldValue(iEntityBase, entry.getValue(), value);
            }
            this.getDataEntityRuntime().resetFieldValue(iEntityBase, this.getLocalStoragePSDEField(false));
        } else {
            Object key = this.getDataEntityRuntime().getFieldValue(iEntityBase, this.getDataEntityRuntime().getKeyPSDEField());
            Object name = null;
            if (this.getDataEntityRuntime().getMajorPSDEField() != null) {
                name = this.getDataEntityRuntime().getFieldValue(iEntityBase, this.getDataEntityRuntime().getMajorPSDEField());
            }
            ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
            String strParamKey = String.format("%1$s_%2$s", "__DYNAFIELDS_", actionSession.getSessionId());
            Object dynaFields = actionSession.getActionParam(strParamKey);
            Map dynaFieldValueMap = null;
            if (dynaFields instanceof Map) {
                dynaFieldValueMap = (Map)dynaFields;
            }
            if (dynaFieldValueMap != null) {
                ArrayList<IEntityDTO> storageEntityList = new ArrayList<IEntityDTO>();
                for (IPSDEField iPSDEField : dynaPSDEFieldMap.values()) {
                    if (!dynaFieldValueMap.containsKey(iPSDEField.getName())) continue;
                    IEntityDTO storageEntity = this.getStorageDataEntityRuntime().createEntity();
                    storageEntity.set(this.getStorageEntityFieldName("NAME"), iPSDEField.getName());
                    storageEntity.set(this.getStorageEntityFieldName(PSModelEnums.PredefinedFieldType.PARENTID.value), key);
                    storageEntity.set(this.getStorageEntityFieldName(PSModelEnums.PredefinedFieldType.PARENTTYPE.value), this.getDataEntityRuntime().getName());
                    if (name != null) {
                        storageEntity.set(this.getStorageEntityFieldName(PSModelEnums.PredefinedFieldType.PARENTNAME.value), name);
                    }
                    Object value = dynaFieldValueMap.get(iPSDEField.getName());
                    this.setStorageEntityFieldValue(storageEntity, iPSDEField, value);
                    storageEntityList.add(storageEntity);
                }
                if (!ObjectUtils.isEmpty(storageEntityList)) {
                    try {
                        this.getStorageDataEntityRuntime().rawSave(storageEntityList, false);
                    }
                    catch (Throwable ex) {
                        throw new Exception(String.format("\u4fdd\u5b58\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                    }
                }
            }
            ISearchContextDTO searchContextDTO = this.getStorageDataEntityRuntime().createSearchContext();
            IPSDEField parentIdPSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
            searchContextDTO.eq(parentIdPSDEField.getName(), key);
            IPSDEField parentTypePSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false);
            searchContextDTO.eq(parentTypePSDEField.getName(), this.getDataEntityRuntime().getName());
            String strFieldName = this.getStorageEntityFieldName("NAME");
            List<IEntityDTO> list = this.getStorageDataEntityRuntime().rawSelect(searchContextDTO);
            if (!ObjectUtils.isEmpty(list)) {
                for (IEntityDTO iEntityDTO : list) {
                    IPSDEField iPSDEField;
                    String strName = iEntityDTO.getString(strFieldName, null);
                    if (ObjectUtils.isEmpty((Object)strName) || (iPSDEField = dynaPSDEFieldMap.get(strName)) == null) continue;
                    this.getDataEntityRuntime().setFieldValue(iEntityBase, iPSDEField, this.getStorageEntityFieldValue(iEntityDTO, iPSDEField));
                }
            }
        }
    }

    protected void setStorageEntityFieldValue(IEntityDTO storageEntity, IPSDEField iPSDEField, Object value) throws Exception {
        int nStdDataType = iPSDEField.getStdDataType();
        if (DataTypeUtils.isLongStringDataType(nStdDataType)) {
            storageEntity.set(this.getStorageEntityFieldName("LONGSTRING_VALUE"), DataTypeUtils.asString(value, null));
            return;
        }
        if (DataTypeUtils.isStringDataType(nStdDataType)) {
            storageEntity.set(this.getStorageEntityFieldName("STRING_VALUE"), DataTypeUtils.asString(value, null));
            return;
        }
        if (DataTypeUtils.isDateTimeDataType(nStdDataType)) {
            storageEntity.set(this.getStorageEntityFieldName("DATETIME_VALUE"), DataTypeUtils.asDateTime(value, null));
            return;
        }
        if (DataTypeUtils.isBigIntDataType(nStdDataType)) {
            storageEntity.set(this.getStorageEntityFieldName("BIGINT_VALUE"), DataTypeUtils.asBigInteger(value, null));
            return;
        }
        if (DataTypeUtils.isBigDecimalDataType(nStdDataType)) {
            storageEntity.set(this.getStorageEntityFieldName("DECIMAL_VALUE"), DataTypeUtils.asBigDecimal(value, null));
            return;
        }
        if (DataTypeUtils.isIntDataType(nStdDataType)) {
            storageEntity.set(this.getStorageEntityFieldName("INT_VALUE"), DataTypeUtils.asInteger(value, null));
            return;
        }
        if (DataTypeUtils.isDoubleDataType(nStdDataType)) {
            storageEntity.set(this.getStorageEntityFieldName("DOUBLE_VALUE"), DataTypeUtils.asDouble(value, null));
            return;
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b[%1$s]", nStdDataType));
    }

    protected Object getStorageEntityFieldValue(IEntityDTO storageEntity, IPSDEField iPSDEField) throws Exception {
        int nStdDataType = iPSDEField.getStdDataType();
        if (DataTypeUtils.isLongStringDataType(nStdDataType)) {
            return storageEntity.get(this.getStorageEntityFieldName("LONGSTRING_VALUE"));
        }
        if (DataTypeUtils.isStringDataType(nStdDataType)) {
            return storageEntity.get(this.getStorageEntityFieldName("STRING_VALUE"));
        }
        if (DataTypeUtils.isDateTimeDataType(nStdDataType)) {
            return storageEntity.get(this.getStorageEntityFieldName("DATETIME_VALUE"));
        }
        if (DataTypeUtils.isBigIntDataType(nStdDataType)) {
            return storageEntity.get(this.getStorageEntityFieldName("BIGINT_VALUE"));
        }
        if (DataTypeUtils.isBigDecimalDataType(nStdDataType)) {
            return storageEntity.get(this.getStorageEntityFieldName("DECIMAL_VALUE"));
        }
        if (DataTypeUtils.isIntDataType(nStdDataType)) {
            return storageEntity.get(this.getStorageEntityFieldName("INT_VALUE"));
        }
        if (DataTypeUtils.isDoubleDataType(nStdDataType)) {
            return storageEntity.get(this.getStorageEntityFieldName("DOUBLE_VALUE"));
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b[%1$s]", nStdDataType));
    }

    protected String getStorageEntityFieldName(String strType) {
        IPSDEField iPSDEField;
        Map<String, IPSDEField> storagePSDEFieldMap = this.getStoragePSDEFieldMap();
        if (storagePSDEFieldMap != null && (iPSDEField = storagePSDEFieldMap.get(strType)) != null) {
            return iPSDEField.getName();
        }
        return strType;
    }

    protected IPSDEField getStoragePSDEField(IPSDEField iPSDEField) throws Exception {
        int nStdDataType = iPSDEField.getStdDataType();
        if (DataTypeUtils.isLongStringDataType(nStdDataType)) {
            return this.getStoragePSDEField("LONGSTRING_VALUE", false);
        }
        if (DataTypeUtils.isStringDataType(nStdDataType)) {
            return this.getStoragePSDEField("STRING_VALUE", false);
        }
        if (DataTypeUtils.isDateTimeDataType(nStdDataType)) {
            return this.getStoragePSDEField("DATETIME_VALUE", false);
        }
        if (DataTypeUtils.isBigIntDataType(nStdDataType)) {
            return this.getStoragePSDEField("BIGINT_VALUE", false);
        }
        if (DataTypeUtils.isBigDecimalDataType(nStdDataType)) {
            return this.getStoragePSDEField("DECIMAL_VALUE", false);
        }
        if (DataTypeUtils.isIntDataType(nStdDataType)) {
            return this.getStoragePSDEField("INT_VALUE", false);
        }
        if (DataTypeUtils.isDoubleDataType(nStdDataType)) {
            return this.getStoragePSDEField("DOUBLE_VALUE", false);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b[%1$s]", nStdDataType));
    }

    protected IPSDEField getStoragePSDEField(String strType, boolean tryMode) throws Exception {
        IPSDEField iPSDEField;
        Map<String, IPSDEField> storagePSDEFieldMap = this.getStoragePSDEFieldMap();
        if (storagePSDEFieldMap != null && (iPSDEField = storagePSDEFieldMap.get(strType)) != null) {
            return iPSDEField;
        }
        if (tryMode) {
            return null;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u52a8\u6001\u5b58\u50a8\u7c7b\u578b[%1$s]\u5bf9\u5e94\u7684\u5c5e\u6027", strType));
    }

    @Override
    public void removeEntityDynaFieldsBeforeRemove(Object arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
        try {
            this.onRemoveEntityDynaFieldsBeforeRemove(arg0, strActionName, iPSDEAction);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u884c\u4e3a[%1$s]\u5904\u7406\u540e\u5f02\u5e38\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEAction != null ? iPSDEAction.getName() : strActionName, ex.getMessage()), ex);
        }
    }

    protected void onRemoveEntityDynaFieldsBeforeRemove(Object arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable {
        if (this.isLocalStorageMode()) {
            return;
        }
        Object key = null;
        key = arg0 instanceof IEntityBase ? this.getDataEntityRuntime().getFieldValue((IEntityBase)arg0, this.getDataEntityRuntime().getKeyPSDEField()) : arg0;
        ISearchContextDTO searchContextDTO = this.getStorageDataEntityRuntime().createSearchContext();
        IPSDEField parentIdPSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
        searchContextDTO.eq(parentIdPSDEField.getName(), key);
        IPSDEField parentTypePSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false);
        searchContextDTO.eq(parentTypePSDEField.getName(), this.getDataEntityRuntime().getName());
        List<IEntityDTO> list = this.getStorageDataEntityRuntime().rawSelect(searchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            ArrayList<Object> keyList = new ArrayList<Object>();
            for (IEntityDTO iEntityDTO : list) {
                keyList.add(iEntityDTO.get(this.getStorageDataEntityRuntime().getKeyPSDEField().getName()));
            }
            try {
                this.getStorageDataEntityRuntime().rawRemove(keyList, false);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u5220\u9664\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
    }

    @Override
    public void translateSearchContextDynaFieldsBeforeProceed(ISearchContextBase arg0, String strDataSetName, IPSDEDataSet iPSDEDataSet) throws Throwable {
        try {
            this.onTranslateSearchContextDynaFieldsBeforeProceed(arg0, strDataSetName, iPSDEDataSet);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6570\u636e\u96c6[%1$s]\u5904\u7406\u524d\u8f6c\u6362\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEDataSet != null ? iPSDEDataSet.getName() : strDataSetName, ex.getMessage()), ex);
        }
    }

    protected void onTranslateSearchContextDynaFieldsBeforeProceed(ISearchContextBase arg0, String strDataSetName, IPSDEDataSet iPSDEDataSet) throws Throwable {
        Map<String, IPSDEField> dynaPSDEFieldMap = this.getDynaPSDEFields((Object)arg0, strDataSetName, iPSDEDataSet);
        if (ObjectUtils.isEmpty(dynaPSDEFieldMap)) {
            return;
        }
        if (this.isLocalStorageMode() || this.getDataEntityRuntime().getStorageMode() != PSModelEnums.DEStorageType.SQL.value || this.getStorageDataEntityRuntime().getStorageMode() != PSModelEnums.DEStorageType.SQL.value) {
            return;
        }
        ISearchContextDTO iSearchContextDTO = (ISearchContextDTO)arg0;
        this.translateSearchContextDynaFields(iSearchContextDTO, iSearchContextDTO, dynaPSDEFieldMap);
    }

    protected void translateSearchContextDynaFields(ISearchContextDTO iSearchContextDTO, ISearchGroupCond iSearchGroupCond, Map<String, IPSDEField> dynaPSDEFieldMap) throws Throwable {
        List<ISearchCond> searchCondList = iSearchGroupCond.getSearchConds();
        if (ObjectUtils.isEmpty(searchCondList)) {
            return;
        }
        String strKeyExpCode = this.getDataEntityRuntime().getFieldQueryExp(this.getDataEntityRuntime().getKeyPSDEField());
        IPSDEField parentIdPSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
        IPSDEField parentTypePSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false);
        ArrayList<ISearchCond> newSearchCondList = new ArrayList<ISearchCond>();
        for (ISearchCond iSearchCond : searchCondList) {
            if (iSearchCond instanceof ISearchFieldCond) {
                IPSDEField dynaPSDEField;
                ISearchFieldCond iSearchFieldCond = (ISearchFieldCond)iSearchCond;
                if (StringUtils.hasLength((String)iSearchFieldCond.getFieldName()) && (dynaPSDEField = dynaPSDEFieldMap.get(iSearchFieldCond.getFieldName().toUpperCase())) != null) {
                    IPSDEField storagePSDEField = this.getStoragePSDEField(dynaPSDEField);
                    SearchCustomCond searchCustomCond = new SearchCustomCond();
                    String strSql = String.format("SELECT 1 FROM %1$s WHERE %2$s = %1$s.%3$s AND %1$s.%4$s ='%5$s' AND ", this.getStorageDataEntityRuntime().getTableName(), strKeyExpCode, this.getDBDialect().getDBObjStandardName(parentIdPSDEField.getName()), this.getDBDialect().getDBObjStandardName(parentTypePSDEField.getName()), this.getDataEntityRuntime().getName());
                    Object value = iSearchFieldCond.getValue();
                    if (iSearchFieldCond.isParamMode() && value != null) {
                        value = iSearchContextDTO.get(value.toString());
                    }
                    strSql = strSql + this.getDBDialect().getConditionSQL(String.format("%1$s.%2$s", this.getStorageDataEntityRuntime().getTableName(), this.getDBDialect().getDBObjStandardName(storagePSDEField.getName())), storagePSDEField.getStdDataType(), iSearchFieldCond.getCondOp(), value, false, null);
                    searchCustomCond.setCustomCond(String.format("EXISTS(%1$s)", strSql));
                    newSearchCondList.add(searchCustomCond);
                    continue;
                }
                newSearchCondList.add(iSearchCond);
                continue;
            }
            newSearchCondList.add(iSearchCond);
            if (!(iSearchCond instanceof ISearchGroupCond)) continue;
            this.translateSearchContextDynaFields(iSearchContextDTO, (ISearchGroupCond)iSearchCond, dynaPSDEFieldMap);
        }
        iSearchGroupCond.getSearchConds().clear();
        iSearchGroupCond.getSearchConds().addAll(newSearchCondList);
    }

    @Override
    public void translateEntityDynaFieldsAfterProceed(ISearchContextBase arg0, List<? extends IEntityBase> list, String strDataSetName, IPSDEDataSet iPSDEDataSet) throws Throwable {
        try {
            this.onTranslateEntityDynaFieldsAfterProceed(arg0, list, strDataSetName, iPSDEDataSet);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6570\u636e\u96c6[%1$s]\u5904\u7406\u540e\u8f6c\u6362\u52a8\u6001\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEDataSet != null ? iPSDEDataSet.getName() : strDataSetName, ex.getMessage()), ex);
        }
    }

    protected void onTranslateEntityDynaFieldsAfterProceed(ISearchContextBase arg0, List<? extends IEntityBase> list, String strDataSetName, IPSDEDataSet iPSDEDataSet) throws Throwable {
        Map<String, IPSDEField> dynaPSDEFieldMap = this.getDynaPSDEFields((Object)arg0, strDataSetName, iPSDEDataSet);
        if (ObjectUtils.isEmpty(dynaPSDEFieldMap)) {
            return;
        }
        this.fillEntityDTODynaFields(list, dynaPSDEFieldMap);
    }

    /*
     * WARNING - void declaration
     */
    protected void fillEntityDTODynaFields(List<? extends IEntityDTO> list, Map<String, IPSDEField> dynaPSDEFieldMap) throws Throwable {
        block11: {
            block10: {
                if (ObjectUtils.isEmpty(list)) {
                    return;
                }
                if (!this.isLocalStorageMode()) break block10;
                for (IEntityDTO iEntityDTO : list) {
                    Object dynaStorage = this.getDataEntityRuntime().getFieldValue((IEntityBase)iEntityDTO, this.getLocalStoragePSDEField(false));
                    Object var6_10 = null;
                    if (dynaStorage != null) {
                        Map map = JsonUtils.asMap(dynaStorage);
                    }
                    for (Map.Entry<String, IPSDEField> entry : dynaPSDEFieldMap.entrySet()) {
                        void var6_9;
                        Object value = var6_9 != null ? var6_9.get(entry.getKey()) : null;
                        this.getDataEntityRuntime().setFieldValue((IEntityBase)iEntityDTO, entry.getValue(), value);
                    }
                    this.getDataEntityRuntime().resetFieldValue((IEntityBase)iEntityDTO, this.getLocalStoragePSDEField(false));
                }
                break block11;
            }
            String strKeyName = this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName();
            LinkedHashMap<Object, IEntityDTO> linkedHashMap = new LinkedHashMap<Object, IEntityDTO>();
            for (IEntityDTO iEntityDTO : list) {
                Object objKeyValue = iEntityDTO.get(strKeyName);
                if (ObjectUtils.isEmpty((Object)objKeyValue)) continue;
                linkedHashMap.put(objKeyValue, iEntityDTO);
            }
            if (ObjectUtils.isEmpty(linkedHashMap)) {
                return;
            }
            IPSDEField parentIdPSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false);
            IPSDEField iPSDEField = this.getStorageDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false);
            ISearchContextDTO iSearchContextDTO = this.getStorageDataEntityRuntime().createSearchContext();
            iSearchContextDTO.all().count(false);
            if (linkedHashMap.size() == 1) {
                this.getStorageDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentIdPSDEField, "EQ", linkedHashMap.keySet().iterator().next());
            } else {
                this.getStorageDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentIdPSDEField, "IN", linkedHashMap.keySet());
            }
            if (iPSDEField != null) {
                this.getStorageDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, iPSDEField, "EQ", (Object)this.getDataEntityRuntime().getName());
            }
            String strFieldName = this.getStorageEntityFieldName("NAME");
            List<IEntityDTO> allList = this.getStorageDataEntityRuntime().rawSelect(iSearchContextDTO);
            if (ObjectUtils.isEmpty(allList)) break block11;
            for (IEntityDTO iEntityDTO : allList) {
                IEntityBase iEntityBase;
                IPSDEField iPSDEField2;
                String strName = iEntityDTO.getString(strFieldName, null);
                if (ObjectUtils.isEmpty((Object)strName) || (iPSDEField2 = dynaPSDEFieldMap.get(strName)) == null || (iEntityBase = (IEntityBase)linkedHashMap.get(iEntityDTO.get(parentIdPSDEField.getLowerCaseName()))) == null) continue;
                this.getDataEntityRuntime().setFieldValue(iEntityBase, iPSDEField2, this.getStorageEntityFieldValue(iEntityDTO, iPSDEField2));
            }
        }
    }
}

