/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.database.mysql;

import net.ibizsys.central.database.DBDialectBase;
import net.ibizsys.central.database.DBFunction;
import net.ibizsys.central.util.ISearchContext;
import org.springframework.util.StringUtils;

public class MySQL5Dialect
extends DBDialectBase {
    public MySQL5Dialect() {
        this.registerDBFunction(new DBFunction("YEAR", 9, "EXTRACT(YEAR FROM %1$s)", 1));
        this.registerDBFunction(new DBFunction("QUARTER", 9, "EXTRACT(QUARTER FROM %1$s)", 1));
        this.registerDBFunction(new DBFunction("MONTH", 9, "EXTRACT(MONTH FROM %1$s)", 1));
        this.registerDBFunction(new DBFunction("DAYOFMONTH", 9, "EXTRACT(DAY FROM %1$s)", 1));
    }

    @Override
    public String getDBType() {
        return "MYSQL5";
    }

    @Override
    public String getDBObjStandardName(String strOriginName) throws Throwable {
        String[] items = strOriginName.split("[.]");
        if (items.length == 1) {
            return String.format("`%1$s`", strOriginName);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(String.format("`%1$s`", items[i]));
        }
        return sb.toString();
    }

    @Override
    protected String getStringConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext) throws Throwable {
        if (bParam) {
            if ("LIKE".equals(strCondOp)) {
                return String.format("UPPER(%1$s) LIKE CONCAT('%%',UPPER(%2$s),'%%')", strFieldName, objValueOrParam);
            }
            if ("LEFTLIKE".equals(strCondOp)) {
                return String.format("UPPER(%1$s) LIKE CONCAT(UPPER(%2$s),'%%')", strFieldName, objValueOrParam);
            }
            if ("RIGHTLIKE".equals(strCondOp)) {
                return String.format("UPPER(%1$s) LIKE CONCAT('%%',UPPER(%2$s))", strFieldName, objValueOrParam);
            }
        }
        return super.getStringConditionSQL(strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam, iSearchContext);
    }

    @Override
    public String getLastInsertIdSQL(String strAlias) throws Throwable {
        if (StringUtils.hasLength((String)strAlias)) {
            return String.format("SELECT LAST_INSERT_ID() AS %1$s", this.getDBObjStandardName(strAlias));
        }
        return "SELECT LAST_INSERT_ID()";
    }
}

