/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.codelist;

import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.codelist.DynamicCodeListRuntimeInstance;
import net.ibizsys.central.codelist.IDynamicCodeListRuntime;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.DynamicCodeListRuntime;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DynamicCodeListRuntimeBase
extends DynamicCodeListRuntime
implements IDynamicCodeListRuntime {
    private static final Log log = LogFactory.getLog(DynamicCodeListRuntimeBase.class);

    @Override
    public ISystemRuntime getSystemRuntime() {
        return (ISystemRuntime)super.getSystemRuntime();
    }

    @Override
    public ICodeListRuntime getInstance(Object dataOrKey) {
        try {
            return this.onGetInstance(dataOrKey);
        }
        catch (Throwable ex) {
            SystemRuntimeException.rethrow(this, ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u4e0a\u4e0b\u6587\u5b9e\u4f8b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected ICodeListRuntime onGetInstance(Object dataOrKey) throws Throwable {
        if (ObjectUtils.isEmpty((Object)dataOrKey)) {
            return this;
        }
        Map params = this.getMap(dataOrKey);
        if (params == null) {
            return this;
        }
        DynamicCodeListRuntimeInstance dynamicCodeListRuntimeInstance = new DynamicCodeListRuntimeInstance();
        dynamicCodeListRuntimeInstance.init(this.getSystemRuntimeBaseContext(), this.getPSCodeList(), params);
        return dynamicCodeListRuntimeInstance;
    }

    protected Map getMap(Object keyOrData) throws Throwable {
        if (keyOrData instanceof Map) {
            return (Map)keyOrData;
        }
        if (keyOrData instanceof IEntity) {
            return ((IEntity)keyOrData).any();
        }
        return null;
    }

    @Override
    public List<IPSCodeItem> getPSCodeItems() {
        return this.getPSCodeItems(null);
    }

    @Override
    public List<IPSCodeItem> getPSCodeItems(Object dataOrKey) {
        return super.getPSCodeItems();
    }

    @Override
    public String getText(Object dataOrKey, Object objValue, IUserContext iUserContext) {
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return this.getPSCodeList().getEmptyText();
        }
        String strValue = null;
        strValue = objValue instanceof String ? (String)objValue : objValue.toString();
        String strOrMode = this.getPSCodeList().getOrMode();
        if (StringUtils.hasLength((String)strOrMode)) {
            if ("STR".equals(strOrMode)) {
                String[] values;
                String strTextSeparator;
                String strValueSeparator = this.getPSCodeList().getValueSeparator();
                if (!StringUtils.hasLength((String)strValueSeparator)) {
                    strValueSeparator = ";";
                }
                if (!StringUtils.hasLength((String)(strTextSeparator = this.getPSCodeList().getTextSeparator()))) {
                    strTextSeparator = "\u3001";
                }
                String strTotalText = "";
                for (String strItem : values = StringUtils.tokenizeToStringArray((String)strValue, (String)strValueSeparator)) {
                    IPSCodeItem iPSCodeItem = this.getPSCodeItem(dataOrKey, strItem, false);
                    if (iPSCodeItem == null) {
                        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u503c[%1$s]\u5bf9\u5e94\u7684\u6587\u672c\u4fe1\u606f", strItem));
                    }
                    if (!ObjectUtils.isEmpty((Object)strTotalText)) {
                        strTotalText = strTotalText + strTextSeparator;
                    }
                    strTotalText = strTotalText + iPSCodeItem.getText();
                }
                return strTotalText;
            }
            if ("NUM".equals(strOrMode)) {
                int nValue;
                String strTextSeparator = this.getPSCodeList().getTextSeparator();
                if (!StringUtils.hasLength((String)strTextSeparator)) {
                    strTextSeparator = "\u3001";
                }
                if ((nValue = Integer.parseInt(strValue)) == 0) {
                    return this.getPSCodeList().getEmptyText();
                }
                String strTotalText = "";
                List<IPSCodeItem> psCodeItems = this.getPSCodeItems(dataOrKey);
                if (psCodeItems != null) {
                    for (IPSCodeItem iPSCodeItem : psCodeItems) {
                        int nValueItem = Integer.parseInt(iPSCodeItem.getValue());
                        if ((nValue & nValueItem) != nValueItem) continue;
                        if (!ObjectUtils.isEmpty((Object)strTotalText)) {
                            strTotalText = strTotalText + strTextSeparator;
                        }
                        strTotalText = strTotalText + iPSCodeItem.getText();
                    }
                }
                return strTotalText;
            }
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6216\u6a21\u5f0f[%1$s]", strOrMode));
        }
        IPSCodeItem iPSCodeItem = this.getPSCodeItem(dataOrKey, strValue, false);
        if (iPSCodeItem != null) {
            return iPSCodeItem.getText();
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u503c[%1$s]\u5bf9\u5e94\u7684\u6587\u672c\u4fe1\u606f", objValue));
    }

    @Override
    public IPSCodeItem getPSCodeItem(Object dataOrKey, String strItemValue, boolean bTryMode) {
        List<IPSCodeItem> psCodeItemList = this.getPSCodeItems(dataOrKey);
        if (psCodeItemList != null) {
            for (IPSCodeItem iPSCodeItem : psCodeItemList) {
                if (DataTypeUtils.compare(strItemValue, iPSCodeItem.getValue()) != 0L) continue;
                return iPSCodeItem;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u503c[%1$s]\u5bf9\u5e94\u7684\u4ee3\u7801\u9879", strItemValue));
    }

    @Override
    public IPSCodeItem getPSCodeItemByText(Object dataOrKey, String strText, IUserContext iUserContext, boolean bTryMode) {
        Assert.hasLength((String)strText, (String)String.format("\u4f20\u5165\u6587\u672c\u65e0\u6548", new Object[0]));
        List<IPSCodeItem> psCodeItemList = this.getPSCodeItems(dataOrKey);
        if (psCodeItemList != null) {
            for (IPSCodeItem item : psCodeItemList) {
                String strItemText = item.getText();
                if (iUserContext != null && item.getTextPSLanguageRes() != null) {
                    strItemText = iUserContext.getLocalization(item.getTextPSLanguageRes().getLanResTag(), strItemText);
                }
                if (!strText.equals(strItemText)) continue;
                return item;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6587\u672c[%1$s]\u5bf9\u5e94\u7684\u4ee3\u7801\u9879", strText));
    }
}

