package net.ibizsys.central.dataentity.util;

import java.util.List;

import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;

public interface IDEDynaStorageUtilRuntime extends net.ibizsys.runtime.dataentity.util.IDEDynaStorageUtilRuntime {

	
	public final static String ACTIONSESSION_DYNAFIELDS_PREFIX = "__DYNAFIELDS_";
	
	/**
	 * 预定义属性：属性名称
	 */
	public final static String PREDEFINEDFIELD_NAME = "NAME";
	
	
	/**
	 * 预定义属性：字符串
	 */
	public final static String PREDEFINEDFIELD_STRING_VALUE = "STRING_VALUE";
	
	
	/**
	 * 预定义属性：长字符串
	 */
	public final static String PREDEFINEDFIELD_LONGSTRING_VALUE = "LONGSTRING_VALUE";
	
	
	
	/**
	 * 预定义属性：双精
	 */
	public final static String PREDEFINEDFIELD_DOUBLE_VALUE = "DOUBLE_VALUE";
	
	
	/**
	 * 预定义属性：时间
	 */
	public final static String PREDEFINEDFIELD_DATETIME_VALUE = "DATETIME_VALUE";
	
	
	/**
	 * 预定义属性：数值
	 */
	public final static String PREDEFINEDFIELD_DECIMAL_VALUE = "DECIMAL_VALUE";
	
	
	/**
	 * 预定义属性：整形
	 */
	public final static String PREDEFINEDFIELD_INT_VALUE = "INT_VALUE";
	
	
	/**
	 * 预定义属性：大整形
	 */
	public final static String PREDEFINEDFIELD_BIGINT_VALUE = "BIGINT_VALUE";
	
	
	/**
	 * 处理之前检查数据对象动态属性
	 * @param arg0
	 * @param strActionName
	 * @param iPSDEAction
	 * @throws Throwable
	 */
	void checkEntityDynaFieldsBeforeProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable;
	
	
	/**
	 * 处理之前转换数据对象动态属性
	 * @param arg0
	 * @param strActionName
	 * @param iPSDEAction
	 * @throws Throwable
	 */
	void translateEntityDynaFieldsBeforeProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable;
	
	
	/**
	 * 处理之后转换数据对象动态属性
	 * @param arg0
	 * @param objRet
	 * @param strActionName
	 * @param iPSDEAction
	 * @throws Throwable
	 */
	void translateEntityDynaFieldsAfterProceed(Object arg0, Object objRet, String strActionName, IPSDEAction iPSDEAction)throws Throwable;
	
	
	/**
	 * 删除之前移除数据对象动态属性
	 * @param arg0
	 * @param strActionName
	 * @param iPSDEAction
	 * @throws Throwable
	 */
	void removeEntityDynaFieldsBeforeRemove(Object arg0, String strActionName, IPSDEAction iPSDEAction) throws Throwable;
	
	
	
	/**
	 * 处理之前转换搜索上下文动态属性
	 * @param arg0
	 * @param strDataSetName
	 * @param iPSDEDataSet
	 * @throws Throwable
	 */
	void translateSearchContextDynaFieldsBeforeProceed(ISearchContextBase arg0, String strDataSetName, IPSDEDataSet iPSDEDataSet) throws Throwable;
	
	

	/**
	 * 处理之后转换数据对象动态属性
	 * @param arg0
	 * @param list
	 * @param strDataSetName
	 * @param iPSDEDataSet
	 * @throws Throwable
	 */
	void translateEntityDynaFieldsAfterProceed(ISearchContextBase arg0, List<? extends IEntityBase> list, String strDataSetName, IPSDEDataSet iPSDEDataSet) throws Throwable;
	
	
//	/**
//	 * 处理之后转换数据对象动态属性
//	 * @param arg0
//	 * @param list
//	 * @param strDataQueryName
//	 * @param iPSDEDataQuery
//	 * @throws Throwable
//	 */
//	void translateEntityDynaFieldsAfterProceed(ISearchContextBase arg0, List<? extends IEntityBase> list, String strDataQueryName, IPSDEDataQuery iPSDEDataQuery) throws Throwable;
}
