package net.ibizsys.central.dataentity.ac;

import org.springframework.data.domain.Page;

import net.ibizsys.central.dataentity.IDataEntityModelRuntime;
import net.ibizsys.central.util.domain.ACDataItem;
import net.ibizsys.model.dataentity.ac.IPSDEACMode;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeContext;

/**
 * 获取实体自填模型运行时对象接口
 * @author lionlau
 *
 */
public interface IDEAutoCompleteRuntime extends IDataEntityModelRuntime{

	/**
	 * 方法：获取自填项分页集合
	 */
	final static String METHOD_FETCH = "FETCH";
	
	/**
	 * 初始化
	 * @param iDataEntityRuntimeContext
	 * @param iPSDEACMode
	 * @throws Exception
	 */
	void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDEACMode iPSDEACMode) throws Exception;
	
	
	/**
	 * 获取相关的实体自填模型对象
	 * @return
	 */
	IPSDEACMode getPSDEACMode();

	
	
	/**
	 * 获取数据项分页结构
	 * @param objData 数据集合
	 * @param objTag
	 * @return
	 */
	Page<ACDataItem> fetch(Object objData, Object objTag) throws Throwable;
	
	
}
