/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util.script;

import java.util.List;
import java.util.Map;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.notify.IPSDENotify;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.runtime.dataentity.notify.IDENotifyRuntime;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.script.IScriptCodeItem;
import net.ibizsys.runtime.util.script.IScriptCodeList;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.ScriptUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ScriptEntity
implements IScriptEntity {
    private static final Log log = LogFactory.getLog(ScriptEntity.class);
    private IDataEntityRuntime iDataEntityRuntime = null;
    private ISystemRuntime iSystemRuntime = null;
    private IEntityBase iEntityBase = null;
    private IEntity iEntity = null;
    private IScriptEntity lastScriptEntity = null;

    public ScriptEntity(IDataEntityRuntime iDataEntityRuntime, IEntityBase iEntityBase) {
        Assert.notNull((Object)iDataEntityRuntime, (String)"\u4f20\u5165\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        this.iDataEntityRuntime = iDataEntityRuntime;
        this.iEntityBase = iEntityBase;
        if (this.iEntityBase == null) {
            this.iEntityBase = this.getDataEntityRuntime().createEntity();
        }
        if (this.iEntityBase instanceof IEntity) {
            this.iEntity = (IEntity)this.iEntityBase;
        }
    }

    public ScriptEntity(ISystemRuntime iSystemRuntime, IEntity iEntity) {
        Assert.notNull((Object)iSystemRuntime, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        this.iSystemRuntime = iSystemRuntime;
        this.iEntity = iEntity;
        if (this.iEntity == null) {
            this.iEntity = this.getSystemRuntime().createEntity();
        }
        this.iEntityBase = this.iEntity;
    }

    protected IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }

    protected ISystemRuntime getSystemRuntime() {
        if (this.iSystemRuntime == null) {
            return this.getDataEntityRuntime().getSystemRuntime();
        }
        return this.iSystemRuntime;
    }

    protected IEntityBase getEntityBase() {
        return this.iEntityBase;
    }

    protected IEntity getEntity() {
        return this.iEntity;
    }

    @Override
    public Object getReal() {
        return this.getEntityBase();
    }

    @Override
    public IScriptEntity set(String strName, Object objValue) {
        objValue = ScriptUtils.getReal(objValue);
        if (this.getDataEntityRuntime() != null) {
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
            if (iPSDEField != null) {
                this.getDataEntityRuntime().setFieldValue(this.getEntityBase(), iPSDEField, objValue);
            } else {
                log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", this.getDataEntityRuntime().getName(), strName));
                if (this.getEntity() != null) {
                    this.getEntity().set(strName, objValue);
                }
            }
        } else {
            this.getEntity().set(strName, objValue);
        }
        return this;
    }

    @Override
    public IScriptEntity set(Object[] args) {
        if (args != null && args.length > 0) {
            int nSize = args.length / 2;
            for (int i = 0; i < nSize; ++i) {
                Object objKey = args[i * 2];
                Object objValue = args[i * 2 + 1];
                if (ObjectUtils.isEmpty((Object)objKey)) continue;
                if (objKey instanceof String) {
                    this.set((String)objKey, objValue);
                    continue;
                }
                this.set(objKey.toString(), objValue);
            }
        }
        return this;
    }

    @Override
    public IScriptEntity set(Object params) {
        if ((params = ScriptUtils.getReal(params)) instanceof Map) {
            Map map = (Map)params;
            for (Map.Entry entry : map.entrySet()) {
                this.set((String)entry.getKey(), entry.getValue());
            }
            return this;
        }
        this.exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u53c2\u6570\u5bf9\u8c61[%1$s]", params));
        return null;
    }

    @Override
    public IScriptEntity field(String strName, Object objValue) {
        objValue = ScriptUtils.getReal(objValue);
        if (this.getDataEntityRuntime() != null) {
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
            if (iPSDEField != null) {
                this.getDataEntityRuntime().setFieldValue(this.getEntityBase(), iPSDEField, objValue);
            } else {
                this.exception(String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", this.getDataEntityRuntime().getName(), strName));
            }
        } else {
            this.getEntity().set(strName, objValue);
        }
        return this;
    }

    @Override
    public IScriptEntity field(Object[] args) {
        if (args != null && args.length > 0) {
            int nSize = args.length / 2;
            for (int i = 0; i < nSize; ++i) {
                Object objKey = args[i * 2];
                Object objValue = args[i * 2 + 1];
                if (ObjectUtils.isEmpty((Object)objKey)) continue;
                if (objKey instanceof String) {
                    this.field((String)objKey, objValue);
                    continue;
                }
                this.field(objKey.toString(), objValue);
            }
        }
        return this;
    }

    @Override
    public IScriptEntity field(Object params) {
        if ((params = ScriptUtils.getReal(params)) instanceof Map) {
            Map map = (Map)params;
            for (Map.Entry entry : map.entrySet()) {
                this.field((String)entry.getKey(), entry.getValue());
            }
            return this;
        }
        this.exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u53c2\u6570\u5bf9\u8c61[%1$s]", params));
        return null;
    }

    @Override
    public Object get(String strName) {
        if (this.getDataEntityRuntime() != null) {
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
            if (iPSDEField != null) {
                return this.getDataEntityRuntime().getFieldValue(this.getEntityBase(), iPSDEField);
            }
            log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", this.getDataEntityRuntime().getName(), strName));
            if (this.getEntity() != null) {
                return this.getEntity().get(strName);
            }
            return null;
        }
        return this.getEntity().get(strName);
    }

    @Override
    public Object get(String strName, Object objDefault) {
        Object value = this.get(strName);
        if (value == null) {
            return objDefault;
        }
        return value;
    }

    @Override
    public Object getId() {
        if (this.getDataEntityRuntime() != null) {
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField("ID");
            if (iPSDEField == null) {
                iPSDEField = this.getDataEntityRuntime().getKeyPSDEField();
            }
            if (iPSDEField == null) {
                return null;
            }
            return this.getDataEntityRuntime().getFieldValue(this.getEntityBase(), iPSDEField);
        }
        if (this.getEntity().contains("srfkey")) {
            return this.getEntity().get("srfkey");
        }
        return this.getEntity().get("id");
    }

    @Override
    public Object getName() {
        if (this.getDataEntityRuntime() != null) {
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField("NAME");
            if (iPSDEField == null) {
                iPSDEField = this.getDataEntityRuntime().getMajorPSDEField();
            }
            if (iPSDEField == null) {
                return null;
            }
            return this.getDataEntityRuntime().getFieldValue(this.getEntityBase(), iPSDEField);
        }
        return this.getEntity().get("name");
    }

    @Override
    public boolean contains(String strName) {
        if (this.getDataEntityRuntime() != null) {
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
            if (iPSDEField != null) {
                return this.getDataEntityRuntime().containsFieldValue(this.getEntityBase(), iPSDEField);
            }
            log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", this.getDataEntityRuntime().getName(), strName));
            if (this.getEntity() != null) {
                return this.getEntity().contains(strName);
            }
            return false;
        }
        return this.getEntity().contains(strName);
    }

    @Override
    public IScriptEntity reset(String strName) {
        if (this.getDataEntityRuntime() != null) {
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
            if (iPSDEField != null) {
                this.getDataEntityRuntime().resetFieldValue(this.getEntityBase(), iPSDEField);
            } else {
                log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%2$s]", this.getDataEntityRuntime().getName(), strName));
                if (this.getEntity() != null) {
                    this.getEntity().reset(strName);
                }
            }
        } else {
            this.getEntity().reset(strName);
        }
        return this;
    }

    @Override
    public IScriptEntity reset(String[] args) {
        if (args != null && args.length > 0) {
            for (String objKey : args) {
                if (ObjectUtils.isEmpty((Object)objKey)) continue;
                if (objKey instanceof String) {
                    this.reset(objKey);
                    continue;
                }
                this.reset(objKey.toString());
            }
        }
        return this;
    }

    @Override
    public IScriptEntity parent(String strName) {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            IPSDER1N iPSDER1N;
            List psDERBases;
            if (!StringUtils.hasLength((String)strName)) {
                List psDERBases2 = this.getDataEntityRuntime().getPSDataEntity().getMinorPSDERs();
                if (psDERBases2 == null) {
                    return null;
                }
                for (IPSDERBase psDERBase : psDERBases2) {
                    IPSDER1N iPSDER1N2;
                    if (!"DER1N".equals(psDERBase.getDERType()) || ((iPSDER1N2 = (IPSDER1N)psDERBase).getMasterRS() & 1) != 1) continue;
                    return this.parent(psDERBase.getMajorPSDataEntity(), (IPSDEField)iPSDER1N2.getPSPickupDEField());
                }
                for (IPSDERBase psDERBase : psDERBases2) {
                    if (!"DER11".equals(psDERBase.getDERType())) continue;
                    return this.parent(psDERBase.getMajorPSDataEntity(), this.getDataEntityRuntime().getKeyPSDEField());
                }
                return null;
            }
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
            if (iPSDEField != null) {
                if (iPSDEField instanceof IPSLinkDEField) {
                    return this.parent(((IPSLinkDEField)iPSDEField).getPSDER().getMajorPSDataEntity(), iPSDEField);
                }
                if (StringUtils.hasLength((String)iPSDEField.getPredefinedType()) && PSModelEnums.PredefinedFieldType.PARENTID.value.equals(iPSDEField.getPredefinedType())) {
                    Object parentId = this.getDataEntityRuntime().getFieldValue(this.getEntityBase(), iPSDEField);
                    if (ObjectUtils.isEmpty((Object)parentId)) {
                        return null;
                    }
                    List psDERBases3 = this.getDataEntityRuntime().getPSDataEntity().getMinorPSDERs();
                    if (psDERBases3 == null) {
                        return null;
                    }
                    IPSDEField parentTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, false);
                    Object parentType = this.getDataEntityRuntime().getFieldValue(this.getEntityBase(), parentTypePSDEField);
                    if (ObjectUtils.isEmpty((Object)parentType)) {
                        return null;
                    }
                    for (IPSDERBase psDERBase : psDERBases3) {
                        if (!(psDERBase instanceof IPSDERCustom) || DataTypeUtils.compare(psDERBase.getMajorPSDataEntityMust().getName(), String.valueOf(parentType)) != 0L) continue;
                        return this.parent(psDERBase.getMajorPSDataEntity(), iPSDEField);
                    }
                    return null;
                }
            }
            if ((psDERBases = this.getDataEntityRuntime().getPSDataEntity().getMinorPSDERs()) == null) {
                return null;
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER1N".equals(psDERBase.getDERType()) || ((iPSDER1N = (IPSDER1N)psDERBase).getMasterRS() & 1) != 1 || !strName.equalsIgnoreCase(psDERBase.getMajorPSDataEntity().getName())) continue;
                return this.parent(psDERBase.getMajorPSDataEntity(), (IPSDEField)iPSDER1N.getPSPickupDEField());
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER11".equals(psDERBase.getDERType()) || !strName.equalsIgnoreCase(psDERBase.getMajorPSDataEntity().getName())) continue;
                return this.parent(psDERBase.getMajorPSDataEntity(), this.getDataEntityRuntime().getKeyPSDEField());
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER1N".equals(psDERBase.getDERType())) continue;
                iPSDER1N = (IPSDER1N)psDERBase;
                if (!strName.equalsIgnoreCase(psDERBase.getMajorPSDataEntity().getName())) continue;
                return this.parent(psDERBase.getMajorPSDataEntity(), (IPSDEField)iPSDER1N.getPSPickupDEField());
            }
            return null;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53\u83b7\u53d6\u5f15\u7528\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strName, ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u83b7\u53d6\u5f15\u7528\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IScriptEntity parent(IPSDataEntity parentPSDataEntity, IPSDEField iPSDEField) throws Throwable {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        Object objValue = this.getDataEntityRuntime().getFieldValue(this.getEntityBase(), iPSDEField);
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        IDataEntityRuntime parentDataEntityRuntime = this.iDataEntityRuntime.getSystemRuntime().getDataEntityRuntime(parentPSDataEntity.getDynaModelFilePath());
        Object objRet = parentDataEntityRuntime.executeAction("get", null, new Object[]{objValue});
        if (objRet != null && objRet instanceof IEntityBase) {
            return parentDataEntityRuntime.createScriptEntity((IEntityBase)objRet);
        }
        return null;
    }

    @Override
    public IScriptEntity create() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            this.getDataEntityRuntime().executeAction("create", null, new Object[]{this.getEntityBase()});
            return this;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u5efa\u7acb\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5efa\u7acb\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public IScriptEntity update() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            this.getDataEntityRuntime().executeAction("update", null, new Object[]{this.getEntityBase()});
            return this;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public void remove() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            this.getDataEntityRuntime().executeAction("remove", null, new Object[]{this.getId()});
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public IScriptEntity wfstart() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            this.getDataEntityRuntime().executeAction("wfStart", null, new Object[]{this.getEntityBase()});
            return this;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u542f\u52a8\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u542f\u52a8\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public IScriptEntity call(String strName) {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            this.getDataEntityRuntime().executeAction(strName, null, new Object[]{this.getEntityBase()});
            return this;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u81ea\u5b9a\u4e49\u8c03\u7528[%3$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getName(), ex.getMessage(), strName), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u81ea\u5b9a\u4e49\u8c03\u7528[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage(), strName), ex);
        }
    }

    @Override
    public void exception(String strErrorInfo) {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), strErrorInfo);
        }
        throw new DataEntityRuntimeException(this.getDataEntityRuntime(), strErrorInfo);
    }

    @Override
    public void exception(String strErrorInfo, int nErrorCode) {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), strErrorInfo, nErrorCode);
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), strErrorInfo, nErrorCode);
    }

    @Override
    public IScriptEntity[] children(String strName) {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            IPSDER1N iPSDER1N;
            IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
            if (iPSDEField != null && "ONE2MANYDATA".equals(iPSDEField.getDataType())) {
                return null;
            }
            List psDERBases = this.getDataEntityRuntime().getPSDataEntity().getMajorPSDERs();
            if (psDERBases == null) {
                return null;
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER1N".equals(psDERBase.getDERType()) || !StringUtils.hasLength((String)(iPSDER1N = (IPSDER1N)psDERBase).getMinorCodeName()) || !iPSDER1N.getMinorCodeName().equalsIgnoreCase(strName)) continue;
                return this.children(psDERBase.getMinorPSDataEntity(), (IPSDEField)iPSDER1N.getPSPickupDEField());
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER1N".equals(psDERBase.getDERType()) || ((iPSDER1N = (IPSDER1N)psDERBase).getMasterRS() & 1) != 1 || !strName.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getName())) continue;
                return this.children(psDERBase.getMinorPSDataEntity(), (IPSDEField)iPSDER1N.getPSPickupDEField());
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER11".equals(psDERBase.getDERType()) || !strName.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getName())) continue;
                return this.children(psDERBase.getMinorPSDataEntity(), null);
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER1N".equals(psDERBase.getDERType())) continue;
                iPSDER1N = (IPSDER1N)psDERBase;
                if (!strName.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getName())) continue;
                return this.children(psDERBase.getMinorPSDataEntity(), (IPSDEField)iPSDER1N.getPSPickupDEField());
            }
            return null;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53\u67e5\u8be2\u5b50\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strName, ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u67e5\u8be2\u5b50\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IScriptEntity[] children(IPSDataEntity childPSDataEntity, IPSDEField iPSDEField) throws Throwable {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        Object objValue = this.getId();
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        IDataEntityRuntime childDataEntityRuntime = this.iDataEntityRuntime.getSystemRuntime().getDataEntityRuntime(childPSDataEntity.getDynaModelFilePath());
        ISearchContextBase iSearchContextBase = childDataEntityRuntime.createSearchContext();
        if (iPSDEField != null) {
            childDataEntityRuntime.setSearchCondition(iSearchContextBase, iPSDEField, "EQ", objValue);
        } else {
            childDataEntityRuntime.setSearchCondition(iSearchContextBase, childDataEntityRuntime.getKeyPSDEField(), "EQ", objValue);
        }
        List<? extends IEntityBase> list = childDataEntityRuntime.select(iSearchContextBase);
        if (list == null) {
            return null;
        }
        IScriptEntity[] arr = new IScriptEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = childDataEntityRuntime.createScriptEntity(list.get(i));
        }
        return arr;
    }

    @Override
    public IScriptEntity child(String strName) {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        try {
            IPSDER1N iPSDER1N;
            List psDERBases = this.getDataEntityRuntime().getPSDataEntity().getMajorPSDERs();
            if (psDERBases == null) {
                return null;
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER1N".equals(psDERBase.getDERType()) || ((iPSDER1N = (IPSDER1N)psDERBase).getMasterRS() & 1) != 1 || !strName.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getName())) continue;
                return this.child(psDERBase.getMinorPSDataEntity(), (IPSDEField)iPSDER1N.getPSPickupDEField());
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER11".equals(psDERBase.getDERType()) || !strName.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getName())) continue;
                return this.child(psDERBase.getMinorPSDataEntity(), null);
            }
            for (IPSDERBase psDERBase : psDERBases) {
                if (!"DER1N".equals(psDERBase.getDERType())) continue;
                iPSDER1N = (IPSDER1N)psDERBase;
                if (!strName.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getName())) continue;
                return this.child(psDERBase.getMinorPSDataEntity(), (IPSDEField)iPSDER1N.getPSPickupDEField());
            }
            return null;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53\u51c6\u5907\u5b50\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strName, ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u51c6\u5907\u5b50\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IScriptEntity child(IPSDataEntity childPSDataEntity, IPSDEField iPSDEField) throws Throwable {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        Object objValue = this.getId();
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        IDataEntityRuntime childDataEntityRuntime = this.iDataEntityRuntime.getSystemRuntime().getDataEntityRuntime(childPSDataEntity.getDynaModelFilePath());
        IEntityBase iEntityBase = childDataEntityRuntime.createEntity();
        if (iPSDEField != null) {
            childDataEntityRuntime.setFieldValue(iEntityBase, iPSDEField, objValue);
        } else {
            childDataEntityRuntime.setFieldValue(iEntityBase, childDataEntityRuntime.getKeyPSDEField(), objValue);
        }
        childDataEntityRuntime.executeAction("getdraft", null, new Object[]{iEntityBase});
        return childDataEntityRuntime.createScriptEntity(iEntityBase);
    }

    @Override
    public boolean exists() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (ObjectUtils.isEmpty((Object)this.getId())) {
            return false;
        }
        return this.getDataEntityRuntime().checkKeyState(this.getId()) == 1;
    }

    @Override
    public IScriptEntity save() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.exists()) {
            return this.update();
        }
        return this.create();
    }

    @Override
    public IScriptEntity clone(boolean bResetUncopyValues) {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        IEntityBase newEntity = null;
        try {
            newEntity = this.getDataEntityRuntime().clone(this.getEntityBase(), bResetUncopyValues);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u514b\u9686\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5efa\u7acb\u514b\u9686\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        return this.getDataEntityRuntime().createScriptEntity(newEntity);
    }

    @Override
    public IScriptEntity callEntity() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        IEntityBase newEntity = this.getDataEntityRuntime().createEntity();
        this.getDataEntityRuntime().setFieldValue(newEntity, this.getDataEntityRuntime().getKeyPSDEField(), this.getId());
        return this.getDataEntityRuntime().createScriptEntity(newEntity);
    }

    @Override
    public IScriptEntity last() {
        if (this.getDataEntityRuntime() == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.lastScriptEntity == null) {
            IEntityBase lastEntityBase = this.getDataEntityRuntime().getLastEntity();
            if (lastEntityBase == null) {
                try {
                    lastEntityBase = this.getDataEntityRuntime().get(this.getId());
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u83b7\u53d6\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getDataEntityRuntime().getName(), ex.getMessage()), ex);
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u83b7\u53d6\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                }
            }
            if (lastEntityBase != null) {
                this.lastScriptEntity = this.getDataEntityRuntime().createScriptEntity(lastEntityBase);
            }
        }
        return this.lastScriptEntity;
    }

    @Override
    public IScriptEntity copy(IScriptEntity srcScriptEntity, String[] fields) {
        if (srcScriptEntity != null && fields != null) {
            for (String strField : fields) {
                String[] items = strField.trim().split("[|]");
                if (items.length == 1) {
                    this.set(items[0], srcScriptEntity.get(items[0]));
                    continue;
                }
                if (items.length < 2) continue;
                this.set(items[1], srcScriptEntity.get(items[0]));
            }
        }
        return this;
    }

    @Override
    public IScriptEntity copy(Object objData, String[] fields) {
        if (objData instanceof IScriptEntity) {
            return this.copy((IScriptEntity)objData, fields);
        }
        if (fields != null) {
            if (this.getEntity() == null) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getDataEntityRuntime(), String.format("\u5f53\u524d\u6570\u636e\u5bf9\u8c61\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c", new Object[0]));
            }
            if ((objData = ScriptUtils.getReal(objData)) instanceof Map) {
                Map srcEntity = (Map)objData;
                if (fields != null) {
                    for (String strField : fields) {
                        String[] items = strField.trim().split("[|]");
                        if (items.length == 1) {
                            this.set(items[0], srcEntity.get(items[0]));
                            continue;
                        }
                        if (items.length < 2) continue;
                        this.set(items[1], srcEntity.get(items[0]));
                    }
                } else {
                    for (Object objKey : srcEntity.keySet()) {
                        Object objValue = srcEntity.get(objKey);
                        this.set((String)objKey, objValue);
                    }
                }
            } else {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6e90\u6570\u636e", new Object[0]));
            }
        }
        return this;
    }

    @Override
    public IScriptEntity notify(String strName) {
        IPSDENotify iPSDENotify;
        IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime;
        block9: {
            if (this.getDataEntityRuntime() == null) {
                throw new SystemRuntimeException(this.getSystemRuntime(), "\u672a\u6307\u5b9a\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u65e0\u6cd5\u652f\u6301\u6b64\u64cd\u4f5c");
            }
            if (!StringUtils.hasLength((String)strName)) {
                throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u6ca1\u6709\u6307\u5b9a\u53d1\u9001\u901a\u77e5\u540d\u79f0", new Object[0]));
            }
            ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
            IDynaInstRuntime lastDynaInstRuntime = actionSession.getDynaInstRuntime();
            IDynaInstRuntime lastChildDynaInstRuntime = actionSession.getChildDynaInstRuntime();
            iDynaInstDataEntityRuntime = null;
            IPSDataEntity iPSDataEntity = null;
            iPSDENotify = null;
            try {
                List psDENotifyList;
                if (lastChildDynaInstRuntime != null) {
                    iDynaInstDataEntityRuntime = lastChildDynaInstRuntime.getDynaInstDataEntityRuntime(this.getDataEntityRuntime().getId());
                }
                if (iDynaInstDataEntityRuntime == null && lastDynaInstRuntime != null) {
                    iDynaInstDataEntityRuntime = lastDynaInstRuntime.getDynaInstDataEntityRuntime(this.getDataEntityRuntime().getId());
                }
                if ((psDENotifyList = (iPSDataEntity = iDynaInstDataEntityRuntime != null ? iDynaInstDataEntityRuntime.getPSDataEntity() : this.getDataEntityRuntime().getPSDataEntity()).getAllPSDENotifies()) == null) break block9;
                for (IPSDENotify item : psDENotifyList) {
                    if (!strName.equalsIgnoreCase(item.getCodeName())) continue;
                    iPSDENotify = item;
                    break;
                }
                if (iPSDENotify != null) break block9;
                for (IPSDENotify item : psDENotifyList) {
                    if (!strName.equalsIgnoreCase(item.getName())) continue;
                    iPSDENotify = item;
                    break;
                }
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5b9e\u4f53[%1$s]\u83b7\u53d6\u5b9e\u4f53\u901a\u77e5[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getDataEntityRuntime().getName(), strName, ex.getMessage()), ex);
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u83b7\u53d6\u5b9e\u4f53\u901a\u77e5[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strName, ex.getMessage()), ex);
            }
        }
        if (iPSDENotify == null) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u901a\u77e5[%1$s]\u6a21\u578b\u5bf9\u8c61", strName), 21);
        }
        IDENotifyRuntime iDENotifyRuntime = iDynaInstDataEntityRuntime != null ? iDynaInstDataEntityRuntime.getDENotifyRuntime(iPSDENotify) : this.getDataEntityRuntime().getDENotifyRuntime(iPSDENotify);
        iDENotifyRuntime.send(this.getEntityBase());
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IScriptEntity from(Object objData) {
        if (ObjectUtils.isEmpty((Object)objData)) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u4ece\u7a7a\u6570\u636e\u6784\u5efa\u5bf9\u8c61", new Object[0]));
        }
        if (this.getEntity() == null) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getDataEntityRuntime(), String.format("\u5f53\u524d\u6570\u636e\u5bf9\u8c61\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c", new Object[0]));
        }
        if ((objData = ScriptUtils.getReal(objData)) instanceof IEntity) {
            this.getEntity().resetAll();
            ((IEntity)objData).copyTo(this.getEntity());
            return this;
        } else if (objData instanceof Map) {
            Map map = (Map)objData;
            this.getEntity().resetAll();
            for (Object objKey : map.keySet()) {
                this.getEntity().set((String)objKey, map.get(objKey));
            }
            return this;
        } else if (this.getDataEntityRuntime() != null) {
            IEntityBase iEntityBase = this.getDataEntityRuntime().deserializeEntity(objData);
            if (!(iEntityBase instanceof IEntity)) throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8f93\u5165\u6570\u636e", new Object[0]));
            IEntity srcEntity = (IEntity)iEntityBase;
            this.getEntity().resetAll();
            srcEntity.copyTo(this.getEntity());
            return this;
        } else {
            Map map = this.getSystemRuntime().deserialize(objData, Map.class);
            if (map == null) throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8f93\u5165\u6570\u636e", new Object[0]));
            this.getEntity().resetAll();
            for (Object objKey : map.keySet()) {
                this.getEntity().set((String)objKey, map.get(objKey));
            }
        }
        return this;
    }

    @Override
    public String codelisttext(String strName) {
        if (this.getDataEntityRuntime() == null) {
            throw new RuntimeException("\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        }
        IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
        if (iPSDEField == null) {
            throw new RuntimeException(String.format("\u5c5e\u6027[%1$s]\u65e0\u6548", strName));
        }
        IPSCodeList iPSCodeList = iPSDEField.getPSCodeList();
        if (iPSCodeList == null) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u5c5e\u6027[%1$s]\u672a\u7ed1\u5b9a\u4ee3\u7801\u8868", iPSDEField.getName()));
        }
        ICodeListRuntime iCodeListRuntime = this.getSystemRuntime().getCodeListRuntime(iPSCodeList);
        Object objValue = this.get(strName);
        try {
            if (ObjectUtils.isEmpty((Object)objValue)) {
                return iCodeListRuntime.getEmptyText();
            }
            return iCodeListRuntime.getText(objValue);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u83b7\u53d6\u4ee3\u7801\u8868[%1$s]\u503c[%2$s]\u6587\u672c\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iPSCodeList.getId(), objValue, ex.getMessage()));
            return ex.getMessage();
        }
    }

    @Override
    public IScriptCodeItem codeitem(String strName) {
        return this.codeitem(strName, false);
    }

    @Override
    public IScriptCodeItem codeitem(String strName, boolean bTryMode) {
        if (this.getDataEntityRuntime() == null) {
            throw new RuntimeException("\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        }
        IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
        if (iPSDEField == null) {
            throw new RuntimeException(String.format("\u5c5e\u6027[%1$s]\u65e0\u6548", strName));
        }
        IPSCodeList iPSCodeList = iPSDEField.getPSCodeList();
        if (iPSCodeList == null) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u5c5e\u6027[%1$s]\u672a\u7ed1\u5b9a\u4ee3\u7801\u8868", iPSDEField.getName()));
        }
        Object objValue = this.get(strName);
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        IScriptCodeList iScriptCodeList = this.getSystemRuntime().getSystemRTScriptContext().codelist(iPSCodeList.getCodeListTag());
        return iScriptCodeList.item(objValue, bTryMode);
    }

    @Override
    public String dump() {
        if (this.getDataEntityRuntime() != null) {
            Object objData = this.getDataEntityRuntime().serializeEntity(this.getEntityBase());
            if (objData == null) {
                return null;
            }
            if (objData instanceof String) {
                return (String)objData;
            }
            return objData.toString();
        }
        Object objData = this.getSystemRuntime().serialize(this.getEntityBase());
        if (objData == null) {
            return null;
        }
        if (objData instanceof String) {
            return (String)objData;
        }
        return objData.toString();
    }
}

