/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRCondition;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFValueRule;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EntityFieldError {
    public static final int ERROR_OK = 0;
    public static final int ERROR_EMPTY = 1;
    public static final int ERROR_DATATYPE = 2;
    public static final int ERROR_VALUERULE = 3;
    public static final int ERROR_DUPLICATE = 4;
    private int nErrorType = 0;
    private String strFieldLogicName = null;
    private String strFieldName = null;
    private String strFieldErrorId = null;
    private String strErrorInfo = null;
    private Object objFieldValue = null;
    private IPSDEField iPSDEField = null;
    private IPSDEFValueRule iPSDEFValueRule = null;
    private IPSDEFVRCondition iPSDEFVRCondition = null;

    public void setPSDEField(IPSDEField iPSDEField) {
        this.iPSDEField = iPSDEField;
    }

    public IPSDEField getPSDEField() {
        return this.iPSDEField;
    }

    public void setPSDEFValueRule(IPSDEFValueRule iPSDEFValueRule) {
        this.iPSDEFValueRule = iPSDEFValueRule;
    }

    public IPSDEFValueRule getPSDEFValueRule() {
        return this.iPSDEFValueRule;
    }

    public void setPSDEFVRCondition(IPSDEFVRCondition iPSDEFVRCondition) {
        this.iPSDEFVRCondition = iPSDEFVRCondition;
    }

    public IPSDEFVRCondition getPSDEFVRCondition() {
        return this.iPSDEFVRCondition;
    }

    public String getFieldName() {
        if (ObjectUtils.isEmpty((Object)this.strFieldName) && this.getPSDEField() != null) {
            return this.getPSDEField().getName();
        }
        return this.strFieldName;
    }

    public void setFieldName(String strFieldName) {
        this.strFieldName = strFieldName;
    }

    public Object getFieldValue() {
        return this.objFieldValue;
    }

    public void setFieldValue(Object objFieldValue) {
        this.objFieldValue = objFieldValue;
    }

    public String getFieldLogicName() {
        if (ObjectUtils.isEmpty((Object)this.strFieldLogicName) && this.getPSDEField() != null) {
            return this.getPSDEField().getLogicName();
        }
        return this.strFieldLogicName;
    }

    public void setFieldLogicName(String strFieldLogicName) {
        this.strFieldLogicName = strFieldLogicName;
    }

    public String getFieldErrorId() {
        return this.strFieldErrorId;
    }

    public void setFieldErrorId(String strFieldErrorId) {
        this.strFieldErrorId = strFieldErrorId;
    }

    public String getErrorInfo() {
        return this.strErrorInfo;
    }

    public void setErrorInfo(String strErrorInfo) {
        this.strErrorInfo = strErrorInfo;
    }

    public int getErrorType() {
        return this.nErrorType;
    }

    public void setErrorType(int nErrorType) {
        this.nErrorType = nErrorType;
    }

    public String toString() {
        if (this.getFieldValue() == null) {
            if (ObjectUtils.isEmpty((Object)this.getErrorInfo())) {
                if (!StringUtils.hasLength((String)this.getFieldLogicName())) {
                    return String.format("%1$s[%2$s]", this.getFieldName(), EntityFieldError.getErrorTypeString(this.getErrorType()));
                }
                return String.format("%1$s[%2$s]", this.getFieldLogicName(), EntityFieldError.getErrorTypeString(this.getErrorType()));
            }
            if (!StringUtils.hasLength((String)this.getFieldLogicName())) {
                return String.format("%1$s[%2$s], %3$s", this.getFieldName(), EntityFieldError.getErrorTypeString(this.getErrorType()), this.getErrorInfo());
            }
            return String.format("%1$s[%2$s], %3$s", this.getFieldLogicName(), EntityFieldError.getErrorTypeString(this.getErrorType()), this.getErrorInfo());
        }
        if (ObjectUtils.isEmpty((Object)this.getErrorInfo())) {
            if (!StringUtils.hasLength((String)this.getFieldLogicName())) {
                return String.format("%1$s(%3$s)[%2$s]", this.getFieldName(), EntityFieldError.getErrorTypeString(this.getErrorType()), this.getFieldValue());
            }
            return String.format("%1$s(%3$s)[%2$s]", this.getFieldLogicName(), EntityFieldError.getErrorTypeString(this.getErrorType()), this.getFieldValue());
        }
        if (!StringUtils.hasLength((String)this.getFieldLogicName())) {
            return String.format("%1$s(%4$s)[%2$s], %3$s", this.getFieldName(), EntityFieldError.getErrorTypeString(this.getErrorType()), this.getErrorInfo(), this.getFieldValue());
        }
        return String.format("%1$s(%4$s)[%2$s], %3$s", this.getFieldLogicName(), EntityFieldError.getErrorTypeString(this.getErrorType()), this.getErrorInfo(), this.getFieldValue());
    }

    public static String getErrorTypeString(int nErrorType) {
        switch (nErrorType) {
            case 1: {
                return "\u6570\u636e\u8f93\u5165\u4e3a\u7a7a\u9519\u8bef";
            }
            case 2: {
                return "\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e\u9519\u8bef";
            }
            case 3: {
                return "\u503c\u89c4\u5219\u9519\u8bef";
            }
            case 4: {
                return "\u503c\u91cd\u590d\u9519\u8bef";
            }
        }
        return "\u672a\u77e5\u9519\u8bef";
    }
}

