/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.util.ArrayDeque;
import java.util.Deque;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;

public final class DataEntityRuntimeHolder {
    private static final ThreadLocal<Deque<IDataEntityRuntime>> LOOKUP_KEY_HOLDER = new ThreadLocal<Deque<IDataEntityRuntime>>(){

        @Override
        protected Deque<IDataEntityRuntime> initialValue() {
            return new ArrayDeque<IDataEntityRuntime>();
        }
    };

    private DataEntityRuntimeHolder() {
    }

    public static IDataEntityRuntime peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static void push(IDataEntityRuntime ds) {
        LOOKUP_KEY_HOLDER.get().push(ds);
    }

    public static void poll() {
        Deque<IDataEntityRuntime> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

