/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.core.Converter;

public class CachedBeanCopier {
    static final Map<String, BeanCopier> BEAN_COPIERS = new HashMap<String, BeanCopier>();

    public static void copy(Object srcObj, Object destObj) {
        CachedBeanCopier.copy(srcObj, destObj, true);
    }

    public static void copy(Object srcObj, Object destObj, boolean useConverter) {
        if (srcObj == null || destObj == null) {
            return;
        }
        CachedBeanCopier.getCopier(srcObj, destObj, useConverter).copy(srcObj, destObj, new Converter(){

            public Object convert(Object o, Class aClass, Object o1) {
                return o;
            }
        });
    }

    public static synchronized BeanCopier getCopier(Object srcObj, Object destObj, boolean useConverter) {
        BeanCopier copier;
        String key = srcObj.getClass().getName() + destObj.getClass().getName() + useConverter;
        if (!BEAN_COPIERS.containsKey(key)) {
            copier = BeanCopier.create(srcObj.getClass(), destObj.getClass(), (boolean)useConverter);
            BEAN_COPIERS.put(key, copier);
        } else {
            copier = BEAN_COPIERS.get(key);
        }
        return copier;
    }
}

