/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import com.fasterxml.jackson.databind.JsonNode;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SysTranslatorRuntimeBase
extends SystemModelRuntimeBase
implements ISysTranslatorRuntime {
    private static final Log log = LogFactory.getLog(SysTranslatorRuntimeBase.class);
    private IPSSysTranslator iPSSysTranslator = null;

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSSysTranslator iPSSysTranslator) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
        this.iPSSysTranslator = iPSSysTranslator;
        this.setConfigFolder("systranslator." + PSModelUtils.calcUniqueTag((IPSSystemModule)this.iPSSysTranslator.getPSSystemModule(), (String)this.iPSSysTranslator.getCodeName()));
        this.onInit();
    }

    @Override
    public IPSSysTranslator getPSSysTranslator() {
        return this.iPSSysTranslator;
    }

    @Override
    public String getId() {
        return this.getPSSysTranslator().getDynaModelFilePath();
    }

    @Override
    public String getName() {
        return this.getPSSysTranslator().getName();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysTranslator();
    }

    @Override
    public Object translate(Object objValue, boolean bIn) throws Throwable {
        return this.translate(objValue, bIn, null, null, null);
    }

    protected String getTranslatorParam(String strKey, String strDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asText(strDefault);
        }
        return strDefault;
    }

    protected int getTranslatorParam(String strKey, int nDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asInt(nDefault);
        }
        return nDefault;
    }

    protected double getTranslatorParam(String strKey, double fDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asDouble(fDefault);
        }
        return fDefault;
    }

    protected boolean getTranslatorParam(String strKey, boolean bDefault) {
        JsonNode node;
        if (this.getPSSysTranslator().getTranslatorParams() != null && (node = this.getPSSysTranslator().getTranslatorParams().get(strKey)) != null) {
            return node.asBoolean(bDefault);
        }
        return bDefault;
    }
}

