/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime;

import com.fasterxml.jackson.core.type.TypeReference;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.database.IPSSysDBValueFunc;
import net.ibizsys.model.dts.IPSSysDTSQueue;
import net.ibizsys.model.msg.IPSSysMsgQueue;
import net.ibizsys.model.msg.IPSSysMsgTarget;
import net.ibizsys.model.msg.IPSSysMsgTempl;
import net.ibizsys.model.res.IPSSysContent;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.model.res.IPSSysSequence;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.model.valuerule.IPSSysValueRule;
import net.ibizsys.model.wf.IPSWFRole;
import net.ibizsys.runtime.DynaInstRuntime;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemEventListener;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ISystemUtilRuntime;
import net.ibizsys.runtime.SystemRuntimeBaseBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.DynamicCodeListRuntime;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.codelist.PredefinedCodeListRuntime;
import net.ibizsys.runtime.codelist.StaticCodeListRuntime;
import net.ibizsys.runtime.dataentity.DynaInstDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.runtime.dataentity.util.DEDataAuditUtilRuntime;
import net.ibizsys.runtime.dataentity.util.IDEDataAuditUtilRuntime;
import net.ibizsys.runtime.dts.ISysDTSQueueRuntime;
import net.ibizsys.runtime.dts.SysDTSQueueRuntime;
import net.ibizsys.runtime.msg.ISysMsgQueueRuntime;
import net.ibizsys.runtime.msg.ISysMsgTargetRuntime;
import net.ibizsys.runtime.msg.ISysMsgTemplRuntime;
import net.ibizsys.runtime.msg.SysDEMsgQueueRuntime;
import net.ibizsys.runtime.msg.SysDEMsgTargetRuntime;
import net.ibizsys.runtime.msg.SysMsgTemplRuntime;
import net.ibizsys.runtime.plugin.IModelRTScript;
import net.ibizsys.runtime.plugin.ModelRTScriptBase;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import net.ibizsys.runtime.res.DefaultSysValueFuncRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.res.ISysNotifyAgentRuntime;
import net.ibizsys.runtime.res.ISysSFPluginRuntime;
import net.ibizsys.runtime.res.ISysSequenceRuntime;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;
import net.ibizsys.runtime.res.ISysUtilRuntime;
import net.ibizsys.runtime.res.ISysValueFuncRuntime;
import net.ibizsys.runtime.res.ISysValueRuleRuntime;
import net.ibizsys.runtime.res.SysDBSequenceRuntime;
import net.ibizsys.runtime.res.SysDESequenceRuntime;
import net.ibizsys.runtime.res.SysDEStorageTranslatorRuntime;
import net.ibizsys.runtime.res.SysDigestTranslatorRuntime;
import net.ibizsys.runtime.res.SysEncryptTranslatorRuntime;
import net.ibizsys.runtime.res.SysLCaseTranslatorRuntime;
import net.ibizsys.runtime.res.SysMQDataSyncAgentRuntime;
import net.ibizsys.runtime.res.SysNotifyAgentRuntime;
import net.ibizsys.runtime.res.SysRegExValueRuleRuntime;
import net.ibizsys.runtime.res.SysSFPluginRuntime;
import net.ibizsys.runtime.res.SysScriptLogicRuntime;
import net.ibizsys.runtime.res.SysScriptValueRuleRuntime;
import net.ibizsys.runtime.res.SysUCaseTranslatorRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.groovy.ISystemRTGroovyContext;
import net.ibizsys.runtime.util.script.ISystemRTScriptContext;
import net.ibizsys.runtime.wf.IWFRoleRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SystemUtilRuntimeBase
extends SystemRuntimeBaseBase
implements ISystemUtilRuntime {
    private static final Log log = LogFactory.getLog(SystemUtilRuntimeBase.class);
    private String strTempFolder = null;
    private String strFileFolder = null;
    private String strReportFolder = null;
    private String strFontFolder = null;
    private ThreadPoolExecutor workThreadPoolExecutor = null;
    private ScheduledExecutorService timerThreadPoolExecutor = null;
    private static Map<String, DecimalFormat> DecimalFormatMap = new ConcurrentHashMap<String, DecimalFormat>();
    private static Map<String, DateFormat> DateFormatMap = new ConcurrentHashMap<String, DateFormat>();
    private List<TimerTask> timerTaskList = new ArrayList<TimerTask>();
    private List<TimerTask> timerTaskList2 = new ArrayList<TimerTask>();
    private Set<Object> autowareObjectList = new LinkedHashSet<Object>();
    private boolean bAutowareObjectList = true;
    private boolean bThreadRun = false;

    protected static boolean registerRuntimeObject(Class<?> cls, String strType, Object strObject) {
        return RuntimeObjectFactory.getInstance().registerObject(cls, strType, strObject);
    }

    protected static boolean registerRuntimeObject(Class<?> cls, Object strObject) {
        return RuntimeObjectFactory.getInstance().registerObject(cls, null, strObject);
    }

    protected static boolean registerRuntimeObjectPrimary(Class<?> cls, String strType, Object strObject) {
        return RuntimeObjectFactory.getInstance().registerObjectPrimary(cls, strType, strObject);
    }

    protected static boolean registerRuntimeObjectPrimary(Class<?> cls, Object strObject) {
        return RuntimeObjectFactory.getInstance().registerObjectPrimary(cls, null, strObject);
    }

    protected static boolean registerRuntimeObject(Class<?> cls, String strType, Object strObject, int nOrderValue) {
        return RuntimeObjectFactory.getInstance().registerObject(cls, strType, strObject, nOrderValue);
    }

    protected static boolean registerRuntimeObject(Class<?> cls, Object strObject, int nOrderValue) {
        return RuntimeObjectFactory.getInstance().registerObject(cls, null, strObject, nOrderValue);
    }

    protected static boolean registerRuntimeObjectIf(Class<?> cls, String strType, Object strObject) {
        return RuntimeObjectFactory.getInstance().registerObjectIf(cls, strType, strObject);
    }

    protected static boolean registerRuntimeObjectIf(Class<?> cls, Object strObject) {
        return RuntimeObjectFactory.getInstance().registerObjectIf(cls, null, strObject);
    }

    protected boolean isThreadRun() {
        return this.bThreadRun;
    }

    @Override
    public Object convertValue(int nDataType, String strValue) throws Exception {
        return DataTypeUtils.parse(nDataType, strValue);
    }

    @Override
    public Object convertValue(int nDataType, Object value) throws Exception {
        return DataTypeUtils.convert(nDataType, value);
    }

    @Override
    public List convertListValue(int nDataType, Object value) throws Exception {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                item = this.convertValue(nDataType, item);
                list.set(i, item);
            }
            return list;
        }
        if (value instanceof String) {
            return this.convertListValue(nDataType, (String)value);
        }
        String strValue = JsonUtils.toString(value);
        return this.convertListValue(nDataType, strValue);
    }

    @Override
    public List convertListValue(int nDataType, String strValue) throws Exception {
        if (ObjectUtils.isEmpty((Object)strValue)) {
            return null;
        }
        List list = JsonUtils.asList(strValue);
        if (ObjectUtils.isEmpty((Object)list)) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            item = this.convertValue(nDataType, item);
            list.set(i, item);
        }
        return list;
    }

    @Override
    public boolean testValueCond(Object objSrcValue, String strOp, Object objDstValue, int nSrcValueDataType) {
        try {
            return DataTypeUtils.testCond(objSrcValue, strOp, objDstValue, nSrcValueDataType);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5224\u65ad\u503c\u6761\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public long compareValue(Object objSrcValue, Object objDstValue, int nValueDataType) {
        return DataTypeUtils.compare(nValueDataType, objSrcValue, objDstValue);
    }

    @Override
    public String writeValue(int nStdDataType, Object value, String strJsonFormat) throws Exception {
        Assert.notNull((Object)value, (String)"\u4f20\u5165\u503c\u65e0\u6548");
        Assert.hasLength((String)strJsonFormat, (String)"\u4f20\u5165\u683c\u5f0f\u5316\u65e0\u6548");
        if (DataTypeUtils.isNumberDataType(nStdDataType)) {
            return SystemUtilRuntimeBase.getDecimalFormat(strJsonFormat).format(value);
        }
        if (DataTypeUtils.isDateTimeDataType(nStdDataType)) {
            return SystemUtilRuntimeBase.getDateFormat(strJsonFormat).format(value);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6807\u51c6\u6570\u636e\u7c7b\u578b[%1$s]", DataTypeUtils.getTypeName(nStdDataType)));
    }

    @Override
    public Object readValue(int nStdDataType, String strValue, String strJsonFormat) throws Exception {
        Assert.hasLength((String)strValue, (String)"\u4f20\u5165\u503c\u65e0\u6548");
        Assert.hasLength((String)strJsonFormat, (String)"\u4f20\u5165\u683c\u5f0f\u5316\u65e0\u6548");
        if (DataTypeUtils.isNumberDataType(nStdDataType)) {
            return SystemUtilRuntimeBase.getDecimalFormat(strJsonFormat).parseObject(strValue);
        }
        if (DataTypeUtils.isDateTimeDataType(nStdDataType)) {
            return SystemUtilRuntimeBase.getDateFormat(strJsonFormat).parseObject(strValue);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6807\u51c6\u6570\u636e\u7c7b\u578b[%1$s]", DataTypeUtils.getTypeName(nStdDataType)));
    }

    public static DecimalFormat getDecimalFormat(String strJsonFormat) throws Exception {
        DecimalFormat decimalFormat = DecimalFormatMap.get(strJsonFormat);
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat(strJsonFormat);
            DecimalFormatMap.put(strJsonFormat, decimalFormat);
        }
        return decimalFormat;
    }

    public static DateFormat getDateFormat(String strJsonFormat) throws Exception {
        DateFormat dateFormat = DateFormatMap.get(strJsonFormat);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(strJsonFormat);
            DateFormatMap.put(strJsonFormat, dateFormat);
        }
        return dateFormat;
    }

    protected IDynaInstRuntime createDynaInstRuntime() {
        return new DynaInstRuntime();
    }

    protected IDynaInstDataEntityRuntime createDynaInstDataEntityRuntime() {
        return new DynaInstDataEntityRuntime();
    }

    @Override
    public ISysValueRuleRuntime createSysValueRuleRuntime(IPSSysValueRule iPSSysValueRule) {
        Assert.notNull((Object)iPSSysValueRule, (String)"\u7cfb\u7edf\u503c\u89c4\u5219\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysValueRuleRuntime iSysValueRuleRuntime = this.getRuntimeObject(iPSSysValueRule.getPSSysSFPlugin(), ISysValueRuleRuntime.class, true);
        if (iSysValueRuleRuntime != null) {
            return iSysValueRuleRuntime;
        }
        if ("REGEX".equals(iPSSysValueRule.getRuleType()) || "REG".equals(iPSSysValueRule.getRuleType())) {
            return new SysRegExValueRuleRuntime();
        }
        if ("SCRIPT".equals(iPSSysValueRule.getRuleType())) {
            return new SysScriptValueRuleRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u503c\u89c4\u5219[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u7c7b\u578b\u4e3a[%2$s]", iPSSysValueRule.getName(), iPSSysValueRule.getRuleType()));
    }

    @Override
    public ISysSequenceRuntime createSysSequenceRuntime(IPSSysSequence iPSSysSequence) {
        Assert.notNull((Object)iPSSysSequence, (String)"\u7cfb\u7edf\u503c\u5e8f\u5217\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysSequenceRuntime iSysSequenceRuntime = this.getRuntimeObject(iPSSysSequence.getPSSysSFPlugin(), ISysSequenceRuntime.class, true);
        if (iSysSequenceRuntime != null) {
            return iSysSequenceRuntime;
        }
        if (StringUtils.hasLength((String)iPSSysSequence.getSequenceType()) && (iSysSequenceRuntime = this.getRuntimeObject(ISysSequenceRuntime.class, iPSSysSequence.getSequenceType())) != null) {
            return iSysSequenceRuntime;
        }
        return this.onCreateSysSequenceRuntime(iPSSysSequence);
    }

    protected ISysSequenceRuntime onCreateSysSequenceRuntime(IPSSysSequence iPSSysSequence) {
        if ("DB".equals(iPSSysSequence.getSequenceType())) {
            return new SysDBSequenceRuntime();
        }
        if ("DE".equals(iPSSysSequence.getSequenceType())) {
            return new SysDESequenceRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u503c\u5e8f\u5217[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u7c7b\u578b\u4e3a[%2$s]", iPSSysSequence.getName(), iPSSysSequence.getSequenceType()));
    }

    @Override
    public ISysTranslatorRuntime createSysTranslatorRuntime(IPSSysTranslator iPSSysTranslator) {
        Assert.notNull((Object)iPSSysTranslator, (String)"\u7cfb\u7edf\u503c\u8f6c\u6362\u5668\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysTranslatorRuntime iSysTranslatorRuntime = this.getRuntimeObject(iPSSysTranslator.getPSSysSFPlugin(), ISysTranslatorRuntime.class, true);
        if (iSysTranslatorRuntime != null) {
            return iSysTranslatorRuntime;
        }
        if ("DIGEST".equals(iPSSysTranslator.getTranslatorType())) {
            return new SysDigestTranslatorRuntime();
        }
        if ("ENCRYPT".equals(iPSSysTranslator.getTranslatorType())) {
            return new SysEncryptTranslatorRuntime();
        }
        if ("DESTORAGE".equals(iPSSysTranslator.getTranslatorType())) {
            return new SysDEStorageTranslatorRuntime();
        }
        if ("UCASE".equals(iPSSysTranslator.getTranslatorType())) {
            return new SysUCaseTranslatorRuntime();
        }
        if ("LCASE".equals(iPSSysTranslator.getTranslatorType())) {
            return new SysLCaseTranslatorRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u503c\u8f6c\u6362\u5668[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u7c7b\u578b\u4e3a[%2$s]", iPSSysTranslator.getName(), iPSSysTranslator.getTranslatorType()));
    }

    @Override
    public ICodeListRuntime createCodeListRuntime(IPSCodeList iPSCodeList) {
        Assert.notNull((Object)iPSCodeList, (String)"\u7cfb\u7edf\u4ee3\u7801\u8868\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ICodeListRuntime iCodeListRuntime = this.getRuntimeObject(iPSCodeList.getPSSysSFPlugin(), ICodeListRuntime.class, true);
        if (iCodeListRuntime != null) {
            return iCodeListRuntime;
        }
        if ("STATIC".equals(iPSCodeList.getCodeListType())) {
            return this.createStaticCodeListRuntime(iPSCodeList);
        }
        if ("DYNAMIC".equals(iPSCodeList.getCodeListType())) {
            return this.createDynamicCodeListRuntime(iPSCodeList);
        }
        if ("PREDEFINED".equals(iPSCodeList.getCodeListType())) {
            return this.createPredefinedCodeListRuntime(iPSCodeList);
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u4ee3\u7801\u8868[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u7c7b\u578b\u4e3a[%2$s]", iPSCodeList.getName(), iPSCodeList.getCodeListType()));
    }

    protected ICodeListRuntime createStaticCodeListRuntime(IPSCodeList iPSCodeList) {
        return new StaticCodeListRuntime();
    }

    protected ICodeListRuntime createPredefinedCodeListRuntime(IPSCodeList iPSCodeList) {
        String strType;
        ICodeListRuntime iCodeListRuntime;
        if (StringUtils.hasLength((String)iPSCodeList.getPredefinedType()) && (iCodeListRuntime = this.getRuntimeObject(ICodeListRuntime.class, strType = String.format("%1$s:%2$s", iPSCodeList.getCodeListType(), iPSCodeList.getPredefinedType()))) != null) {
            return iCodeListRuntime;
        }
        return new PredefinedCodeListRuntime();
    }

    protected ICodeListRuntime createDynamicCodeListRuntime(IPSCodeList iPSCodeList) {
        String strType;
        ICodeListRuntime iCodeListRuntime;
        if (iPSCodeList.isUserScope()) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u4ee3\u7801\u8868[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u4e0d\u652f\u6301\u7528\u6237\u8303\u56f4", iPSCodeList.getName()));
        }
        if (StringUtils.hasLength((String)iPSCodeList.getPredefinedType()) && (iCodeListRuntime = this.getRuntimeObject(ICodeListRuntime.class, strType = String.format("%1$s:%2$s", iPSCodeList.getCodeListType(), iPSCodeList.getPredefinedType()))) != null) {
            return iCodeListRuntime;
        }
        return new DynamicCodeListRuntime();
    }

    @Override
    public ISysUtilRuntime createSysUtilRuntime(IPSSysUtil iPSSysUtil) {
        Assert.notNull((Object)iPSSysUtil, (String)"\u7cfb\u7edf\u529f\u80fd\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysUtilRuntime iSysUtilRuntime = this.getRuntimeObject(iPSSysUtil.getPSSysSFPlugin(), ISysUtilRuntime.class, true);
        if (iSysUtilRuntime != null) {
            return iSysUtilRuntime;
        }
        iSysUtilRuntime = "USER".equals(iPSSysUtil.getUtilType()) ? this.getRuntimeObject(ISysUtilRuntime.class, String.format("%1$s:%2$s", iPSSysUtil.getUtilType(), iPSSysUtil.getUtilTag())) : this.getRuntimeObject(ISysUtilRuntime.class, iPSSysUtil.getUtilType());
        if (iSysUtilRuntime != null) {
            return iSysUtilRuntime;
        }
        iSysUtilRuntime = this.onCreateSysUtilRuntime(iPSSysUtil);
        if (iSysUtilRuntime != null) {
            return iSysUtilRuntime;
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u7cfb\u7edf\u9884\u7f6e\u529f\u80fd\u7ec4\u4ef6[%1$s]", iPSSysUtil.getUtilType()));
    }

    protected ISysUtilRuntime onCreateSysUtilRuntime(IPSSysUtil iPSSysUtil) {
        ISysUtilRuntime iSysUtilRuntime = this.createDefaultSysUtilRuntime(iPSSysUtil);
        if (iSysUtilRuntime != null) {
            return iSysUtilRuntime;
        }
        String strUtilType = iPSSysUtil.getUtilType();
        if (StringUtils.hasLength((String)strUtilType) && "DATAAUDIT".equals(strUtilType)) {
            return this.createDEDataAuditUtilRuntime();
        }
        return null;
    }

    protected IDEDataAuditUtilRuntime createDEDataAuditUtilRuntime() {
        return new DEDataAuditUtilRuntime();
    }

    protected ISysUtilRuntime createDefaultSysUtilRuntime(IPSSysUtil iPSSysUtil) {
        return null;
    }

    @Override
    public ISysDataSyncAgentRuntime createSysDataSyncAgentRuntime(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
        Assert.notNull((Object)iPSSysDataSyncAgent, (String)"\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime = this.getRuntimeObject(iPSSysDataSyncAgent.getPSSysSFPlugin(), ISysDataSyncAgentRuntime.class, true);
        if (iSysDataSyncAgentRuntime != null) {
            return iSysDataSyncAgentRuntime;
        }
        iSysDataSyncAgentRuntime = this.getRuntimeObject(ISysDataSyncAgentRuntime.class, iPSSysDataSyncAgent.getAgentType());
        if (iSysDataSyncAgentRuntime != null) {
            return iSysDataSyncAgentRuntime;
        }
        return this.onCreateSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
    }

    protected ISysDataSyncAgentRuntime onCreateSysDataSyncAgentRuntime(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
        if (!StringUtils.hasLength((String)iPSSysDataSyncAgent.getAgentType())) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u672a\u6307\u5b9a\u4ee3\u7406\u7c7b\u578b", iPSSysDataSyncAgent.getName()));
        }
        if ("ACTIVEMQ".equals(iPSSysDataSyncAgent.getAgentType())) {
            return new SysMQDataSyncAgentRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u7c7b\u578b\u4e3a[%2$s]", iPSSysDataSyncAgent.getName(), iPSSysDataSyncAgent.getAgentType()));
    }

    @Override
    public ISysNotifyAgentRuntime createSysNotifyAgentRuntime() {
        return new SysNotifyAgentRuntime();
    }

    @Override
    public ISysMsgTemplRuntime createSysMsgTemplRuntime(IPSSysMsgTempl iPSSysMsgTempl) {
        Assert.notNull((Object)iPSSysMsgTempl, (String)"\u7cfb\u7edf\u6d88\u606f\u6a21\u677f\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysMsgTemplRuntime iSysMsgTemplRuntime = this.getRuntimeObject(iPSSysMsgTempl.getPSSysSFPlugin(), ISysMsgTemplRuntime.class, true);
        if (iSysMsgTemplRuntime != null) {
            return iSysMsgTemplRuntime;
        }
        iSysMsgTemplRuntime = this.getRuntimeObject(ISysMsgTemplRuntime.class, iPSSysMsgTempl.getTemplEngine());
        if (iSysMsgTemplRuntime != null) {
            return iSysMsgTemplRuntime;
        }
        return this.onCreateSysMsgTemplRuntime(iPSSysMsgTempl);
    }

    protected ISysMsgTemplRuntime onCreateSysMsgTemplRuntime(IPSSysMsgTempl iPSSysMsgTempl) {
        return new SysMsgTemplRuntime();
    }

    @Override
    public ISysMsgQueueRuntime createSysMsgQueueRuntime(IPSSysMsgQueue iPSSysMsgQueue) {
        Assert.notNull((Object)iPSSysMsgQueue, (String)"\u7cfb\u7edf\u6d88\u606f\u961f\u5217\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysMsgQueueRuntime iSysMsgQueueRuntime = this.getRuntimeObject(iPSSysMsgQueue.getPSSysSFPlugin(), ISysMsgQueueRuntime.class, true);
        if (iSysMsgQueueRuntime != null) {
            return iSysMsgQueueRuntime;
        }
        Assert.notNull((Object)iPSSysMsgQueue.getMsgQueueType(), (String)"\u7cfb\u7edf\u6d88\u606f\u961f\u5217\u6a21\u578b\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548");
        if ("DE".equals(iPSSysMsgQueue.getMsgQueueType())) {
            return new SysDEMsgQueueRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u7cfb\u7edf\u6d88\u606f\u961f\u5217[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u7c7b\u578b\u4e3a[%2$s]", iPSSysMsgQueue.getName(), iPSSysMsgQueue.getMsgQueueType()));
    }

    @Override
    public ISysMsgTargetRuntime createSysMsgTargetRuntime(IPSSysMsgTarget iPSSysMsgTarget) {
        Assert.notNull((Object)iPSSysMsgTarget, (String)"\u7cfb\u7edf\u6d88\u606f\u76ee\u6807\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysMsgTargetRuntime iSysMsgTargetRuntime = this.getRuntimeObject(iPSSysMsgTarget.getPSSysSFPlugin(), ISysMsgTargetRuntime.class, true);
        if (iSysMsgTargetRuntime != null) {
            return iSysMsgTargetRuntime;
        }
        Assert.notNull((Object)iPSSysMsgTarget.getMsgTargetType(), (String)"\u7cfb\u7edf\u6d88\u606f\u76ee\u6807\u6a21\u578b\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548");
        if ("DE".equals(iPSSysMsgTarget.getMsgTargetType())) {
            return new SysDEMsgTargetRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u7cfb\u7edf\u6d88\u606f\u76ee\u6807[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\uff0c\u7c7b\u578b\u4e3a[%2$s]", iPSSysMsgTarget.getName(), iPSSysMsgTarget.getMsgTargetType()));
    }

    @Override
    public ISysValueFuncRuntime createSysValueFuncRuntime(IPSSysDBValueFunc iPSSysDBValueFunc) {
        Assert.notNull((Object)iPSSysDBValueFunc, (String)"\u7cfb\u7edf\u503c\u51fd\u6570\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysValueFuncRuntime iSysValueFuncRuntime = this.getRuntimeObject(iPSSysDBValueFunc.getPSSysSFPlugin(), ISysValueFuncRuntime.class, true);
        if (iSysValueFuncRuntime != null) {
            return iSysValueFuncRuntime;
        }
        Assert.notNull((Object)iPSSysDBValueFunc.getCodeName(), (String)"\u7cfb\u7edf\u503c\u51fd\u6570\u6a21\u578b\u5bf9\u8c61\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        if ("DATEDIFFNOW".equalsIgnoreCase(iPSSysDBValueFunc.getCodeName()) || "DATEDIFFNOW2".equalsIgnoreCase(iPSSysDBValueFunc.getCodeName()) || "STRLEN".equalsIgnoreCase(iPSSysDBValueFunc.getCodeName())) {
            return new DefaultSysValueFuncRuntime();
        }
        return new DefaultSysValueFuncRuntime();
    }

    @Override
    public ISysLogicRuntime createSysLogicRuntime(IPSSysLogic iPSSysLogic) {
        Assert.notNull((Object)iPSSysLogic, (String)"\u7cfb\u7edf\u903b\u8f91\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysLogicRuntime iSysLogicRuntime = this.getRuntimeObject(iPSSysLogic.getPSSysSFPlugin(), ISysLogicRuntime.class, true);
        if (iSysLogicRuntime != null) {
            return iSysLogicRuntime;
        }
        if (iPSSysLogic.isCustomCode()) {
            return new SysScriptLogicRuntime();
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u5efa\u7acb\u7cfb\u7edf\u903b\u8f91[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", iPSSysLogic.getName()));
    }

    @Override
    public IWFRoleRuntime createWFRoleRuntime(IPSWFRole iPSWFRole) {
        Assert.notNull((Object)iPSWFRole, (String)"\u5de5\u4f5c\u6d41\u89d2\u8272\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public ISysSFPluginRuntime createSysSFPluginRuntime(IPSSysSFPlugin iPSSysSFPlugin) {
        Assert.notNull((Object)iPSSysSFPlugin, (String)"\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysSFPluginRuntime iSysSFPluginRuntime = this.createDefaultSysSFPluginRuntime(iPSSysSFPlugin);
        if (iSysSFPluginRuntime != null) {
            return iSysSFPluginRuntime;
        }
        return new SysSFPluginRuntime();
    }

    protected ISysSFPluginRuntime createDefaultSysSFPluginRuntime(IPSSysSFPlugin iPSSysSFPlugin) {
        return null;
    }

    @Override
    public ISysDTSQueueRuntime createSysDTSQueueRuntime(IPSSysDTSQueue iPSSysDTSQueue) {
        Assert.notNull((Object)iPSSysDTSQueue, (String)"\u7cfb\u7edf\u5f02\u6b65\u5904\u7406\u961f\u5217\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        ISysDTSQueueRuntime iSysDTSQueueRuntime = this.createDefaultSysDTSQueueRuntime(iPSSysDTSQueue);
        if (iSysDTSQueueRuntime != null) {
            return iSysDTSQueueRuntime;
        }
        return new SysDTSQueueRuntime();
    }

    protected ISysDTSQueueRuntime createDefaultSysDTSQueueRuntime(IPSSysDTSQueue iPSSysDTSQueue) {
        return null;
    }

    @Override
    public void installBaseDatas(String strMode) {
        this.onInstallBaseDatas(strMode);
    }

    protected void onInstallBaseDatas(String strMode) {
        List psSysContentList = null;
        try {
            psSysContentList = this.getPSSystem().getInitPSSysContents();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u83b7\u53d6\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), 21, (Throwable)ex);
        }
        if (psSysContentList == null) {
            return;
        }
        for (IPSSysContent iPSSysContent : psSysContentList) {
            try {
                this.executeInstallScript(iPSSysContent);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u5b89\u88c5\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysContent.getName(), ex.getMessage()));
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5b89\u88c5\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysContent.getName(), ex.getMessage()), ex);
            }
        }
    }

    @Override
    public void installSampleDatas(String strMode) {
        this.onInstallSampleDatas(strMode);
    }

    protected void onInstallSampleDatas(String strMode) {
        List psSysContentList = null;
        try {
            psSysContentList = this.getPSSystem().getSamplePSSysContents();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u83b7\u53d6\u7cfb\u7edf\u793a\u4f8b\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u7cfb\u7edf\u793a\u4f8b\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), 21, (Throwable)ex);
        }
        if (psSysContentList == null) {
            return;
        }
        for (IPSSysContent iPSSysContent : psSysContentList) {
            try {
                this.executeInstallScript(iPSSysContent);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u5b89\u88c5\u7cfb\u7edf\u793a\u4f8b\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysContent.getName(), ex.getMessage()));
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5b89\u88c5\u7cfb\u7edf\u793a\u4f8b\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysContent.getName(), ex.getMessage()), ex);
            }
        }
    }

    @Override
    public void installTestDatas(String strMode) {
        this.onInstallTestDatas(strMode);
    }

    protected void onInstallTestDatas(String strMode) {
        List psSysContentList = null;
        try {
            psSysContentList = this.getPSSystem().getTestPSSysContents();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u83b7\u53d6\u7cfb\u7edf\u6d4b\u8bd5\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u7cfb\u7edf\u6d4b\u8bd5\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), 21, (Throwable)ex);
        }
        if (psSysContentList == null) {
            return;
        }
        for (IPSSysContent iPSSysContent : psSysContentList) {
            try {
                this.executeInstallScript(iPSSysContent);
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u5b89\u88c5\u7cfb\u7edf\u6d4b\u8bd5\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysContent.getName(), ex.getMessage()));
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5b89\u88c5\u7cfb\u7edf\u6d4b\u8bd5\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysContent.getName(), ex.getMessage()), ex);
            }
        }
    }

    public abstract ISystemRTScriptContext getSystemRTScriptContext();

    protected void executeInstallScript(IPSSysContent iPSSysContent) throws Exception {
        if (!StringUtils.hasLength((String)iPSSysContent.getContent())) {
            return;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        String strJSCode = "function main(sys,data){";
        strJSCode = strJSCode + iPSSysContent.getContent();
        strJSCode = strJSCode + "}";
        engine.eval(strJSCode);
        Invocable invocable = (Invocable)((Object)engine);
        invocable.invokeFunction("main", this.getSystemRTScriptContext(), iPSSysContent);
    }

    @Override
    public int executeSql(String strDSLink, String strSql, Object param) throws Exception {
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public ResultSet executeSqlQuery(String strDSLink, String strSql, Object param) throws Exception {
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public boolean testUniRes(String strUniResCode) {
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    protected void prepareThreadPoolExecutors() throws Exception {
        this.bThreadRun = true;
        this.workThreadPoolExecutor = this.createWorkThreadPoolExecutor();
        this.timerThreadPoolExecutor = this.createScheduleThreadPoolExecutor();
        this.timerThreadPoolExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SystemUtilRuntimeBase.this.timerThreadRun();
            }
        }, this.getTimerThreadTimer(), this.getTimerThreadTimer(), TimeUnit.MILLISECONDS);
    }

    protected void shutdownThreadPoolExecutors() throws Exception {
        if (!this.bThreadRun) {
            return;
        }
        this.bThreadRun = false;
        this.shutdownWorkThreadPoolExecutor();
        this.shutdownScheduleThreadPoolExecutor();
    }

    protected ThreadPoolExecutor createWorkThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, this.getWorkThreadMaximumPoolSize(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.getWorkThreadBlockingQueueSize()), new ThreadPoolExecutor.AbortPolicy());
        return threadPoolExecutor;
    }

    protected ScheduledExecutorService createScheduleThreadPoolExecutor() {
        return Executors.newScheduledThreadPool(1);
    }

    protected void shutdownWorkThreadPoolExecutor() {
        if (this.workThreadPoolExecutor != null) {
            try {
                this.workThreadPoolExecutor.shutdownNow();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5173\u95ed\u5de5\u4f5c\u7ebf\u7a0b\u6c60\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.workThreadPoolExecutor = null;
        }
    }

    protected void shutdownScheduleThreadPoolExecutor() {
        if (this.timerThreadPoolExecutor != null) {
            try {
                this.timerThreadPoolExecutor.shutdownNow();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5173\u95ed\u5b9a\u65f6\u7ebf\u7a0b\u6c60\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.timerThreadPoolExecutor = null;
        }
    }

    protected int getWorkThreadMaximumPoolSize() {
        return 40;
    }

    protected int getWorkThreadBlockingQueueSize() {
        return 2000;
    }

    protected int getTimerThreadTimer() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timerThreadRun() {
        if (!this.isThreadRun()) {
            return;
        }
        List<TimerTask> list = this.timerTaskList;
        synchronized (list) {
            if (this.timerTaskList.size() == 0) {
                return;
            }
            this.timerTaskList2.addAll(this.timerTaskList);
            this.timerTaskList.clear();
        }
        long nCurrentTime = System.currentTimeMillis();
        while (this.timerTaskList2.size() > 0) {
            TimerTask timerTask = this.timerTaskList2.remove(0);
            if (nCurrentTime >= timerTask.time) {
                IUserContext last = UserContext.getCurrent();
                UserContext.setCurrent(this.getThreadTaskUserContext(timerTask.userContext));
                this.threadRun(timerTask.runnable, -1L);
                UserContext.setCurrent(last);
                continue;
            }
            List<TimerTask> list2 = this.timerTaskList;
            synchronized (list2) {
                this.timerTaskList.add(timerTask);
            }
        }
    }

    @Override
    public void threadRun(Runnable runnable) {
        this.threadRun(runnable, -1L, null);
    }

    @Override
    public void threadRun(Runnable runnable, long nTime) {
        this.threadRun(runnable, nTime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadRun(final Runnable runnable, long nTime, String strTaskName) {
        if (!this.isThreadRun()) {
            return;
        }
        final IUserContext iUserContext = UserContext.getCurrent();
        if (nTime <= 0L) {
            Assert.notNull((Object)this.workThreadPoolExecutor, (String)"\u540e\u53f0\u4f5c\u4e1a\u7ebf\u7a0b\u6c60\u5bf9\u8c61\u65e0\u6548");
            this.workThreadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    IUserContext last = UserContext.getCurrent();
                    UserContext.setCurrent(SystemUtilRuntimeBase.this.getThreadTaskUserContext(iUserContext));
                    runnable.run();
                    UserContext.setCurrent(last);
                }
            });
        } else {
            TimerTask timerTask = new TimerTask();
            timerTask.runnable = runnable;
            timerTask.time = nTime;
            timerTask.userContext = iUserContext;
            timerTask.name = strTaskName;
            List<TimerTask> list = this.timerTaskList;
            synchronized (list) {
                if (StringUtils.hasLength((String)strTaskName)) {
                    for (int i = 0; i < this.timerTaskList.size(); ++i) {
                        TimerTask item = this.timerTaskList.get(i);
                        if (!StringUtils.hasLength((String)item.name) || !item.name.equals(strTaskName)) continue;
                        this.timerTaskList.remove(i);
                        break;
                    }
                }
                this.timerTaskList.add(timerTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadCancel(String strTaskName) {
        if (!this.isThreadRun()) {
            return;
        }
        Assert.hasLength((String)strTaskName, (String)"\u672a\u4f20\u5165\u53d6\u6d88\u4efb\u52a1\u7684\u540d\u79f0");
        List<TimerTask> list = this.timerTaskList;
        synchronized (list) {
            for (int i = 0; i < this.timerTaskList.size(); ++i) {
                TimerTask item = this.timerTaskList.get(i);
                if (!StringUtils.hasLength((String)item.name) || !item.name.equals(strTaskName)) continue;
                this.timerTaskList.remove(i);
                break;
            }
        }
    }

    @Override
    public Object asyncExecute(final IAction iAction, final Object[] args, Object actionTag) throws Throwable {
        this.threadRun(new Runnable(){

            @Override
            public void run() {
                try {
                    iAction.execute(args);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
        });
        return null;
    }

    @Override
    public Object sseExecute(IAction iAction, Object[] args, Object actionTag, long nTimeout) throws Throwable {
        return this.asyncExecute(iAction, args, actionTag);
    }

    protected IUserContext getThreadTaskUserContext(IUserContext iUserContext) {
        return iUserContext;
    }

    @Override
    public IEntity createEntity() {
        return this.createEntity(null);
    }

    @Override
    public IEntity createEntity(Object source) {
        return this.createEntity(source, true);
    }

    @Override
    public IEntity createEntity(Object source, boolean bLowerCaseFieldName) {
        return new Entity(source, bLowerCaseFieldName);
    }

    @Override
    public Object serialize(Object obj) {
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> T deserialize(Object objData, Class<T> cls) {
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> T deserialize(Object objData, TypeReference<T> type) {
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public String getReportFolder() {
        return this.strReportFolder;
    }

    protected void setReportFolder(String strReportFolder) {
        this.strReportFolder = strReportFolder;
    }

    @Override
    public String getFontFolder() {
        return this.strFontFolder;
    }

    protected void setFontFolder(String strFontFolder) {
        this.strFontFolder = strFontFolder;
    }

    @Override
    public String getFileFolder() {
        return this.strFileFolder;
    }

    protected void setFileFolder(String strFileFolder) {
        this.strFileFolder = strFileFolder;
    }

    @Override
    public String getTempFolder() {
        return this.strTempFolder;
    }

    protected void setTempFolder(String strTempFolder) {
        this.strTempFolder = strTempFolder;
    }

    @Override
    public IUserContext createDefaultUserContext() {
        throw new SystemRuntimeException((ISystemRuntimeBase)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public <T> T getRuntimeObject(Class<T> cls, String strType) {
        try {
            T t = RuntimeObjectFactory.getInstance().getObject(cls, strType);
            if (t != null) {
                this.autowareObject(t);
            }
            return t;
        }
        catch (Exception ex) {
            if (StringUtils.hasLength((String)strType)) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s|%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", cls.getCanonicalName(), strType, ex.getMessage()), ex);
            }
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", cls.getCanonicalName(), ex.getMessage()), ex);
        }
    }

    @Override
    public <T> Map<String, T> getRuntimeObjects(Class<T> cls) {
        return this.getRuntimeObjects(cls, null);
    }

    @Override
    public <T> Map<String, T> getRuntimeObjects(Class<T> cls, String strType) {
        try {
            return RuntimeObjectFactory.getInstance().getObjects(cls, strType);
        }
        catch (Exception ex) {
            if (StringUtils.hasLength((String)strType)) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u8fd0\u884c\u65f6\u5bf9\u8c61\u5217\u8868[%1$s|%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", cls.getCanonicalName(), strType, ex.getMessage()), ex);
            }
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u8fd0\u884c\u65f6\u5bf9\u8c61\u5217\u8868[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", cls.getCanonicalName(), ex.getMessage()), ex);
        }
    }

    public abstract boolean isLoaded();

    public abstract void registerSystemEventListener(ISystemEventListener var1);

    public abstract void registerSystemEventListener(ISystemEventListener var1, String[] var2);

    public abstract void unregisterSystemEventListener(ISystemEventListener var1);

    public abstract ISystemRTGroovyContext getSystemRTGroovyContext();

    @Override
    public <T> T createObject(Class<T> cls, String strObjectName) {
        Class<?> objectCls = null;
        try {
            objectCls = Class.forName(strObjectName);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5efa\u7acb\u5bf9\u8c61[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strObjectName, ex.getMessage()), ex);
        }
        return this.createObject(cls, objectCls);
    }

    @Override
    public <T> T createObject(Class<T> cls, Class<?> objectCls) {
        Object obj = null;
        try {
            obj = objectCls.newInstance();
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5efa\u7acb\u5bf9\u8c61[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", objectCls.getName(), ex.getMessage()), ex);
        }
        if (!cls.isAssignableFrom(obj.getClass())) {
            throw new SystemRuntimeException(this, String.format("\u5bf9\u8c61[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", objectCls.getName()));
        }
        this.autowareObject(obj);
        return (T)obj;
    }

    @Override
    public void autowareObject(Object object) {
        Assert.notNull((Object)object, (String)"\u4f20\u5165\u88c5\u914d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.bAutowareObjectList) {
            try {
                this.doAutowareObject(object, object.getClass());
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u88c5\u914d\u5bf9\u8c61[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", object, ex.getMessage()), ex);
            }
        } else {
            this.autowareObjectList.add(object);
        }
    }

    protected void doAutowareObject(Object object, Class<?> cls) throws Exception {
        Object[] fields;
        if (cls.equals(Object.class)) {
            return;
        }
        if (cls.getSuperclass() != null) {
            this.doAutowareObject(object, cls.getSuperclass());
        }
        if (ObjectUtils.isEmpty((Object[])(fields = cls.getDeclaredFields()))) {
            return;
        }
        try {
            for (Object field : fields) {
                Qualifier qualifier = ((Field)field).getAnnotation(Qualifier.class);
                Autowired autowired = ((Field)field).getAnnotation(Autowired.class);
                if (qualifier == null && autowired == null) continue;
                Object value = this.getObjectFieldValue(object, (Field)field, qualifier);
                if (value == null) {
                    if (autowired != null && !autowired.required()) continue;
                    throw new Exception(String.format("\u65e0\u6cd5\u8ba1\u7b97[%1$s][%2$s]\u7684\u503c", object, ((Field)field).getName()));
                }
                if (!((AccessibleObject)field).isAccessible()) {
                    ((Field)field).setAccessible(true);
                }
                if (value instanceof IModelRuntime) {
                    ((Field)field).set(object, value);
                    continue;
                }
                ((Field)field).set(object, this.getRealValue(((Field)field).getType(), value));
            }
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    protected Object getObjectFieldValue(Object object, Field field, Qualifier qualifier) {
        if (qualifier != null) {
            String name = qualifier.value();
            if (StringUtils.hasLength((String)name)) {
                String[] items = name.split("[:]");
                if (items.length == 1) {
                    if (field.getType().getName().equals("java.lang.Class") || field.getType().getName().equals("java.lang.Object")) {
                        return this.getSystemRTGroovyContext().getModelRuntime(items[0], field.getName());
                    }
                    return this.getSystemRTGroovyContext().getModelRuntime(field.getType(), items[0]);
                }
                return this.getSystemRTGroovyContext().getModelRuntime(items[0], items[1]);
            }
            return this.getSystemRTGroovyContext().getModelRuntime(field.getType(), field.getName());
        }
        return this.getSystemRTGroovyContext().getModelRuntime(field.getType(), field.getName());
    }

    protected Object getRealValue(Class<?> type, Object objValue) throws Exception {
        if (type.equals(String.class)) {
            return objValue.toString();
        }
        if (type.equals(BigInteger.class)) {
            return DataTypeUtils.getBigIntegerValue(objValue, null);
        }
        if (type.equals(BigDecimal.class)) {
            return DataTypeUtils.getBigDecimalValue(objValue, null);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return DataTypeUtils.getIntegerValue(objValue, null);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return DataTypeUtils.getLongValue(objValue, null);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return DataTypeUtils.getDoubleValue(objValue, null);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return DataTypeUtils.getDateTimeValue(objValue, null);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            String strValue = objValue.toString();
            return strValue.equalsIgnoreCase("1") || strValue.equalsIgnoreCase("true");
        }
        return objValue;
    }

    @Override
    public IModelRTScript createModelRTScript(Object owner, String strScriptCode) {
        return (IModelRTScript)this.createModelRTScript(owner, strScriptCode, ModelRTScriptBase.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T createModelRTScript(Object owner, String strScriptCode, Class<? extends ModelRTScriptBase> cls) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setScriptBaseClass(cls.getName());
        try (GroovyClassLoader classLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());){
            GroovyShell groovyShell = new GroovyShell((ClassLoader)classLoader, compilerConfiguration);
            Script script = groovyShell.parse(strScriptCode);
            ((ModelRTScriptBase)script).setOwner(owner);
            script.run();
            Script script2 = script;
            return (T)script2;
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5efa\u7acb\u6a21\u578b\u8fd0\u884c\u65f6\u811a\u672c\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    protected void onBeforeStart() throws Exception {
        this.bAutowareObjectList = false;
        if (!ObjectUtils.isEmpty(this.autowareObjectList)) {
            for (Object object : this.autowareObjectList) {
                this.doAutowareObject(object, object.getClass());
            }
            this.autowareObjectList.clear();
        }
        super.onBeforeStart();
    }

    @Override
    protected void onShutdown() throws Exception {
        this.shutdownThreadPoolExecutors();
        super.onShutdown();
    }

    protected class TimerTask {
        public long time;
        public Runnable runnable;
        public IUserContext userContext;
        public Object tag;
        public String name;

        protected TimerTask() {
        }
    }
}

