/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.ibizsys.model.IPSDynaInstService;
import net.ibizsys.model.IPSDynaInstServiceGlobal;
import net.ibizsys.model.IPSDynaInstServiceRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSDynaInstServiceGlobal;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.database.IPSSysDBValueFunc;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.msg.IPSSysMsgQueue;
import net.ibizsys.model.msg.IPSSysMsgTarget;
import net.ibizsys.model.msg.IPSSysMsgTempl;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.model.res.IPSSysSequence;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.ISystemEventListener;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.ModelException;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.SystemUtilRuntimeBase;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.msg.ISysMsgQueueRuntime;
import net.ibizsys.runtime.msg.ISysMsgTargetRuntime;
import net.ibizsys.runtime.msg.ISysMsgTemplRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.res.ISysSFPluginRuntime;
import net.ibizsys.runtime.res.ISysSequenceRuntime;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;
import net.ibizsys.runtime.res.ISysUtilRuntime;
import net.ibizsys.runtime.res.ISysValueFuncRuntime;
import net.ibizsys.runtime.sysutil.ISysFileUtilRuntime;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.ISystemRTScriptContext;
import net.ibizsys.runtime.util.script.ScriptEntity;
import net.ibizsys.runtime.util.script.SystemRTScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SystemRuntimeBase
extends SystemUtilRuntimeBase
implements ISystemRuntime,
IPSDynaInstServiceGlobal {
    private static final Log log = LogFactory.getLog(SystemRuntimeBase.class);
    public static final String VERSION = "8.1.0.472";
    private static Map<String, String> ScriptCodeEngineMap = new HashMap<String, String>();
    private Map<String, IDataEntityRuntime> dataEntityMap = new HashMap<String, IDataEntityRuntime>();
    private IPSSystemService iPSSystemService = null;
    private Map<String, IDynaInstRuntime> dynaInstRuntimeMap = new HashMap<String, IDynaInstRuntime>();
    private ScheduledExecutorService refreshScheduledThreadPool = null;
    private Map<String, IPSDynaInstService> psDynaInstServicehMap = new HashMap<String, IPSDynaInstService>();
    private List<IDynaInstRuntime> checkDynaInstRuntimeList = new ArrayList<IDynaInstRuntime>();
    private int DYNAINST_CHECKTIMER = 30000;
    private ISystemRTScriptContext iSystemRTScriptContext = null;
    private Map<String, ISysUtilRuntime> sysUtilRuntimeMap = null;
    private Map<String, ISysValueFuncRuntime> sysValueFuncRuntimeMap = null;
    private Map<String, ISysSFPluginRuntime> sysSFPluginRuntimeMap = new ConcurrentHashMap<String, ISysSFPluginRuntime>();
    private Map<String, IPSCodeList> psCodeListMap = new HashMap<String, IPSCodeList>();
    private ISysFileUtilRuntime iSysFileUtilRuntime = null;
    private boolean loaded = false;
    private Date loadedDate = null;
    private Map<ISystemEventListener, String[]> systemEventListenerMap = new LinkedHashMap<ISystemEventListener, String[]>();
    private ISystemRuntimeContext iSystemRuntimeContext = new ISystemRuntimeContext(){

        @Override
        public ISystemRuntime getSystemRuntime() {
            return SystemRuntimeBase.this.getSelf();
        }

        @Override
        public IPSSystemService getPSSystemService() {
            return SystemRuntimeBase.this.getSelf().getPSSystemService();
        }
    };

    public SystemRuntimeBase() {
        this.setPSDynaInstServiceGlobal();
    }

    protected void setPSDynaInstServiceGlobal() {
        PSDynaInstServiceGlobal.setInstance((IPSDynaInstServiceGlobal)this);
    }

    private SystemRuntimeBase getSelf() {
        return this;
    }

    @Override
    public ISystemRTScriptContext getSystemRTScriptContext() {
        if (this.iSystemRTScriptContext == null) {
            this.iSystemRTScriptContext = this.createSystemRTScriptContext();
        }
        return this.iSystemRTScriptContext;
    }

    protected ISystemRTScriptContext createSystemRTScriptContext() {
        return new SystemRTScriptContext(this.getSystemRuntimeContext());
    }

    @Override
    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    @Override
    protected ISystemRuntimeBaseContext getSystemRuntimeBaseContext() {
        return this.getSystemRuntimeContext();
    }

    @Override
    public void registerDataEntityRuntime(IDataEntityRuntime iDataEntity) {
        if (StringUtils.hasLength((String)iDataEntity.getId())) {
            this.dataEntityMap.put(iDataEntity.getId(), iDataEntity);
        }
        if (StringUtils.hasLength((String)iDataEntity.getName())) {
            this.dataEntityMap.put(iDataEntity.getName().toLowerCase(), iDataEntity);
        }
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime(String strIdOrName) {
        return this.getDataEntityRuntime(strIdOrName, false);
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime(String strIdOrName, boolean bTryMode) {
        IDataEntityRuntime iDataEntity = this.dataEntityMap.get(strIdOrName);
        if (iDataEntity == null && (iDataEntity = this.dataEntityMap.get(strIdOrName.toLowerCase())) == null && !bTryMode) {
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strIdOrName));
        }
        return iDataEntity;
    }

    @Override
    public String getId() {
        return "PSSYSTEM.json";
    }

    @Override
    public String getName() {
        return "\u7cfb\u7edf";
    }

    @Override
    public IPSSystemService getPSSystemService() {
        try {
            if (this.iPSSystemService == null) {
                IPSSystemService iPSSystemService;
                this.iPSSystemService = iPSSystemService = this.createPSSystemService();
                this.prepareSysSFPluginRuntimes();
                this.prepareThreadPoolExecutors();
                this.onInit();
                this.onBeforeStart();
                this.onStart();
                this.onAfterStart();
                this.markLoaded();
            }
            return this.iPSSystemService;
        }
        catch (Exception ex) {
            this.iPSSystemService = null;
            this.refreshScheduledThreadPool = null;
            log.error((Object)String.format("\u83b7\u53d6\u6838\u5fc3\u7cfb\u7edf\u6a21\u578b\u670d\u52a1\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u83b7\u53d6\u6838\u5fc3\u7cfb\u7edf\u6a21\u578b\u670d\u52a1\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void setPSSystemService(IPSSystemService iPSSystemService) {
        this.iPSSystemService = iPSSystemService;
    }

    @Override
    protected void onInit() throws Exception {
        List psSysDBValueFuncs;
        List psSysUtils;
        super.onInit();
        List psCodeLists = this.getPSSystem().getAllPSCodeLists();
        if (psCodeLists != null) {
            for (IPSCodeList iPSCodeList : psCodeLists) {
                this.psCodeListMap.put(iPSCodeList.getDynaModelFilePath(), iPSCodeList);
                if (!StringUtils.hasLength((String)iPSCodeList.getCodeListTag())) continue;
                this.psCodeListMap.put(iPSCodeList.getCodeListTag(), iPSCodeList);
            }
        }
        if ((psSysUtils = this.getPSSystem().getAllPSSysUtils()) != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                this.registerPSSysUtil(iPSSysUtil);
            }
        }
        if (this.getSysFileUtilRuntime(true) == null) {
            this.setSysFileUtilRuntime(this.registerDefaultSysFileUtilRuntime());
        }
        if ((psSysDBValueFuncs = this.getPSSystem().getAllPSSysDBValueFuncs()) != null) {
            for (IPSSysDBValueFunc iPSSysDBValueFunc : psSysDBValueFuncs) {
                this.registerPSSysValueFunc(iPSSysDBValueFunc);
            }
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    protected void markLoaded() throws Exception {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        this.loadedDate = new Date();
        this.onLoad();
        this.fireSystemEvent("LOAD", null);
    }

    @Override
    public Date getLoadedDate() {
        return this.loadedDate;
    }

    protected void prepareSysSFPluginRuntimes() throws Exception {
        List psSysSFPlugins = this.getPSSystem().getAllPSSysSFPlugins();
        if (psSysSFPlugins != null) {
            final LinkedHashMap taskRetMap = new LinkedHashMap();
            ArrayList<CompletableFuture<Void>> taskList = new ArrayList<CompletableFuture<Void>>();
            Iterator<Object> iterator = psSysSFPlugins.iterator();
            while (iterator.hasNext()) {
                final IPSSysSFPlugin iPSSysSFPlugin = (IPSSysSFPlugin)iterator.next();
                CompletableFuture<Void> task = CompletableFuture.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SystemRuntimeBase.this.registerPSSysSFPlugin(iPSSysSFPlugin);
                        }
                        catch (Throwable ex) {
                            log.error((Object)String.format("\u6ce8\u518c\u540e\u53f0\u63d2\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysSFPlugin.getName(), ex.getMessage()), ex);
                            taskRetMap.put(iPSSysSFPlugin, ex);
                        }
                    }
                });
                taskList.add(task);
            }
            try {
                CompletableFuture.allOf(taskList.toArray(new CompletableFuture[taskList.size()])).get();
            }
            catch (Exception ex) {
                throw new Exception(String.format("\u51c6\u5907\u540e\u53f0\u63d2\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            if (taskRetMap.size() > 0 && (iterator = taskRetMap.entrySet().iterator()).hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                throw new Exception(String.format("\u6ce8\u518c\u540e\u53f0\u63d2\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", ((IPSSysSFPlugin)entry.getKey()).getName(), ((Throwable)entry.getValue()).getMessage()), (Throwable)entry.getValue());
            }
        }
    }

    @Override
    public ISysUtilRuntime getSysUtilRuntime(String strTag) {
        return this.getSysUtilRuntime(strTag, false);
    }

    @Override
    public ISysUtilRuntime getSysUtilRuntime(String strTag, boolean bTryMode) {
        ISysUtilRuntime iSysUtilRuntime = null;
        if (this.sysUtilRuntimeMap != null && (iSysUtilRuntime = this.sysUtilRuntimeMap.get(strTag)) == null) {
            iSysUtilRuntime = this.sysUtilRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysUtilRuntime != null || bTryMode) {
            return iSysUtilRuntime;
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", strTag));
    }

    @Override
    public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode) {
        if (this.sysUtilRuntimeMap != null) {
            for (ISysUtilRuntime iSysUtilRuntime : this.sysUtilRuntimeMap.values()) {
                if (!cls.isAssignableFrom(iSysUtilRuntime.getClass())) continue;
                return (T)iSysUtilRuntime;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", cls.getCanonicalName()));
    }

    protected ISysUtilRuntime registerPSSysUtil(IPSSysUtil iPSSysUtil) throws Exception {
        ISysUtilRuntime iSysUtilRuntime;
        if (this.sysUtilRuntimeMap != null && (iSysUtilRuntime = this.sysUtilRuntimeMap.get(iPSSysUtil.getId())) != null) {
            return iSysUtilRuntime;
        }
        iSysUtilRuntime = this.createSysUtilRuntime(iPSSysUtil);
        if (iSysUtilRuntime == null) {
            return null;
        }
        try {
            iSysUtilRuntime.init(this.getSystemRuntimeContext(), iPSSysUtil);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysUtil.getName(), ex.getMessage()), ex);
        }
        if (this.sysUtilRuntimeMap == null) {
            this.sysUtilRuntimeMap = new ConcurrentHashMap<String, ISysUtilRuntime>();
        }
        this.sysUtilRuntimeMap.put(iPSSysUtil.getId(), iSysUtilRuntime);
        if (!"USER".equals(iPSSysUtil.getUtilType())) {
            this.sysUtilRuntimeMap.put(iPSSysUtil.getUtilType(), iSysUtilRuntime);
        }
        if (StringUtils.hasLength((String)iPSSysUtil.getCodeName())) {
            String strTag = null;
            strTag = iPSSysUtil.getPSSystemModule() != null ? PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysUtil.getPSSystemModule(), (String)iPSSysUtil.getCodeName()) : PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysUtil.getPSSysModelGroup(), (String)iPSSysUtil.getCodeName());
            if (this.sysUtilRuntimeMap.containsKey(strTag)) {
                log.warn((Object)String.format("\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6[%1$s]\u552f\u4e00\u6807\u8bb0[%2$s]\u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u6ce8\u518c", iPSSysUtil.getName(), strTag));
            } else {
                this.sysUtilRuntimeMap.put(strTag, iSysUtilRuntime);
            }
        }
        if (iSysUtilRuntime instanceof ISysFileUtilRuntime && this.getSysFileUtilRuntime(true) == null) {
            this.setSysFileUtilRuntime((ISysFileUtilRuntime)iSysUtilRuntime);
        }
        return iSysUtilRuntime;
    }

    @Override
    public ISysValueFuncRuntime getSysValueFuncRuntime(String strTag) {
        if (this.sysValueFuncRuntimeMap == null) {
            return null;
        }
        return this.sysValueFuncRuntimeMap.get(strTag);
    }

    protected ISysValueFuncRuntime registerPSSysValueFunc(IPSSysDBValueFunc iPSSysDBValueFunc) throws Exception {
        ISysValueFuncRuntime iSysValueFuncRuntime;
        if (this.sysValueFuncRuntimeMap != null && (iSysValueFuncRuntime = this.sysValueFuncRuntimeMap.get(iPSSysDBValueFunc.getId())) != null) {
            return iSysValueFuncRuntime;
        }
        iSysValueFuncRuntime = this.createSysValueFuncRuntime(iPSSysDBValueFunc);
        if (iSysValueFuncRuntime == null) {
            return null;
        }
        iSysValueFuncRuntime.init(this, iPSSysDBValueFunc);
        if (this.sysValueFuncRuntimeMap == null) {
            this.sysValueFuncRuntimeMap = new HashMap<String, ISysValueFuncRuntime>();
        }
        this.sysValueFuncRuntimeMap.put(iPSSysDBValueFunc.getCodeName().toUpperCase(), iSysValueFuncRuntime);
        return iSysValueFuncRuntime;
    }

    @Override
    public ISysSFPluginRuntime getSysSFPluginRuntime(String strTag) {
        return this.getSysSFPluginRuntime(strTag, false);
    }

    @Override
    public ISysSFPluginRuntime getSysSFPluginRuntime(String strTag, boolean bTryMode) {
        ISysSFPluginRuntime iSysSFPluginRuntime = null;
        if (StringUtils.hasLength((String)strTag) && !ObjectUtils.isEmpty(this.sysSFPluginRuntimeMap) && (iSysSFPluginRuntime = this.sysSFPluginRuntimeMap.get(strTag)) == null) {
            iSysSFPluginRuntime = this.sysSFPluginRuntimeMap.get(strTag.toLowerCase());
        }
        if (iSysSFPluginRuntime != null || bTryMode) {
            return iSysSFPluginRuntime;
        }
        throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u63d2\u4ef6\uff0c\u6807\u8bc6\u4e3a[%1$s]", strTag));
    }

    protected ISysSFPluginRuntime registerPSSysSFPlugin(IPSSysSFPlugin iPSSysSFPlugin) throws Exception {
        String strTag;
        ISysSFPluginRuntime iSysSFPluginRuntime;
        if (!ObjectUtils.isEmpty(this.sysSFPluginRuntimeMap) && (iSysSFPluginRuntime = this.sysSFPluginRuntimeMap.get(iPSSysSFPlugin.getId())) != null) {
            return iSysSFPluginRuntime;
        }
        iSysSFPluginRuntime = this.createSysSFPluginRuntime(iPSSysSFPlugin);
        Assert.notNull((Object)iSysSFPluginRuntime, (String)"\u7cfb\u7edf\u63d2\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        iSysSFPluginRuntime.init(this.getSystemRuntimeContext(), iPSSysSFPlugin);
        this.sysSFPluginRuntimeMap.put(iPSSysSFPlugin.getId(), iSysSFPluginRuntime);
        if (StringUtils.hasLength((String)iPSSysSFPlugin.getPluginCode()) && !this.sysSFPluginRuntimeMap.containsKey(strTag = PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysSFPlugin.getPSSystemModule(), (String)iPSSysSFPlugin.getPluginCode()))) {
            this.sysSFPluginRuntimeMap.put(strTag, iSysSFPluginRuntime);
        }
        if (iPSSysSFPlugin.isReplaceDefault()) {
            if (!StringUtils.hasLength((String)iPSSysSFPlugin.getPluginCode())) {
                throw new ModelException((IPSModelObject)iPSSysSFPlugin, String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u8bbe\u7f6e\u4e3a\u5168\u5c40\u9ed8\u8ba4\u4f46\u672a\u6307\u5b9a\u63d2\u4ef6\u6807\u8bc6", iPSSysSFPlugin.getPluginCode()));
            }
            this.sysSFPluginRuntimeMap.put(iPSSysSFPlugin.getPluginCode(), iSysSFPluginRuntime);
        }
        return iSysSFPluginRuntime;
    }

    @Override
    public ISysSFPluginRuntime reloadSysSFPluginRuntime(IPSSysSFPlugin iPSSysSFPlugin) {
        Assert.notNull((Object)iPSSysSFPlugin, (String)"\u4f20\u5165\u540e\u53f0\u63d2\u4ef6\u5bf9\u8c61\u65e0\u6548");
        Assert.hasLength((String)iPSSysSFPlugin.getId(), (String)"\u4f20\u5165\u540e\u53f0\u63d2\u4ef6\u5bf9\u8c61\u6807\u8bc6\u65e0\u6548");
        if (!ObjectUtils.isEmpty(this.sysSFPluginRuntimeMap)) {
            this.sysSFPluginRuntimeMap.remove(iPSSysSFPlugin.getId());
        }
        try {
            return this.registerPSSysSFPlugin(iPSSysSFPlugin);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u6ce8\u518c\u7cfb\u7edf\u63d2\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysSFPlugin.getName(), ex.getMessage()), ex);
        }
    }

    @Override
    public Collection<ISysSFPluginRuntime> getSysSFPluginRuntimes() {
        if (ObjectUtils.isEmpty(this.sysSFPluginRuntimeMap)) {
            return null;
        }
        HashSet<ISysSFPluginRuntime> list = new HashSet<ISysSFPluginRuntime>();
        for (ISysSFPluginRuntime iSysSFPlugRuntime : this.sysSFPluginRuntimeMap.values()) {
            list.add(iSysSFPlugRuntime);
        }
        return list;
    }

    @Override
    protected void onStart() throws Exception {
        if (this.refreshScheduledThreadPool == null) {
            this.refreshScheduledThreadPool = Executors.newScheduledThreadPool(1);
            this.refreshScheduledThreadPool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    SystemRuntimeBase.this.checkDynaInstRuntimes();
                }
            }, 30L, 5L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDynaInstRuntimes() {
        int nCount = 50;
        while (nCount > 0) {
            --nCount;
            IDynaInstRuntime iDynaInstRuntime = null;
            List<IDynaInstRuntime> list = this.checkDynaInstRuntimeList;
            synchronized (list) {
                if (this.checkDynaInstRuntimeList.size() > 0) {
                    iDynaInstRuntime = this.checkDynaInstRuntimeList.remove(0);
                }
            }
            if (iDynaInstRuntime == null) break;
            try {
                if (!iDynaInstRuntime.check() || !this.checkDynaInstRuntime(iDynaInstRuntime)) {
                    this.psDynaInstServicehMap.remove(iDynaInstRuntime.getId());
                    this.dynaInstRuntimeMap.remove(iDynaInstRuntime.getId());
                    log.debug((Object)String.format("\u52a8\u6001\u5b9e\u4f8b\u8fd0\u884c\u65f6[%1$s]\u7248\u672c\u5df2\u53d8\u5316\uff0c\u6267\u884c\u79fb\u9664", iDynaInstRuntime.getId()));
                    this.logEvent(20000, "\u52a8\u6001\u5b9e\u4f8b\u5378\u8f7d", String.format("\u52a8\u6001\u5b9e\u4f8b\u8fd0\u884c\u65f6[%1$s][%2$s]\u7248\u672c\u5df2\u53d8\u5316\uff0c\u6267\u884c\u79fb\u9664", iDynaInstRuntime.getName(), iDynaInstRuntime.getId()), null);
                    continue;
                }
                iDynaInstRuntime.markChecked();
            }
            catch (RuntimeException ex) {
                log.error((Object)String.format("\u68c0\u67e5\u52a8\u6001\u5b9e\u4f8b\u662f\u5426\u8fc7\u671f\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
                List<IDynaInstRuntime> list2 = this.checkDynaInstRuntimeList;
                synchronized (list2) {
                    this.checkDynaInstRuntimeList.clear();
                }
            }
        }
    }

    protected boolean checkDynaInstRuntime(IDynaInstRuntime iDynaInstRuntime) {
        return true;
    }

    protected abstract IPSSystemService createPSSystemService() throws Exception;

    protected abstract IPSDynaInstService createPSDynaInstService(String var1) throws Exception;

    @Override
    public IPSSystem getPSSystem() {
        return this.getPSSystemService().getPSSystem();
    }

    @Override
    public void refreshDynaInst(String strDynaInstId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDynaInstRuntime getDynaInstRuntime(String strDynaInstId) {
        IDynaInstRuntime iDynaInstRuntime = this.dynaInstRuntimeMap.get(strDynaInstId);
        if (iDynaInstRuntime == null) {
            IPSDynaInstService iPSDynaInstService;
            try {
                iPSDynaInstService = this.createPSDynaInstService(strDynaInstId);
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5efa\u7acb\u52a8\u6001\u5b9e\u4f8b\u6a21\u578b\u670d\u52a1\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            IDynaInstRuntime iDynaInstRuntime2 = this.createDynaInstRuntime();
            try {
                iDynaInstRuntime2.init(iPSDynaInstService, this.getSystemRuntimeContext());
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u52a8\u6001\u5b9e\u4f8b\u6a21\u578b\u670d\u52a1\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            iDynaInstRuntime = this.dynaInstRuntimeMap.get(strDynaInstId);
            if (iDynaInstRuntime == null) {
                this.dynaInstRuntimeMap.put(strDynaInstId, iDynaInstRuntime2);
                iDynaInstRuntime = iDynaInstRuntime2;
            }
            iDynaInstRuntime.markChecked();
            this.logEvent(20000, "\u52a8\u6001\u5b9e\u4f8b\u6302\u8f7d", String.format("\u52a8\u6001\u5b9e\u4f8b\u8fd0\u884c\u65f6[%1$s][%2$s]\u5df2\u6302\u8f7d", iDynaInstRuntime.getName(), iDynaInstRuntime.getId()), null);
        } else if (System.currentTimeMillis() - iDynaInstRuntime.getLastCheckTime() > (long)this.DYNAINST_CHECKTIMER) {
            iDynaInstRuntime.markChecked();
            List<IDynaInstRuntime> list = this.checkDynaInstRuntimeList;
            synchronized (list) {
                this.checkDynaInstRuntimeList.add(iDynaInstRuntime);
            }
        }
        iDynaInstRuntime.active();
        return iDynaInstRuntime;
    }

    public IPSDynaInstService getCachePSDynaInstService(String strPSDynaInstId) {
        return this.psDynaInstServicehMap.get(strPSDynaInstId);
    }

    public IPSDynaInstService getPSDynaInstService(String strPSDynaInstId, boolean bReload) throws Exception {
        IPSDynaInstService iPSDynaInstService = null;
        if (!bReload && (iPSDynaInstService = this.psDynaInstServicehMap.get(strPSDynaInstId)) != null) {
            return iPSDynaInstService;
        }
        iPSDynaInstService = this.createPSDynaInstService(strPSDynaInstId);
        if (iPSDynaInstService instanceof IPSDynaInstServiceRuntime) {
            IPSDynaInstServiceRuntime iPSModelServiceRuntime = (IPSDynaInstServiceRuntime)iPSDynaInstService;
            iPSModelServiceRuntime.setPSDynaInstId(strPSDynaInstId);
            iPSModelServiceRuntime.setPSSystemService(this.getPSSystemService());
        }
        iPSDynaInstService.getPSSystem();
        this.psDynaInstServicehMap.put(strPSDynaInstId, iPSDynaInstService);
        return iPSDynaInstService;
    }

    public void resetPSDynaInstService(String strPSDynaInstId) {
        this.psDynaInstServicehMap.remove(strPSDynaInstId);
    }

    @Override
    public void log(int nLogLevel, String strCat, String strInfo, Object objData) {
    }

    @Override
    public void info(Object cat, String strInfo) {
        Assert.notNull((Object)cat, (String)"\u672a\u4f20\u5165\u65e5\u5fd7\u5206\u7c7b");
        if (cat instanceof String) {
            this.log(20000, (String)cat, strInfo, null);
        } else {
            this.log(20000, cat.getClass().getName(), strInfo, null);
        }
    }

    @Override
    public void warn(Object cat, String strInfo) {
        Assert.notNull((Object)cat, (String)"\u672a\u4f20\u5165\u65e5\u5fd7\u5206\u7c7b");
        if (cat instanceof String) {
            this.log(30000, (String)cat, strInfo, null);
        } else {
            this.log(30000, cat.getClass().getName(), strInfo, null);
        }
    }

    @Override
    public void error(Object cat, String strInfo) {
        Assert.notNull((Object)cat, (String)"\u672a\u4f20\u5165\u65e5\u5fd7\u5206\u7c7b");
        if (cat instanceof String) {
            this.log(40000, (String)cat, strInfo, null);
        } else {
            this.log(40000, cat.getClass().getName(), strInfo, null);
        }
    }

    @Override
    public void logAudit(int nLogLevel, String strCat, String strInfo, String strPersonId, String strAddress, Object objData) {
    }

    @Override
    public void logEvent(int nLogLevel, String strCat, String strInfo, Object objData) {
    }

    @Override
    public void logPO(int nLogLevel, String strCat, String strInfo, String strDEName, String strAction, long nTime, Object objData) {
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSystem();
    }

    @Override
    public <T> T getRuntimeObject(IPSSysSFPlugin iPSSysSFPlugin, Class<T> cls, boolean bNewInstance) {
        if (iPSSysSFPlugin == null || !StringUtils.hasLength((String)iPSSysSFPlugin.getId())) {
            return null;
        }
        return this.getRuntimeObject(iPSSysSFPlugin.getId(), cls, bNewInstance, false);
    }

    @Override
    public <T> T getRuntimeObject(String strPluginTag, Class<T> cls, boolean bNewInstance, boolean bTryMode) {
        ISysSFPluginRuntime iSysSFPluginRuntime = this.getSysSFPluginRuntime(strPluginTag, bTryMode);
        if (iSysSFPluginRuntime == null || !iSysSFPluginRuntime.isRuntimePlugin()) {
            return null;
        }
        try {
            return iSysSFPluginRuntime.getRuntimeObject(cls, bNewInstance);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u63d2\u4ef6[%1$s]\u83b7\u53d6\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iSysSFPluginRuntime.getName(), ex.getMessage()), ex);
        }
    }

    protected int getDataEntityStorageMode(IPSDataEntity iPSDataEntity) {
        return iPSDataEntity.getStorageMode();
    }

    @Override
    public ICodeListRuntime getCodeListRuntime(String strTag) {
        return this.getCodeListRuntime(strTag, false);
    }

    @Override
    public ICodeListRuntime getCodeListRuntime(String strTag, boolean bTryMode) {
        IPSCodeList iPSCodeList = this.psCodeListMap.get(strTag);
        if (iPSCodeList == null) {
            if (bTryMode) {
                return null;
            }
            throw new SystemRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u4ee3\u7801\u8868[%1$s]\u6a21\u578b\u5bf9\u8c61", strTag));
        }
        return this.getCodeListRuntime(iPSCodeList);
    }

    @Override
    public ISysFileUtilRuntime getSysFileUtilRuntime() {
        return this.getSysFileUtilRuntime(false);
    }

    @Override
    public ISysFileUtilRuntime getSysFileUtilRuntime(boolean bTryMode) {
        if (this.iSysFileUtilRuntime != null || bTryMode) {
            return this.iSysFileUtilRuntime;
        }
        throw new SystemRuntimeException(this, String.format("\u7cfb\u7edf\u672a\u63d0\u4f9b\u9ed8\u8ba4\u6587\u4ef6\u5b58\u50a8\u529f\u80fd\u7ec4\u4ef6", new Object[0]));
    }

    protected void setSysFileUtilRuntime(ISysFileUtilRuntime iSysFileUtilRuntime) {
        this.iSysFileUtilRuntime = iSysFileUtilRuntime;
    }

    protected ISysFileUtilRuntime registerDefaultSysFileUtilRuntime() throws Exception {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("id", "FILE");
        objectNode.put("name", "FILE");
        objectNode.put("utilType", "FILE");
        objectNode.put("codeName", "FILE");
        IPSSysUtil iPSSysUtil = (IPSSysUtil)this.getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSSystem(), IPSSysUtil.class, objectNode);
        ISysUtilRuntime iSysUtilRuntime = this.registerPSSysUtil(iPSSysUtil);
        if (iSysUtilRuntime instanceof ISysFileUtilRuntime) {
            return (ISysFileUtilRuntime)iSysUtilRuntime;
        }
        throw new SystemRuntimeException(this, String.format("\u9ed8\u8ba4\u6587\u4ef6\u5b58\u50a8\u529f\u80fd\u7ec4\u4ef6\u5bf9\u8c61\u7c7b\u578b\u4e0d\u6b63\u786e", new Object[0]));
    }

    @Override
    public IScriptEntity createScriptEntity(IEntity iEntity) {
        return new ScriptEntity(this, iEntity);
    }

    @Override
    public ISysLogicRuntime getSysLogicRuntime(String strTag, boolean bTryMode) {
        IPSSysLogic iPSSysLogic = this.getPSSystemService().getPSSysLogic(strTag, bTryMode);
        if (iPSSysLogic != null) {
            return super.getSysLogicRuntime(iPSSysLogic);
        }
        return null;
    }

    @Override
    public ISysTranslatorRuntime getSysTranslatorRuntime(String strTag, boolean bTryMode) {
        IPSSysTranslator iPSSysTranslator = this.getPSSystemService().getPSSysTranslator(strTag, bTryMode);
        if (iPSSysTranslator != null) {
            return super.getSysTranslatorRuntime(iPSSysTranslator);
        }
        return null;
    }

    @Override
    public ISysSequenceRuntime getSysSequenceRuntime(String strTag, boolean bTryMode) {
        IPSSysSequence iPSSysSequence = this.getPSSystemService().getPSSysSequence(strTag, bTryMode);
        if (iPSSysSequence != null) {
            return super.getSysSequenceRuntime(iPSSysSequence);
        }
        return null;
    }

    @Override
    public ISysDataSyncAgentRuntime getSysDataSyncAgentRuntime(String strTag, boolean bTryMode) {
        IPSSysDataSyncAgent iPSSysDataSyncAgent = this.getPSSystemService().getPSSysDataSyncAgent(strTag, bTryMode);
        if (iPSSysDataSyncAgent != null) {
            return super.getSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
        }
        return null;
    }

    @Override
    public ISysMsgTemplRuntime getSysMsgTemplRuntime(String strTag, boolean bTryMode) {
        IPSSysMsgTempl iPSSysMsgTempl = this.getPSSystemService().getPSSysMsgTempl(strTag, bTryMode);
        if (iPSSysMsgTempl != null) {
            return super.getSysMsgTemplRuntime(iPSSysMsgTempl);
        }
        return null;
    }

    @Override
    public ISysMsgTargetRuntime getSysMsgTargetRuntime(String strTag, boolean bTryMode) {
        IPSSysMsgTarget iPSSysMsgTarget = this.getPSSystemService().getPSSysMsgTarget(strTag, bTryMode);
        if (iPSSysMsgTarget != null) {
            return super.getSysMsgTargetRuntime(iPSSysMsgTarget);
        }
        return null;
    }

    @Override
    public ISysMsgQueueRuntime getSysMsgQueueRuntime(String strTag, boolean bTryMode) {
        IPSSysMsgQueue iPSSysMsgQueue = this.getPSSystemService().getPSSysMsgQueue(strTag, bTryMode);
        if (iPSSysMsgQueue != null) {
            return super.getSysMsgQueueRuntime(iPSSysMsgQueue);
        }
        return null;
    }

    @Override
    public synchronized void registerSystemEventListener(ISystemEventListener listener) {
        this.registerSystemEventListener(listener, null);
    }

    @Override
    public synchronized void registerSystemEventListener(ISystemEventListener listener, String[] events) {
        LinkedHashMap<ISystemEventListener, String[]> map = new LinkedHashMap<ISystemEventListener, String[]>();
        map.putAll(this.systemEventListenerMap);
        map.put(listener, events);
        this.systemEventListenerMap = map;
    }

    @Override
    public synchronized void unregisterSystemEventListener(ISystemEventListener listener) {
        LinkedHashMap<ISystemEventListener, String[]> map = new LinkedHashMap<ISystemEventListener, String[]>();
        map.putAll(this.systemEventListenerMap);
        map.remove(listener);
        this.systemEventListenerMap = map;
    }

    public void fireSystemEvent(final String event, final Object[] params) {
        Map<ISystemEventListener, String[]> map = this.systemEventListenerMap;
        for (final Map.Entry<ISystemEventListener, String[]> entry : map.entrySet()) {
            boolean match = true;
            if (!ObjectUtils.isEmpty((Object[])entry.getValue())) {
                match = false;
                for (String item : entry.getValue()) {
                    if (!event.equalsIgnoreCase(item)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            Executor executor = entry.getKey().getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((ISystemEventListener)entry.getKey()).receiveEvent(event, params);
                    }
                });
                continue;
            }
            try {
                entry.getKey().receiveEvent(event, params);
            }
            catch (Throwable ex) {
                log.error((Object)ex);
            }
        }
    }

    @Override
    public String getScriptEngine(String strScriptCode) {
        if (StringUtils.hasLength((String)strScriptCode)) {
            for (Map.Entry<String, String> entry : ScriptCodeEngineMap.entrySet()) {
                if (strScriptCode.indexOf(entry.getKey()) != 0) continue;
                return entry.getValue();
            }
        }
        return this.getDefaultScriptEngine();
    }

    @Override
    public String getDefaultScriptEngine() {
        return "JavaScript";
    }

    static {
        ScriptCodeEngineMap.put("/*Groovy*/", "Groovy");
        ScriptCodeEngineMap.put("//Groovy", "Groovy");
        ScriptCodeEngineMap.put("/*JavaScript*/", "JavaScript");
        ScriptCodeEngineMap.put("//JavaScript", "JavaScript");
    }
}

