/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util.script;

import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.service.client.WebClientRepEntity;
import net.ibizsys.central.util.script.IScriptWebClient;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.ScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptWebClient
implements IScriptWebClient {
    private ISystemRuntime iSystemRuntime = null;
    private IModelRuntime iModelRuntime = null;
    private IWebClient iWebClient = null;

    public ScriptWebClient(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime, IWebClient iWebClient) {
        this.iSystemRuntime = iSystemRuntime;
        this.iModelRuntime = iModelRuntime;
        this.iWebClient = iWebClient;
    }

    protected ISystemRuntime getSystemRuntime() {
        return this.iSystemRuntime;
    }

    protected IModelRuntime getModelRuntime() {
        return this.iModelRuntime;
    }

    protected IWebClient getWebClient() {
        return this.iWebClient;
    }

    @Override
    public String getServiceUrl() {
        return this.getWebClient().getServiceUrl();
    }

    @Override
    public IScriptEntity get(Object param) {
        return this.execute("GET", param);
    }

    @Override
    public IScriptEntity post(Object param) {
        return this.execute("POST", param);
    }

    @Override
    public IScriptEntity head(Object param) {
        return this.execute("HEAD", param);
    }

    @Override
    public IScriptEntity put(Object param) {
        return this.execute("PUT", param);
    }

    @Override
    public IScriptEntity patch(Object param) {
        return this.execute("PATCH", param);
    }

    @Override
    public IScriptEntity delete(Object param) {
        return this.execute("DELETE", param);
    }

    @Override
    public IScriptEntity options(Object param) {
        return this.execute("OPTIONS", param);
    }

    @Override
    public IScriptEntity trace(Object param) {
        return this.execute("TRACE", param);
    }

    @Override
    public IScriptEntity upload(Object param) {
        return this.execute("UPLOAD", param);
    }

    @Override
    public IScriptEntity download(Object param) {
        return this.execute("DOWNLOAD", param);
    }

    @Override
    public IScriptEntity execute(String strMethod, Object param) {
        Assert.hasLength((String)strMethod, (String)"\u672a\u4f20\u5165\u8bf7\u6c42\u65b9\u5f0f");
        return this.onExecute(strMethod, param);
    }

    protected IScriptEntity onExecute(String strMethod, Object param) {
        if ((param = ScriptUtils.getReal(param)) == null) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getModelRuntime(), String.format("\u4f20\u5165\u53c2\u6570\u65e0\u6548", new Object[0]));
        }
        String strUri = null;
        Map uriParams = null;
        Map headers = null;
        Map queries = null;
        Object objBody = null;
        Object objTag = null;
        String strContentType = null;
        if (param instanceof String) {
            strUri = (String)param;
        } else if (param instanceof Map) {
            Map map = (Map)param;
            Object obj = map.get("uri");
            if (obj instanceof String) {
                strUri = (String)obj;
            } else {
                obj = map.get("url");
                if (obj instanceof String) {
                    strUri = (String)obj;
                }
            }
            obj = map.get("param");
            if (obj instanceof Map && (uriParams = (Map)obj).size() == 0) {
                uriParams = null;
            }
            if ((obj = map.get("header")) instanceof Map && (headers = (Map)obj).size() == 0) {
                headers = null;
            }
            if ((obj = map.get("query")) instanceof Map && (queries = (Map)obj).size() == 0) {
                queries = null;
            }
            if ((obj = map.get("contenttype")) instanceof String) {
                strContentType = (String)obj;
            }
            objBody = map.get("body");
            objTag = map.get("tag");
        } else {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getModelRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u4f20\u5165\u53c2\u6570", new Object[0]));
        }
        if (!StringUtils.hasLength((String)strUri)) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getModelRuntime(), String.format("\u672a\u4f20\u5165\u8fdc\u7a0b\u8def\u5f84", new Object[0]));
        }
        try {
            if ("GET".equalsIgnoreCase(strMethod)) {
                if (queries == null && objBody instanceof Map) {
                    queries = objBody;
                }
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().get(strUri, uriParams, headers, queries, String.class, objTag)));
            }
            if ("POST".equalsIgnoreCase(strMethod)) {
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().post(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag)));
            }
            if ("PUT".equalsIgnoreCase(strMethod)) {
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().put(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag)));
            }
            if ("PATCH".equalsIgnoreCase(strMethod)) {
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().patch(strUri, uriParams, headers, queries, objBody, strContentType, String.class, objTag)));
            }
            if ("DELETE".equalsIgnoreCase(strMethod)) {
                if (queries == null && objBody instanceof Map) {
                    queries = objBody;
                }
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().delete(strUri, uriParams, headers, queries, String.class, objTag)));
            }
            if ("HEAD".equalsIgnoreCase(strMethod)) {
                if (queries == null && objBody instanceof Map) {
                    queries = objBody;
                }
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().head(strUri, uriParams, headers, queries, String.class, objTag)));
            }
            if ("UPLOAD".equalsIgnoreCase(strMethod)) {
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().upload(strUri, uriParams, headers, queries, objBody, objTag)));
            }
            if ("DOWNLOAD".equalsIgnoreCase(strMethod)) {
                return this.getSystemRuntime().createScriptEntity(WebClientRepEntity.from(this.getWebClient().download(strUri, uriParams, headers, queries, objBody, objTag)));
            }
            throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8bf7\u6c42\u65b9\u5f0f[%1$s]", strMethod));
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), this.getModelRuntime(), ex.getMessage(), ex);
        }
    }
}

