/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.ds.IDEFilterDTORuntime;
import net.ibizsys.central.dataentity.service.IDEMethodDTORuntime;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.PageRequest;
import net.ibizsys.central.util.SearchGroupCond;
import net.ibizsys.runtime.util.EntityBase;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.SearchCustomCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import net.ibizsys.runtime.util.SearchPredefinedCond;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SimpleSearchContextDTO
extends EntityBase
implements ISearchContextDTO {
    @JsonIgnore
    private Pageable pageable = null;
    @JsonIgnore
    private Sort sort = null;
    @JsonIgnore
    private boolean bCount = true;
    @JsonIgnore
    private List<ISearchCond> searchCondList = null;

    public SimpleSearchContextDTO() {
    }

    public SimpleSearchContextDTO(Map map) throws Exception {
        this.init(null, map, true);
    }

    @Override
    public void init(IDEMethodDTORuntime iDEMethodDTORuntime, Object objData, boolean bDTOData) throws Exception {
        if (!bDTOData) {
            throw new Exception(String.format("\u4ec5\u652f\u6301\u4f20\u5165DTO", new Object[0]));
        }
        if (objData instanceof Map) {
            Map map = (Map)objData;
            this.setAny(map, true);
        }
        this.onInit();
    }

    protected void onInit() throws Exception {
        List<Sort.Order> list;
        Object size = this.get("size");
        Object page = this.get("page");
        Object offset = this.get("offset");
        Object sortinfo = this.get("sort");
        Object searchConds = this.get("searchconds");
        this.reset("size");
        this.reset("page");
        this.reset("offset");
        this.reset("sort");
        this.reset("searchconds");
        int nSize = 20;
        if (size != null && ((nSize = Integer.valueOf(size.toString()).intValue()) <= 0 || nSize >= 1000)) {
            nSize = 20;
        }
        long nOffset = 0L;
        if (offset != null && (nOffset = Long.valueOf(offset.toString()).longValue()) < 0L) {
            nOffset = 0L;
        }
        int nPage = 0;
        if (page != null && (nPage = Integer.valueOf(page.toString()).intValue()) < 0) {
            nPage = 0;
        }
        if (sortinfo instanceof String) {
            String strSortInfo = (String)sortinfo;
            if (StringUtils.hasLength((String)(strSortInfo = strSortInfo.trim()))) {
                list = new ArrayList();
                String[] items = strSortInfo.split("[,]");
                if (items.length == 1) {
                    list.add(Sort.Order.asc((String)items[0].trim()));
                } else if (items.length == 2) {
                    if ("DESC".equalsIgnoreCase(items[1].trim())) {
                        list.add(Sort.Order.desc((String)items[0].trim()));
                    } else {
                        list.add(Sort.Order.asc((String)items[0].trim()));
                    }
                }
                if (list.size() > 0) {
                    this.sort = Sort.by(list);
                }
            }
        }
        this.pageable = PageRequest.of(nPage, nSize, nOffset);
        Object count = this.get("count");
        this.reset("count");
        if (count != null && count.toString().equalsIgnoreCase("false")) {
            this.setCount(false);
        }
        if (searchConds instanceof List) {
            list = (List)searchConds;
            for (Object e : list) {
                ISearchCond iSearchCond;
                if (!(e instanceof Map) || (iSearchCond = SearchGroupCond.getSearchCond((Map)e, true)) == null) continue;
                this.getSearchCondsIf().add(iSearchCond);
            }
        }
    }

    @Override
    @JsonIgnore
    protected Map<String, Object> createAny() {
        return new LinkedHashMap<String, Object>();
    }

    @Override
    @JsonIgnore
    public IDEFilterDTORuntime getDEMethodDTORuntime() {
        return null;
    }

    @Override
    public void setDEMethodDTORuntime(IDEFilterDTORuntime iDEFilterDTORuntime) {
    }

    @Override
    @JsonIgnore
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    @JsonIgnore
    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    @Override
    @JsonIgnore
    public Sort getPageSort() {
        return this.sort;
    }

    @Override
    @JsonIgnore
    public void setPageSort(Sort sort) {
        this.sort = sort;
    }

    @Override
    @JsonIgnore
    public boolean isCount() {
        return this.bCount;
    }

    @Override
    @JsonIgnore
    public void setCount(boolean bCount) {
        this.bCount = bCount;
    }

    @Override
    @JsonIgnore
    protected boolean isLowerCaseName() {
        return false;
    }

    @Override
    @JsonIgnore
    public List<ISearchCond> getSearchConds() {
        return this.searchCondList;
    }

    @JsonIgnore
    public void setSearchConds(List<ISearchCond> searchCondList) {
        this.searchCondList = searchCondList;
    }

    @Override
    @JsonIgnore
    public List<ISearchCond> getSearchCondsIf() {
        if (this.searchCondList == null) {
            this.searchCondList = new ArrayList<ISearchCond>();
        }
        return this.searchCondList;
    }

    @Override
    public void set(String strName, String strValue) {
        this.set(strName, (Object)strValue);
    }

    @Override
    @JsonIgnore
    public String getCondOp() {
        return "AND";
    }

    @Override
    @JsonIgnore
    public String getCat() {
        return null;
    }

    @Override
    @JsonIgnore
    public boolean isNotMode() {
        return false;
    }

    @Override
    @JsonIgnore
    public String getCondType() {
        return "GROUP";
    }

    @Override
    @JsonIgnore
    public String getQuery() {
        Object query = this.get("query");
        if (query instanceof String) {
            return (String)query;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getDrillDownCond() {
        Object drilldowncond = this.get("drilldowncond");
        if (drilldowncond instanceof String) {
            return (String)drilldowncond;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getGroupCond() {
        Object groupcond = this.get("groupcond");
        if (groupcond instanceof String) {
            return (String)groupcond;
        }
        return null;
    }

    @Override
    public void setPageable(int nPageNumber, int nPageSize, long nOffset) {
        this.setPageable((Pageable)PageRequest.of(nPageNumber, nPageSize, nOffset));
    }

    @Override
    public void setPageSort(String strSortInfo) {
        if (StringUtils.hasLength((String)strSortInfo)) {
            ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
            String[] items = strSortInfo.split("[,]");
            if (items.length == 1) {
                list.add(Sort.Order.asc((String)items[0]));
            } else if (items.length == 2) {
                if ("DESC".equalsIgnoreCase(items[1])) {
                    list.add(Sort.Order.desc((String)items[0]));
                } else {
                    list.add(Sort.Order.asc((String)items[0]));
                }
            }
            if (list.size() > 0) {
                this.setPageSort(Sort.by(list));
            }
        } else {
            this.setPageSort(Sort.unsorted());
        }
    }

    @Override
    public SimpleSearchContextDTO setFieldCond(String strFieldName, String strCondOp, Object objValue) {
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setCondOp(strCondOp);
        if (!"ISNULL".equals(strCondOp) && !"ISNOTNULL".equals(strCondOp)) {
            searchFieldCond.setParamMode(true);
            String strParamName = "";
            int nIndex = 1;
            do {
                strParamName = nIndex == 1 ? String.format("n_%1$s_%2$s", strFieldName, strCondOp).toLowerCase() : String.format("n_%1$s_%2$s_%3$s", strFieldName, strCondOp, nIndex).toLowerCase();
                ++nIndex;
            } while (this.contains(strParamName));
            searchFieldCond.setValue(strParamName);
            this.set(strParamName, objValue);
        }
        this.getSearchCondsIf().add(searchFieldCond);
        return this;
    }

    @Override
    public SimpleSearchContextDTO eq(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "EQ", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO ne(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTEQ", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO gt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GT", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO gte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GTANDEQ", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO lt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LT", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO lte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LTANDEQ", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO like(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LIKE", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO ll(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LEFTLIKE", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO rl(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "RIGHTLIKE", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO nvl(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNULL", null);
        return this;
    }

    @Override
    public SimpleSearchContextDTO nn(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNOTNULL", null);
        return this;
    }

    @Override
    public SimpleSearchContextDTO in(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "IN", objValue);
        return this;
    }

    @Override
    public SimpleSearchContextDTO ni(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTIN", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SimpleSearchContextDTO custom(String strCustomCond) {
        SearchCustomCond searchCustomCond = new SearchCustomCond();
        searchCustomCond.setCustomCond(strCustomCond);
        this.getSearchCondsIf().add(searchCustomCond);
        return this;
    }

    @Override
    @JsonIgnore
    public SimpleSearchContextDTO predefined(String strPredefinedCond, String strPredefinedType) {
        SearchPredefinedCond searchPredefinedCond = new SearchPredefinedCond();
        searchPredefinedCond.setPredefinedCond(strPredefinedCond);
        searchPredefinedCond.setPredefinedType(strPredefinedType);
        this.getSearchCondsIf().add(searchPredefinedCond);
        return this;
    }

    @Override
    public SearchGroupCond and() {
        SearchGroupCond searchGroupCond = new SearchGroupCond(this);
        searchGroupCond.setCondOp("AND");
        this.getSearchCondsIf().add(searchGroupCond);
        return searchGroupCond;
    }

    @Override
    public SearchGroupCond or() {
        SearchGroupCond searchGroupCond = new SearchGroupCond(this);
        searchGroupCond.setCondOp("OR");
        this.getSearchCondsIf().add(searchGroupCond);
        return searchGroupCond;
    }

    @Override
    public SimpleSearchContextDTO count(boolean bCount) {
        this.setCount(bCount);
        return this;
    }

    @Override
    public SimpleSearchContextDTO sort(String strSortInfo) {
        this.setPageSort(strSortInfo);
        return this;
    }

    @Override
    public SimpleSearchContextDTO all() {
        return this.limit(Integer.MAX_VALUE).count(false);
    }

    @Override
    public SimpleSearchContextDTO limit(int nSize) {
        return this.limit(0, nSize);
    }

    @Override
    public SimpleSearchContextDTO limit(int nStart, int nSize) {
        this.setPageable(0, nSize, nStart);
        return this;
    }

    @Override
    public SimpleSearchContextDTO param(String strName, Object objValue) {
        this.set(strName, objValue);
        return this;
    }
}

