/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.ds.IDEFilterDTORuntime;
import net.ibizsys.central.dataentity.service.IDEMethodDTORuntime;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.PageRequest;
import net.ibizsys.central.util.SearchGroupCond;
import net.ibizsys.model.dataentity.defield.IPSDEFSearchMode;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEFilterDTOField;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.EntityBase;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.SearchCustomCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import net.ibizsys.runtime.util.SearchPredefinedCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchContextDTO
extends EntityBase
implements ISearchContextDTO {
    @JsonIgnore
    private static final Log log = LogFactory.getLog(SearchContextDTO.class);
    @JsonIgnore
    private static int MaxSize = 1000;
    @JsonIgnore
    private static int DefaultSize = 20;
    @JsonIgnore
    private transient IDEFilterDTORuntime iDEFilterDTORuntime = null;
    @JsonIgnore
    private Pageable pageable = null;
    @JsonIgnore
    private Sort sort = null;
    @JsonIgnore
    private boolean bCount = true;
    @JsonIgnore
    private List<ISearchCond> searchCondList = null;

    @JsonIgnore
    public static void setMaxSize(int nMaxSize) {
        MaxSize = nMaxSize;
    }

    @JsonIgnore
    public static int getMaxSize() {
        return MaxSize;
    }

    @JsonIgnore
    public static void setDefaultSize(int nDefaultSize) {
        DefaultSize = nDefaultSize;
    }

    @JsonIgnore
    public static int getDefaultSize() {
        return DefaultSize;
    }

    @Override
    public void init(IDEMethodDTORuntime iDEMethodDTORuntime, Object objData, boolean bDTOData) throws Exception {
        if (!(iDEMethodDTORuntime instanceof IDEFilterDTORuntime)) {
            throw new Exception(String.format("\u4f20\u5165\u5b9e\u4f53\u65b9\u6cd5DTO\u8fd0\u884c\u65f6\u5bf9\u8c61\u4e0d\u6b63\u786e", new Object[0]));
        }
        if (!bDTOData) {
            throw new Exception(String.format("\u4ec5\u652f\u6301\u4f20\u5165DTO", new Object[0]));
        }
        this.iDEFilterDTORuntime = (IDEFilterDTORuntime)iDEMethodDTORuntime;
        if (objData instanceof Map) {
            Map map = (Map)objData;
            this.setAny(map, true);
        }
        this.onInit();
    }

    protected void onInit() throws Exception {
        Object predefinedcond;
        Object size = this.get("size");
        Object page = this.get("page");
        Object offset = this.get("offset");
        Object sortinfo = this.get("sort");
        this.reset("size");
        this.reset("page");
        this.reset("offset");
        this.reset("sort");
        int nSize = SearchContextDTO.getDefaultSize();
        if (size != null) {
            nSize = Integer.valueOf(size.toString());
            if (nSize <= 0) {
                log.warn((Object)String.format("\u4f20\u5165\u5206\u9875\u5927\u5c0f[%1$s]\u65e0\u6548\uff0c\u8c03\u6574\u4e3a[%2$s]", nSize, SearchContextDTO.getDefaultSize()));
                nSize = SearchContextDTO.getDefaultSize();
            } else if (nSize > SearchContextDTO.getMaxSize()) {
                log.warn((Object)String.format("\u4f20\u5165\u5206\u9875\u5927\u5c0f[%1$s]\u65e0\u6548\uff0c\u8c03\u6574\u4e3a[%2$s]", nSize, SearchContextDTO.getMaxSize()));
                nSize = SearchContextDTO.getMaxSize();
            }
        }
        int nPage = 0;
        if (page != null && (nPage = Integer.valueOf(page.toString()).intValue()) < 0) {
            nPage = 0;
        }
        long nOffset = 0L;
        if (offset != null && (nOffset = Long.valueOf(offset.toString()).longValue()) < 0L) {
            nOffset = 0L;
        }
        if (sortinfo instanceof String) {
            String strSortInfo = (String)sortinfo;
            strSortInfo = strSortInfo.trim();
            this.setPageSort(strSortInfo);
        }
        this.setPageable((Pageable)PageRequest.of(nPage, nSize, nOffset));
        Object count = this.get("count");
        this.reset("count");
        if (count != null && count.toString().equalsIgnoreCase("false")) {
            this.setCount(false);
        }
        Object objSearchConds = this.get("searchconds");
        this.reset("searchconds");
        if (objSearchConds != null && objSearchConds instanceof List) {
            List list = (List)objSearchConds;
            for (Object objItem : list) {
                ISearchCond iSearchCond;
                if (!(objItem instanceof Map) || (iSearchCond = SearchGroupCond.getSearchCond((Map)objItem, true)) == null) continue;
                this.getSearchCondsIf().add(iSearchCond);
            }
        }
        if (this.getDEMethodDTORuntime() != null) {
            List<IPSDEField> psDEFieldList;
            Object query;
            List psDEFilterDTOFieldList = this.getDEMethodDTORuntime().getPSDEFilterDTO().getPSDEFilterDTOFields();
            if (psDEFilterDTOFieldList != null) {
                for (IPSDEFilterDTOField iPSDEFilterDTOField : psDEFilterDTOFieldList) {
                    Object objValue = this.get(iPSDEFilterDTOField.getLowerCaseName());
                    if (ObjectUtils.isEmpty((Object)objValue)) continue;
                    SearchFieldCond searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iPSDEFilterDTOField.getPSDEFieldMust().getName());
                    searchFieldCond.setParamMode(true);
                    searchFieldCond.setCondOp(iPSDEFilterDTOField.getPSDEFSearchModeMust().getValueOP());
                    searchFieldCond.setValue(iPSDEFilterDTOField.getLowerCaseName());
                    searchFieldCond.setDataType(iPSDEFilterDTOField.getStdDataType());
                    searchFieldCond.setValueFunc(iPSDEFilterDTOField.getPSDEFSearchModeMust().getValueFunc());
                    this.getSearchCondsIf().add(searchFieldCond);
                }
            }
            if ((query = this.get("query")) instanceof String && !ObjectUtils.isEmpty((Object)query) && (psDEFieldList = this.getDEMethodDTORuntime().getDataEntityRuntime().getQuickSearchPSDEFields()) != null && psDEFieldList.size() > 0) {
                net.ibizsys.runtime.util.SearchGroupCond querySearchGroupCond = null;
                List<ISearchCond> searchConds = this.getSearchCondsIf();
                for (ISearchCond iSearchCond : searchConds) {
                    net.ibizsys.runtime.util.SearchGroupCond searchGroupCond;
                    if (!(iSearchCond instanceof net.ibizsys.runtime.util.SearchGroupCond) || !"QUERY".equals((searchGroupCond = (net.ibizsys.runtime.util.SearchGroupCond)iSearchCond).getCat()) || !"OR".equals(searchGroupCond.getCondOp())) continue;
                    querySearchGroupCond = searchGroupCond;
                    break;
                }
                if (querySearchGroupCond == null) {
                    querySearchGroupCond = new net.ibizsys.runtime.util.SearchGroupCond();
                    querySearchGroupCond.setCondOp("OR");
                    querySearchGroupCond.setCat("QUERY");
                    this.getSearchCondsIf().add(querySearchGroupCond);
                }
                for (IPSDEField iPSDEField : psDEFieldList) {
                    SearchFieldCond searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iPSDEField.getName());
                    searchFieldCond.setParamMode(true);
                    searchFieldCond.setCondOp("LIKE");
                    searchFieldCond.setValue("query");
                    searchFieldCond.setDataType(iPSDEField.getStdDataType());
                    querySearchGroupCond.getSearchCondsIf().add(searchFieldCond);
                }
            }
        }
        if ((predefinedcond = this.get("predefinedcond")) instanceof String && !ObjectUtils.isEmpty((Object)predefinedcond)) {
            SearchContextDTO.addSearchPredefinedCond(this, (String)predefinedcond, null);
        }
    }

    @Override
    @JsonIgnore
    protected Map<String, Object> createAny() {
        return new LinkedHashMap<String, Object>();
    }

    @Override
    @JsonIgnore
    public IDEFilterDTORuntime getDEMethodDTORuntime() {
        return this.iDEFilterDTORuntime;
    }

    @Override
    @JsonIgnore
    public void setDEMethodDTORuntime(IDEFilterDTORuntime iDEFilterDTORuntime) {
        this.iDEFilterDTORuntime = iDEFilterDTORuntime;
    }

    @Override
    @JsonIgnore
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    @JsonIgnore
    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    @Override
    @JsonIgnore
    public Sort getPageSort() {
        return this.sort;
    }

    @Override
    @JsonIgnore
    public void setPageSort(Sort sort) {
        this.sort = sort;
    }

    @Override
    @JsonProperty(value="count")
    public boolean isCount() {
        return this.bCount;
    }

    @Override
    @JsonIgnore
    public void setCount(boolean bCount) {
        this.bCount = bCount;
    }

    @Override
    @JsonProperty(value="searchconds")
    public List<ISearchCond> getSearchConds() {
        return this.searchCondList;
    }

    @JsonIgnore
    public void setSearchConds(List<ISearchCond> searchCondList) {
        this.searchCondList = searchCondList;
    }

    @Override
    @JsonIgnore
    public List<ISearchCond> getSearchCondsIf() {
        if (this.searchCondList == null) {
            this.searchCondList = new ArrayList<ISearchCond>();
        }
        return this.searchCondList;
    }

    public static ISearchCond addSearchCustomCond(ISearchContextDTO iSearchContextDTO, String strCustomCond) {
        Assert.notNull((Object)iSearchContextDTO, (String)"\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.hasLength((String)strCustomCond, (String)"\u4f20\u5165\u81ea\u5b9a\u4e49\u6761\u4ef6\u65e0\u6548");
        SearchCustomCond searchCustomCond = new SearchCustomCond();
        searchCustomCond.setCustomCond(strCustomCond);
        iSearchContextDTO.getSearchCondsIf().add(searchCustomCond);
        return searchCustomCond;
    }

    public static ISearchCond addSearchPredefinedCond(ISearchContextDTO iSearchContextDTO, String strPredefinedCond, String strPredefinedType) {
        Assert.notNull((Object)iSearchContextDTO, (String)"\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        SearchPredefinedCond searchPredefinedCond = new SearchPredefinedCond();
        searchPredefinedCond.setPredefinedCond(strPredefinedCond);
        searchPredefinedCond.setPredefinedType(strPredefinedType);
        iSearchContextDTO.getSearchCondsIf().add(searchPredefinedCond);
        return searchPredefinedCond;
    }

    public static ISearchCond addSearchFieldCond(ISearchContextDTO iSearchContextDTO, String strFieldName, String strCondOp, Object objValue) {
        Assert.notNull((Object)iSearchContextDTO, (String)"\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.hasLength((String)strFieldName, (String)"\u4f20\u5165\u8fc7\u6ee4\u5c5e\u6027\u65e0\u6548");
        Assert.hasLength((String)strCondOp, (String)"\u4f20\u5165\u8fc7\u6ee4\u64cd\u4f5c\u65e0\u6548");
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setParamMode(false);
        searchFieldCond.setCondOp(strCondOp);
        searchFieldCond.setValue(objValue);
        iSearchContextDTO.getSearchCondsIf().add(searchFieldCond);
        return searchFieldCond;
    }

    public static ISearchCond addSearchFieldCond(ISearchContextDTO iSearchContextDTO, String strFieldName, String strCondOp, Object objValue, String strParamName) {
        Assert.notNull((Object)iSearchContextDTO, (String)"\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.hasLength((String)strFieldName, (String)"\u4f20\u5165\u8fc7\u6ee4\u5c5e\u6027\u65e0\u6548");
        Assert.hasLength((String)strCondOp, (String)"\u4f20\u5165\u8fc7\u6ee4\u64cd\u4f5c\u65e0\u6548");
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setCondOp(strCondOp);
        if (!"ISNULL".equals(strCondOp) && !"ISNOTNULL".equals(strCondOp)) {
            searchFieldCond.setParamMode(true);
            if (StringUtils.hasLength((String)strParamName)) {
                iSearchContextDTO.set(strParamName, objValue);
            } else {
                int nIndex = 1;
                do {
                    strParamName = nIndex == 1 ? String.format("n_%1$s_%2$s", strFieldName, strCondOp).toLowerCase() : String.format("n_%1$s_%2$s_%3$s", strFieldName, strCondOp, nIndex).toLowerCase();
                    ++nIndex;
                } while (iSearchContextDTO.contains(strParamName));
                iSearchContextDTO.set(strParamName, objValue);
            }
            searchFieldCond.setValue(strParamName);
        }
        iSearchContextDTO.getSearchCondsIf().add(searchFieldCond);
        return searchFieldCond;
    }

    public static ISearchCond addSearchFieldCondIf(ISearchContextDTO iSearchContextDTO, String strFieldName, String strCondOp, Object objValue, String strParamName) {
        Assert.notNull((Object)iSearchContextDTO, (String)"\u4f20\u5165\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.hasLength((String)strFieldName, (String)"\u4f20\u5165\u8fc7\u6ee4\u5c5e\u6027\u65e0\u6548");
        Assert.hasLength((String)strCondOp, (String)"\u4f20\u5165\u8fc7\u6ee4\u64cd\u4f5c\u65e0\u6548");
        List<ISearchCond> searchCondList = iSearchContextDTO.getSearchConds();
        if (!ObjectUtils.isEmpty(searchCondList)) {
            for (ISearchCond iSearchCond : searchCondList) {
                ISearchFieldCond iSearchFieldCond;
                if (!(iSearchCond instanceof ISearchFieldCond) || !(iSearchFieldCond = (ISearchFieldCond)iSearchCond).isParamMode() || !strFieldName.equalsIgnoreCase(iSearchFieldCond.getFieldName()) || !strCondOp.equalsIgnoreCase(iSearchFieldCond.getCondOp())) continue;
                if (!"ISNULL".equals(strCondOp) && !"ISNOTNULL".equals(strCondOp)) {
                    String strLastParamName = strParamName;
                    if (!StringUtils.hasLength((String)strLastParamName)) {
                        strLastParamName = (String)iSearchFieldCond.getValue();
                    }
                    Object lastValue = iSearchContextDTO.get(strLastParamName);
                    if (objValue == null || lastValue == null || !objValue.equals(lastValue)) continue;
                }
                return iSearchFieldCond;
            }
        }
        return SearchContextDTO.addSearchFieldCond(iSearchContextDTO, strFieldName, strCondOp, objValue, strParamName);
    }

    public static ISearchCond addSearchFieldCond(ISearchContextDTO iSearchContextDTO, String strSearchMode, Object objValue) {
        Assert.notNull((Object)iSearchContextDTO.getDEMethodDTORuntime(), (String)"\u641c\u7d22\u8fc7\u6ee4\u5668\u672a\u6307\u5b9a\u8fd0\u884c\u65f6\u5bf9\u8c61");
        IPSDEMethodDTOField iPSDEMethodDTOField = iSearchContextDTO.getDEMethodDTORuntime().getPSDEMethodDTOField(strSearchMode.toLowerCase(), false);
        if (iPSDEMethodDTOField instanceof IPSDEFilterDTOField) {
            IPSDEFilterDTOField iPSDEFilterDTOField = (IPSDEFilterDTOField)iPSDEMethodDTOField;
            IPSDEFSearchMode iPSDEFSearchMode = iPSDEFilterDTOField.getPSDEFSearchModeMust();
            IPSDEField iPSDEField = (IPSDEField)iPSDEFSearchMode.getParentPSModelObject(IPSDEField.class, false);
            return SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getName(), iPSDEFSearchMode.getValueOP(), objValue, strSearchMode);
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iSearchContextDTO.getDEMethodDTORuntime().getDataEntityRuntime(), iSearchContextDTO.getDEMethodDTORuntime(), String.format("\u5c5e\u6027[%1$s]\u7c7b\u578b\u4e0d\u662f\u8fc7\u6ee4\u5668\u5c5e\u6027", strSearchMode));
    }

    public static ISearchCond addSearchQuickCond(ISearchContextDTO iSearchContextDTO, String strValue) {
        Assert.notNull((Object)iSearchContextDTO.getDEMethodDTORuntime(), (String)"\u641c\u7d22\u8fc7\u6ee4\u5668\u672a\u6307\u5b9a\u8fd0\u884c\u65f6\u5bf9\u8c61");
        List<IPSDEField> psDEFieldList = iSearchContextDTO.getDEMethodDTORuntime().getDataEntityRuntime().getQuickSearchPSDEFields();
        if (StringUtils.hasLength((String)strValue) && !ObjectUtils.isEmpty(psDEFieldList)) {
            iSearchContextDTO.set("query", strValue);
            net.ibizsys.runtime.util.SearchGroupCond searchGroupCond = new net.ibizsys.runtime.util.SearchGroupCond();
            searchGroupCond.setCondOp("OR");
            for (IPSDEField iPSDEField : psDEFieldList) {
                SearchFieldCond searchFieldCond = new SearchFieldCond();
                searchFieldCond.setFieldName(iPSDEField.getName());
                searchFieldCond.setParamMode(true);
                searchFieldCond.setCondOp("LIKE");
                searchFieldCond.setValue("query");
                searchFieldCond.setDataType(iPSDEField.getStdDataType());
                searchGroupCond.getSearchCondsIf().add(searchFieldCond);
            }
            iSearchContextDTO.getSearchCondsIf().add(searchGroupCond);
            return searchGroupCond;
        }
        return null;
    }

    @Override
    public void set(String strName, String strValue) {
        this.set(strName, (Object)strValue);
    }

    @Override
    public SearchContextDTO setFieldCond(String strFieldName, String strCondOp, Object objValue) {
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setCondOp(strCondOp);
        if (!"ISNULL".equals(strCondOp) && !"ISNOTNULL".equals(strCondOp)) {
            searchFieldCond.setParamMode(true);
            String strParamName = "";
            int nIndex = 1;
            do {
                strParamName = nIndex == 1 ? String.format("n_%1$s_%2$s", strFieldName, strCondOp).toLowerCase() : String.format("n_%1$s_%2$s_%3$s", strFieldName, strCondOp, nIndex).toLowerCase();
                ++nIndex;
            } while (this.contains(strParamName));
            searchFieldCond.setValue(strParamName);
            this.set(strParamName, objValue);
        }
        this.getSearchCondsIf().add(searchFieldCond);
        return this;
    }

    @Override
    public SearchContextDTO eq(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "EQ", objValue);
        return this;
    }

    @Override
    public SearchContextDTO ne(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTEQ", objValue);
        return this;
    }

    @Override
    public SearchContextDTO gt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GT", objValue);
        return this;
    }

    @Override
    public SearchContextDTO gte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GTANDEQ", objValue);
        return this;
    }

    @Override
    public SearchContextDTO lt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LT", objValue);
        return this;
    }

    @Override
    public SearchContextDTO lte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LTANDEQ", objValue);
        return this;
    }

    @Override
    public SearchContextDTO like(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LIKE", objValue);
        return this;
    }

    @Override
    public SearchContextDTO ll(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LEFTLIKE", objValue);
        return this;
    }

    @Override
    public SearchContextDTO rl(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "RIGHTLIKE", objValue);
        return this;
    }

    @Override
    public SearchContextDTO nvl(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNULL", null);
        return this;
    }

    @Override
    public SearchContextDTO nn(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNOTNULL", null);
        return this;
    }

    @Override
    public SearchContextDTO in(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "IN", objValue);
        return this;
    }

    @Override
    public SearchContextDTO ni(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTIN", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchContextDTO custom(String strCustomCond) {
        SearchCustomCond searchCustomCond = new SearchCustomCond();
        searchCustomCond.setCustomCond(strCustomCond);
        this.getSearchCondsIf().add(searchCustomCond);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchContextDTO predefined(String strPredefinedCond, String strPredefinedType) {
        SearchPredefinedCond searchPredefinedCond = new SearchPredefinedCond();
        searchPredefinedCond.setPredefinedCond(strPredefinedCond);
        searchPredefinedCond.setPredefinedType(strPredefinedType);
        this.getSearchCondsIf().add(searchPredefinedCond);
        return this;
    }

    @Override
    public SearchGroupCond and() {
        SearchGroupCond searchGroupCond = new SearchGroupCond(this);
        searchGroupCond.setCondOp("AND");
        this.getSearchCondsIf().add(searchGroupCond);
        return searchGroupCond;
    }

    @Override
    public SearchGroupCond or() {
        SearchGroupCond searchGroupCond = new SearchGroupCond(this);
        searchGroupCond.setCondOp("OR");
        this.getSearchCondsIf().add(searchGroupCond);
        return searchGroupCond;
    }

    @Override
    public SearchContextDTO count(boolean bCount) {
        this.setCount(bCount);
        return this;
    }

    @Override
    public SearchContextDTO sort(String strSortInfo) {
        this.setPageSort(strSortInfo);
        return this;
    }

    @Override
    public SearchContextDTO all() {
        return this.limit(Integer.MAX_VALUE).count(false);
    }

    @Override
    public SearchContextDTO limit(int nSize) {
        return this.limit(0, nSize);
    }

    @Override
    public SearchContextDTO limit(int nStart, int nSize) {
        this.setPageable(0, nSize, nStart);
        return this;
    }

    @Override
    public SearchContextDTO param(String strName, Object objValue) {
        this.set(strName, objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public String getCondOp() {
        return "AND";
    }

    @Override
    @JsonIgnore
    public boolean isNotMode() {
        return false;
    }

    @Override
    @JsonIgnore
    public String getCondType() {
        return "GROUP";
    }

    @Override
    @JsonIgnore
    public String getCat() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getQuery() {
        Object query = this.get("query");
        if (query instanceof String) {
            return (String)query;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getDrillDownCond() {
        Object drilldowncond = this.get("drilldowncond");
        if (drilldowncond instanceof String) {
            return (String)drilldowncond;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getGroupCond() {
        Object groupcond = this.get("groupcond");
        if (groupcond instanceof String) {
            return (String)groupcond;
        }
        return null;
    }

    @Override
    @JsonIgnore
    public void setPageable(int nPageNumber, int nPageSize, long nOffset) {
        this.setPageable((Pageable)PageRequest.of(nPageNumber, nPageSize, nOffset));
    }

    @Override
    @JsonIgnore
    public void setPageSort(String strSortInfo) {
        Sort sort = null;
        if (StringUtils.hasLength((String)strSortInfo)) {
            String[] parts;
            ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
            for (String strPart : parts = strSortInfo.split("[;]")) {
                String[] items = strPart.split("[,]");
                if (items.length == 1) {
                    list.add(Sort.Order.asc((String)items[0].trim()));
                    continue;
                }
                if (items.length != 2) continue;
                if ("DESC".equalsIgnoreCase(items[1].trim())) {
                    list.add(Sort.Order.desc((String)items[0].trim()));
                    continue;
                }
                list.add(Sort.Order.asc((String)items[0].trim()));
            }
            if (list.size() > 0) {
                sort = Sort.by(list);
            }
        }
        this.setPageSort(sort);
    }

    @JsonProperty(value="sort")
    public String getSortInfo() {
        Iterator orders;
        if (this.getPageSort() != null && this.getPageSort() != Sort.unsorted() && (orders = this.sort.iterator()) != null) {
            String strSortInfo = "";
            while (orders.hasNext()) {
                Sort.Order order;
                if (StringUtils.hasLength((String)strSortInfo)) {
                    strSortInfo = strSortInfo + ";";
                }
                if ((order = (Sort.Order)orders.next()).isAscending()) {
                    strSortInfo = strSortInfo + String.format("%1$s,asc", order.getProperty());
                    continue;
                }
                strSortInfo = strSortInfo + String.format("%1$s,desc", order.getProperty());
            }
            return strSortInfo;
        }
        return null;
    }

    @JsonProperty(value="offset")
    public long getOffset() {
        if (this.getPageable() != null) {
            return this.getPageable().getOffset();
        }
        return 0L;
    }

    @JsonProperty(value="size")
    public int getSize() {
        if (this.getPageable() != null) {
            return this.getPageable().getPageSize();
        }
        return 1000;
    }

    @JsonProperty(value="page")
    public int getPage() {
        if (this.getPageable() != null) {
            return this.getPageable().getPageNumber();
        }
        return 0;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(this);
    }
}

