/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.res;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.res.SysTranslatorRuntimeBase;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.msg.ISysMsgQueueRuntime;
import net.ibizsys.runtime.msg.ISysMsgTemplRuntime;
import net.ibizsys.runtime.util.ASFutureActionBase;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.domain.MsgSendQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysAtContentTranslatorRuntime
extends SysTranslatorRuntimeBase {
    private static final Log log = LogFactory.getLog(SysAtContentTranslatorRuntime.class);
    private static final Map<String, Integer> MsgTypeMap = new LinkedHashMap<String, Integer>();
    private static final Pattern Regex;
    public static final String TEMPLPARAM_CONTENT = "content";
    public static final String PARAM_MSGTYPE = "msgtype";
    public static final String PARAM_MSGTEMPL = "msgtempl";
    public static final String PARAM_MSGQUEUE = "msgqueue";
    public static final String PARAM_USERID = "userid";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_CODEITEMTEXTSUFFIX = "codeitemtextsuffix";
    public static final String PARAM_THREADMODE = "threadmode";
    private String strUserIdField = null;
    private String strUserNameField = null;
    private int nMsgType;
    private String strMsgTemplTag;
    private String strMsgQueueTag;
    private String strCodeItemTextSuffix;
    private ISysMsgTemplRuntime iSysMsgTemplRuntime;
    private ISysMsgQueueRuntime iSysMsgQueueRuntime;
    private boolean bThreadMode;

    public SysAtContentTranslatorRuntime() {
        this.nMsgType = PSModelEnums.InfomMsgType.INTERNAL.value;
        this.strMsgTemplTag = "";
        this.strMsgQueueTag = "";
        this.strCodeItemTextSuffix = null;
        this.iSysMsgTemplRuntime = null;
        this.iSysMsgQueueRuntime = null;
        this.bThreadMode = true;
    }

    @Override
    protected void onInit() throws Exception {
        this.strUserIdField = this.getTranslatorParam(PARAM_USERID, "id");
        this.strUserNameField = this.getTranslatorParam(PARAM_USERNAME, "name");
        String strMsgType = this.getTranslatorParam(PARAM_MSGTYPE, "INTERNAL");
        this.strCodeItemTextSuffix = this.getTranslatorParam(PARAM_CODEITEMTEXTSUFFIX, "text");
        if (StringUtils.hasLength((String)strMsgType)) {
            String[] items;
            this.nMsgType = 0;
            for (String item : items = strMsgType.toUpperCase().replace(",", ";").split("[;]")) {
                if (!MsgTypeMap.containsKey(item)) continue;
                this.nMsgType |= MsgTypeMap.get(item).intValue();
            }
            if (this.nMsgType == 0) {
                this.nMsgType = PSModelEnums.InfomMsgType.INTERNAL.value;
            }
        }
        this.strMsgTemplTag = this.getTranslatorParam(PARAM_MSGTEMPL, null);
        this.strMsgQueueTag = this.getTranslatorParam(PARAM_MSGQUEUE, null);
        this.bThreadMode = this.getTranslatorParam(PARAM_THREADMODE, true);
        if (StringUtils.hasLength((String)this.getMsgTemplTag())) {
            this.iSysMsgTemplRuntime = this.getSystemRuntime().getSysMsgTemplRuntime(this.getMsgTemplTag(), false);
        }
        if (StringUtils.hasLength((String)this.getMsgQueueTag())) {
            this.iSysMsgQueueRuntime = this.getSystemRuntime().getSysMsgQueueRuntime(this.getMsgQueueTag(), false);
        }
        if (this.getSysMsgQueueRuntime() == null) {
            throw new Exception("\u672a\u6307\u5b9a\u6d88\u606f\u53d1\u9001\u961f\u5217");
        }
        if (this.getSysMsgTemplRuntime() == null) {
            throw new Exception("\u672a\u6307\u5b9a\u6d88\u606f\u6a21\u677f");
        }
        super.onInit();
    }

    protected Pattern getPattern() {
        return Regex;
    }

    protected String getUserIdField() {
        return this.strUserIdField;
    }

    protected String getUserNameField() {
        return this.strUserNameField;
    }

    protected int getMsgType() {
        return this.nMsgType;
    }

    protected String getMsgTemplTag() {
        return this.strMsgTemplTag;
    }

    protected String getMsgQueueTag() {
        return this.strMsgQueueTag;
    }

    protected String getCodeItemTextSuffix() {
        return this.strCodeItemTextSuffix;
    }

    protected ISysMsgQueueRuntime getSysMsgQueueRuntime() {
        return this.iSysMsgQueueRuntime;
    }

    protected ISysMsgTemplRuntime getSysMsgTemplRuntime() {
        return this.iSysMsgTemplRuntime;
    }

    protected boolean isThreadMode() {
        return this.bThreadMode;
    }

    @Override
    protected Object onTranslate(Object objValue, boolean bIn, final IEntityDTO iEntityDTO, IPSDEField iPSDEField, final net.ibizsys.runtime.dataentity.IDataEntityRuntime entityDataEntityRuntime) throws Throwable {
        if (bIn && !ObjectUtils.isEmpty((Object)objValue) && iEntityDTO != null) {
            IEntityBase lastEntity;
            if (iPSDEField != null && entityDataEntityRuntime != null && (lastEntity = entityDataEntityRuntime.getLastEntity()) != null) {
                Object lastContent = entityDataEntityRuntime.getFieldValue(lastEntity, iPSDEField);
                if (DataTypeUtils.compare(iPSDEField.getStdDataType(), objValue, lastContent) == 0L) {
                    return super.onTranslate(objValue, bIn, iEntityDTO, iPSDEField, entityDataEntityRuntime);
                }
            }
            String text = objValue.toString();
            Matcher matcher = this.getPattern().matcher(text);
            LinkedHashMap<String, String> replaceContentMap = new LinkedHashMap<String, String>();
            final LinkedHashMap<String, String> userIdMap = new LinkedHashMap<String, String>();
            while (matcher.find()) {
                String json = matcher.group(1);
                try {
                    Map map = JsonUtils.asMap(json);
                    Object userid = map.get(this.getUserIdField());
                    Object username = map.get(this.getUserNameField());
                    if (userid == null || username == null) continue;
                    replaceContentMap.put(String.format("@%1$s", json), String.format("@%1$s", username));
                    userIdMap.put(userid.toString(), username.toString());
                }
                catch (Throwable throwable) {
                    log.error((Object)String.format("\u8f6c\u5316\u503c\u5904\u7406\u89e3\u6790Json\u53d1\u751f\u5f02\u5e38\uff0c%1$s", throwable.getMessage()), throwable);
                }
            }
            if (replaceContentMap.size() > 0) {
                for (Map.Entry entry : replaceContentMap.entrySet()) {
                    text = text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                final HashMap<String, String> templParams = new HashMap<String, String>();
                templParams.put(TEMPLPARAM_CONTENT, text);
                ActionSessionManager.getCurrentSession().registerFutureAction(new ASFutureActionBase(){

                    @Override
                    public void commit() {
                        if (SysAtContentTranslatorRuntime.this.isThreadMode()) {
                            SysAtContentTranslatorRuntime.this.getSystemRuntime().threadRun(new Runnable(){

                                @Override
                                public void run() {
                                    this.onCommit();
                                }
                            });
                        } else {
                            this.onCommit();
                        }
                    }

                    private void onCommit() {
                        MsgSendQueue msgSendQueue;
                        IEntityDTO temp = iEntityDTO;
                        if (entityDataEntityRuntime instanceof IDataEntityRuntime) {
                            temp = ((IDataEntityRuntime)entityDataEntityRuntime).createEntity();
                            iEntityDTO.copyTo(temp, true);
                            ((IDataEntityRuntime)entityDataEntityRuntime).fillEntityCodeListTexts(temp, SysAtContentTranslatorRuntime.this.getCodeItemTextSuffix());
                        }
                        try {
                            msgSendQueue = SysAtContentTranslatorRuntime.this.getMsgSendQueue(temp, templParams, userIdMap, entityDataEntityRuntime);
                        }
                        catch (Throwable ex) {
                            log.error((Object)String.format("\u83b7\u53d6\u6d88\u606f\u53d1\u9001\u961f\u5217\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
                            return;
                        }
                        SysAtContentTranslatorRuntime.this.getSysMsgQueueRuntime().send(new MsgSendQueue[]{msgSendQueue});
                    }
                });
            }
        }
        return super.onTranslate(objValue, bIn, iEntityDTO, iPSDEField, entityDataEntityRuntime);
    }

    protected MsgSendQueue getMsgSendQueue(IEntity iEntity, Map<String, Object> params, Map<String, String> targetMap, net.ibizsys.runtime.dataentity.IDataEntityRuntime entityDataEntityRuntime) throws Throwable {
        MsgSendQueue msgSendQueue = this.fillMsgSendQueue(null, iEntity, params, entityDataEntityRuntime);
        ArrayNode array = JsonUtils.createArrayNode();
        for (Map.Entry<String, String> entry : targetMap.entrySet()) {
            array.add(entry.getKey());
        }
        msgSendQueue.setDstUsers(array.toString());
        return msgSendQueue;
    }

    protected MsgSendQueue fillMsgSendQueue(MsgSendQueue msgSendQueue, IEntity iEntity, Map<String, Object> params, net.ibizsys.runtime.dataentity.IDataEntityRuntime entityDataEntityRuntime) throws Throwable {
        if (msgSendQueue == null) {
            msgSendQueue = new MsgSendQueue();
        }
        int nMsgType = this.getMsgType();
        IEntityBase data = iEntity;
        if (entityDataEntityRuntime != null) {
            data = entityDataEntityRuntime.createScriptEntity(iEntity);
        }
        net.ibizsys.central.msg.ISysMsgTemplRuntime iSysMsgTemplRuntime = null;
        if (this.getSysMsgTemplRuntime() instanceof net.ibizsys.central.msg.ISysMsgTemplRuntime) {
            iSysMsgTemplRuntime = (net.ibizsys.central.msg.ISysMsgTemplRuntime)this.getSysMsgTemplRuntime();
        }
        msgSendQueue.setMsgType(nMsgType);
        msgSendQueue.setTemplateId(this.getSysMsgTemplRuntime().getPSSysMsgTempl().getCodeName());
        if (iSysMsgTemplRuntime != null) {
            msgSendQueue.setSubject(iSysMsgTemplRuntime.getSubject(data, params));
            msgSendQueue.setUrl(iSysMsgTemplRuntime.getUrl(data, params));
            msgSendQueue.setMobileUrl(iSysMsgTemplRuntime.getMobileUrl(data, params));
        } else {
            msgSendQueue.setSubject(this.getSysMsgTemplRuntime().getSubject(data));
            msgSendQueue.setUrl(this.getSysMsgTemplRuntime().getUrl(data));
            msgSendQueue.setMobileUrl(this.getSysMsgTemplRuntime().getMobileUrl(data));
        }
        if ((nMsgType & 3) != 0) {
            msgSendQueue.setContentType(this.getSysMsgTemplRuntime().getContentType());
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setContent(iSysMsgTemplRuntime.getContent(data, params));
            } else {
                msgSendQueue.setContent(this.getSysMsgTemplRuntime().getContent(data));
            }
        }
        if ((nMsgType & 4) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setSMSContent(iSysMsgTemplRuntime.getSMSContent(data, params));
            } else {
                msgSendQueue.setSMSContent(this.getSysMsgTemplRuntime().getSMSContent(data));
            }
        }
        if ((nMsgType & 0x18) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setIMContent(iSysMsgTemplRuntime.getIMContent(data, params));
            } else {
                msgSendQueue.setIMContent(this.getSysMsgTemplRuntime().getIMContent(data));
            }
        }
        if ((nMsgType & 0x20) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setWXContent(iSysMsgTemplRuntime.getWXContent(data, params));
            } else {
                msgSendQueue.setWXContent(this.getSysMsgTemplRuntime().getWXContent(data));
            }
        }
        if ((nMsgType & 0x40) != 0) {
            if (iSysMsgTemplRuntime != null) {
                msgSendQueue.setDDContent(iSysMsgTemplRuntime.getDDContent(data, params));
            } else {
                msgSendQueue.setDDContent(this.getSysMsgTemplRuntime().getDDContent(data));
            }
        }
        return msgSendQueue;
    }

    static {
        MsgTypeMap.put(PSModelEnums.InfomMsgType.INTERNAL.toString(), PSModelEnums.InfomMsgType.INTERNAL.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.DT.toString(), PSModelEnums.InfomMsgType.DT.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.EMAIL.toString(), PSModelEnums.InfomMsgType.EMAIL.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.ENTWT.toString(), PSModelEnums.InfomMsgType.ENTWT.value);
        MsgTypeMap.put("ENTWX", PSModelEnums.InfomMsgType.ENTWT.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.MSN.toString(), PSModelEnums.InfomMsgType.MSN.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.SAIM.toString(), PSModelEnums.InfomMsgType.SAIM.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.SMS.toString(), PSModelEnums.InfomMsgType.SMS.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.WT.toString(), PSModelEnums.InfomMsgType.WT.value);
        MsgTypeMap.put("WX", PSModelEnums.InfomMsgType.WT.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.USER.toString(), PSModelEnums.InfomMsgType.USER.value);
        MsgTypeMap.put(PSModelEnums.InfomMsgType.USER2.toString(), PSModelEnums.InfomMsgType.USER2.value);
        Regex = Pattern.compile("@(\\{.*?\\})");
    }
}

