/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.util.DEUtilRuntimeBase;
import net.ibizsys.central.dataentity.util.IDEVersionStorageUtilRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSPickupDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEVersionStorageUtilRuntimeBase
extends DEUtilRuntimeBase
implements IDEVersionStorageUtilRuntime {
    private static final Log log = LogFactory.getLog(DEVersionStorageUtilRuntimeBase.class);
    private IDataEntityRuntime versionDataEntityRuntime = null;
    private IPSDEField versionDataParentTypePSDEField = null;
    private IPSDEField versionDataParentIdPSDEField = null;
    private IPSDEField versionDataParentVersionIdPSDEField = null;
    private IPSDEField versionDataFilterPSDEField = null;
    private IPSDEField versionDataOwnerTypePSDEField = null;
    private IPSDEField versionDataOwnerIdPSDEField = null;
    private IPSDEField versionDataDataPSDEField = null;

    @Override
    protected void onInit() throws Exception {
        if (this.getVersionDataEntityRuntime(true) == null) {
            this.prepareVersionDataEntityRuntime();
            this.getVersionDataEntityRuntime(false);
        }
        super.onInit();
    }

    protected void prepareVersionDataEntityRuntime() throws Exception {
        IPSDataEntity utilPSDataEntity = this.getPSDEUtil().getUtilPSDE();
        if (utilPSDataEntity == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u7248\u672c\u6570\u636e\u5b58\u50a8\u5b9e\u4f53", new Object[0]));
        }
        IDataEntityRuntime versionDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(utilPSDataEntity.getId());
        this.setVersionDataEntityRuntime(versionDataEntityRuntime);
        this.setVersionDataParentIdPSDEField(versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTID.value, false));
        this.setVersionDataParentVersionIdPSDEField(versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTVERSIONID.value, false));
        this.setVersionDataParentTypePSDEField(versionDataEntityRuntime.getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE.value, true));
        this.setVersionDataDataPSDEField(versionDataEntityRuntime.getPSDEFieldByTag("DATA", false));
        this.setVersionDataFilterPSDEField(versionDataEntityRuntime.getPSDEFieldByTag("FILTER", false));
        this.setVersionDataOwnerTypePSDEField(versionDataEntityRuntime.getPSDEFieldByTag("OWNER_TYPE", true));
        this.setVersionDataOwnerIdPSDEField(versionDataEntityRuntime.getPSDEFieldByTag("OWNER_ID", true));
    }

    @Override
    public IDataEntityRuntime getVersionDataEntityRuntime() {
        try {
            return this.getVersionDataEntityRuntime(false);
        }
        catch (Exception ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected IPSDEField getVersionDataParentTypePSDEField() {
        return this.versionDataParentTypePSDEField;
    }

    protected void setVersionDataParentTypePSDEField(IPSDEField versionDataParentTypePSDEField) {
        this.versionDataParentTypePSDEField = versionDataParentTypePSDEField;
    }

    protected IPSDEField getVersionDataParentIdPSDEField() {
        return this.versionDataParentIdPSDEField;
    }

    protected void setVersionDataParentIdPSDEField(IPSDEField versionDataParentIdPSDEField) {
        this.versionDataParentIdPSDEField = versionDataParentIdPSDEField;
    }

    protected IPSDEField getVersionDataParentVersionIdPSDEField() {
        return this.versionDataParentVersionIdPSDEField;
    }

    protected void setVersionDataParentVersionIdPSDEField(IPSDEField versionDataParentVersionIdPSDEField) {
        this.versionDataParentVersionIdPSDEField = versionDataParentVersionIdPSDEField;
    }

    protected IPSDEField getVersionDataFilterPSDEField() {
        return this.versionDataFilterPSDEField;
    }

    protected void setVersionDataFilterPSDEField(IPSDEField versionDataFilterPSDEField) {
        this.versionDataFilterPSDEField = versionDataFilterPSDEField;
    }

    protected IPSDEField getVersionDataOwnerTypePSDEField() {
        return this.versionDataOwnerTypePSDEField;
    }

    protected void setVersionDataOwnerTypePSDEField(IPSDEField versionDataOwnerTypePSDEField) {
        this.versionDataOwnerTypePSDEField = versionDataOwnerTypePSDEField;
    }

    protected IPSDEField getVersionDataOwnerIdPSDEField() {
        return this.versionDataOwnerIdPSDEField;
    }

    protected void setVersionDataOwnerIdPSDEField(IPSDEField versionDataOwnerIdPSDEField) {
        this.versionDataOwnerIdPSDEField = versionDataOwnerIdPSDEField;
    }

    protected IPSDEField getVersionDataDataPSDEField() {
        return this.versionDataDataPSDEField;
    }

    protected void setVersionDataDataPSDEField(IPSDEField versionDataDataPSDEField) {
        this.versionDataDataPSDEField = versionDataDataPSDEField;
    }

    protected IDataEntityRuntime getVersionDataEntityRuntime(boolean tryMode) throws Exception {
        if (this.versionDataEntityRuntime != null || tryMode) {
            return this.versionDataEntityRuntime;
        }
        throw new Exception(String.format("\u7248\u672c\u6570\u636e\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setVersionDataEntityRuntime(IDataEntityRuntime versionDataEntityRuntime) {
        this.versionDataEntityRuntime = versionDataEntityRuntime;
    }

    @Override
    public boolean isEnableAction(String strActionName, IPSDEAction iPSDEAction, Object[] args) {
        return args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1]);
    }

    @Override
    public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
        Assert.notNull((Object)args, (String)"\u672a\u4f20\u5165\u8c03\u7528\u53c2\u6570");
        try {
            if (args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1])) {
                return this.onExecuteAction(strActionName, iPSDEAction, args, actionData);
            }
            throw new Exception("\u8c03\u7528\u53c2\u6570\u683c\u5f0f\u65e0\u6548");
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6267\u884c\u884c\u4e3a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onExecuteAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
        String strRealActionName;
        String string = strRealActionName = iPSDEAction != null ? iPSDEAction.getName() : strActionName;
        if ("get".equalsIgnoreCase(strRealActionName)) {
            return this.get(args[0], args[2]);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u884c\u4e3a[%1$s]", strRealActionName));
    }

    @Override
    public IEntityBase get(Object key, Object objVersionId) throws Throwable {
        try {
            return this.onGet(key, objVersionId);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u83b7\u53d6\u7248\u672c\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IEntityBase onGet(Object key, Object objVersionId) throws Throwable {
        IAppContext iAppContext = ActionSessionManager.getAppContextMust();
        IPSDERBase iPSDERBase = this.getVersionPSDERBase(iAppContext, false);
        Object parentId = ActionSessionManager.getAppContextMust().get(iPSDERBase.getMajorPSDataEntityMust().getName());
        ISearchContextDTO iSearchContextDTO = this.getVersionDataEntityRuntime().createSearchContext();
        iSearchContextDTO.count(false);
        iSearchContextDTO.eq(this.getVersionDataParentVersionIdPSDEField().getLowerCaseName(), objVersionId);
        iSearchContextDTO.eq(this.getVersionDataParentIdPSDEField().getLowerCaseName(), parentId);
        if (this.getVersionDataParentTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionDataParentTypePSDEField().getLowerCaseName(), iPSDERBase.getMajorPSDataEntityMust().getName());
        }
        if (this.getVersionDataOwnerTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionDataOwnerTypePSDEField().getLowerCaseName(), this.getDataEntityRuntime().getName());
        }
        if (this.getVersionDataOwnerIdPSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionDataOwnerIdPSDEField().getLowerCaseName(), key);
            iSearchContextDTO.limit(1);
        } else {
            iSearchContextDTO.all();
        }
        Object ret = this.getVersionDataEntityRuntime().fetchDataSet(null, this.getVersionDataEntityRuntime().getDefaultPSDEDataSet(), new Object[]{iSearchContextDTO});
        if (!(ret instanceof Page)) {
            throw new Exception("\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e");
        }
        Page page = (Page)ret;
        if (!ObjectUtils.isEmpty((Object)page.getContent())) {
            for (Object item : page.getContent()) {
                IEntityDTO iEntityDTO = (IEntityDTO)this.getDataEntityRuntime().deserializeEntity(((IEntityDTO)item).get(this.getVersionDataDataPSDEField().getLowerCaseName()));
                if (!key.equals(iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName()))) continue;
                return iEntityDTO;
            }
        }
        throw new Exception("\u6307\u5b9a\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @Override
    public boolean isEnableDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args) {
        return args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1]);
    }

    @Override
    public Page fetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
        Assert.notNull((Object)args, (String)"\u672a\u4f20\u5165\u8c03\u7528\u53c2\u6570");
        try {
            if (args != null && args.length >= 3 && "SRFVERSIONID".equals(args[1])) {
                return this.onFetchDataSet(strDataSetName, iPSDEDataSet, args, actionData);
            }
            throw new Exception("\u8c03\u7528\u53c2\u6570\u683c\u5f0f\u65e0\u6548");
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u96c6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Page onFetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
        Object ret;
        ISearchContextDTO realSearchContextDTO = (ISearchContextDTO)args[0];
        Object versionId = args[2];
        IAppContext iAppContext = ActionSessionManager.getAppContextMust();
        IPSDERBase iPSDERBase = this.getVersionPSDERBase(iAppContext, false);
        Object parentId = ActionSessionManager.getAppContextMust().get(iPSDERBase.getMajorPSDataEntityMust().getName());
        ISearchContextDTO iSearchContextDTO = this.getVersionDataEntityRuntime().createSearchContext();
        if (realSearchContextDTO.getPageable() != null) {
            iSearchContextDTO.setPageable(realSearchContextDTO.getPageable().getPageNumber(), realSearchContextDTO.getPageable().getPageSize(), 0L);
        }
        iSearchContextDTO.eq(this.getVersionDataParentVersionIdPSDEField().getLowerCaseName(), versionId);
        iSearchContextDTO.eq(this.getVersionDataParentIdPSDEField().getLowerCaseName(), parentId);
        if (this.getVersionDataParentTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionDataParentTypePSDEField().getLowerCaseName(), iPSDERBase.getMajorPSDataEntityMust().getName());
        }
        if (this.getVersionDataOwnerTypePSDEField() != null) {
            iSearchContextDTO.eq(this.getVersionDataOwnerTypePSDEField().getLowerCaseName(), this.getDataEntityRuntime().getName());
        }
        if (!((ret = this.getVersionDataEntityRuntime().fetchDataSet(null, this.getVersionDataEntityRuntime().getDefaultPSDEDataSet(), new Object[]{iSearchContextDTO})) instanceof Page)) {
            throw new Exception("\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e");
        }
        Page page = (Page)ret;
        ArrayList<IEntityDTO> entityDTOList = new ArrayList<IEntityDTO>();
        if (!ObjectUtils.isEmpty((Object)page.getContent())) {
            for (Object item : page.getContent()) {
                IEntityDTO iEntityDTO = (IEntityDTO)this.getDataEntityRuntime().deserializeEntity(((IEntityDTO)item).get(this.getVersionDataDataPSDEField().getLowerCaseName()));
                entityDTOList.add(iEntityDTO);
            }
        }
        return new PageImpl(entityDTOList, realSearchContextDTO.getPageable(), page.getTotalElements());
    }

    protected IPSDERBase getVersionPSDERBase(IAppContext iAppContext, boolean bTryMode) throws Exception {
        List psDERBaseList = this.getDataEntityRuntime().getPSDataEntity().getMinorPSDERs();
        if (!ObjectUtils.isEmpty((Object)psDERBaseList) && iAppContext != null) {
            for (IPSDERBase iPSDERBase : psDERBaseList) {
                Object value;
                IDataEntityRuntime majorDataEntityRuntime;
                if (iPSDERBase instanceof IPSDER1N) {
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    majorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDER1N.getMajorPSDataEntityMust().getId(), false);
                    if (!majorDataEntityRuntime.isEnableVersionControl() || ObjectUtils.isEmpty((Object)(value = iAppContext.get(majorDataEntityRuntime.getName())))) continue;
                    return iPSDER1N;
                }
                if (!(iPSDERBase instanceof IPSDERCustom)) continue;
                IPSDERCustom iPSDERCustom = (IPSDERCustom)iPSDERBase;
                majorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERCustom.getMajorPSDataEntityMust().getId(), false);
                if (!majorDataEntityRuntime.isEnableVersionControl() || ObjectUtils.isEmpty((Object)(value = iAppContext.get(majorDataEntityRuntime.getName())))) continue;
                return iPSDERCustom;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u4f20\u5165\u6570\u636e\u7248\u672c\u63a7\u5236\u5173\u7cfb");
    }

    @Override
    public void commit(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) {
        Assert.notNull((Object)parentData, (String)"\u4f20\u5165\u7236\u6570\u636e\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSDERBase, (String)"\u4f20\u5165\u7236\u6570\u636e\u5173\u7cfb\u6a21\u578b\u65e0\u6548");
        Assert.notNull((Object)versionId, (String)"\u4f20\u5165\u7236\u6570\u636e\u7248\u672c\u65e0\u6548");
        try {
            this.onCommit(parentData, iPSDERBase, versionId);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u63d0\u4ea4\u7236\u6570\u636e\u76f8\u5173\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onCommit(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) throws Throwable {
        IPSDEField orderValuePSDEField;
        IPSDERCustom iPSDERCustom;
        IPSPickupDEField pickupPSDEField = null;
        IPSDEField parentTypePSDEField = null;
        IPSDEField parentSubTypePSDEField = null;
        String strParentSubType = null;
        IPSDEDataSet nestedPSDEDataSet = null;
        if (iPSDERBase instanceof IPSDER1N) {
            IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
            if ((iPSDER1N.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value) {
                pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                nestedPSDEDataSet = ((IPSDER1N)iPSDERBase).getNestedPSDEDataSet();
            }
        } else if (iPSDERBase instanceof IPSDERCustom && ((iPSDERCustom = (IPSDERCustom)iPSDERBase).getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value && (this.getDataEntityRuntime().getDEType() == 4 || PSModelEnums.DERSubType.DER1N.value.equalsIgnoreCase(iPSDERCustom.getDERSubType()))) {
            pickupPSDEField = iPSDERCustom.getPickupPSDEField();
            nestedPSDEDataSet = iPSDERCustom.getNestedPSDEDataSet();
            parentTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE, this.getDataEntityRuntime().getDEType() != 4);
            parentSubTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTSUBTYPE, true);
            if (parentSubTypePSDEField != null && !StringUtils.hasLength((String)(strParentSubType = ((IPSDERCustom)iPSDERBase).getTypeValue()))) {
                strParentSubType = iPSDERBase.getMinorCodeName();
            }
        }
        if (pickupPSDEField == null) {
            throw new Exception(String.format("\u4f20\u5165\u5173\u7cfb\u65e0\u6548\uff0c\u672a\u63d0\u4f9b\u8fde\u63a5\u5c5e\u6027", new Object[0]));
        }
        Object key = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMajorPSDataEntityMust().getId()).getKeyFieldValue(parentData);
        ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
        iSearchContextDTO.all().count(false);
        this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, (IPSDEField)pickupPSDEField, "EQ", key);
        if (parentTypePSDEField != null) {
            this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentTypePSDEField, "EQ", (Object)this.getDataEntityRuntime().getName());
        }
        if (parentSubTypePSDEField != null) {
            if (StringUtils.hasLength(strParentSubType)) {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "EQ", DataTypeUtils.convert(parentSubTypePSDEField.getStdDataType(), strParentSubType));
            } else {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "ISNULL", null);
            }
        }
        if ((orderValuePSDEField = this.getDataEntityRuntime().getOrderValuePSDEField()) != null) {
            this.getDataEntityRuntime().setSearchSort(iSearchContextDTO, orderValuePSDEField, PSModelEnums.SortDir.ASC.value);
        }
        List<IEntityDTO> lastList = null;
        lastList = nestedPSDEDataSet != null ? this.getDataEntityRuntime().selectDataSet(nestedPSDEDataSet, iSearchContextDTO) : this.getDataEntityRuntime().select(iSearchContextDTO);
        if (!ObjectUtils.isEmpty(lastList)) {
            ArrayList<IEntityDTO> insertList = new ArrayList<IEntityDTO>();
            for (IEntityDTO item : lastList) {
                IEntityDTO temp = this.getVersionDataEntityRuntime().createEntity();
                temp.set(this.getVersionDataParentIdPSDEField().getLowerCaseName(), key);
                temp.set(this.getVersionDataParentVersionIdPSDEField().getLowerCaseName(), versionId);
                if (this.getVersionDataParentTypePSDEField() != null) {
                    temp.set(this.getVersionDataParentTypePSDEField().getLowerCaseName(), iPSDERBase.getMajorPSDataEntityMust().getName());
                }
                temp.set(this.getVersionDataFilterPSDEField().getLowerCaseName(), pickupPSDEField.getName());
                temp.set(this.getVersionDataDataPSDEField().getLowerCaseName(), this.getDataEntityRuntime().serializeEntity(item));
                if (this.getVersionDataOwnerTypePSDEField() != null) {
                    temp.set(this.getVersionDataOwnerTypePSDEField().getLowerCaseName(), this.getDataEntityRuntime().getName());
                }
                if (this.getVersionDataOwnerIdPSDEField() != null) {
                    temp.set(this.getVersionDataOwnerIdPSDEField().getLowerCaseName(), item.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName()));
                }
                this.getVersionDataEntityRuntime().fillEntityKeyValue(temp);
                insertList.add(temp);
            }
            this.getVersionDataEntityRuntime().rawCreate(insertList, false);
        }
    }

    @Override
    public void restore(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) {
        Assert.notNull((Object)parentData, (String)"\u4f20\u5165\u7236\u6570\u636e\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSDERBase, (String)"\u4f20\u5165\u7236\u6570\u636e\u5173\u7cfb\u6a21\u578b\u65e0\u6548");
        Assert.notNull((Object)versionId, (String)"\u4f20\u5165\u7236\u6570\u636e\u7248\u672c\u65e0\u6548");
        try {
            this.onRestore(parentData, iPSDERBase, versionId);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u6062\u590d\u7236\u6570\u636e\u76f8\u5173\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onRestore(IEntityBase parentData, IPSDERBase iPSDERBase, Object versionId) throws Throwable {
        List<IEntityDTO> list;
        IPSDEField orderValuePSDEField;
        IPSDERCustom iPSDERCustom;
        IPSPickupDEField pickupPSDEField = null;
        IPSDEField parentTypePSDEField = null;
        IPSDEField parentSubTypePSDEField = null;
        String strParentSubType = null;
        IPSDEDataSet nestedPSDEDataSet = null;
        if (iPSDERBase instanceof IPSDER1N) {
            IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
            if ((iPSDER1N.getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value) {
                pickupPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
                nestedPSDEDataSet = ((IPSDER1N)iPSDERBase).getNestedPSDEDataSet();
            }
        } else if (iPSDERBase instanceof IPSDERCustom && ((iPSDERCustom = (IPSDERCustom)iPSDERBase).getMasterRS() & PSModelEnums.DER1NMasterRS.VERSION.value) == PSModelEnums.DER1NMasterRS.VERSION.value && (this.getDataEntityRuntime().getDEType() == 4 || PSModelEnums.DERSubType.DER1N.value.equalsIgnoreCase(iPSDERCustom.getDERSubType()))) {
            pickupPSDEField = iPSDERCustom.getPickupPSDEField();
            nestedPSDEDataSet = iPSDERCustom.getNestedPSDEDataSet();
            parentTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTTYPE, this.getDataEntityRuntime().getDEType() != 4);
            parentSubTypePSDEField = this.getDataEntityRuntime().getPSDEFieldByPredefinedType(PSModelEnums.PredefinedFieldType.PARENTSUBTYPE, true);
            if (parentSubTypePSDEField != null && !StringUtils.hasLength((String)(strParentSubType = ((IPSDERCustom)iPSDERBase).getTypeValue()))) {
                strParentSubType = iPSDERBase.getMinorCodeName();
            }
        }
        if (pickupPSDEField == null) {
            throw new Exception(String.format("\u4f20\u5165\u5173\u7cfb\u65e0\u6548\uff0c\u672a\u63d0\u4f9b\u8fde\u63a5\u5c5e\u6027", new Object[0]));
        }
        Object key = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMajorPSDataEntityMust().getId()).getKeyFieldValue(parentData);
        LinkedHashMap<Object, IEntityDTO> lastMap = new LinkedHashMap<Object, IEntityDTO>();
        ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
        iSearchContextDTO.all().count(false);
        this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, (IPSDEField)pickupPSDEField, "EQ", key);
        if (parentTypePSDEField != null) {
            this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentTypePSDEField, "EQ", (Object)this.getDataEntityRuntime().getName());
        }
        if (parentSubTypePSDEField != null) {
            if (StringUtils.hasLength(strParentSubType)) {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "EQ", DataTypeUtils.convert(parentSubTypePSDEField.getStdDataType(), strParentSubType));
            } else {
                this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO, parentSubTypePSDEField, "ISNULL", null);
            }
        }
        if ((orderValuePSDEField = this.getDataEntityRuntime().getOrderValuePSDEField()) != null) {
            this.getDataEntityRuntime().setSearchSort(iSearchContextDTO, orderValuePSDEField, PSModelEnums.SortDir.ASC.value);
        }
        List<IEntityDTO> lastList = null;
        lastList = nestedPSDEDataSet != null ? this.getDataEntityRuntime().selectDataSet(nestedPSDEDataSet, iSearchContextDTO) : this.getDataEntityRuntime().select(iSearchContextDTO);
        if (!ObjectUtils.isEmpty(lastList)) {
            for (IEntityDTO iEntityDTO : lastList) {
                lastMap.put(iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName()), iEntityDTO);
            }
        }
        ArrayList<IEntityDTO> updateList = new ArrayList<IEntityDTO>();
        ArrayList<IEntityDTO> createList = new ArrayList<IEntityDTO>();
        ISearchContextDTO iSearchContextDTO2 = this.getVersionDataEntityRuntime().createSearchContext();
        iSearchContextDTO2.all().count(false);
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionDataParentIdPSDEField(), "EQ", key);
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionDataParentTypePSDEField(), "EQ", (Object)iPSDERBase.getMajorPSDataEntityMust().getName());
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionDataFilterPSDEField(), "EQ", (Object)pickupPSDEField.getName());
        this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionDataParentVersionIdPSDEField(), "EQ", versionId);
        if (this.getVersionDataOwnerTypePSDEField() != null) {
            this.getVersionDataEntityRuntime().setSearchCondition((ISearchContextBase)iSearchContextDTO2, this.getVersionDataOwnerTypePSDEField(), "EQ", (Object)this.getDataEntityRuntime().getName());
        }
        if (!ObjectUtils.isEmpty(list = this.getVersionDataEntityRuntime().select(iSearchContextDTO2))) {
            for (IEntityDTO versionData : list) {
                IEntityDTO iEntityDTO = (IEntityDTO)this.getDataEntityRuntime().deserializeEntity(versionData.get(this.getVersionDataDataPSDEField().getLowerCaseName()));
                Object id = iEntityDTO.get(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName());
                IEntityDTO lastEntityDTO = (IEntityDTO)lastMap.remove(id);
                if (lastEntityDTO != null) {
                    updateList.add(lastEntityDTO);
                    continue;
                }
                createList.add(iEntityDTO);
            }
        }
        if (!ObjectUtils.isEmpty(lastMap)) {
            this.getDataEntityRuntime().rawRemove(new ArrayList<Object>(lastMap.keySet()), true);
        }
        if (!ObjectUtils.isEmpty(updateList)) {
            this.getDataEntityRuntime().rawUpdate(updateList, true);
        }
        if (!ObjectUtils.isEmpty(createList)) {
            this.getDataEntityRuntime().rawCreate(createList, true);
        }
    }
}

