/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.print;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.IDynaInstRuntime;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.central.dataentity.print.IDEPrintRuntime;
import net.ibizsys.central.dataentity.report.DEReportRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DEPrintRuntime
extends net.ibizsys.runtime.dataentity.print.DEPrintRuntime
implements IDEPrintRuntime {
    private static final Log log = LogFactory.getLog(DEPrintRuntime.class);
    private String strReportFilePath = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (!StringUtils.hasLength((String)this.getReportFilePath())) {
            this.prepareReportFilePath();
        }
    }

    @Override
    protected String getReportFilePath() {
        return this.strReportFilePath;
    }

    protected void setReportFilePath(String strReportFilePath) {
        this.strReportFilePath = strReportFilePath;
    }

    protected void prepareReportFilePath() throws Exception {
        String strReportFilePath = this.getPSDEPrint().getReportFile();
        if (!StringUtils.hasLength((String)strReportFilePath)) {
            return;
        }
        String strReportFilePath2 = strReportFilePath.toLowerCase();
        if (strReportFilePath2.indexOf("http://") == 0 || strReportFilePath2.indexOf("https://") == 0) {
            File tempFile = File.createTempFile("deprint", this.getDefaultReportFileSuffix());
            try {
                this.getSystemRuntime().getDefaultWebClient().download(strReportFilePath, null, null, null, tempFile, null);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u4e0b\u8f7d\u8fdc\u7a0b\u62a5\u8868\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.setReportFilePath(tempFile.getCanonicalPath());
        } else {
            if (!StringUtils.hasLength((String)this.getSystemRuntime().getReportFolder())) {
                if (StringUtils.hasLength((String)this.getReportModel())) {
                    return;
                }
                throw new Exception(String.format("\u7cfb\u7edf\u672a\u5b9a\u4e49\u62a5\u8868\u5b58\u50a8\u6587\u4ef6\u5939", new Object[0]));
            }
            File file = new File(this.getSystemRuntime().getReportFolder() + strReportFilePath);
            if (!file.exists()) {
                if (StringUtils.hasLength((String)this.getReportModel())) {
                    return;
                }
                throw new Exception(String.format("\u6307\u5b9a\u62a5\u8868\u6587\u4ef6\u4e0d\u5b58\u5728", new Object[0]));
            }
            this.setReportFilePath(file.getCanonicalPath());
        }
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return (IDataEntityRuntime)super.getDataEntityRuntime();
    }

    @Override
    public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime() {
        return (IDynaInstDataEntityRuntime)super.getDynaInstDataEntityRuntime();
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return (ISystemRuntime)super.getSystemRuntime();
    }

    @Override
    public IDynaInstRuntime getDynaInstRuntime() {
        return (IDynaInstRuntime)super.getDynaInstRuntime();
    }

    protected String getDefaultReportFileSuffix() {
        return null;
    }

    protected String getCodeItemTextSuffix() {
        return "text";
    }

    protected List<? extends IEntity> selectDetails(IEntity iEntity) throws Throwable {
        IPSDEDataSet detailPSDEDataSet;
        if (this.getPSDEPrint().getDetailPSDE() == null) {
            return null;
        }
        Object objValue = this.getDataEntityRuntime().getKeyFieldValue(iEntity);
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        IDataEntityRuntime childDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSDEPrint().getDetailPSDE().getId());
        ISearchContextDTO iSearchContextDTO = childDataEntityRuntime.createSearchContext();
        iSearchContextDTO.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), objValue);
        List psDERBases = this.getDataEntityRuntime().getPSDataEntity().getMajorPSDERs();
        if (!ObjectUtils.isEmpty((Object)psDERBases)) {
            String strMinorDEId = this.getPSDEPrint().getDetailPSDE().getId();
            IPSDER1N filterPSDERBase = null;
            for (IPSDERBase psDERBase : psDERBases) {
                IPSDER1N iPSDER1N;
                if (!"DER1N".equals(psDERBase.getDERType()) || ((iPSDER1N = (IPSDER1N)psDERBase).getMasterRS() & 1) != 1 || !strMinorDEId.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getId())) continue;
                if (filterPSDERBase == null) {
                    filterPSDERBase = iPSDER1N;
                    continue;
                }
                log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u5b58\u5728\u591a\u4e2a\u9644\u5c5e\u5b9e\u4f53[%2$s]\u7684\u5173\u7cfb\uff0c\u5ffd\u7565\u8fc7\u6ee4\u5904\u7406", this.getDataEntityRuntime().getName(), this.getPSDEPrint().getDetailPSDE().getName()));
                filterPSDERBase = null;
                break;
            }
            if (filterPSDERBase instanceof IPSDER1N) {
                SearchContextDTO.addSearchFieldCond(iSearchContextDTO, ((IPSDER1N)filterPSDERBase).getPSPickupDEFieldMust().getLowerCaseName(), "EQ", objValue, null);
            }
        }
        if ((detailPSDEDataSet = this.getPSDEPrint().getDetailPSDEDataSet()) == null) {
            detailPSDEDataSet = childDataEntityRuntime.getDefaultPSDEDataSet();
        }
        if (detailPSDEDataSet == null) {
            throw new Exception("\u660e\u7ec6\u6570\u636e\u6570\u636e\u96c6\u65e0\u6548");
        }
        List<IEntityDTO> list = childDataEntityRuntime.selectDataSet(detailPSDEDataSet, iSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (IEntityDTO iEntityDTO : list) {
                childDataEntityRuntime.fillEntityCodeListTexts(iEntityDTO, this.getCodeItemTextSuffix());
            }
        }
        return list;
    }

    @Override
    protected IEntityBase[] onBeforeOutput(IEntityBase[] list, String strType) throws Throwable {
        if (list != null) {
            for (IEntityBase iEntityBase : list) {
                if (!(iEntityBase instanceof IEntity)) continue;
                this.getDataEntityRuntime().fillEntityCodeListTexts((IEntity)iEntityBase, this.getCodeItemTextSuffix());
            }
        }
        return super.onBeforeOutput(list, strType);
    }

    @Override
    public void output(ServletResponse servletResponse, Object[] keys, String strType, boolean bTestPriv) throws Throwable {
        if (!StringUtils.hasLength((String)strType)) {
            strType = this.getDefaultContentType();
        }
        try {
            this.onOutput(servletResponse, keys, strType, bTestPriv);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException dataEntityRuntimeException;
            if (ex instanceof DataEntityRuntimeException && (dataEntityRuntimeException = (DataEntityRuntimeException)ex).getModelRuntime() == this) {
                throw dataEntityRuntimeException;
            }
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u8f93\u51fa\u6253\u5370\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onOutput(ServletResponse servletResponse, Object[] keys, String strType, boolean bTestPriv) throws Throwable {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.output(bos, keys, strType, bTestPriv);
        this.outputContentType(servletResponse, strType, null);
        bos.writeTo((OutputStream)servletResponse.getOutputStream());
    }

    protected void outputContentType(ServletResponse servletResponse, String strType, String strFileName) throws Exception {
        if (StringUtils.hasLength((String)strType)) {
            PSModelEnums.ReportContentType reportContentType = PSModelEnums.ReportContentType.from((String)strType);
            DEReportRuntime.outputContentType(servletResponse, reportContentType);
            if (!StringUtils.hasLength((String)strFileName)) {
                switch (reportContentType) {
                    case DOCX: {
                        strFileName = "print.docx";
                        break;
                    }
                    case PDF: {
                        strFileName = "print.pdf";
                        break;
                    }
                }
            }
        }
        if (!StringUtils.hasLength((String)strFileName)) {
            return;
        }
        if (servletResponse instanceof HttpServletResponse) {
            String strFileName2 = new String(URLEncoder.encode(strFileName, "utf-8").getBytes("utf-8"), "iso8859-1");
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", "0");
            httpServletResponse.setHeader("charset", "utf-8");
            if (StringUtils.hasLength((String)strFileName)) {
                httpServletResponse.setHeader("Content-Disposition", String.format("attachment;filename=%s;filename*=utf-8''%s", strFileName2, URLEncoder.encode(strFileName, "utf-8")));
            }
        }
    }
}

