/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.logic;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.central.dataentity.logic.IDEMSLogicRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogic;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogicLink;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkCond;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkGroupCond;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkSingleCond;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBaseContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEMSLogicRuntimeBase
extends DataEntityModelRuntimeBase
implements IDEMSLogicRuntime {
    private static final Log log = LogFactory.getLog(DEMSLogicRuntimeBase.class);
    private IPSDEMSLogic iPSDEMSLogic = null;
    private int nDebugMode = 0;
    private IDataEntityRuntimeBaseContext iDataEntityRuntimeBaseContext = null;
    private IPSDEField statePSDEField = null;
    private Map<String, IPSDEMSLogicNode> psDEMSLogicNodeMap = new LinkedHashMap<String, IPSDEMSLogicNode>();

    @Override
    public void init(IDataEntityRuntimeBaseContext iDataEntityRuntimeBaseContext, IPSDEMSLogic iPSDEMSLogic) throws Exception {
        this.setDataEntityRuntimeBase(iDataEntityRuntimeBaseContext.getDataEntityRuntime());
        this.iDataEntityRuntimeBaseContext = iDataEntityRuntimeBaseContext;
        this.iPSDEMSLogic = iPSDEMSLogic;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        List mainStatePSDEFieldList = this.getDataEntityRuntime().getPSDataEntity().getMainStatePSDEFields();
        if (ObjectUtils.isEmpty((Object)mainStatePSDEFieldList)) {
            throw new Exception("\u5b9e\u4f53\u672a\u5b9a\u4e49\u4e3b\u72b6\u6001\u5c5e\u6027");
        }
        if (StringUtils.hasLength((String)this.getPSDEMSLogic().getLogicTag2())) {
            if (this.getDataEntityRuntime().getPSDataEntity().getMainStatePSDEFields().size() <= 2) {
                throw new Exception(String.format("\u5b9e\u4f53\u672a\u63d0\u4f9b\u7b2c\u4e09\u4e2a\u4e3b\u72b6\u6001\u5c5e\u6027", new Object[0]));
            }
            this.statePSDEField = (IPSDEField)mainStatePSDEFieldList.get(2);
        } else if (StringUtils.hasLength((String)this.getPSDEMSLogic().getLogicTag())) {
            if (this.getDataEntityRuntime().getPSDataEntity().getMainStatePSDEFields().size() <= 1) {
                throw new Exception(String.format("\u5b9e\u4f53\u672a\u63d0\u4f9b\u7b2c\u4e8c\u4e2a\u4e3b\u72b6\u6001\u5c5e\u6027", new Object[0]));
            }
            this.statePSDEField = (IPSDEField)mainStatePSDEFieldList.get(1);
        } else {
            this.statePSDEField = (IPSDEField)mainStatePSDEFieldList.get(0);
        }
        List psDEMSLogicNodes = this.getPSDEMSLogic().getPSDEMSLogicNodes();
        if (!ObjectUtils.isEmpty((Object)psDEMSLogicNodes)) {
            for (IPSDEMSLogicNode iPSDEMSLogicNode : psDEMSLogicNodes) {
                String strState = iPSDEMSLogicNode.getStateValue();
                if (!StringUtils.hasLength((String)strState)) {
                    strState = iPSDEMSLogicNode.getCodeName();
                }
                if (!StringUtils.hasLength((String)strState)) {
                    throw new Exception(String.format("\u72b6\u6001\u8282\u70b9[%1$s]\u672a\u5b9a\u4e49\u72b6\u6001\u503c", iPSDEMSLogicNode.getName()));
                }
                if (this.psDEMSLogicNodeMap.containsKey(strState)) {
                    throw new Exception(String.format("\u51fa\u73b0\u91cd\u590d\u7684\u72b6\u6001\u503c[%1$s]", strState));
                }
                this.psDEMSLogicNodeMap.put(strState, iPSDEMSLogicNode);
                if (!iPSDEMSLogicNode.isDefaultMode()) continue;
                if (this.psDEMSLogicNodeMap.containsKey("")) {
                    throw new Exception(String.format("\u51fa\u73b0\u91cd\u590d\u7684\u9ed8\u8ba4\u72b6\u6001\u8282\u70b9[%1$s]", iPSDEMSLogicNode.getName()));
                }
                this.psDEMSLogicNodeMap.put("", iPSDEMSLogicNode);
            }
        }
        super.onInit();
    }

    protected IDataEntityRuntimeBaseContext getDataEntityRuntimeContext() {
        return this.iDataEntityRuntimeBaseContext;
    }

    private DEMSLogicRuntimeBase getSelf() {
        return this;
    }

    protected IPSDEField getStatePSDEField() {
        return this.statePSDEField;
    }

    @Override
    public IPSDEMSLogic getPSDEMSLogic() {
        return this.iPSDEMSLogic;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDEMSLogic();
    }

    @Override
    public int getDebugMode() {
        return this.nDebugMode;
    }

    protected void setDebugMode(int nDebugMode) {
        this.nDebugMode = nDebugMode;
    }

    @Override
    public boolean isOutputDebugInfo() {
        return this.getDebugMode() == 1;
    }

    @Override
    public List<IPSDEMSLogicNode> getNextPSDEMSLogicNodes(IEntity iEntity) {
        try {
            return this.onGetNextPSDEMSLogicNodes(iEntity);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u8ba1\u7b97\u4e3b\u72b6\u6001\u903b\u8f91\u4e0b\u4e00\u6b65\u8282\u70b9\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected List<IPSDEMSLogicNode> onGetNextPSDEMSLogicNodes(IEntity iEntity) throws Throwable {
        ArrayList<IPSDEMSLogicNode> list = new ArrayList<IPSDEMSLogicNode>();
        String strState = DataTypeUtils.getStringValue(this.getDataEntityRuntime().getFieldValue(iEntity, this.getStatePSDEField()), "");
        IPSDEMSLogicNode iPSDEMSLogicNode = this.getPSDEMSLogicNodeByState(strState, false);
        if (!ObjectUtils.isEmpty((Object)iPSDEMSLogicNode.getPSDEMSLogicLinks())) {
            for (IPSDEMSLogicLink iPSDEMSLogicLink : iPSDEMSLogicNode.getPSDEMSLogicLinks()) {
                if (iPSDEMSLogicLink.getPSDEMSLogicLinkGroupCond() != null) {
                    try {
                        if (!this.testPSDEMSLogicLinkCond(iEntity, (IPSDEMSLogicLinkCond)iPSDEMSLogicLink.getPSDEMSLogicLinkGroupCond())) {
                            continue;
                        }
                    }
                    catch (Throwable ex) {
                        throw new Exception(String.format("\u5224\u65ad\u8282\u70b9[%1$s]\u8def\u7531\u6761\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEMSLogicNode.getName(), ex.getMessage()), ex);
                    }
                }
                list.add(iPSDEMSLogicLink.getDstPSDEMSLogicNodeMust());
            }
        }
        return list;
    }

    protected IPSDEMSLogicNode getPSDEMSLogicNodeByState(String strState, boolean bTryMode) throws Exception {
        IPSDEMSLogicNode iPSDEMSLogicNode = this.psDEMSLogicNodeMap.get(strState);
        if (iPSDEMSLogicNode != null || bTryMode) {
            return iPSDEMSLogicNode;
        }
        if (StringUtils.hasLength((String)strState)) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u503c[%1$s]\u72b6\u6001\u8282\u70b9", strState));
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u9ed8\u8ba4\u72b6\u6001\u8282\u70b9", new Object[0]));
    }

    protected boolean testPSDEMSLogicLinkCond(IEntity iEntity, IPSDEMSLogicLinkCond iPSDEMSLogicLinkCond) throws Exception {
        if (iPSDEMSLogicLinkCond instanceof IPSDEMSLogicLinkGroupCond) {
            IPSDEMSLogicLinkGroupCond iPSDEMSLogicLinkGroupCond = (IPSDEMSLogicLinkGroupCond)iPSDEMSLogicLinkCond;
            boolean bRet = true;
            if (iPSDEMSLogicLinkGroupCond.getGroupOP().equals("AND")) {
                if (iPSDEMSLogicLinkGroupCond.getPSDEMSLogicLinkConds() != null && iPSDEMSLogicLinkGroupCond.getPSDEMSLogicLinkConds().size() > 0) {
                    bRet = true;
                    for (IPSDEMSLogicLinkCond childPSDEMSLogicLinkCond : iPSDEMSLogicLinkGroupCond.getPSDEMSLogicLinkConds()) {
                        if (this.testPSDEMSLogicLinkCond(iEntity, childPSDEMSLogicLinkCond)) continue;
                        bRet = false;
                        break;
                    }
                }
            } else if (iPSDEMSLogicLinkGroupCond.getGroupOP().equals("OR")) {
                if (iPSDEMSLogicLinkGroupCond.getPSDEMSLogicLinkConds() != null && iPSDEMSLogicLinkGroupCond.getPSDEMSLogicLinkConds().size() > 0) {
                    bRet = false;
                    for (IPSDEMSLogicLinkCond childPSDEMSLogicLinkCond : iPSDEMSLogicLinkGroupCond.getPSDEMSLogicLinkConds()) {
                        if (!this.testPSDEMSLogicLinkCond(iEntity, childPSDEMSLogicLinkCond)) continue;
                        bRet = true;
                        break;
                    }
                }
            } else {
                throw new Exception(String.format("\u8def\u7531\u6761\u4ef6[%1$s]\u7ec4\u903b\u8f91\u64cd\u4f5c[%2$s]\u65e0\u6548", iPSDEMSLogicLinkCond.getName(), iPSDEMSLogicLinkGroupCond.getGroupOP()));
            }
            if (iPSDEMSLogicLinkGroupCond.isNotMode()) {
                bRet = !bRet;
            }
            return bRet;
        }
        if (iPSDEMSLogicLinkCond instanceof IPSDEMSLogicLinkSingleCond) {
            IPSDEMSLogicLinkSingleCond iPSDEMSLogicLinkSingleCond = (IPSDEMSLogicLinkSingleCond)iPSDEMSLogicLinkCond;
            Object objValue = null;
            String strDstFieldName = iPSDEMSLogicLinkSingleCond.getDstFieldName();
            if (ObjectUtils.isEmpty((Object)strDstFieldName)) {
                throw new Exception(String.format("\u5355\u9879\u6761\u4ef6[%1$s]\u672a\u6307\u5b9a\u76ee\u6807\u5c5e\u6027", iPSDEMSLogicLinkSingleCond.getName()));
            }
            objValue = iEntity.get(strDstFieldName.toLowerCase());
            Object dstValue = iPSDEMSLogicLinkSingleCond.getParamValue();
            String strParamType = iPSDEMSLogicLinkSingleCond.getParamType();
            if (StringUtils.hasLength((String)strParamType)) {
                if (ObjectUtils.isEmpty((Object)dstValue)) {
                    throw new Exception(String.format("\u5355\u9879\u6761\u4ef6[%1$s]\u672a\u6307\u5b9a\u53c2\u6570\u9879\u540d\u79f0", iPSDEMSLogicLinkCond.getName()));
                }
                if (strParamType.equals(PSModelEnums.DEFVRParamType.ENTITYFIELD.value)) {
                    dstValue = iEntity.get(((String)dstValue).toLowerCase());
                } else if (strParamType.equals(PSModelEnums.DEFVRParamType.CURTIME.value)) {
                    dstValue = new Timestamp(System.currentTimeMillis());
                } else {
                    throw new Exception(String.format("\u5355\u9879\u6761\u4ef6[%1$s]\u53c2\u6570\u7c7b\u578b[%2$s]\u672a\u652f\u6301", iPSDEMSLogicLinkCond.getName(), strParamType));
                }
            }
            return this.testValueCond(objValue, iPSDEMSLogicLinkSingleCond.getCondOP(), dstValue);
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u8def\u7531\u6761\u4ef6[%1$s][%2$s]", iPSDEMSLogicLinkCond.getName(), iPSDEMSLogicLinkCond.getLogicType()));
    }

    protected boolean testValueCond(Object objSrcValue, String strOP, Object objDstValue) throws Exception {
        return DataTypeUtils.testCond(objSrcValue, strOP, objDstValue);
    }

    protected boolean test(Object objSrcValue, String strOP, Object objDstValue) throws Exception {
        return this.testValueCond(objSrcValue, strOP, objDstValue);
    }
}

