/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.logic;

import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.logic.DELogicNodeRuntimeBase;
import net.ibizsys.central.dataentity.logic.IDELogicRuntimeContext;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQJoin;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DELogicFilterParamNodeRuntimeBase
extends DELogicNodeRuntimeBase {
    private static final Log log = LogFactory.getLog(DELogicFilterParamNodeRuntimeBase.class);

    protected boolean testPSDEDQJoin(IDELogicRuntimeContext iDELogicRuntimeContext, Object data, IPSDEDQJoin iPSDEDQJoin) throws Exception {
        Assert.notNull((Object)data, (String)String.format("\u4f20\u5165\u6570\u636e\u65e0\u6548", new Object[0]));
        Assert.notNull((Object)iPSDEDQJoin, (String)String.format("\u4f20\u5165\u6570\u636e\u67e5\u8be2\u8fde\u63a5\u65e0\u6548", new Object[0]));
        if (iPSDEDQJoin.getPSDEDQGroupCondition() != null && !this.testPSDEDQCondition(data, (IPSDEDQCondition)iPSDEDQJoin.getPSDEDQGroupCondition())) {
            return false;
        }
        List psDEDQJoinList = iPSDEDQJoin.getChildPSDEDQJoins();
        if (psDEDQJoinList != null) {
            for (IPSDEDQJoin childPSDEDQJoin : psDEDQJoinList) {
                IPSDEMethodDTOField iPSDEMethodDTOField;
                IEntityDTO iEntityDTO;
                String strJoinType = childPSDEDQJoin.getJoinType();
                if (!"1N".equals(strJoinType) && !"1NNOT".equals(strJoinType)) continue;
                boolean bNot = false;
                if ("1NNOT".equals(strJoinType)) {
                    bNot = true;
                }
                String strFieldCodeName = null;
                IPSDERBase iPSDERBase = childPSDEDQJoin.getJoinPSDERMust();
                if (data instanceof IEntityDTO && (iEntityDTO = (IEntityDTO)data).getDEMethodDTORuntime() != null && (iPSDEMethodDTOField = iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDER(iPSDERBase.getId(), true)) != null) {
                    strFieldCodeName = iPSDEMethodDTOField.getName();
                }
                if (!StringUtils.hasLength(strFieldCodeName)) {
                    if (iPSDERBase instanceof IPSDER1N) {
                        strFieldCodeName = ((IPSDER1N)iPSDERBase).getMinorCodeName();
                    } else if (iPSDERBase instanceof IPSDERCustom) {
                        strFieldCodeName = ((IPSDERCustom)iPSDERBase).getMinorCodeName();
                    }
                }
                if (!StringUtils.hasLength(strFieldCodeName)) {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u67e5\u8be2\u8fde\u63a5[%1$s][%2$s]", strJoinType, iPSDERBase.getDERType()));
                }
                Object childItem = null;
                if (data instanceof IEntity) {
                    IEntity iEntity = (IEntity)data;
                    childItem = iEntity.get(strFieldCodeName.toLowerCase());
                } else if (data instanceof Map) {
                    Map map = (Map)data;
                    childItem = map.get(strFieldCodeName.toLowerCase());
                } else {
                    throw new Exception(String.format("\u6570\u636e\u5bf9\u8c61[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", data));
                }
                List childItemList = null;
                if (childItem instanceof List) {
                    childItemList = (List)childItem;
                } else if (childItem != null) {
                    throw new Exception(String.format("\u5c5e\u6027[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", strFieldCodeName));
                }
                if (ObjectUtils.isEmpty((Object)childItemList)) {
                    if (bNot) continue;
                    return false;
                }
                boolean bItemOk = false;
                for (Object childData : childItemList) {
                    boolean bRet = this.testPSDEDQJoin(iDELogicRuntimeContext, childData, childPSDEDQJoin);
                    if (bRet && !bNot) {
                        bItemOk = true;
                        break;
                    }
                    if (bRet || !bNot) continue;
                    bItemOk = true;
                    break;
                }
                if (bItemOk) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean testPSDEDQCondition(Object data, IPSDEDQCondition iPSDEDQCondition) throws Exception {
        if (iPSDEDQCondition instanceof IPSDEDQGroupCondition) {
            IPSDEDQGroupCondition iPSDEDQGroupCondition = (IPSDEDQGroupCondition)iPSDEDQCondition;
            boolean bRet = true;
            if (iPSDEDQGroupCondition.getCondOp().equals("AND")) {
                if (iPSDEDQGroupCondition.getPSDEDQConditions() != null && iPSDEDQGroupCondition.getPSDEDQConditions().size() > 0) {
                    bRet = true;
                    for (IPSDEDQCondition childPSDEDQCondition : iPSDEDQGroupCondition.getPSDEDQConditions()) {
                        if (this.testPSDEDQCondition(data, childPSDEDQCondition)) continue;
                        bRet = false;
                        break;
                    }
                }
            } else if (iPSDEDQGroupCondition.getCondOp().equals("OR") && iPSDEDQGroupCondition.getPSDEDQConditions() != null && iPSDEDQGroupCondition.getPSDEDQConditions().size() > 0) {
                bRet = false;
                for (IPSDEDQCondition childPSDEDQCondition : iPSDEDQGroupCondition.getPSDEDQConditions()) {
                    if (!this.testPSDEDQCondition(data, childPSDEDQCondition)) continue;
                    bRet = true;
                    break;
                }
            }
            if (iPSDEDQGroupCondition.isNotMode()) {
                bRet = !bRet;
            }
            return bRet;
        }
        if (iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
            IPSDEDQFieldCondition iPSDEDQFieldCondition = (IPSDEDQFieldCondition)iPSDEDQCondition;
            String strDstFieldName = iPSDEDQFieldCondition.getPSDEFieldMust().getLowerCaseName();
            Object objValue = null;
            if (data instanceof IEntity) {
                IEntity iEntity = (IEntity)data;
                objValue = iEntity.get(strDstFieldName.toLowerCase());
            } else if (data instanceof Map) {
                Map map = (Map)data;
                objValue = map.get(strDstFieldName.toLowerCase());
            } else {
                throw new Exception(String.format("\u6570\u636e\u5bf9\u8c61[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", data));
            }
            if (StringUtils.hasLength((String)iPSDEDQFieldCondition.getValueFunc())) {
                objValue = this.calcValueFunc(objValue, iPSDEDQFieldCondition.getValueFunc());
            }
            Object dstValue = iPSDEDQFieldCondition.getCondValue();
            if (StringUtils.hasLength((String)iPSDEDQFieldCondition.getPSVARTypeId())) {
                dstValue = this.calcValueType(dstValue, iPSDEDQFieldCondition.getPSVARTypeId());
            }
            return this.testValueCond(objValue, iPSDEDQFieldCondition.getCondOp(), dstValue);
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u8fde\u63a5\u6761\u4ef6[%1$s][%2$s]", iPSDEDQCondition.getName(), iPSDEDQCondition.getCondType()));
    }

    protected Object calcValueFunc(Object objValue, String strFuncName) throws Exception {
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u503c\u5904\u7406\u65b9\u6cd5[%1$s]", strFuncName));
    }

    protected Object calcValueType(Object objValue, String strVarType) throws Exception {
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u503c\u53d8\u91cf\u7c7b\u578b[%1$s]", strVarType));
    }

    protected boolean testValueCond(Object objSrcValue, String strOP, Object objDstValue) throws Exception {
        return DataTypeUtils.testCond(objSrcValue, strOP, objDstValue);
    }
}

