package net.ibizsys.runtime.security;

/**
 * 用户会话的键值常量
 * @author lionlau
 *
 */
public class UserSessionKeys {

	/**
	 * 用户标识
	 */
	final public static String USERID = "SRFUSERID";
	
	/**
	 * 用户名称
	 */
	final public static String USERNAME = "SRFUSERNAME";


	/**
	 * 当前的用户模式
	 */
	final public static String USERMODE = "SRFUSERMODE";
	
	

	/**
	 * 登录名称
	 */
	public final static String LOGINNAME = "SRFLOGINNAME";

	/**
	 * 超级用户模式
	 */
	public final static String SUPERUSER = "SRFSUPERUSER";

	/**
	 * 组织管理员
	 */
	public final static String ORGADMIN = "SRFORGADMIN";


	/**
	 * 本地化（Spring变量）
	 */
	public final static String LOCALE = "SRFLOCALE";
	
	/**
	 * 当前用户时区标识
	 */
	public final static String TIMEZONE = "SRFTIMEZONE";

	/**
	 * 当前用户组织标识
	 */
	public final static String ORGID = "SRFORGID";

	/**
	 * 当前用户组织名称
	 */
	public final static String ORGNAME = "SRFORGNAME";

	/**
	 * 当前用户组织部门标识
	 */
	public final static String ORGSECTORID = "SRFORGSECTORID";

	/**
	 * 当前用户组织部门名称
	 */
	public final static String ORGSECTORNAME = "SRFORGSECTORNAME";

	/**
	 * 当前用户条线代码
	 */
	public final static String ORGSECTORBC = "SRFORGSECTORBC";
}
