package net.ibizsys.runtime;

import net.ibizsys.model.IPSModelObject;

/**
 * 模型运行时实现基类对象
 * @author lionlau
 *
 */
public abstract class ModelRuntimeBase implements IModelRuntime {

	private String strLowerCaseName = null;
	
	@Override
	public String getId() {
		return getPSModelObject().getId();
	}
	
	
	@Override
	public String getName() {
		return getPSModelObject().getName();
	}
	
	@Override
	public String getLowerCaseName() {
		if(this.strLowerCaseName == null && this.getName()!= null) {
			this.strLowerCaseName = this.getName().toLowerCase();
		}
		return this.strLowerCaseName;
	}
	
	@Override
	public String getLogicName() {
		return this.getName();
	}
	
	/**
	 * 初始化
	 * @throws Exception
	 */
	protected void onInit() throws Exception{
		
	}
	
	
	/**
	 * 获取相关的模型对象
	 * @return
	 */
	public abstract IPSModelObject getPSModelObject();
	
	
	
}
