package net.ibizsys.central.util.script;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;

import org.springframework.util.ObjectUtils;

import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.service.client.WebClientBase;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.Errors;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;

public class ScriptEntity extends net.ibizsys.runtime.util.script.ScriptEntity implements IScriptEntity {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(ScriptEntity.class);
	
	public ScriptEntity(IDataEntityRuntime iDataEntityRuntime, IEntityBase iEntityBase) {
		super(iDataEntityRuntime, iEntityBase);
	}
	
	public ScriptEntity(ISystemRuntime iSystemRuntime, IEntity iEntity) {
		super(iSystemRuntime, iEntity);
	}
	
	protected ISystemRuntime getSystemRuntime() {
		return (ISystemRuntime)super.getSystemRuntime();
	}
	
	@Override
	protected IDataEntityRuntime getDataEntityRuntime() {
		return (IDataEntityRuntime)super.getDataEntityRuntime();
	}

	
	@Override
	public Object get(String strName) {
		Object objValue = super.get(strName);
		if(objValue == null) {
			return objValue;
		}
		
		return this.getSystemRuntime().createScriptObject(objValue);
		
	}

	@Override
	public Object call(String strName, Object... objects) {
		if(this.getDataEntityRuntime() == null) {
			throw new SystemRuntimeException(this.getSystemRuntime(), "未指定实体运行时对象，无法支持此操作");
		}
		
		throw new DataEntityRuntimeException(this.getDataEntityRuntime(), "没有实现", Errors.NOTIMPL);
//		try {
//			
//			//需要转化入参及出参
//			
//			Object objRet = this.getDataEntityRuntime().executeAction(strName, null, new Object[] { this.getEntityBase() });
//			return objRet;
//		} catch (Throwable ex) {
//			log.error(String.format("实体[%1$s]自定义调用[%3$s]发生异常，%2$s", this.getDataEntityRuntime().getName(), ex.getMessage(), strName), ex);
//			throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("自定义调用[%2$s]发生异常，%1$s", ex.getMessage(), strName), ex);
//		}
	}
	
	
	@Override
	public Timestamp getTimestamp(String strName, Timestamp def) {
		try {
			return DataTypeUtils.getDateTimeValue(super.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public BigDecimal getBigDecimal(String strName, BigDecimal fDefault) {
		try {
			return DataTypeUtils.getBigDecimalValue(super.get(strName), fDefault);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public BigInteger getBigInteger(String strName, BigInteger nDefault) {
		try {
			return DataTypeUtils.getBigIntegerValue(super.get(strName), nDefault);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public Boolean getBoolean(String strName, Boolean def) {
		try {
			return DataTypeUtils.getBooleanValue(super.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public Double getDouble(String strName, Double def) {
		try {
			return DataTypeUtils.getDoubleValue(super.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public Float getFloat(String strName, Float def) {
		try {
			return DataTypeUtils.getFloatValue(super.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}

	
	@Override
	public Integer getInteger(String strName, Integer def) {
		try {
			return DataTypeUtils.getIntegerValue(super.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	

	@Override
	public Long getLong(String strName, Long def) {
		try {
			return DataTypeUtils.getLongValue(super.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public String getString(String strName, String strDefault) {
		try {
			return DataTypeUtils.getStringValue(super.get(strName), strDefault);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	
	@Override
	public String toJsonString() {
		return this.toJsonString(false);
	}
	
	
	@Override
	public String codelisttext(String strName) {
		if(this.getDataEntityRuntime() == null) {
			throw new RuntimeException("实体运行时对象无效");
		}
		
		IPSDEField iPSDEField = this.getDataEntityRuntime().getPSDEField(strName);
		IPSCodeList iPSCodeList = iPSDEField.getPSCodeList();
		if(iPSCodeList == null) {
			throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("属性[%1$s]未绑定代码表", iPSDEField.getName()));
		}
		
		ICodeListRuntime iCodeListRuntime = this.getSystemRuntime().getCodeListRuntime(iPSCodeList);
		Object objValue = this.get(strName);
		try {
			if(ObjectUtils.isEmpty(objValue)) {
				return iCodeListRuntime.getEmptyText();
			}
			else {
				return iCodeListRuntime.getText(objValue);
			}
		}
		catch (Throwable ex) {
			log.error(String.format("获取代码表[%1$s]值[%2$s]文本发生异常，%3$s", iPSCodeList.getId(), objValue, ex.getMessage()));
			return ex.getMessage();
		}
	}
	
	
	@Override
	public String toJsonString(boolean bDTO) {
		try {
			Entity entity = new Entity();
			if(bDTO) {
				if(this.getReal() instanceof IEntityDTO) {
					((IEntityDTO)this.getReal()).copyTo(entity, true);
				}
				else
					if(this.getReal() instanceof IEntity) {
						((IEntity)this.getReal()).copyTo(entity);
					}
			}
			else {
				if(this.getReal() instanceof IEntity) {
					((IEntity)this.getReal()).copyTo(entity);
				}
			}
			
			if(this.getDataEntityRuntime()!=null) {
				this.getDataEntityRuntime().fillEntityCodeListTexts(entity);
			}
			
			return WebClientBase.MAPPER.writeValueAsString(entity);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	
	@Override
	public String toString() {
		try {
			Entity entity = new Entity();
			if(this.getReal() instanceof IEntity) {
				((IEntity)this.getReal()).copyTo(entity);
			}
			return WebClientBase.MAPPER.writeValueAsString(entity);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
}
