package net.ibizsys.central.util.groovy;


import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.eai.ISysEAIAgentRuntime;
import net.ibizsys.central.res.ISysResourceRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.central.sysutil.ISysUniStateUtilRuntime;
import net.ibizsys.central.sysutil.ISysUtilRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.res.ISysSequenceRuntime;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.sysutil.ISysFileUtilRuntime;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.AppContext;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.LogCats;
import net.ibizsys.runtime.util.LogLevels;


public class SystemRTGroovyContext implements ISystemRTGroovyContext {

	private ISystemRuntimeContext systemRuntimeContext = null;
	
	
	public SystemRTGroovyContext(ISystemRuntimeContext systemRuntimeContext) {
		Assert.notNull(systemRuntimeContext, "传入系统运行时上下文无效");
		this.systemRuntimeContext = systemRuntimeContext;
	}
	
	protected ISystemRuntimeContext getSystemRuntimeContext() {
		return this.systemRuntimeContext;
	}
	
	protected ISystemRuntime getSystemRuntime() {
		return this.getSystemRuntimeContext().getSystemRuntime();
	}
	
	@Override
	public IWebClient webclient() {
		return getSystemRuntime().getDefaultWebClient();
	}

	@Override
	public IWebClient webclient(String tag) {
		return subsysapi(tag).getWebClient();
	}
	
	
	@Override
	public IDataEntityRuntime dataentity(String tag) {
		return this.getSystemRuntime().getDataEntityRuntime(tag, false);
	}

	@Override
	public IDEService deservice(String tag) {
		return this.dataentity(tag).getDEService();
	}
	
	@Override
	public ISubSysServiceAPIRuntime subsysapi(String tag) {
		return this.getSystemRuntime().getSubSysServiceAPIRuntime(tag, false);
	}

	@Override
	public ISysUtilRuntime util(String tag) {
		return (ISysUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(tag, false);
	}
	
	@Override
	public ICodeListRuntime codelist(String tag) {
		return this.getSystemRuntime().getCodeListRuntime(tag, false);
	}
	
	@Override
	public IEntity entity() {
		return new Entity();
	}

	@Override
	public IEntityDTO entity(String tag) {
		return dataentity(tag).createEntity();
	}
	
	@Override
	public ISearchContextDTO filter(String tag) {
		return dataentity(tag).createSearchContext();
	}
	
	@Override
	public ISysLogicRuntime logic(String tag) {
		return this.getSystemRuntime().getSysLogicRuntime(tag, false);
	}
	
	
	
	@Override
	public ISysSequenceRuntime sequence(String tag) {
		return this.getSystemRuntime().getSysSequenceRuntime(tag, false);
	}

	@Override
	public ISysTranslatorRuntime translator(String tag) {
		return this.getSystemRuntime().getSysTranslatorRuntime(tag, false);
	}
	
	

	@Override
	public ISysDataSyncAgentRuntime datasyncagent(String tag) {
		return this.getSystemRuntime().getSysDataSyncAgentRuntime(tag, false);
	}

	@Override
	public ISysEAIAgentRuntime eaiagent(String tag) {
		ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime = this.getSystemRuntime().getSysDataSyncAgentRuntime(tag, false);
		if(iSysDataSyncAgentRuntime instanceof ISysEAIAgentRuntime) {
			return (ISysEAIAgentRuntime)iSysDataSyncAgentRuntime;
		}
		throw new SystemRuntimeException(this.getSystemRuntime(), String.format("应用集成代理[%1$s]类型不正确", tag));
	}
	
	@Override
	public ISysDBSchemeRuntime dbschema(String tag) {
		return dbscheme(tag);
	}
	
	@Override
	public ISysDBSchemeRuntime dbscheme(String tag) {
		return this.getSystemRuntime().getSysDBSchemeRuntime(tag, false);
	}

	@Override
	public ISysResourceRuntime resource(String tag) {
		return this.getSystemRuntime().getSysResourceRuntime(tag, false);
	}
	
	@Override
	public Object plugin(String tag) {
		try {
			return this.getSystemRuntime().getSysSFPluginRuntime(tag, false).getRuntimeObject(false);
		}
		catch (Exception ex) {
			throw new SystemRuntimeException(this.getSystemRuntime(), String.format("获取插件[%1$s]发生异常，%2$s", tag, ex.getMessage()), ex);
		}
	}
	
	@Override
	public Object config(String strKey) {
		return config(strKey, null);
	}
	
	@Override
	public Object config(String strKey, Object defValue) {
		Object value = this.getSystemRuntime().getSystemRuntimeSetting().getParam(strKey);
		return (value != null)?value:defValue;
	}
	
	@Override
	public Object param(String strKey) {
		return param(strKey, null);
	}

	@Override
	public Object param(String strKey, Object defValue) {
		Object value = this.getSystemRuntime().getSystemRuntimeSetting().getParam("param." + strKey);
		return (value != null)?value:defValue;
	}

	@Override
	public Object getModelRuntime(Class<?> theClass, String tag) {
		if (ISysUtilRuntime.class.isAssignableFrom(theClass)) {
			if (ISysFileUtilRuntime.class.isAssignableFrom(theClass)) {
				return this.getSystemRuntime().getSysFileUtilRuntime(true);
			}
			if (ISysCacheUtilRuntime.class.isAssignableFrom(theClass)) {
				return this.getSystemRuntime().getSysCacheUtilRuntime(true);
			}
			if (ISysUniStateUtilRuntime.class.isAssignableFrom(theClass)) {
				return this.getSystemRuntime().getSysUniStateUtilRuntime(true);
			}
			
			if(StringUtils.hasLength(tag)) {
				Object obj = this.getSystemRuntime().getSysUtilRuntime(tag, true);
				if(obj != null) {
					return obj;
				}
			}
			
			return this.getSystemRuntime().getSysUtilRuntime(theClass, false);
			
			//return getModelRuntime(MODELTYPE_UTIL, tag);
		}
		if (ISubSysServiceAPIRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_SUBSYSAPI, tag);
		}
		if (IWebClient.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_WEBCLIENT, tag);
		}
		if (IDataEntityRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_DATAENTITY, tag);
		}
		if (IDEService.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_DESERVICE, tag);
		}
		if (ISysLogicRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_LOGIC, tag);
		}
		if (ICodeListRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_CODELIST, tag);
		}
		if (ISysTranslatorRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_TRANSLATOR, tag);
		}
		if (ISysSequenceRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_SEQUENCE, tag);
		}
		if (ISysDataSyncAgentRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_DATASYNCAGENT, tag);
		}
		if (ISysEAIAgentRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_EAIAGENT, tag);
		}
		if (ISysDBSchemeRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_DBSCHEME, tag);
		}
		
		if (ISysResourceRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_RESOURCE, tag);
		}
		
		
		if (ISystemRuntime.class.isAssignableFrom(theClass)) {
			return getModelRuntime(MODELTYPE_SYS, tag);
		}
		
		throw new RuntimeException(String.format("无法识别的运行时对象[%1$s][%2$s]", theClass.getName(), tag));
	}

	@Override
	public Object getModelRuntime(String type, String tag) {
		
		if(MODELTYPE_SYS.equalsIgnoreCase(type)) {
			return this.getSystemRuntime();
		}
		
		if(MODELTYPE_UTIL.equalsIgnoreCase(type)) {
			return this.util(tag);
		}
		if(MODELTYPE_SUBSYSAPI.equalsIgnoreCase(type)) {
			return this.subsysapi(tag);
		}
		if(MODELTYPE_WEBCLIENT.equalsIgnoreCase(type)) {
			return this.webclient(tag);
		}
		if(MODELTYPE_DATAENTITY.equalsIgnoreCase(type)) {
			return this.dataentity(tag);
		}
		if(MODELTYPE_DESERVICE.equalsIgnoreCase(type)) {
			return this.deservice(tag);
		}
		
		if(MODELTYPE_LOGIC.equalsIgnoreCase(type)) {
			return this.logic(tag);
		}
		
		if(MODELTYPE_CODELIST.equalsIgnoreCase(type)) {
			return this.codelist(tag);
		}
		
		if(MODELTYPE_SEQUENCE.equalsIgnoreCase(type)) {
			return this.sequence(tag);
		}
		
		if(MODELTYPE_TRANSLATOR.equalsIgnoreCase(type)) {
			return this.translator(tag);
		}
		
		if(MODELTYPE_DATASYNCAGENT.equalsIgnoreCase(type)) {
			return this.datasyncagent(tag);
		}
		
		if(MODELTYPE_EAIAGENT.equalsIgnoreCase(type)) {
			return this.eaiagent(tag);
		}
		
		if(MODELTYPE_DBSCHEMA.equalsIgnoreCase(type)
				||MODELTYPE_DBSCHEME.equalsIgnoreCase(type)) {
			return this.dbscheme(tag);
		}
		
		if(MODELTYPE_RESOURCE.equalsIgnoreCase(type)) {
			return this.resource(tag);
		}
		
		
		if(MODELTYPE_PLUGIN.equalsIgnoreCase(type)) {
			return this.plugin(tag);
		}
		
		if(MODELTYPE_CONFIG.equalsIgnoreCase(type)) {
			return this.config(tag);
		}
		
		if(MODELTYPE_PARAM.equalsIgnoreCase(type)) {
			return this.param(tag);
		}
		
		throw new RuntimeException(String.format("无法识别的运行时对象[%1$s][%2$s]", type, tag));
	}
	

	@Override
	public IAppContext context() {
		IAppContext iAppContext = ActionSessionManager.getAppContext();
		if (iAppContext == null) {
			iAppContext = AppContext.newInstance(null);
			ActionSessionManager.getCurrentSessionMust().setAppContext(iAppContext);
		}
		return iAppContext;
	}

	@Override
	public IUserContext user() {
		return UserContext.getCurrentMust();
	}

	
	@Override
	public void info(String info) {
		this.getSystemRuntime().log(LogLevels.INFO, LogCats.GROOVY, info, null);
	}

	@Override
	public void warn(String info) {
		this.getSystemRuntime().log(LogLevels.WARN, LogCats.GROOVY, info, null);
	}

	@Override
	public void error(String info) {
		this.getSystemRuntime().log(LogLevels.ERROR, LogCats.GROOVY, info, null);
	}

	

	

	

	
	
}
