package net.ibizsys.central.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.model.security.IPSSysUserRole;
import net.ibizsys.model.security.IPSSysUserRoleData;
import net.ibizsys.model.security.IPSSysUserRoleRes;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.IEntity;

public class SysUserRoleRuntime extends SystemModelRuntimeBase implements ISysUserRoleRuntime{

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysUserRoleRuntime.class);
	
	private IPSSysUserRole iPSSysUserRole = null;
	private Map<String, ISysUniResRuntime> sysUniResRuntimeMap = null;
	private Map<String, List<IPSDEUserRole>> deDEUserRoleListMap = null;
	private ISystemAccessManager iSystemAccessManager = null;
	
	
	@Override
	public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, ISystemAccessManager iSystemAccessManager, IPSSysUserRole iPSSysUserRole) throws Exception {
		this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
		this.iPSSysUserRole = iPSSysUserRole;
		this.iSystemAccessManager = iSystemAccessManager;
		if(this.iSystemAccessManager == null) {
			this.iSystemAccessManager = this.getSystemRuntime().getSystemAccessManager();
		}
		this.onInit();
	}
	
	@Override
	protected void onInit() throws Exception {
		
		if(this.getPSSysUserRole() != null) {
			this.sysUniResRuntimeMap = new HashMap<String, ISysUniResRuntime>();
			List<IPSSysUserRoleRes> psSysUserRoleResList = this.getPSSysUserRole().getPSSysUserRoleReses();
			if(psSysUserRoleResList != null) {
				for(IPSSysUserRoleRes iPSSysUserRoleRes : psSysUserRoleResList) {
					sysUniResRuntimeMap.put(iPSSysUserRoleRes.getSysUniResCode(), this.getSystemAccessManager().getSysUniResRuntime(iPSSysUserRoleRes.getSysUniResCode(), false));
				}
			}
			
			this.deDEUserRoleListMap = new HashMap<String, List<IPSDEUserRole>>();
			List<IPSSysUserRoleData> psSysUserRoleDataList = this.getPSSysUserRole().getPSSysUserRoleDatas();
			if(psSysUserRoleDataList != null) {
				for(IPSSysUserRoleData iPSSysUserRoleData : psSysUserRoleDataList) {
					List<IPSDEUserRole> list = deDEUserRoleListMap.get(iPSSysUserRoleData.getPSDataEntityMust().getId());
					if(list == null) {
						list = new ArrayList<IPSDEUserRole>();
						deDEUserRoleListMap.put(iPSSysUserRoleData.getPSDataEntityMust().getId(), list);
					}
					list.add(iPSSysUserRoleData.getPSDEUserRoleMust());
				}
			}
		}
		
		super.onInit();
	}
	
	@Override
	public IPSModelObject getPSModelObject() {
		return getPSSysUserRole();
	}

	

	@Override
	public IPSSysUserRole getPSSysUserRole() {
		return this.iPSSysUserRole;
	}


	
	@Override
	public ISystemAccessManager getSystemAccessManager() {
		return this.iSystemAccessManager;
	}

	@Override
	public List<IPSDEUserRole> getPSDEUserRoles(String strDEId) {
		if(this.deDEUserRoleListMap == null) {
			return null;
		}
		return this.deDEUserRoleListMap.get(strDEId);
	}

	@Override
	public Boolean testSysUniRes(IUserContext iUserContext, String strUniResCode) {
		return this.testSysUniRes(iUserContext, strUniResCode, null);
	}
	
	@Override
	public Boolean testSysUniRes(IUserContext iUserContext, String strUniResCode, IEntity iEntity) {
		if(this.sysUniResRuntimeMap != null) {
			ISysUniResRuntime iSysUniResRuntime = this.sysUniResRuntimeMap.get(strUniResCode);
			if(iSysUniResRuntime != null) {
				return iSysUniResRuntime.test(iUserContext, iEntity);
			}
		}
		return null;
	}

	@Override
	public String getDefaultUser() {
		return this.getPSSysUserRole().getDefaultUser();
	}
	

	@Override
	public boolean testUser(IUserContext iUserContext) {
		return false;
	}

	@Override
	public String getRoleTag() {
		return this.getPSSysUserRole().getRoleTag();
	}

}
