package net.ibizsys.central.dataentity.search;

import net.ibizsys.central.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.search.IPSDESearch;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeContext;

public abstract class DESearchRuntimeBase extends DataEntityModelRuntimeBase implements IDESearchRuntime  {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DESearchRuntimeBase.class);
	
	private IPSDESearch iPSDESearch = null;

	
	@Override
	public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDESearch iPSDESearch) throws Exception {
		this.setDataEntityRuntimeBase(iDataEntityRuntimeContext.getDataEntityRuntime());
		this.setPSDESearch(iPSDESearch);
		this.onInit();
	}
	
	
	@Override
	public IPSDESearch getPSDESearch() {
		return this.iPSDESearch;
	}
	
	protected void setPSDESearch(IPSDESearch iPSDESearch) {
		this.iPSDESearch = iPSDESearch;
	}

	@Override
	public IPSModelObject getPSModelObject() {
		return this.getPSDESearch();
	}
	
	
	
	
	
}
