/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DBTypes {
    public static final String DB2 = "DB2";
    public static final String MYSQL5 = "MYSQL5";
    public static final String ORACLE = "ORACLE";
    public static final String SQLSERVER = "SQLSERVER";
    public static final String POSTGRESQL = "POSTGRESQL";
    public static final String PPAS = "PPAS";
    public static final String SQLITE = "SQLITE";
    public static final String DM = "DM";
    public static final String HANA = "HANA";
    private static Map<String, String> driverClassNameMap = new HashMap<String, String>();
    private static Map<String, String> compatibleTypeMap = new HashMap<String, String>();
    private static final String _MYSQL = "MYSQL";

    public static void registerDriverClassName(String strDBType, String strDriverClassName) {
        Assert.hasLength((String)strDBType, (String)"\u672a\u4f20\u5165\u6570\u636e\u5e93\u7c7b\u578b");
        Assert.hasLength((String)strDriverClassName, (String)"\u672a\u4f20\u5165\u9a71\u52a8\u540d\u79f0");
        driverClassNameMap.put(strDBType.toUpperCase(), strDriverClassName);
    }

    public static String getDriverClassName(String strDBType) {
        Assert.hasLength((String)strDBType, (String)"\u672a\u4f20\u5165\u6570\u636e\u5e93\u7c7b\u578b");
        strDBType = strDBType.toUpperCase();
        String strDriverClassName = driverClassNameMap.get(strDBType);
        if (strDriverClassName == null) {
            if (_MYSQL.equals(strDBType)) {
                return driverClassNameMap.get(MYSQL5);
            }
            if (MYSQL5.equals(strDBType)) {
                return driverClassNameMap.get(_MYSQL);
            }
        }
        return strDriverClassName;
    }

    public static void registerCompatibleType(String strDBType, String strCompatibleType) {
        Assert.hasLength((String)strDBType, (String)"\u672a\u4f20\u5165\u6570\u636e\u5e93\u7c7b\u578b");
        if (StringUtils.hasLength((String)strCompatibleType)) {
            compatibleTypeMap.put(strDBType.toUpperCase(), strCompatibleType.toUpperCase());
        } else {
            compatibleTypeMap.put(strDBType.toUpperCase(), "");
        }
    }

    public static String getCompatibleType(String strDBType) {
        Assert.hasLength((String)strDBType, (String)"\u672a\u4f20\u5165\u6570\u636e\u5e93\u7c7b\u578b");
        strDBType = strDBType.toUpperCase();
        String strCompatibleType = compatibleTypeMap.get(strDBType);
        if (strCompatibleType != null) {
            return strCompatibleType;
        }
        return MYSQL5;
    }

    public static String fromJdbcUrl(String strJdbcUrl) {
        Assert.hasLength((String)strJdbcUrl, (String)"\u672a\u4f20\u5165Jdbc\u8def\u5f84");
        int nPos = strJdbcUrl.indexOf("://");
        if (nPos == -1) {
            throw new RuntimeException(String.format("\u8def\u5f84[%1$s]\u683c\u5f0f\u4e0d\u6b63\u786e", strJdbcUrl));
        }
        String strTemp = strJdbcUrl.substring(0, nPos);
        if ((nPos = strTemp.lastIndexOf(":")) == -1) {
            throw new RuntimeException(String.format("\u8def\u5f84[%1$s]\u683c\u5f0f\u4e0d\u6b63\u786e", strJdbcUrl));
        }
        if (_MYSQL.equals(strTemp = strTemp.substring(nPos + 1).toUpperCase())) {
            return MYSQL5;
        }
        return strTemp;
    }

    static {
        DBTypes.registerCompatibleType(ORACLE, "");
        DBTypes.registerCompatibleType(DB2, "");
        DBTypes.registerCompatibleType(SQLSERVER, "");
        DBTypes.registerCompatibleType(POSTGRESQL, ORACLE);
        DBTypes.registerCompatibleType(PPAS, ORACLE);
    }
}

