/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.util.concurrent.TimeUnit;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.AppContext;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IInterProcessMutexUtil;
import net.ibizsys.runtime.util.ITransactionalUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionSessionManager {
    private static final Log log = LogFactory.getLog(ActionSessionManager.class);
    private static ThreadLocal<ActionSession> actionSession = new ThreadLocal();
    private static ThreadLocal<StringBuilder> actionInfoBuilder = new ThreadLocal();
    private static ITransactionalUtil iTransactionalUtil = null;
    private static IInterProcessMutexUtil iInterProcessMutexUtil = null;
    private static int nLogPOTime = 200;
    private static int nReportLogPOTime = 30000;
    private static int nImportDataLogPOTime = 30000;
    private static int nExportDataLogPOTime = 30000;

    public static void setTransactionalUtil(ITransactionalUtil iTransactionalUtil) {
        ActionSessionManager.iTransactionalUtil = iTransactionalUtil;
    }

    public static ITransactionalUtil getTransactionalUtil() {
        return iTransactionalUtil;
    }

    public static void setInterProcessMutexUtil(IInterProcessMutexUtil iInterProcessMutexUtil) {
        ActionSessionManager.iInterProcessMutexUtil = iInterProcessMutexUtil;
    }

    public static IInterProcessMutexUtil getInterProcessMutexUtil() {
        return iInterProcessMutexUtil;
    }

    public static int getLogPOTime() {
        return nLogPOTime;
    }

    public static void setLogPOTime(int nLogPOTime) {
        ActionSessionManager.nLogPOTime = nLogPOTime;
    }

    public static int getReportLogPOTime() {
        return nReportLogPOTime;
    }

    public static void setReportLogPOTime(int nReportLogPOTime) {
        ActionSessionManager.nReportLogPOTime = nReportLogPOTime;
    }

    public static int getImportDataLogPOTime() {
        return nImportDataLogPOTime;
    }

    public static void setImportDataLogPOTime(int nImportDataLogPOTime) {
        ActionSessionManager.nImportDataLogPOTime = nImportDataLogPOTime;
    }

    public static int getExportDataLogPOTime() {
        return nExportDataLogPOTime;
    }

    public static void setExportDataLogPOTime(int nExportDataLogPOTime) {
        ActionSessionManager.nExportDataLogPOTime = nExportDataLogPOTime;
    }

    public static ActionSession openSession() {
        return ActionSessionManager.openSession("DEFAULT");
    }

    public static ActionSession openSession(String strName) {
        ActionSession currentSession = actionSession.get();
        if (currentSession == null) {
            currentSession = new ActionSession();
            currentSession.setName(strName);
            actionSession.set(currentSession);
        }
        return currentSession;
    }

    public static ActionSession openSession(String strName, boolean bTopSession) {
        ActionSession currentSession = actionSession.get();
        if (currentSession != null) {
            if (bTopSession) {
                return currentSession;
            }
            return currentSession.openChildSession(strName);
        }
        currentSession = new ActionSession();
        currentSession.setName(strName);
        actionSession.set(currentSession);
        return currentSession;
    }

    public static void closeSession(boolean bCommit) {
        ActionSession currentSession = actionSession.get();
        if (currentSession != null) {
            currentSession.close(bCommit);
            actionSession.set(null);
        }
    }

    public static ActionSession getCurrentSession() {
        ActionSession actionSession2 = actionSession.get();
        if (actionSession2 != null) {
            return actionSession2.getCurrentSession();
        }
        return null;
    }

    public static ActionSession getCurrentSessionMust() {
        ActionSession actionSession2 = ActionSessionManager.getCurrentSession();
        if (actionSession2 == null) {
            throw new RuntimeException("\u5f53\u524d\u64cd\u4f5c\u4f1a\u8bdd\u65e0\u6548");
        }
        return actionSession2;
    }

    public static ActionSession getCurrentSession(boolean bCreateIfNotExists) {
        ActionSession actionSession2 = actionSession.get();
        if (actionSession2 == null && bCreateIfNotExists) {
            return ActionSessionManager.openSession();
        }
        if (actionSession2 == null) {
            return null;
        }
        return actionSession2.getCurrentSession();
    }

    public static void appendActionInfo(String strInfo) {
        StringBuilder stringBuilder = ActionSessionManager.getActionInfoBuilder();
        if (stringBuilder != null) {
            stringBuilder.append(strInfo);
        }
        if (ActionSessionManager.getCurrentSession() == null) {
            return;
        }
        ActionSessionManager.getCurrentSession().appendActionInfo(strInfo);
    }

    public static String getActionInfo() {
        StringBuilder stringBuilder = ActionSessionManager.getActionInfoBuilder();
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        if (ActionSessionManager.getCurrentSession() == null) {
            return null;
        }
        return ActionSessionManager.getCurrentSession().getActionInfo();
    }

    public static IUserContext getUserContext() {
        if (ActionSessionManager.getCurrentSession() != null) {
            return ActionSessionManager.getCurrentSession().getUserContext();
        }
        return UserContext.getCurrent();
    }

    public static IUserContext getUserContextMust() {
        IUserContext iUserContext = ActionSessionManager.getUserContext();
        if (iUserContext == null) {
            throw new RuntimeException("\u7528\u6237\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        }
        return iUserContext;
    }

    public static IAppContext getAppContext() {
        if (ActionSessionManager.getCurrentSession() != null) {
            return ActionSessionManager.getCurrentSession().getAppContext();
        }
        if (UserContext.getCurrent() != null) {
            return UserContext.getCurrent().getAppContext();
        }
        return null;
    }

    public static IAppContext getAppContextIf() {
        IAppContext iAppContext = ActionSessionManager.getAppContext();
        if (iAppContext == null) {
            iAppContext = AppContext.newInstance(null);
            ActionSessionManager.getCurrentSessionMust().setAppContext(iAppContext);
        }
        return iAppContext;
    }

    public static IAppContext getAppContextMust() {
        IAppContext iAppContext = ActionSessionManager.getAppContext();
        if (iAppContext == null) {
            throw new RuntimeException("\u5e94\u7528\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        }
        return iAppContext;
    }

    public static Object execute(IAction iAction, Object[] args, int nPropagation) throws Throwable {
        boolean bOpenActionSession = ActionSessionManager.getCurrentSession() == null;
        boolean bCommit = true;
        try {
            Object object = ActionSessionManager.openSession().execute(iAction, args, nPropagation);
            return object;
        }
        catch (Throwable ex) {
            bCommit = false;
            throw ex;
        }
        finally {
            if (bOpenActionSession) {
                ActionSessionManager.closeSession(bCommit);
            }
        }
    }

    public static Object execute(IAction iAction, Object[] args, String strInterProcessLock) throws Throwable {
        return ActionSessionManager.execute(iAction, args, strInterProcessLock, -1);
    }

    public static Object execute(IAction iAction, Object[] args, String strInterProcessLock, long time, TimeUnit unit) throws Throwable {
        return ActionSessionManager.execute(iAction, args, strInterProcessLock, time, unit, -1);
    }

    public static Object execute(final IAction iAction, Object[] args, String strInterProcessLock, final int nPropagation) throws Throwable {
        IInterProcessMutexUtil iInterProcessMutexUtil = ActionSessionManager.getInterProcessMutexUtil();
        if (iInterProcessMutexUtil != null) {
            return iInterProcessMutexUtil.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return ActionSessionManager.execute(iAction, args, nPropagation);
                }
            }, args, strInterProcessLock);
        }
        log.warn((Object)String.format("\u672a\u5b9a\u4e49Cloud\u4e8b\u52a1\u8f85\u52a9\u5bf9\u8c61\uff0c\u5ffd\u7565Cloud\u4e8b\u52a1\u6a21\u5f0f", new Object[0]));
        return ActionSessionManager.execute(iAction, args, nPropagation);
    }

    public static Object execute(final IAction iAction, Object[] args, String strInterProcessLock, long time, TimeUnit unit, final int nPropagation) throws Throwable {
        IInterProcessMutexUtil iInterProcessMutexUtil = ActionSessionManager.getInterProcessMutexUtil();
        if (iInterProcessMutexUtil != null) {
            return iInterProcessMutexUtil.execute(new IAction(){

                @Override
                public Object execute(Object[] args) throws Throwable {
                    return ActionSessionManager.execute(iAction, args, nPropagation);
                }
            }, args, strInterProcessLock, time, unit);
        }
        log.warn((Object)String.format("\u672a\u5b9a\u4e49Cloud\u4e8b\u52a1\u8f85\u52a9\u5bf9\u8c61\uff0c\u5ffd\u7565Cloud\u4e8b\u52a1\u6a21\u5f0f", new Object[0]));
        return ActionSessionManager.execute(iAction, args, strInterProcessLock, nPropagation);
    }

    public static void setActionInfoBuilder(StringBuilder stringBuilder) {
        actionInfoBuilder.set(stringBuilder);
    }

    public static StringBuilder getActionInfoBuilder() {
        return actionInfoBuilder.get();
    }
}

