/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.ActionSessionLog;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IASFutureAction;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IActionSessionLog;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.ITransactionalUtil;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.SimpleEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ActionSession {
    private static final Log log = LogFactory.getLog(ActionSession.class);
    private static final String PARAM_LASTRETURN = "__LAST_RETURN__";
    public static final Object EMPTYPARAM = new Object();
    private Map<String, String> recursionDataMap = new HashMap<String, String>();
    private Map<String, Object> actionParamMap = new HashMap<String, Object>();
    private List<IASFutureAction> asFutureActionList = null;
    private String strName = "";
    private StringBuilder actionInfoSB = new StringBuilder();
    private String strActionStep = null;
    private double fCompletionRate = 0.0;
    private IEntity envEntity = null;
    private ActionSession childActionSession = null;
    private int nLevel = 0;
    private IDynaInstRuntime iDynaInstRuntime = null;
    private IDynaInstRuntime childDynaInstRuntime = null;
    private String strSessionId = null;
    private String strGlobalSessionId = null;
    private String strDefaultDynaInstId = null;
    private IUserContext iUserContext = null;
    private IAppContext iAppContext = null;
    private ActionSessionLog actionSessionLog = null;
    private boolean bInTran = false;

    public ActionSession() {
    }

    protected ActionSession(ActionSession parentActionSession, int nLevel) {
        try {
            this.nLevel = nLevel;
            if (parentActionSession.getEnvEntity(false) != null) {
                this.envEntity = new SimpleEntity();
                parentActionSession.getEnvEntity(false).copyTo(this.envEntity);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public ActionSession openChildSession(String strName) {
        if (this.childActionSession == null) {
            this.childActionSession = new ActionSession(this, this.nLevel + 1);
            this.childActionSession.setName(strName);
            this.childActionSession.setUserContext(this.getUserContext(true));
            this.childActionSession.setAppContext(this.getAppContext(true));
            this.childActionSession.setInTransaction(this.isInTransaction());
            this.childActionSession.setGlobalSessionId(this.getGlobalSessionId());
            return this.childActionSession;
        }
        return this.childActionSession.openChildSession(strName);
    }

    public int closeChildSession() {
        return this.closeChildSession(true);
    }

    public int closeChildSession(boolean bCommit) {
        if (this.childActionSession == null) {
            return -1;
        }
        int nLastLevel = this.childActionSession.closeChildSession(bCommit);
        if (nLastLevel == -1) {
            this.childActionSession = null;
            return this.nLevel;
        }
        return nLastLevel;
    }

    public ActionSession getCurrentSession() {
        if (this.childActionSession == null) {
            return this;
        }
        return this.childActionSession.getCurrentSession();
    }

    public String getName() {
        return this.strName;
    }

    public void setName(String strName) {
        this.strName = strName;
    }

    public boolean isInTransaction() {
        return this.bInTran;
    }

    public void setInTransaction(boolean bInTran) {
        this.bInTran = bInTran;
    }

    public boolean registerRecursion(String strDEId, Object objKeyValue) {
        String strRecursionTag = String.format("%1$s||%2$s", strDEId, objKeyValue);
        if (this.recursionDataMap.containsKey(strRecursionTag)) {
            return false;
        }
        this.recursionDataMap.put(strRecursionTag, "");
        return true;
    }

    public void unregisterRecursion(String strDEId, Object objKeyValue) {
        String strRecursionTag = String.format("%1$s||%2$s", strDEId, objKeyValue);
        this.recursionDataMap.remove(strRecursionTag);
    }

    public boolean registerRecursion(String strActionType, String strDEId, Object objKeyValue) {
        String strRecursionTag = String.format("%1$s||%2$s||%3$s", strActionType, strDEId, objKeyValue);
        if (this.recursionDataMap.containsKey(strRecursionTag)) {
            return false;
        }
        this.recursionDataMap.put(strRecursionTag, "");
        return true;
    }

    public void unregisterRecursion(String strActionType, String strDEId, Object objKeyValue) {
        String strRecursionTag = String.format("%1$s||%2$s||%3$s", strActionType, strDEId, objKeyValue);
        this.recursionDataMap.remove(strRecursionTag);
    }

    public boolean registerRecursion(String strActionType, String strDEId, Object objKeyValue, Object objTag) {
        String strRecursionTag = String.format("%1$s||%2$s||%3$s||%4$s", strActionType, strDEId, objKeyValue, objTag);
        if (this.recursionDataMap.containsKey(strRecursionTag)) {
            return false;
        }
        this.recursionDataMap.put(strRecursionTag, "");
        return true;
    }

    public void unregisterRecursion(String strActionType, String strDEId, Object objKeyValue, Object objTag) {
        String strRecursionTag = String.format("%1$s||%2$s||%3$s||%4$s", strActionType, strDEId, objKeyValue, objTag);
        this.recursionDataMap.remove(strRecursionTag);
    }

    public void appendActionInfo(String strInfo) {
        this.actionInfoSB.append(strInfo);
    }

    public void updateActionStep(String strStep) {
        this.updateActionStep(strStep, this.getCompletionRate());
    }

    public void updateActionStep(String strStep, double fCompletionRate) {
        this.updateActionStep(strStep, fCompletionRate, true);
    }

    public void updateActionStep(String strStep, double fCompletionRate, boolean bAppendActionInfo) {
        this.strActionStep = strStep;
        this.fCompletionRate = fCompletionRate;
        if (bAppendActionInfo && StringUtils.hasLength((String)strStep)) {
            this.appendActionInfo(strStep);
        }
    }

    public String getActionStep() {
        return this.strActionStep;
    }

    public double getCompletionRate() {
        return this.fCompletionRate;
    }

    public String getActionInfo() {
        return this.actionInfoSB.toString();
    }

    public void setActionParam(String strName, Object objValue) {
        this.actionParamMap.put(strName, objValue);
    }

    public Object removeActionParam(String strName) {
        return this.actionParamMap.remove(strName);
    }

    public boolean containsActionParam(String strName) {
        return this.actionParamMap.containsKey(strName);
    }

    public Object getActionParam(String strName) {
        return this.actionParamMap.get(strName);
    }

    public void resetActionParams() {
        this.actionParamMap.clear();
    }

    public IEntity getEnvEntity(boolean bIfCreate) {
        if (this.envEntity == null && bIfCreate) {
            this.envEntity = new SimpleEntity();
        }
        return this.envEntity;
    }

    public IEntity getEnvEntity() {
        return this.getEnvEntity(false);
    }

    public void resetEnvEntity() {
        this.envEntity = null;
    }

    public int getLevel() {
        return this.nLevel;
    }

    public void setDynaInstRuntime(IDynaInstRuntime iDynaInstRuntime) {
        this.iDynaInstRuntime = iDynaInstRuntime;
    }

    public IDynaInstRuntime getDynaInstRuntime() {
        return this.iDynaInstRuntime;
    }

    public void setChildDynaInstRuntime(IDynaInstRuntime childDynaInstRuntime) {
        this.childDynaInstRuntime = childDynaInstRuntime;
    }

    public IDynaInstRuntime getChildDynaInstRuntime() {
        return this.childDynaInstRuntime;
    }

    public String getDefaultDynaInstId() {
        return this.strDefaultDynaInstId;
    }

    public void setDefaultDynaInstId(String strDefaultDynaInstId) {
        this.strDefaultDynaInstId = strDefaultDynaInstId;
    }

    public String getSessionId() {
        return this.strSessionId;
    }

    public void setSessionId(String strSessionId) {
        this.strSessionId = strSessionId;
    }

    public String getGlobalSessionId() {
        return this.strGlobalSessionId;
    }

    public void setGlobalSessionId(String strGlobalSessionId) {
        this.strGlobalSessionId = strGlobalSessionId;
    }

    public void newSessionId() {
        this.strSessionId = KeyValueUtils.genGuidEx();
    }

    public IUserContext getUserContext() {
        return this.getUserContext(false);
    }

    public IUserContext getUserContext(boolean bSessionOnly) {
        if (this.iUserContext == null && !bSessionOnly) {
            return UserContext.getCurrent();
        }
        return this.iUserContext;
    }

    public void setUserContext(IUserContext iUserContext) {
        this.iUserContext = iUserContext;
    }

    public IUserContext getUserContextMust() {
        IUserContext iUserContext = this.getUserContext();
        if (iUserContext == null) {
            throw new RuntimeException("\u7528\u6237\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        }
        return iUserContext;
    }

    public IAppContext getAppContext() {
        return this.getAppContext(false);
    }

    public IAppContext getAppContext(boolean bSessionOnly) {
        if (this.iAppContext == null && !bSessionOnly && this.getUserContext() != null) {
            return this.getUserContext().getAppContext();
        }
        return this.iAppContext;
    }

    public void setAppContext(IAppContext iAppContext) {
        this.iAppContext = iAppContext;
    }

    public IAppContext getAppContextMust() {
        IAppContext iAppContext = this.getAppContext();
        if (iAppContext == null) {
            throw new RuntimeException("\u5e94\u7528\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        }
        return iAppContext;
    }

    public void registerFutureAction(IASFutureAction iASFutureAction) {
        this.registerFutureAction(iASFutureAction, false);
    }

    public void registerFutureAction(IASFutureAction iASFutureAction, boolean bRemoveIf) {
        Assert.notNull((Object)iASFutureAction, (String)"\u4f20\u5165\u64cd\u4f5c\u4f1a\u8bdd\u540e\u7eed\u884c\u4e3a\u65e0\u6548");
        if (this.asFutureActionList == null) {
            this.asFutureActionList = new ArrayList<IASFutureAction>();
        }
        if (bRemoveIf && StringUtils.hasLength((String)iASFutureAction.getId())) {
            for (IASFutureAction lastASFutureAction : this.asFutureActionList) {
                if (!iASFutureAction.getId().equals(lastASFutureAction.getId())) continue;
                this.asFutureActionList.remove(lastASFutureAction);
                break;
            }
        }
        this.asFutureActionList.add(iASFutureAction);
    }

    protected void executeFutureActions(boolean bCommit) {
        if (this.asFutureActionList == null) {
            return;
        }
        for (IASFutureAction lastASFutureAction : this.asFutureActionList) {
            if (bCommit) {
                lastASFutureAction.commit();
                continue;
            }
            lastASFutureAction.rollback();
        }
        this.asFutureActionList = null;
    }

    public void unregisterFutureAction(String strActionId) {
        if (this.asFutureActionList == null) {
            return;
        }
        for (IASFutureAction lastASFutureAction : this.asFutureActionList) {
            if (!strActionId.equals(lastASFutureAction.getId())) continue;
            this.asFutureActionList.remove(lastASFutureAction);
            break;
        }
    }

    public void close(boolean bCommit) {
        this.executeFutureActions(bCommit);
    }

    public IActionSessionLog beginLog(String strDEName, String strAction) {
        if (this.actionSessionLog == null) {
            this.actionSessionLog = new ActionSessionLog(null);
            this.actionSessionLog.setBeginTime(System.currentTimeMillis());
            this.actionSessionLog.setAction(strAction);
            this.actionSessionLog.setDEName(strDEName);
            return this.actionSessionLog;
        }
        this.actionSessionLog = this.actionSessionLog.beginSubAction(strDEName, strAction);
        return this.actionSessionLog;
    }

    public IActionSessionLog endLog(String strInfo) {
        if (this.actionSessionLog == null) {
            return null;
        }
        ActionSessionLog curActionSessionLog = this.actionSessionLog;
        this.actionSessionLog = curActionSessionLog.endAction(strInfo);
        return curActionSessionLog;
    }

    public IActionSessionLog endLog(String strInfo, boolean bError, Throwable cause) {
        if (this.actionSessionLog == null) {
            return null;
        }
        ActionSessionLog curActionSessionLog = this.actionSessionLog;
        this.actionSessionLog = curActionSessionLog.endAction(strInfo, bError, cause);
        return curActionSessionLog;
    }

    public Object getLastReturn() {
        return this.getActionParam(PARAM_LASTRETURN);
    }

    public void setLastReturn(Object lastReturn) {
        this.setActionParam(PARAM_LASTRETURN, lastReturn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(IAction iAction, Object[] args, int nPropagation) throws Throwable {
        ITransactionalUtil iTransactionalUtil = ActionSessionManager.getTransactionalUtil();
        if (nPropagation == -1) return iAction.execute(args);
        if (iTransactionalUtil == null) {
            return iAction.execute(args);
        }
        boolean bLastTran = this.isInTransaction();
        try {
            switch (nPropagation) {
                case 6: {
                    this.setInTransaction(true);
                    Object object = iTransactionalUtil.nested(iAction, args);
                    return object;
                }
                case 2: {
                    this.setInTransaction(true);
                    Object object = iTransactionalUtil.mandatory(iAction, args);
                    return object;
                }
                case 5: {
                    Object object = iTransactionalUtil.never(iAction, args);
                    return object;
                }
                case 4: {
                    Object object = iTransactionalUtil.not_supported(iAction, args);
                    return object;
                }
                case 0: {
                    if (bLastTran) {
                        Object object = iAction.execute(args);
                        return object;
                    }
                    this.setInTransaction(true);
                    Object object = iTransactionalUtil.required(iAction, args);
                    return object;
                }
                case 3: {
                    List<IASFutureAction> lastASFutureActionList = this.asFutureActionList;
                    this.asFutureActionList = null;
                    this.setInTransaction(true);
                    try {
                        Object objRet = iTransactionalUtil.required_new(iAction, args);
                        this.executeFutureActions(true);
                        this.asFutureActionList = lastASFutureActionList;
                        Object object = objRet;
                        return object;
                    }
                    catch (Throwable ex) {
                        this.executeFutureActions(false);
                        this.asFutureActionList = lastASFutureActionList;
                        throw ex;
                    }
                }
                case 1: {
                    return iAction.execute(args);
                }
                default: {
                    throw new RuntimeException(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u4e8b\u52a1\u6a21\u5f0f[%1$s]", nPropagation));
                }
            }
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            this.setInTransaction(bLastTran);
        }
    }
}

