/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.codelist;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.security.IUserContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class CodeListRuntimeBase
extends SystemModelRuntimeBase
implements ICodeListRuntime {
    private Map<String, IPSCodeItem> psCodeItemMap = null;
    private IPSCodeList iPSCodeList = null;
    private String strValueSeparator = "";
    private String strTextSeparator = "";

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSCodeList iPSCodeList) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
        this.iPSCodeList = iPSCodeList;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        String strOrMode = this.getPSCodeList().getOrMode();
        if ("STR".equals(strOrMode)) {
            this.strValueSeparator = ";";
            this.strTextSeparator = "\u3001";
            if (!ObjectUtils.isEmpty((Object)this.getPSCodeList().getTextSeparator())) {
                this.strTextSeparator = this.getPSCodeList().getTextSeparator();
            }
            if (!ObjectUtils.isEmpty((Object)this.getPSCodeList().getValueSeparator())) {
                this.strValueSeparator = this.getPSCodeList().getValueSeparator();
            }
        } else if ("NUM".equals(strOrMode)) {
            this.strValueSeparator = "";
            this.strTextSeparator = "\u3001";
            if (!ObjectUtils.isEmpty((Object)this.getPSCodeList().getTextSeparator())) {
                this.strTextSeparator = this.getPSCodeList().getTextSeparator();
            }
        } else {
            this.strValueSeparator = "";
            this.strTextSeparator = "";
        }
        super.onInit();
    }

    public IPSCodeList getPSCodeList() {
        return this.iPSCodeList;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSCodeList();
    }

    @Override
    public String getText(Object objValue) {
        return this.getText(objValue, null);
    }

    @Override
    public String getText(Object objValue, IUserContext iUserContext) {
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return this.getPSCodeList().getEmptyText();
        }
        String strValue = null;
        strValue = objValue instanceof String ? (String)objValue : objValue.toString();
        String strOrMode = this.getPSCodeList().getOrMode();
        if (StringUtils.hasLength((String)strOrMode)) {
            if ("STR".equals(strOrMode)) {
                String[] values;
                String strTextSeparator;
                String strValueSeparator = this.getPSCodeList().getValueSeparator();
                if (!StringUtils.hasLength((String)strValueSeparator)) {
                    strValueSeparator = ";";
                }
                if (!StringUtils.hasLength((String)(strTextSeparator = this.getPSCodeList().getTextSeparator()))) {
                    strTextSeparator = "\u3001";
                }
                String strTotalText = "";
                for (String strItem : values = StringUtils.tokenizeToStringArray((String)strValue, (String)strValueSeparator)) {
                    IPSCodeItem iPSCodeItem = this.getPSCodeItem(strItem);
                    if (iPSCodeItem == null) {
                        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u503c[%1$s]\u5bf9\u5e94\u7684\u6587\u672c\u4fe1\u606f", strItem));
                    }
                    if (!ObjectUtils.isEmpty((Object)strTotalText)) {
                        strTotalText = strTotalText + strTextSeparator;
                    }
                    strTotalText = strTotalText + iPSCodeItem.getText();
                }
                return strTotalText;
            }
            if ("NUM".equals(strOrMode)) {
                int nValue;
                String strTextSeparator = this.getPSCodeList().getTextSeparator();
                if (!StringUtils.hasLength((String)strTextSeparator)) {
                    strTextSeparator = "\u3001";
                }
                if ((nValue = Integer.parseInt(strValue)) == 0) {
                    return this.getPSCodeList().getEmptyText();
                }
                String strTotalText = "";
                List<IPSCodeItem> psCodeItems = this.getPSCodeItems();
                if (psCodeItems != null) {
                    for (IPSCodeItem iPSCodeItem : psCodeItems) {
                        int nValueItem = Integer.parseInt(iPSCodeItem.getValue());
                        if ((nValue & nValueItem) != nValueItem) continue;
                        if (!ObjectUtils.isEmpty((Object)strTotalText)) {
                            strTotalText = strTotalText + strTextSeparator;
                        }
                        strTotalText = strTotalText + iPSCodeItem.getText();
                    }
                }
                return strTotalText;
            }
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6216\u6a21\u5f0f[%1$s]", strOrMode));
        }
        IPSCodeItem iPSCodeItem = this.getPSCodeItem(strValue);
        if (iPSCodeItem != null) {
            return iPSCodeItem.getText();
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u503c[%1$s]\u5bf9\u5e94\u7684\u6587\u672c\u4fe1\u606f", objValue));
    }

    @Override
    public abstract List<IPSCodeItem> getPSCodeItems();

    @Override
    public IPSCodeItem getPSCodeItem(String strItemValue) {
        return this.getPSCodeItem(strItemValue, false);
    }

    @Override
    public IPSCodeItem getPSCodeItem(String strItemValue, boolean bTryMode) {
        IPSCodeItem iPSCodeItem;
        Map<String, IPSCodeItem> psCodeItemMap = this.psCodeItemMap;
        if (psCodeItemMap == null) {
            psCodeItemMap = new HashMap<String, IPSCodeItem>();
            List<IPSCodeItem> psCodeItemList = this.getPSCodeItems();
            if (psCodeItemList != null) {
                for (IPSCodeItem iPSCodeItem2 : psCodeItemList) {
                    psCodeItemMap.put(iPSCodeItem2.getValue(), iPSCodeItem2);
                }
            }
            if (this.psCodeItemMap == null) {
                this.psCodeItemMap = psCodeItemMap;
            }
        }
        if ((iPSCodeItem = psCodeItemMap.get(strItemValue)) != null || bTryMode) {
            return iPSCodeItem;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u503c[%1$s]\u5bf9\u5e94\u7684\u4ee3\u7801\u9879", strItemValue));
    }

    @Override
    public IPSCodeItem getPSCodeItemByText(String strText, boolean bTryMode) {
        return this.getPSCodeItemByText(strText, null, bTryMode);
    }

    @Override
    public IPSCodeItem getPSCodeItemByText(String strText, IUserContext iUserContext, boolean bTryMode) {
        Assert.hasLength((String)strText, (String)String.format("\u4f20\u5165\u6587\u672c\u65e0\u6548", new Object[0]));
        List<IPSCodeItem> psCodeItemList = this.getPSCodeItems();
        if (psCodeItemList != null) {
            for (IPSCodeItem item : psCodeItemList) {
                String strItemText = item.getText();
                if (iUserContext != null && item.getTextPSLanguageRes() != null) {
                    strItemText = iUserContext.getLocalization(item.getTextPSLanguageRes().getLanResTag(), strItemText);
                }
                if (!strText.equals(strItemText)) continue;
                return item;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6587\u672c[%1$s]\u5bf9\u5e94\u7684\u4ee3\u7801\u9879", strText));
    }

    @Override
    public String getValueSeparator() {
        return this.strValueSeparator;
    }

    @Override
    public String getTextSeparator() {
        return this.strTextSeparator;
    }

    @Override
    public String getEmptyText() {
        return this.getPSCodeList().getEmptyText();
    }

    @Override
    public void reset() {
        this.psCodeItemMap = null;
    }
}

