/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util.script;

import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.service.client.WebClientBase;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.PageRequest;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.script.IScriptList;
import net.ibizsys.central.util.script.IScriptPage;
import net.ibizsys.central.util.script.IScriptSearchContext;
import net.ibizsys.central.util.script.IScriptSearchGroupCond;
import net.ibizsys.central.util.script.ScriptPageImpl;
import net.ibizsys.central.util.script.ScriptSearchGroupCond;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.ScriptUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptSearchContext
implements IScriptSearchContext {
    private ISearchContextDTO iSearchContextDTO;
    private IDataEntityRuntime iDataEntityRuntime = null;

    public ScriptSearchContext(IDataEntityRuntime iDataEntityRuntime, ISearchContextDTO iSearchContextDTO) {
        this.iDataEntityRuntime = iDataEntityRuntime;
        this.iSearchContextDTO = iSearchContextDTO;
        Assert.notNull((Object)this.getSearchContextDTO(), (String)"\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
    }

    @Override
    public Object getReal() {
        return this.getSearchContextDTO();
    }

    protected ISearchContextDTO getSearchContextDTO() {
        return this.iSearchContextDTO;
    }

    protected IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }

    protected IDataEntityRuntime getDataEntityRuntimeMust() {
        if (this.getDataEntityRuntime() == null) {
            throw new RuntimeException("\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        }
        return this.getDataEntityRuntime();
    }

    protected ISystemRuntime getSystemRuntime() {
        return this.getDataEntityRuntimeMust().getSystemRuntime();
    }

    @Override
    public IScriptSearchContext pageable(int nPageNumber, int nPageSize) {
        this.getSearchContextDTO().setPageable(nPageNumber, nPageSize, 0L);
        return this;
    }

    @Override
    public IScriptSearchContext sort(String strPageSort) {
        this.getSearchContextDTO().setPageSort(strPageSort);
        return this;
    }

    @Override
    public long getPageNo() {
        if (this.getSearchContextDTO().getPageable() != null) {
            return this.getSearchContextDTO().getPageable().getPageNumber();
        }
        return 0L;
    }

    @Override
    public long getPageSize() {
        if (this.getSearchContextDTO().getPageable() != null) {
            return this.getSearchContextDTO().getPageable().getPageSize();
        }
        return 1000L;
    }

    @Override
    public IScriptSearchContext count(boolean bCount) {
        this.getSearchContextDTO().setCount(bCount);
        return this;
    }

    @Override
    public IScriptSearchGroupCond and() {
        return new ScriptSearchGroupCond(this.getSearchContextDTO().and());
    }

    @Override
    public IScriptSearchGroupCond or() {
        return new ScriptSearchGroupCond(this.getSearchContextDTO().or());
    }

    @Override
    public IScriptSearchContext field(String strFieldName, String strCondOp, Object objValue) {
        this.getSearchContextDTO().setFieldCond(strFieldName, strCondOp, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext eq(String strFieldName, Object objValue) {
        this.getSearchContextDTO().eq(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext ne(String strFieldName, Object objValue) {
        this.getSearchContextDTO().ne(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext gt(String strFieldName, Object objValue) {
        this.getSearchContextDTO().gt(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext gte(String strFieldName, Object objValue) {
        this.getSearchContextDTO().gte(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext lt(String strFieldName, Object objValue) {
        this.getSearchContextDTO().lt(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext lte(String strFieldName, Object objValue) {
        this.getSearchContextDTO().lte(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext like(String strFieldName, Object objValue) {
        this.getSearchContextDTO().like(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext ll(String strFieldName, Object objValue) {
        this.getSearchContextDTO().ll(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext rl(String strFieldName, Object objValue) {
        this.getSearchContextDTO().rl(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext nvl(String strFieldName) {
        this.getSearchContextDTO().nvl(strFieldName);
        return this;
    }

    @Override
    public IScriptSearchContext nn(String strFieldName) {
        this.getSearchContextDTO().nn(strFieldName);
        return this;
    }

    @Override
    public IScriptSearchContext in(String strFieldName, Object objValue) {
        this.getSearchContextDTO().in(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext ni(String strFieldName, Object objValue) {
        this.getSearchContextDTO().ni(strFieldName, objValue);
        return this;
    }

    @Override
    public IScriptSearchContext custom(String strCustomCond) {
        SearchContextDTO.addSearchCustomCond(this.getSearchContextDTO(), strCustomCond);
        return this;
    }

    @Override
    public IScriptSearchContext predefined(String strPredefinedCond, String strPredefinedType) {
        SearchContextDTO.addSearchPredefinedCond(this.iSearchContextDTO, strPredefinedCond, strPredefinedType);
        return this;
    }

    @Override
    public IScriptSearchContext quick(String strValue) {
        SearchContextDTO.addSearchQuickCond(this.iSearchContextDTO, strValue);
        return this;
    }

    @Override
    public IScriptList select() {
        List<IEntityDTO> list = this.getDataEntityRuntimeMust().select(this.getSearchContextDTO());
        return this.getSystemRuntime().createScriptList(list);
    }

    @Override
    public IScriptList select(String strDEDataQueryName) {
        if (StringUtils.isEmpty((Object)strDEDataQueryName)) {
            return this.select();
        }
        List<IEntityDTO> list = this.getDataEntityRuntimeMust().selectDataQuery(strDEDataQueryName, this.getSearchContextDTO());
        return this.getSystemRuntime().createScriptList(list);
    }

    @Override
    public IScriptList selectSimple() {
        List<IEntityDTO> list = this.getDataEntityRuntimeMust().selectSimple(this.getSearchContextDTO());
        return this.getSystemRuntime().createScriptList(list);
    }

    @Override
    public IScriptList selectsimple() {
        return this.selectSimple();
    }

    @Override
    public IScriptPage fetch(String strDEDataSetName) {
        Page page;
        block4: {
            IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntimeMust();
            page = null;
            try {
                Object objRet = iDataEntityRuntime.fetchDataSet(strDEDataSetName, null, new Object[]{this.getSearchContextDTO()});
                if (objRet == null) break block4;
                if (objRet instanceof Page) {
                    page = (Page)objRet;
                    if (page.getContent() == null) {
                        page = null;
                    }
                    break block4;
                }
                throw new Exception("\u8fd4\u56de\u7ed3\u679c\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            catch (Throwable ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u83b7\u53d6\u7ed3\u679c\u96c6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strDEDataSetName, ex.getMessage()), ex);
            }
        }
        return this.getSystemRuntime().createScriptPage(page);
    }

    @Override
    public IScriptPage fetch() {
        Page page;
        block5: {
            IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntimeMust();
            IPSDEDataSet iPSDEDataSet = iDataEntityRuntime.getDefaultPSDEDataSet();
            if (iPSDEDataSet == null) {
                throw new DataEntityRuntimeException(iDataEntityRuntime, "\u672a\u6307\u5b9a\u9ed8\u8ba4\u7ed3\u679c\u96c6");
            }
            page = null;
            try {
                Object objRet = iDataEntityRuntime.fetchDataSet(iPSDEDataSet.getName(), iPSDEDataSet, new Object[]{this.getSearchContextDTO()});
                if (objRet == null) break block5;
                if (objRet instanceof Page) {
                    page = (Page)objRet;
                    if (page.getContent() == null) {
                        page = null;
                    }
                    break block5;
                }
                throw new Exception("\u8fd4\u56de\u7ed3\u679c\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            catch (Throwable ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u83b7\u53d6\u7ed3\u679c\u96c6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEDataSet.getName(), ex.getMessage()), ex);
            }
        }
        return this.getSystemRuntime().createScriptPage(page);
    }

    @Override
    public int remove() {
        IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntimeMust();
        IPSDEDataQuery defaultPSDEDataQuery = iDataEntityRuntime.getDefaultPSDEDataQuery();
        List<IEntityDTO> list = null;
        list = defaultPSDEDataQuery != null ? iDataEntityRuntime.selectDataQuery(defaultPSDEDataQuery, this.getSearchContextDTO()) : iDataEntityRuntime.select(this.getSearchContextDTO());
        if (list == null || list.size() == 0) {
            return 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                iDataEntityRuntime.remove(iDataEntityRuntime.getKeyFieldValue(list.get(i)));
                continue;
            }
            catch (Throwable ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5220\u9664\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getKeyFieldValue(list.get(i)), ex.getMessage()), ex);
            }
        }
        return list.size();
    }

    @Override
    public IScriptPage page() {
        Object pageable = this.getSearchContextDTO().getPageable();
        if (pageable != null && pageable != Pageable.unpaged() && this.getSearchContextDTO().getPageSort() != null) {
            pageable = PageRequest.of(pageable.getPageNumber(), pageable.getPageSize(), pageable.getOffset(), this.getSearchContextDTO().getPageSort());
        }
        return this.getSystemRuntime().createScriptPage((Page<?>)new ScriptPageImpl(this.getDataEntityRuntimeMust().createEntityList(), (Pageable)pageable, 0L));
    }

    @Override
    public IScriptEntity selectOne(boolean bTryMode) {
        IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntimeMust();
        IEntityDTO iEntityDTO = iDataEntityRuntime.selectOne(this.getSearchContextDTO(), bTryMode);
        if (iEntityDTO != null) {
            return iDataEntityRuntime.createScriptEntity(iEntityDTO);
        }
        return null;
    }

    @Override
    public IScriptEntity selectone(boolean bTryMode) {
        return this.selectOne(bTryMode);
    }

    @Override
    public IScriptEntity selectOne() {
        return this.selectOne(false);
    }

    @Override
    public IScriptEntity selectone() {
        return this.selectOne(false);
    }

    @Override
    public boolean exists() {
        return this.selectOne(true) != null;
    }

    @Override
    public IScriptList update(Object data) {
        IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntimeMust();
        if (data != null) {
            data = ScriptUtils.getReal(data);
        }
        IEntity srcEntity = null;
        Map srcMap = null;
        if (data instanceof IEntity) {
            srcEntity = (IEntity)data;
        } else if (data instanceof Map) {
            srcMap = (Map)data;
        } else {
            throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u66f4\u65b0\u6570\u636e[%1$s]", data));
        }
        IPSDEDataQuery defaultPSDEDataQuery = iDataEntityRuntime.getDefaultPSDEDataQuery();
        List<IEntityDTO> list = null;
        list = defaultPSDEDataQuery != null ? iDataEntityRuntime.selectDataQuery(defaultPSDEDataQuery, this.getSearchContextDTO()) : iDataEntityRuntime.select(this.getSearchContextDTO());
        if (list == null || list.size() == 0) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                IEntityDTO iEntityDTO = list.get(i);
                if (srcEntity != null) {
                    srcEntity.copyTo(iEntityDTO);
                } else {
                    iEntityDTO.putAll(srcMap);
                }
                iDataEntityRuntime.update(iEntityDTO);
                continue;
            }
            catch (Throwable ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u66f4\u65b0\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getKeyFieldValue(list.get(i)), ex.getMessage()), ex);
            }
        }
        return this.getSystemRuntime().createScriptList(list);
    }

    public String toString() {
        try {
            if (this.getReal() instanceof ISearchContextDTO) {
                return WebClientBase.MAPPER.writeValueAsString(this.getReal());
            }
            return super.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

