/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.ISearchGroupCond;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.SearchCustomCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import net.ibizsys.runtime.util.SearchPredefinedCond;
import org.springframework.util.ObjectUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchGroupCond
extends net.ibizsys.runtime.util.SearchGroupCond
implements ISearchGroupCond {
    @JsonIgnore
    private ISearchContextDTO iSearchContextDTO = null;

    public SearchGroupCond() {
    }

    @JsonIgnore
    public SearchGroupCond(ISearchContextDTO iSearchContextDTO) {
        this.iSearchContextDTO = iSearchContextDTO;
    }

    @JsonIgnore
    public ISearchContextDTO getSearchContextDTO() {
        return this.iSearchContextDTO;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond not() {
        this.setNotMode(true);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond setFieldCond(String strFieldName, String strCondOp, Object objValue) {
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setCondOp(strCondOp);
        if (this.getSearchContextDTO() != null) {
            if (!"ISNULL".equals(strCondOp) && !"ISNOTNULL".equals(strCondOp)) {
                searchFieldCond.setParamMode(true);
                int nIndex = 1;
                String strParamName = "";
                do {
                    strParamName = nIndex == 1 ? String.format("n_%1$s_%2$s", strFieldName, strCondOp).toLowerCase() : String.format("n_%1$s_%2$s_%3$s", strFieldName, strCondOp, nIndex).toLowerCase();
                    ++nIndex;
                } while (this.getSearchContextDTO().contains(strParamName));
                searchFieldCond.setValue(strParamName);
                this.getSearchContextDTO().set(strParamName, objValue);
            }
        } else if (!"ISNULL".equals(strCondOp) && !"ISNOTNULL".equals(strCondOp)) {
            searchFieldCond.setValue(objValue);
        }
        this.getSearchCondsIf().add(searchFieldCond);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond eq(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "EQ", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond ne(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTEQ", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond gt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GT", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond gte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GTANDEQ", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond lt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LT", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond lte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LTANDEQ", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond like(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LIKE", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond ll(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LEFTLIKE", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond rl(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "RIGHTLIKE", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond nvl(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNULL", null);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond nn(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNOTNULL", null);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond in(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "IN", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond ni(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTIN", objValue);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond custom(String strCustomCond) {
        SearchCustomCond searchCustomCond = new SearchCustomCond();
        searchCustomCond.setCustomCond(strCustomCond);
        this.getSearchCondsIf().add(searchCustomCond);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond predefined(String strPredefinedCond, String strPredefinedType) {
        SearchPredefinedCond searchPredefinedCond = new SearchPredefinedCond();
        searchPredefinedCond.setPredefinedCond(strPredefinedCond);
        searchPredefinedCond.setPredefinedType(strPredefinedType);
        this.getSearchCondsIf().add(searchPredefinedCond);
        return this;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond and() {
        SearchGroupCond searchGroupCond = new SearchGroupCond(this.getSearchContextDTO());
        searchGroupCond.setCondOp("AND");
        this.getSearchCondsIf().add(searchGroupCond);
        return searchGroupCond;
    }

    @Override
    @JsonIgnore
    public SearchGroupCond or() {
        SearchGroupCond searchGroupCond = new SearchGroupCond(this.getSearchContextDTO());
        searchGroupCond.setCondOp("OR");
        this.getSearchCondsIf().add(searchGroupCond);
        return searchGroupCond;
    }

    public static SearchGroupCond from(Map<String, Object> map, boolean bIgnoreEmtpyGroup) {
        Object objSearchConds = map.remove("searchconds");
        map.remove("condtype");
        SearchGroupCond searchGroupCond = (SearchGroupCond)JsonUtils.MAPPER.convertValue(map, SearchGroupCond.class);
        if (objSearchConds instanceof List) {
            List list = (List)objSearchConds;
            for (Object objItem : list) {
                if (!(objItem instanceof Map)) continue;
                Map child = (Map)objItem;
                String strType = (String)child.remove("condtype");
                if ("DEFIELD".equalsIgnoreCase(strType)) {
                    SearchFieldCond searchFieldCond = (SearchFieldCond)JsonUtils.MAPPER.convertValue((Object)child, SearchFieldCond.class);
                    searchGroupCond.getSearchCondsIf().add(searchFieldCond);
                    continue;
                }
                if ("GROUP".equalsIgnoreCase(strType)) {
                    SearchGroupCond childGroup = SearchGroupCond.from(child, bIgnoreEmtpyGroup);
                    if (childGroup == null) continue;
                    searchGroupCond.getSearchCondsIf().add(childGroup);
                    continue;
                }
                if ("CUSTOM".equalsIgnoreCase(strType)) {
                    SearchCustomCond searchCustomCond = (SearchCustomCond)JsonUtils.MAPPER.convertValue((Object)child, SearchCustomCond.class);
                    searchGroupCond.getSearchCondsIf().add(searchCustomCond);
                    continue;
                }
                if (!"PREDEFINED".equalsIgnoreCase(strType)) continue;
                SearchPredefinedCond searchPredefinedCond = (SearchPredefinedCond)JsonUtils.MAPPER.convertValue((Object)child, SearchPredefinedCond.class);
                searchGroupCond.getSearchCondsIf().add(searchPredefinedCond);
            }
        }
        if (bIgnoreEmtpyGroup && ObjectUtils.isEmpty(searchGroupCond.getSearchConds())) {
            return null;
        }
        return searchGroupCond;
    }

    public static ISearchCond getSearchCond(Map<String, Object> map, boolean bIgnoreEmtpyGroup) {
        String strType = (String)map.remove("condtype");
        if ("DEFIELD".equalsIgnoreCase(strType)) {
            return (ISearchCond)JsonUtils.MAPPER.convertValue(map, SearchFieldCond.class);
        }
        if ("GROUP".equalsIgnoreCase(strType)) {
            return SearchGroupCond.from(map, bIgnoreEmtpyGroup);
        }
        if ("CUSTOM".equalsIgnoreCase(strType)) {
            return (ISearchCond)JsonUtils.MAPPER.convertValue(map, SearchCustomCond.class);
        }
        if ("PREDEFINED".equalsIgnoreCase(strType)) {
            return (ISearchCond)JsonUtils.MAPPER.convertValue(map, SearchPredefinedCond.class);
        }
        throw new RuntimeException(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6\u7c7b\u578b[%1$s]", strType));
    }
}

