/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.testing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.testing.DETestCaseRuntimeBase;
import net.ibizsys.central.testing.ISysTestDataRuntime;
import net.ibizsys.central.testing.TestCaseRunResult;
import net.ibizsys.central.testing.TestRollbackException;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.testing.IPSDEActionTestCase;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.model.testing.IPSSysTestCaseInput;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.INamedAction;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DEActionTestCaseRuntime
extends DETestCaseRuntimeBase {
    private static final Log log = LogFactory.getLog(DEActionTestCaseRuntime.class);
    private IDataEntityRuntime iDataEntityRuntime = null;

    @Override
    protected void onInit() throws Exception {
        if (!(this.getPSSysTestCase() instanceof IPSDEActionTestCase)) {
            throw new Exception("\u6a21\u578b\u5bf9\u8c61\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        super.onInit();
    }

    public IPSDEActionTestCase getPSDEActionTestCase() {
        return (IPSDEActionTestCase)this.getPSSysTestCase();
    }

    public IDataEntityRuntime getDataEntityRuntime() {
        if (this.iDataEntityRuntime == null) {
            this.iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSDEActionTestCase().getPSDataEntityMust().getId());
        }
        return this.iDataEntityRuntime;
    }

    @Override
    protected void fillTestCaseInfo(TestCaseRunResult testCaseRunResult) {
        testCaseRunResult.setDEName(this.getDataEntityRuntime().getName());
        testCaseRunResult.setDEActionName(this.getPSDEActionTestCase().getPSDEActionMust().getName());
        super.fillTestCaseInfo(testCaseRunResult);
    }

    @Override
    protected TestCaseRunResult onRun() throws Throwable {
        TestCaseRunResult testCaseRunResult;
        block2: {
            testCaseRunResult = new TestCaseRunResult();
            IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntime();
            try {
                iDataEntityRuntime.rawExecute(new INamedAction(){

                    @Override
                    public Object execute(Object[] args) throws Throwable {
                        DEActionTestCaseRuntime.this.runDEActionTestCase(testCaseRunResult);
                        if (DEActionTestCaseRuntime.this.getPSSysTestCase().isRollbackTransaction()) {
                            throw new TestRollbackException();
                        }
                        return null;
                    }

                    @Override
                    public String getName() {
                        return String.format("\u6d4b\u8bd5\u7528\u4f8b\u884c\u4e3a[%1$s]", DEActionTestCaseRuntime.this.getPSSysTestCase().getName());
                    }
                }, null, 3);
            }
            catch (Throwable ex) {
                if (this.isTestRollbackException(ex)) break block2;
                throw ex;
            }
        }
        return testCaseRunResult;
    }

    protected void runDEActionTestCase(TestCaseRunResult testCaseRunResult) throws Throwable {
        ObjectNode objectNode;
        IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntime();
        IPSDEAction iPSDEAction = this.getPSDEActionTestCase().getPSDEActionMust();
        IPSDEMethodDTO iPSDEMethodDTO = iPSDEAction.getPSDEActionInputMust().getPSDEMethodDTO();
        ArrayNode arrayNode = JsonUtils.createArrayNode();
        List psSysTestCaseInputList = this.getPSDEActionTestCase().getPSSysTestCaseInputs();
        if (!ObjectUtils.isEmpty((Object)psSysTestCaseInputList)) {
            for (IPSSysTestCaseInput iPSSysTestCaseInput : psSysTestCaseInputList) {
                Map<String, Object> data;
                objectNode = arrayNode.addObject();
                objectNode.put("inputtag", iPSSysTestCaseInput.getName());
                List psSysTestCaseAssertList = iPSSysTestCaseInput.getPSSysTestCaseAsserts();
                if (ObjectUtils.isEmpty((Object)psSysTestCaseAssertList)) {
                    log.warn((Object)String.format("\u6d4b\u8bd5\u8f93\u5165[%1$s]\u672a\u5b9a\u4e49\u65ad\u8a00\uff0c\u5ffd\u7565\u6267\u884c", iPSSysTestCaseInput.getName()));
                    objectNode.put("actualresult", "\u672a\u5b9a\u4e49\u65ad\u8a00\uff0c\u65e0\u6cd5\u5224\u65ad");
                    objectNode.put("executeresult", "BLOCKING");
                    continue;
                }
                String strInputType = iPSSysTestCaseInput.getInputType();
                IEntity iEntity = null;
                iEntity = iPSDEMethodDTO != null ? (IEntity)((Object)iDataEntityRuntime.getDEMethodDTO(iPSDEMethodDTO, null)) : iDataEntityRuntime.createEntity();
                if (iPSSysTestCaseInput.getPSSysTestData() != null) {
                    ISysTestDataRuntime iSysTestDataRuntime = this.getSystemRuntime().getSysTestDataRuntime(iPSSysTestCaseInput.getPSSysTestData());
                    iSysTestDataRuntime.getEntity(iEntity);
                }
                if ((data = this.getInputDataMap(iPSSysTestCaseInput.getName())) != null) {
                    for (Map.Entry<String, Object> entry : data.entrySet()) {
                        iEntity.set(entry.getKey(), entry.getValue());
                    }
                }
                if ("CUSTOMCODE".equals(strInputType)) {
                    this.invokeInputScript(iPSSysTestCaseInput.getName(), iDataEntityRuntime.createScriptEntity(iEntity));
                }
                Object objRet = null;
                Throwable throwable = null;
                try {
                    objRet = iDataEntityRuntime.executeAction(iPSDEAction.getName(), iPSDEAction, new Object[]{iEntity});
                }
                catch (Throwable ex) {
                    throwable = ex;
                }
                IEntity resultEntity = null;
                resultEntity = objRet instanceof IEntity ? (IEntity)objRet : iEntity;
                ArrayList<String> resultList = new ArrayList<String>();
                String strStatus = "PASS";
                for (IPSSysTestCaseAssert iPSSysTestCaseAssert : psSysTestCaseAssertList) {
                    String strAssertType = iPSSysTestCaseAssert.getAssertType();
                    String strName = iPSSysTestCaseAssert.getMemo();
                    if ("RESULT".equals(strAssertType)) {
                        if (!StringUtils.hasLength((String)strName)) {
                            strName = String.format("[%1$s]\u9884\u671f\u7ed3\u679c", iPSSysTestCaseAssert.getName());
                        }
                        if (throwable != null) {
                            strStatus = "FAILURE";
                            resultList.add(String.format("%1$s[\u672a\u901a\u8fc7]\uff0c\u53d1\u751f\u5f02\u5e38", strName));
                            continue;
                        }
                        if (this.testResult(resultEntity, iPSSysTestCaseAssert)) {
                            resultList.add(String.format("%1$s[\u901a\u8fc7]", strName));
                            continue;
                        }
                        strStatus = "FAILURE";
                        resultList.add(String.format("%1$s[\u672a\u901a\u8fc7]", strName));
                        continue;
                    }
                    if ("EXCEPTION".equals(strAssertType)) {
                        if (!StringUtils.hasLength((String)strName)) {
                            strName = StringUtils.hasLength((String)iPSSysTestCaseAssert.getExceptionName()) ? String.format("[%1$s]\u9884\u671f\u5f02\u5e38(%2$s)", iPSSysTestCaseAssert.getName(), iPSSysTestCaseAssert.getExceptionName()) : String.format("[%1$s]\u9884\u671f\u5f02\u5e38", iPSSysTestCaseAssert.getName());
                        }
                        if (throwable != null) {
                            if (this.testException(throwable, iPSSysTestCaseAssert)) {
                                resultList.add(String.format("%1$s[\u901a\u8fc7]", strName));
                                continue;
                            }
                            strStatus = "FAILURE";
                            resultList.add(String.format("%1$s[\u672a\u901a\u8fc7]", strName));
                            continue;
                        }
                        strStatus = "FAILURE";
                        resultList.add(String.format("%1$s[\u672a\u901a\u8fc7]\uff0c\u672a\u53d1\u751f\u5f02\u5e38", strName));
                        continue;
                    }
                    if ("NOEXCEPTION".equals(strAssertType)) {
                        if (!StringUtils.hasLength((String)strName)) {
                            strName = String.format("[%1$s]\u9884\u671f\u65e0\u5f02\u5e38", iPSSysTestCaseAssert.getName());
                        }
                        if (throwable != null) {
                            strStatus = "FAILURE";
                            resultList.add(String.format("%1$s[\u672a\u901a\u8fc7]", strName));
                            continue;
                        }
                        resultList.add(String.format("%1$s[\u901a\u8fc7]", strName));
                        continue;
                    }
                    if ("CUSTOMCODE".equals(strAssertType)) {
                        String strRet;
                        if (!StringUtils.hasLength((String)strName)) {
                            strName = String.format("[%1$s]\u4ee3\u7801\u5224\u65ad", iPSSysTestCaseAssert.getName());
                        }
                        if (throwable != null) {
                            strStatus = "FAILURE";
                            resultList.add(String.format("%1$s[\u672a\u901a\u8fc7]\uff0c\u53d1\u751f\u5f02\u5e38", strName));
                            continue;
                        }
                        boolean bRet = true;
                        Object objAssertRet = this.invokeAssertScript(iPSSysTestCaseAssert.getName(), iDataEntityRuntime.createScriptEntity(resultEntity));
                        if (objAssertRet != null && !"true".equalsIgnoreCase(strRet = objAssertRet.toString())) {
                            bRet = false;
                        }
                        if (bRet) {
                            resultList.add(String.format("%1$s[\u901a\u8fc7]", strName));
                            continue;
                        }
                        strStatus = "FAILURE";
                        resultList.add(String.format("%1$s[\u672a\u901a\u8fc7]\uff0c%2$s", strName, objAssertRet));
                        continue;
                    }
                    if (!"FAILURE".equals(strStatus)) {
                        strStatus = "BLOCKING";
                    }
                    resultList.add(String.format("%1$s[\u672a\u5224\u65ad]\uff0c\u65e0\u6cd5\u8bc6\u522b\u7684\u65ad\u8a00\u7c7b\u578b[%2$s]", strName, strAssertType));
                }
                objectNode.put("actualresult", StringUtils.collectionToDelimitedString(resultList, (String)"\n"));
                objectNode.put("executeresult", strStatus);
            }
        }
        String strStatus = "PASS";
        for (int i = 0; i < arrayNode.size(); ++i) {
            objectNode = (ObjectNode)arrayNode.get(i);
            JsonNode node = objectNode.get("executeresult");
            if (node == null) continue;
            String strText = node.asText("PASS");
            if ("BLOCKING".equals(strText)) {
                if ("FAILURE".equals(strStatus)) continue;
                strStatus = "BLOCKING";
                continue;
            }
            if (!"FAILURE".equals(strText)) continue;
            strStatus = "FAILURE";
        }
        testCaseRunResult.setStatus(strStatus);
        testCaseRunResult.setResults(arrayNode.toString());
    }
}

