/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.logic;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.dataentity.logic.IDELogicNodeRuntime;
import net.ibizsys.central.dataentity.logic.IDELogicParamRuntime;
import net.ibizsys.central.dataentity.logic.IDELogicRuntime;
import net.ibizsys.central.dataentity.logic.IDELogicRuntimeContext;
import net.ibizsys.central.dataentity.logic.IDELogicSession;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DELogicSession
implements IDELogicSession {
    private static final Log log = LogFactory.getLog(DELogicSession.class);
    private static ThreadLocal<IDELogicSession> current = new ThreadLocal();
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private Object result = null;
    private Object lastReturn = null;
    private IDELogicRuntimeContext iDELogicRuntimeContext = null;
    private ArrayNode debugArrayNode = null;

    public static IDELogicSession getCurrent() {
        return current.get();
    }

    public static void setCurrent(IDELogicSession iDELogicSession) {
        current.set(iDELogicSession);
    }

    public static IDELogicSession getCurrentMust() {
        IDELogicSession iDELogicSession = DELogicSession.getCurrent();
        if (iDELogicSession == null) {
            throw new RuntimeException("\u5f53\u524d\u903b\u8f91\u4f1a\u8bdd\u65e0\u6548");
        }
        return iDELogicSession;
    }

    public DELogicSession(IDELogicRuntimeContext iDELogicRuntimeContext) {
        this.iDELogicRuntimeContext = iDELogicRuntimeContext;
        this.debugArrayNode = JsonUtils.createArrayNode();
    }

    protected IDELogicRuntimeContext getDELogicRuntimeContext() {
        return this.iDELogicRuntimeContext;
    }

    @Override
    @Deprecated
    public IEntity getParam(String strName) throws Throwable {
        return this.getParam(strName, false);
    }

    @Override
    @Deprecated
    public IEntity getParam(String strName, boolean bTryMode) throws Throwable {
        Object obj = this.paramMap.get(strName);
        IEntity iEntity = null;
        if (obj != null) {
            if (obj instanceof IEntity) {
                iEntity = (IEntity)obj;
            } else {
                throw new Exception(String.format("\u53c2\u6570[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", strName));
            }
        }
        if (iEntity != null || bTryMode) {
            return iEntity;
        }
        throw new Exception(String.format("\u672a\u5b58\u5728\u6307\u5b9a\u53c2\u6570[%1$s]", strName));
    }

    @Override
    @Deprecated
    public void setParam(String strName, IEntity iEntity) {
        this.paramMap.put(strName, iEntity);
    }

    @Override
    public Object getParamObject(String strName) throws Throwable {
        return this.getParamObject(strName, false);
    }

    @Override
    public void setParamObject(String strName, Object object) {
        this.paramMap.put(strName, object);
    }

    @Override
    public Object getParamObject(String strName, boolean bTryMode) throws Throwable {
        Object obj = this.paramMap.get(strName);
        if (obj != null || bTryMode) {
            return obj;
        }
        throw new Exception(String.format("\u672a\u5b58\u5728\u6307\u5b9a\u53c2\u6570[%1$s]", strName));
    }

    @Override
    public IUserContext getUserContext() {
        ActionSession actionSession = ActionSessionManager.getCurrentSession();
        if (actionSession != null && actionSession.getUserContext() != null) {
            return actionSession.getUserContext();
        }
        return UserContext.getCurrent();
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public Object getLastReturn() {
        return this.lastReturn;
    }

    @Override
    public void setLastReturn(Object lastReturn) {
        this.lastReturn = lastReturn;
    }

    @Override
    public void debugEnterNode(IDELogicNodeRuntime iDELogicNodeRuntime, IPSDELogicNode iPSDELogicNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u8fdb\u5165\u8282\u70b9[%1$s]", iPSDELogicNode.getName()));
        }
        if (this.getDebugArrayNode() == null) {
            return;
        }
        ObjectNode objectNode = this.getDebugArrayNode().addObject();
        objectNode.put("type", "enternode");
        objectNode.put("time", DateUtils.getCurTimeString2());
        objectNode.put("name", iPSDELogicNode.getName());
        objectNode.put("codeName", iPSDELogicNode.getCodeName());
    }

    @Override
    public void debugExitNode(IDELogicNodeRuntime iDELogicNodeRuntime, IPSDELogicNode iPSDELogicNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u79bb\u5f00\u8282\u70b9[%1$s]", iPSDELogicNode.getName()));
        }
        if (this.getDebugArrayNode() == null) {
            return;
        }
        ObjectNode objectNode = this.getDebugArrayNode().addObject();
        objectNode.put("type", "exitnode");
        objectNode.put("time", DateUtils.getCurTimeString2());
        objectNode.put("name", iPSDELogicNode.getName());
        objectNode.put("codeName", iPSDELogicNode.getCodeName());
    }

    @Override
    public void debugEnterLink(IDELogicNodeRuntime iDELogicNodeRuntime, IPSDELogicNode iPSDELogicNode, IPSDELogicLink iPSDELogicLink) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u8fdb\u5165\u8fde\u63a5[%1$s@%2$s]", iPSDELogicLink.getName(), iPSDELogicNode.getName()));
        }
        if (this.getDebugArrayNode() == null) {
            return;
        }
        ObjectNode objectNode = this.getDebugArrayNode().addObject();
        objectNode.put("type", "enterlink");
        objectNode.put("time", DateUtils.getCurTimeString2());
        objectNode.put("name", String.format("%1$s@%2$s", iPSDELogicLink.getName(), iPSDELogicNode.getName()));
    }

    @Override
    public void debugParam(IDELogicParamRuntime iDELogicParamRuntime) {
        if (this.getDebugArrayNode() == null) {
            return;
        }
        ObjectNode objectNode = this.getDebugArrayNode().addObject();
        objectNode.put("type", "debugparam");
        objectNode.put("time", DateUtils.getCurTimeString2());
        iDELogicParamRuntime.debug(this, objectNode);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u8f93\u51fa\u53c2\u6570[%1$s]\r\n%2$s", iDELogicParamRuntime.getName(), objectNode));
        }
    }

    @Override
    public void debugInfo(String strInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)strInfo);
        }
        if (this.getDebugArrayNode() == null) {
            return;
        }
        ObjectNode objectNode = this.getDebugArrayNode().addObject();
        objectNode.put("type", "debuginfo");
        objectNode.put("time", DateUtils.getCurTimeString2());
        objectNode.put("info", strInfo);
    }

    @Override
    public ArrayNode getDebugArrayNode() {
        return this.debugArrayNode;
    }

    @Override
    public IAppContext getAppContext() {
        if (ActionSessionManager.getCurrentSession() != null) {
            return ActionSessionManager.getCurrentSession().getAppContext();
        }
        return UserContext.getCurrentMust().getAppContext();
    }

    @Override
    public IDELogicRuntime getDELogicRuntime() {
        return this.getDELogicRuntimeContext().getDELogicRuntime();
    }
}

