/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.ds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.database.IDBDataService;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.database.IDBFunction;
import net.ibizsys.central.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeExp;
import net.ibizsys.runtime.ModelRuntimeBase;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchCustomCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.ISearchGroupCond;
import org.springframework.util.StringUtils;

public class DEDataQueryCodeRuntime
extends ModelRuntimeBase
implements IDEDataQueryCodeRuntime {
    private IDataEntityRuntimeContext iDataEntityRuntimeContext = null;
    private IPSDEDataQueryCode iPSDEDataQueryCode = null;
    private IPSDEDataQuery iPSDEDataQuery = null;
    private IDBDialect iDBDialect = null;
    private Map<String, IPSDEDataQueryCodeExp> psDEDataQueryCodeExpMap = new HashMap<String, IPSDEDataQueryCodeExp>();

    @Override
    public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDEDataQuery iPSDEDataQuery, IPSDEDataQueryCode iPSDEDataQueryCode) throws Exception {
        this.iDataEntityRuntimeContext = iDataEntityRuntimeContext;
        this.iPSDEDataQueryCode = iPSDEDataQueryCode;
        this.iPSDEDataQuery = iPSDEDataQuery;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        this.iDBDialect = this.getDataEntityRuntimeContext().getDataEntityRuntime().getSystemRuntime().getDBDialect(this.getPSDEDataQueryCode().getDBType());
        List psDEDataQueryCodeExpList = this.getPSDEDataQueryCode().getPSDEDataQueryCodeExps();
        if (psDEDataQueryCodeExpList != null) {
            for (IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp : psDEDataQueryCodeExpList) {
                this.psDEDataQueryCodeExpMap.put(iPSDEDataQueryCodeExp.getName().toUpperCase(), iPSDEDataQueryCodeExp);
            }
        }
        super.onInit();
    }

    @Override
    public IPSDEDataQueryCode getPSDEDataQueryCode() {
        return this.iPSDEDataQueryCode;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDEDataQueryCode();
    }

    @Override
    public IPSDEDataQuery getPSDEDataQuery() {
        return this.iPSDEDataQuery;
    }

    protected IDataEntityRuntimeContext getDataEntityRuntimeContext() {
        return this.iDataEntityRuntimeContext;
    }

    @Override
    public IPSDEDataQueryCodeExp getPSDEDataQueryCodeExp(String strName, boolean bTryMode) {
        IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp = this.psDEDataQueryCodeExpMap.get(strName.toUpperCase());
        if (iPSDEDataQueryCodeExp != null || bTryMode) {
            return iPSDEDataQueryCodeExp;
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntimeContext().getDataEntityRuntime(), this, String.format("\u5b9e\u4f53\u67e5\u8be2[%1$s]\u4ee3\u7801[%2$s]\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u8868\u8fbe\u5f0f", this.getPSDEDataQuery().getName(), this.getPSDEDataQueryCode().getDBType(), strName));
    }

    @Override
    public IDBDialect getDBDialect() {
        return this.iDBDialect;
    }

    @Override
    public String getConditionSQL(List<ISearchCond> searchCondList, String strCondOp, IDBDataService iDBDataService, ISearchContext iSearchContext) throws Throwable {
        if (StringUtils.isEmpty((Object)strCondOp)) {
            strCondOp = "AND";
        }
        ArrayList<String> condList = null;
        if (searchCondList != null && searchCondList.size() != 0) {
            condList = new ArrayList<String>();
            for (ISearchCond subSearchCond : searchCondList) {
                String strSubCond = this.getConditionSQL(subSearchCond, iDBDataService, iSearchContext);
                if (!StringUtils.hasLength((String)strSubCond)) continue;
                condList.add(strSubCond);
            }
        }
        if (condList == null || condList.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean bFirst = true;
        for (String strCond : condList) {
            if (bFirst) {
                bFirst = false;
            } else {
                sb.append(String.format(" %1$s ", strCondOp));
            }
            sb.append(String.format("( %1$s )", strCond));
        }
        return sb.toString();
    }

    @Override
    public String getConditionSQL(ISearchCond iSearchCond, IDBDataService iDBDataService, ISearchContext iSearchContext) throws Throwable {
        if ("GROUP".equals(iSearchCond.getCondType())) {
            ArrayList<String> condList = null;
            ISearchGroupCond iSearchGroupCond = (ISearchGroupCond)iSearchCond;
            List<ISearchCond> subSearchCondList = iSearchGroupCond.getSearchConds();
            if (subSearchCondList != null && subSearchCondList.size() != 0) {
                condList = new ArrayList<String>();
                for (ISearchCond subSearchCond : subSearchCondList) {
                    String strSubCond = this.getConditionSQL(subSearchCond, iDBDataService, iSearchContext);
                    if (!StringUtils.hasLength((String)strSubCond)) continue;
                    condList.add(strSubCond);
                }
            }
            if (condList == null || condList.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            boolean bFirst = true;
            for (String strCond : condList) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append(String.format(" %1$s ", iSearchGroupCond.getCondOp()));
                }
                sb.append(String.format("( %1$s )", strCond));
            }
            if (iSearchGroupCond.isNotMode()) {
                return String.format(" NOT( %1$s )", sb.toString());
            }
            return sb.toString();
        }
        if ("DEFIELD".equals(iSearchCond.getCondType())) {
            ISearchFieldCond iSearchFieldCond = (ISearchFieldCond)iSearchCond;
            String strDEFieldExp = iSearchFieldCond.getName();
            int nStdDataType = iSearchFieldCond.getDataType();
            if (StringUtils.isEmpty((Object)strDEFieldExp)) {
                strDEFieldExp = this.getPSDEDataQueryCodeExp(iSearchFieldCond.getFieldName(), false).getExpression();
            }
            if (StringUtils.isEmpty((Object)iSearchFieldCond.getValueFunc())) {
                if (nStdDataType == 0) {
                    nStdDataType = this.getDataEntityRuntimeContext().getDataEntityRuntime().getPSDEField(iSearchFieldCond.getFieldName(), false).getStdDataType();
                }
            } else {
                IDBFunction iDBFunction = this.getDBDialect().getDBFunction(iSearchFieldCond.getValueFunc());
                nStdDataType = iDBFunction.getOutputDataType();
                strDEFieldExp = iDBFunction.getFuncSQL(new String[]{strDEFieldExp});
            }
            if (iDBDataService != null) {
                return iDBDataService.getConditionSQL(strDEFieldExp, nStdDataType, iSearchFieldCond.getCondOp(), iSearchFieldCond.getValue(), iSearchFieldCond.isParamMode(), iSearchContext, this.getDBDialect());
            }
            return this.getDBDialect().getConditionSQL(strDEFieldExp, nStdDataType, iSearchFieldCond.getCondOp(), iSearchFieldCond.getValue(), iSearchFieldCond.isParamMode(), iSearchContext);
        }
        if ("CUSTOM".equals(iSearchCond.getCondType())) {
            return ((ISearchCustomCond)iSearchCond).getCustomCond();
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntimeContext().getDataEntityRuntime(), this, String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iSearchCond.getCondType()));
    }
}

