/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.database.DBFunction;
import net.ibizsys.central.database.IDBDialect;
import net.ibizsys.central.database.IDBFunction;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import org.springframework.util.StringUtils;

public abstract class DBDialectBase
implements IDBDialect {
    private Map<String, IDBFunction> dbFunctionMap = new HashMap<String, IDBFunction>();

    public DBDialectBase() {
        this.registerDBFunction(new DBFunction("AVG", 6, "AVG(%1$s)", 1));
        this.registerDBFunction(new DBFunction("MAX", 0, "MAX(%1$s)", 1));
        this.registerDBFunction(new DBFunction("MIN", 0, "MIN(%1$s)", 1));
        this.registerDBFunction(new DBFunction("SUM", 6, "SUM(%1$s)", 1));
        this.registerDBFunction(new DBFunction("COUNT", 1, "COUNT(1)", 0));
    }

    @Override
    public String getDBObjStandardName(String strOriginName) throws Throwable {
        return strOriginName;
    }

    @Override
    public IDBFunction getDBFunction(String strFuncName) throws Throwable {
        IDBFunction iDBFunction = this.dbFunctionMap.get(strFuncName);
        if (iDBFunction != null) {
            return iDBFunction;
        }
        throw new Exception(String.format("\u6570\u636e\u5e93[%1$s]\u8bed\u6cd5\u9002\u914d\u5668\u4e0d\u5b58\u5728\u6307\u5b9a\u51fd\u6570[%2$s]", this.getDBType(), strFuncName));
    }

    protected void registerDBFunction(IDBFunction iDBFunction) {
        this.dbFunctionMap.put(iDBFunction.getName(), iDBFunction);
    }

    @Override
    public String getConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext) throws Throwable {
        if ("TESTNULL".equals(strCondOp)) {
            if (objValueOrParam != null && objValueOrParam.toString().equals("1")) {
                return String.format("%1$s IS NULL", strFieldName);
            }
            return String.format("%1$s IS NOT NULL", strFieldName);
        }
        if ("ISNULL".equals(strCondOp)) {
            return String.format("%1$s IS NULL", strFieldName);
        }
        if ("ISNOTNULL".equals(strCondOp)) {
            return String.format("%1$s IS NOT NULL", strFieldName);
        }
        if (DataTypeUtils.isStringDataType(nStdDataType)) {
            return this.getStringConditionSQL(strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam, iSearchContext);
        }
        if (DataTypeUtils.isIntDataType(nStdDataType)) {
            return this.getIntConditionSQL(strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam, iSearchContext);
        }
        if (DataTypeUtils.isDoubleDataType(nStdDataType)) {
            return this.getDoubleConditionSQL(strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam, iSearchContext);
        }
        if (DataTypeUtils.isDateTimeDataType(nStdDataType)) {
            return this.getDateTimeConditionSQL(strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam, iSearchContext);
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8ba1\u7b97\u67e5\u8be2\u6761\u4ef6[%1$s][%2$s][%3$s][%4$s][%5$s]", strFieldName, nStdDataType, strCondOp, objValueOrParam, bParam));
    }

    @Override
    public String getFunctionSQL(String strFuncName, String[] args) throws Throwable {
        IDBFunction iDBFunction = this.getDBFunction(strFuncName);
        return iDBFunction.getFuncSQL(args);
    }

    protected String getStringConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext) throws Throwable {
        if (!bParam) {
            String strValue = DataTypeUtils.getStringValue(objValueOrParam, "");
            strValue = strValue.replace("'", "''");
            if ("IN".equals(strCondOp) || "NOTIN".equals(strCondOp)) {
                if (StringUtils.isEmpty((Object)strValue)) {
                    if ("IN".equals(strCondOp)) {
                        return "1<>1";
                    }
                    return "1=1";
                }
                String[] items = strValue.split("[,|;]");
                String strSQL = "";
                strSQL = "IN".equals(strCondOp) ? String.format("%1$s IN (", strFieldName) : String.format("%1$s NOT IN (", strFieldName);
                for (int i = 0; i < items.length; ++i) {
                    if (i != 0) {
                        strSQL = strSQL + ",";
                    }
                    strSQL = strSQL + String.format("'%1$s'", items[i]);
                }
                strSQL = strSQL + ")";
                return strSQL;
            }
            if ("EQ".equals(strCondOp)) {
                return String.format("%1$s = '%2$s'", strFieldName, strValue);
            }
            if ("NOTEQ".equals(strCondOp)) {
                return String.format("%1$s <> '%2$s'", strFieldName, strValue);
            }
            if ("LIKE".equals(strCondOp)) {
                strValue = "%" + strValue + "%";
                return String.format("UPPER(%1$s) LIKE '%2$s'", strFieldName, strValue.toUpperCase());
            }
            if ("LEFTLIKE".equals(strCondOp)) {
                strValue = strValue + "%";
                return String.format("UPPER(%1$s) LIKE '%2$s'", strFieldName, strValue.toUpperCase());
            }
            if ("RIGHTLIKE".equals(strCondOp)) {
                strValue = "%" + strValue;
                return String.format("UPPER(%1$s) LIKE '%2$s'", strFieldName, strValue.toUpperCase());
            }
            if ("USERLIKE".equals(strCondOp)) {
                return String.format("UPPER(%1$s) LIKE '%2$s'", strFieldName, strValue.toUpperCase());
            }
        } else {
            if ("EQ".equals(strCondOp)) {
                return String.format("%1$s = %2$s", strFieldName, objValueOrParam);
            }
            if ("NOTEQ".equals(strCondOp)) {
                return String.format("%1$s <> %2$s", strFieldName, objValueOrParam);
            }
            if ("LIKE".equals(strCondOp)) {
                return String.format("%1$s LIKE '%%'||%2$s||'%%'", strFieldName, objValueOrParam);
            }
            if ("LEFTLIKE".equals(strCondOp)) {
                return String.format("%1$s LIKE %2$s ||'%%'", strFieldName, objValueOrParam);
            }
            if ("RIGHTLIKE".equals(strCondOp)) {
                return String.format("%1$s LIKE '%%'||%2$s", strFieldName, objValueOrParam);
            }
            if ("USERLIKE".equals(strCondOp)) {
                return String.format("%1$s LIKE '%%'||%2$s||'%%'", strFieldName, objValueOrParam);
            }
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6[%1$s][%2$s][%3$s][%4$s]", strFieldName, strCondOp, objValueOrParam, bParam));
    }

    protected String getIntConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext) throws Throwable {
        if (!bParam) {
            if (!"IN".equals(strCondOp) && !"NOTIN".equals(strCondOp)) {
                BigInteger objValue = DataTypeUtils.getBigIntegerValue(objValueOrParam, null);
                if (objValue == null) {
                    throw new Exception(String.format("\u503c[%1$s]\u975e\u6574\u6570\u503c", objValueOrParam));
                }
                if ("BITAND".equals(strCondOp)) {
                    if (objValue.longValue() == 0L) {
                        return String.format("(%1$s = 0 || %1$s IS NULL) ", strFieldName);
                    }
                    return String.format("(%1$s & %2$s)>0", strFieldName, objValue.longValue());
                }
                if ("EQ".equals(strCondOp)) {
                    return String.format("%1$s = %2$s", strFieldName, objValue.longValue());
                }
                if ("NOTEQ".equals(strCondOp)) {
                    return String.format("%1$s <> %2$s", strFieldName, objValue.longValue());
                }
                if ("GT".equals(strCondOp)) {
                    return String.format("%1$s > %2$s", strFieldName, objValue.longValue());
                }
                if ("GTANDEQ".equals(strCondOp)) {
                    return String.format("%1$s >= %2$s", strFieldName, objValue.longValue());
                }
                if ("LT".equals(strCondOp)) {
                    return String.format("%1$s < %2$s", strFieldName, objValue.longValue());
                }
                if ("LTANDEQ".equals(strCondOp)) {
                    return String.format("%1$s <= %2$s", strFieldName, objValue.longValue());
                }
            }
            if ("IN".equals(strCondOp) || "NOTIN".equals(strCondOp)) {
                String strValue = DataTypeUtils.getStringValue(objValueOrParam, null);
                if (StringUtils.isEmpty((Object)strValue)) {
                    if ("IN".equals(strCondOp)) {
                        return "1<>1";
                    }
                    return "1=1";
                }
                String[] items = strValue.split("[,|;]");
                String strSQL = "";
                strSQL = "IN".equals(strCondOp) ? String.format("%1$s IN (", strFieldName) : String.format("%1$s NOT IN (", strFieldName);
                for (int i = 0; i < items.length; ++i) {
                    if (i != 0) {
                        strSQL = strSQL + ",";
                    }
                    strSQL = strSQL + String.format("%1$s", items[i]);
                }
                strSQL = strSQL + ")";
                return strSQL;
            }
        } else {
            if ("BITAND".equals(strCondOp)) {
                return String.format("(%1$s & %2$s) > 0", strFieldName, objValueOrParam);
            }
            if ("EQ".equals(strCondOp)) {
                return String.format("%1$s = %2$s", strFieldName, objValueOrParam);
            }
            if ("NOTEQ".equals(strCondOp)) {
                return String.format("%1$s <> %2$s", strFieldName, objValueOrParam);
            }
            if ("GT".equals(strCondOp)) {
                return String.format("%1$s > %2$s", strFieldName, objValueOrParam);
            }
            if ("GTANDEQ".equals(strCondOp)) {
                return String.format("%1$s >= %2$s", strFieldName, objValueOrParam);
            }
            if ("LT".equals(strCondOp)) {
                return String.format("%1$s < %2$s", strFieldName, objValueOrParam);
            }
            if ("LTANDEQ".equals(strCondOp)) {
                return String.format("%1$s <= %2$s", strFieldName, objValueOrParam);
            }
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6[%1$s][%2$s][%3$s][%4$s]", strFieldName, strCondOp, objValueOrParam, bParam));
    }

    protected String getDoubleConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext) throws Throwable {
        if (!bParam) {
            if (!"IN".equals(strCondOp) && !"NOTIN".equals(strCondOp)) {
                BigDecimal objValue = DataTypeUtils.getBigDecimalValue(objValueOrParam, null);
                if (objValue == null) {
                    throw new Exception(String.format("\u503c[%1$s]\u975e\u6d6e\u70b9\u503c", objValueOrParam));
                }
                if ("EQ".equals(strCondOp)) {
                    return String.format("%1$s = %2$s", strFieldName, objValue.doubleValue());
                }
                if ("NOTEQ".equals(strCondOp)) {
                    return String.format("%1$s <> %2$s", strFieldName, objValue.doubleValue());
                }
                if ("GT".equals(strCondOp)) {
                    return String.format("%1$s > %2$s", strFieldName, objValue.doubleValue());
                }
                if ("GTANDEQ".equals(strCondOp)) {
                    return String.format("%1$s >= %2$s", strFieldName, objValue.doubleValue());
                }
                if ("LT".equals(strCondOp)) {
                    return String.format("%1$s < %2$s", strFieldName, objValue.doubleValue());
                }
                if ("LTANDEQ".equals(strCondOp)) {
                    return String.format("%1$s <= %2$s", strFieldName, objValue.doubleValue());
                }
            }
            if ("IN".equals(strCondOp) || "NOTIN".equals(strCondOp)) {
                String strValue = DataTypeUtils.getStringValue(objValueOrParam, null);
                if (StringUtils.isEmpty((Object)strValue)) {
                    if ("IN".equals(strCondOp)) {
                        return "1<>1";
                    }
                    return "1=1";
                }
                String[] items = strValue.split("[,|;]");
                String strSQL = "";
                strSQL = "IN".equals(strCondOp) ? String.format("%1$s IN (", strFieldName) : String.format("%1$s NOT IN (", strFieldName);
                for (int i = 0; i < items.length; ++i) {
                    if (i != 0) {
                        strSQL = strSQL + ",";
                    }
                    strSQL = strSQL + String.format("%1$s", items[i]);
                }
                strSQL = strSQL + ")";
                return strSQL;
            }
        } else {
            if ("EQ".equals(strCondOp)) {
                return String.format("%1$s = %2$s", strFieldName, objValueOrParam);
            }
            if ("NOTEQ".equals(strCondOp)) {
                return String.format("%1$s <> %2$s", strFieldName, objValueOrParam);
            }
            if ("GT".equals(strCondOp)) {
                return String.format("%1$s > %2$s", strFieldName, objValueOrParam);
            }
            if ("GTANDEQ".equals(strCondOp)) {
                return String.format("%1$s >=%2$s", strFieldName, objValueOrParam);
            }
            if ("LT".equals(strCondOp)) {
                return String.format("%1$s < %2$s", strFieldName, objValueOrParam);
            }
            if ("LTANDEQ".equals(strCondOp)) {
                return String.format("%1$s <= %2$s", strFieldName, objValueOrParam);
            }
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6[%1$s][%2$s][%3$s][%4$s]", strFieldName, strCondOp, objValueOrParam, bParam));
    }

    protected String getDateTimeConditionSQL(String strFieldName, int nStdDataType, String strCondOp, Object objValueOrParam, boolean bParam, ISearchContext iSearchContext) throws Throwable {
        if (!bParam) {
            String strValue = null;
            if (!(objValueOrParam instanceof String)) {
                long nValue = DataTypeUtils.getDateTimeValue(objValueOrParam);
                if (nValue == -1L) {
                    throw new Exception(String.format("\u503c[%1$s]\u975e\u65e5\u671f\u65f6\u95f4\u6027", objValueOrParam));
                }
                Timestamp ts = new Timestamp(nValue);
                strValue = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", ts);
                if ("LT".equals(strCondOp) || "LTANDEQ".equals(strCondOp)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date(ts.getTime()));
                    if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
                        strValue = String.format("%1$tY-%1$tm-%1$td 23:59:59", ts);
                    }
                }
            }
            if ("EQ".equals(strCondOp)) {
                return String.format("%1$s = '%2$s'", strFieldName, strValue);
            }
            if ("NOTEQ".equals(strCondOp)) {
                return String.format("%1$s <> '%2$s'", strFieldName, strValue);
            }
            if ("GT".equals(strCondOp)) {
                return String.format("%1$s > '%2$s'", strFieldName, strValue);
            }
            if ("GTANDEQ".equals(strCondOp)) {
                return String.format("%1$s >= '%2$s'", strFieldName, strValue);
            }
            if ("LT".equals(strCondOp)) {
                return String.format("%1$s < '%2$s'", strFieldName, strValue);
            }
            if ("LTANDEQ".equals(strCondOp)) {
                return String.format("%1$s <= '%2$s'", strFieldName, strValue);
            }
        } else {
            if ("EQ".equals(strCondOp)) {
                return String.format("%1$s = %2$s", strFieldName, objValueOrParam);
            }
            if ("NOTEQ".equals(strCondOp)) {
                return String.format("%1$s <> %2$s", strFieldName, objValueOrParam);
            }
            if ("GT".equals(strCondOp)) {
                return String.format("%1$s > %2$s", strFieldName, objValueOrParam);
            }
            if ("GTANDEQ".equals(strCondOp)) {
                return String.format("%1$s >= %2$s", strFieldName, objValueOrParam);
            }
            if ("LT".equals(strCondOp)) {
                return String.format("%1$s < %2$s", strFieldName, objValueOrParam);
            }
            if ("LTANDEQ".equals(strCondOp)) {
                return String.format("%1$s <= %2$s", strFieldName, objValueOrParam);
            }
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6[%1$s][%2$s][%3$s][%4$s]", strFieldName, strCondOp, objValueOrParam, bParam));
    }

    @Override
    public String getLastInsertIdSQL(String strAlias) throws Throwable {
        return null;
    }
}

