package net.ibizsys.runtime.util;

/**
 * 支持事务服务对象接口
 * @author lionlau
 *
 */
public interface ITransactionalUtil {

	/**
	 * 未知事务模式
	 */
	public final int PROPAGATION_UNKNOWN = -1;
	

	/**
	 * 支持当前已经存在的事务，如果还没有事务，就创建一个新事务
	 */
	public final int PROPAGATION_REQUIRED = 0;

	
	/**
	 * 支持当前事务，如果没有事务那么就不在事务中运行
	 */
	public final int PROPAGATION_SUPPORTS = 1;

	
	/**
	 * 支持当前已经存在的事务，如果还没有事务，就抛出一个异常
	 */
	public final int PROPAGATION_MANDATORY = 2;

	
	/**
	 * 挂起当前事务，创建一个新事务，如果还没有事务，就简单地创建一个新事务
	 */
	public final int PROPAGATION_REQUIRES_NEW = 3;

	
	/**
	 * 强制不在事务中运行，如果当前存在一个事务，则挂起该事务
	 */
	public final int PROPAGATION_NOT_SUPPORTED = 4;

	
	/**
	 * 强制要求不在事务中运行，如果当前存在一个事务，则抛出异常
	 */
	public final int PROPAGATION_NEVER = 5;

	
	/**
	 * 在当前事务中创建一个嵌套事务，如果还没有事务，那么就简单地创建一个新事务
	 */
	public final int PROPAGATION_NESTED = 6;
	
	
	
	Object mandatory(IAction iAction, Object[] args) throws Throwable;
	
	
	Object nested(IAction iAction, Object[] args) throws Throwable;
	
	
	Object never(IAction iAction, Object[] args) throws Throwable;
	
	
	Object not_supported(IAction iAction, Object[] args) throws Throwable;
	
	
	Object required(IAction iAction, Object[] args) throws Throwable;
	
	
	Object required_new(IAction iAction, Object[] args) throws Throwable;
	
	
	Object supports(IAction iAction, Object[] args) throws Throwable;
	
	
	/**
	 * 提交当前事务
	 * @throws Throwable
	 */
	void commit()throws Throwable;
	
	
	/**
	 * 回滚当前事务
	 * @throws Throwable
	 */
	void rollback()throws Throwable;
}
